<?php



/*



 * Template Name: Blog Advanced



 * Description: A Page Template Blog.



 */



$theme_option=sonex_global();



get_header(); ?>



      <section class="page-title-bar" <?php if($theme_option['bcimage']['url']!=''){ ?> style="background-image: url('<?php echo esc_url($theme_option['bcimage']['url']); ?>');"
<?php } else { ?> style="background-image: url('<?php echo get_template_directory_uri()?>/images/breadbg.jpg');"<?php } ?>>




    <div class="container">



      <div class="row">



        <div class="col-md-12 bccontent">



          <h2><?php esc_attr(the_title()); ?></h2>



          <?php if ($theme_option['breadcrumbs_opt'] != '0') { ?>
            <?php sonex_breadcrumbs(); ?>
          <?php }else{} ?>



        </div>



      </div>



    </div>



  </section>

     

 <section class="contentsepe">



    <div class="container">



      <div class="row padder">



        <div class="col-md-8">



              <?php



                $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;



                $args = array(



                'post_type' => 'post',



                'paged' => $paged,



                );



                $query = new WP_Query($args);



                if($query->have_posts()) : ?>



              <?php while($query->have_posts()) : $query->the_post(); ?>  



                <article class="project-item blog-item blog-item-alt margin-bottom-40">

                  <div class="post-container">
                    <div class="row">
                  <div class="wrap-left col-md-6">



                    <!-- Project image //-->

                    

                    <?php $format = get_post_format(); if($format=='video'){ ?>



                  <?php $link_video = get_post_meta(get_the_ID(),'_cmb_link_video', true);?>

                    <?php if($link_video) { ?>

                      <figure class="hover-effect">

                        <iframe height="185" src="<?php echo esc_url(get_post_meta(get_the_ID(),'_cmb_link_video', true));?>" ></iframe>

                      </figure>

                  <?php } }elseif($format=='audio') { ?>



                  <?php $link_audio = get_post_meta(get_the_ID(),'_cmb_link_audio', true);?>

                    <?php if($link_audio) { ?>

                      <figure class="hover-effect">

                        <iframe class="auframe" height="166" scrolling="no" frameborder="no" src="<?php echo esc_url(get_post_meta(get_the_ID(), "_cmb_link_audio", true));?>"></iframe>

                      </figure>

                  <?php } }elseif($format=='gallery') { ?>

                  <?php
                    /**
                     * Detect plugin. For use on Front End only.
                     */
                    include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
                    // check for plugin using plugin name
                    if ( is_plugin_active('meta-box/meta-box.php') ) { 
                  ?>

                    <?php $images = rwmb_meta( '_cmb_images', "type=image" ); ?>



                      <?php if($images){ ?>

                      <div class="width-100 float-left post-id-gallery">

                        <?php                                                        
	                      foreach ( $images as $image ) {                              
	                    ?>

                        <figure class="hover-effect">

                           <div><img src="<?php echo esc_url($image['full_url']); ?>" alt=""></div>

                        </figure>

                        <?php } ?>  

                      </div>
                      <?php } ?>  
                    <?php } ?>    
                  <?php }else{ $image = wp_get_attachment_url(get_post_thumbnail_id()); ?>

                  <?php $params = array( 'width' => 900, 'height' => 560 );

                    $image = bfi_thumb( wp_get_attachment_url(get_post_thumbnail_id()), $params ); if($image) { ?>

                    <figure class="hover-effect">



                        <div><a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($image); ?>" alt=""></a></div>



                    </figure>

                    <?php } }?>



                  </div>



                  <div class="wrap-right col-md-6">



                    <!-- Project info //-->



                    <div class="info">
                    

                      <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>



                     <!-- Meta //-->
                     <div class="meta">

                     <ul>

                     <li><span class="blogad-category"> <?php the_category(', '); ?></span> <span class="text-sep">|</span> <span class="datestyling"><?php esc_attr( the_time( get_option( 'date_format' ) ) ); ?></span> <span class="text-sep">|</span> <?php comments_popup_link(__('0 comment','sonex'),__('1  comment','sonex'),__('% comments','sonex'),'comments-link',__('Comments are Closed','sonex')); ?><i class="fa fa-comments"></i></li>

                    </ul>

                    </div>


                      <p><?php echo sonex_excerpt($theme_option['blog_excerpt']); ?></p>



                    </div>



                  </div></div></div>

           

                </article>



              <?php endwhile;?> 



              <?php else: ?>



                <h1><?php esc_html('Nothing Found Here!','sonex' ); ?></h1>



              <?php endif; ?>

              <div class="pagination margin-top-30 margin-bottom-20">

                <?php

                $big = 999999999;

                echo paginate_links( array(

                  'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),

                  'format' => '?paged=%#%',

                  'current' => max( 1, get_query_var('paged') ),

                  'total' => $query->max_num_pages,

                  'prev_text'    => esc_html__('Prev', 'sonex' ),

                  'next_text'    => esc_html__('Next', 'sonex' ),

                  

                ) );

                ?>

              </div>

          </div> 

        <div class="col-md-4">



          <?php get_sidebar()?>



        </div>

      </div>

    </div>

  </section>



<?php get_footer(); ?>