<?php

/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */

if ( post_password_required() )
    return;
?>



<!-- COMMENTS -->
<?php if ( have_comments() ) : ?>  

            <ul class="comments-list" id="comments">

                <?php wp_list_comments(

                    array(

                    'callback'=>'sonex_theme_comment',

                    'style' => 'ul' 

                    )

                ); 

                ?>

            </ul>

            <?php

                // Are there comments to navigate through?

                if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :

            ?>

                <nav class="navigation comment-navigation" role="navigation">

                    
                    <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'sonex' ) ); ?></div>

                    <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'sonex' ) ); ?></div>

                </nav><!-- .comment-navigation -->

            <?php endif; // Check for comment navigation ?>



            <?php if ( ! comments_open() && get_comments_number() ) : ?>

                <p class="no-comments"><?php esc_html_e( 'Comments are closed.' , 'sonex' ); ?></p>

            <?php endif; ?>

        <?php endif; ?>

    <!-- End Comments -->



<?php if (comments_open()) { ?>

<!-- LEAVE A COMMENT -->

<div class="add-comment-form">

	<?php

        if ( is_singular() ) wp_enqueue_script( "comment-reply" );

            $aria_req = ( $req ? " aria-required='true'" : '' );

            $comment_args = array(

                    'id_form' => 'comment_form',                           
                    'title_reply'=> esc_html__('add a comment','sonex'),
                     'fields' => apply_filters( 'comment_form_default_fields', array(
                        'author' => '<p class="name-mail"><input type="text" name="author" placeholder="'.__('your name','sonex').'" id="comments_form_name">',   
                        'email' => '<input type="text" name="email" placeholder="'.__('your email','sonex').'" id="comment-email"></p>',                                                                                                
                     ) ),

                     'comment_field' => '<p class="cmfield"><textarea id="comment-entry" name="comment" placeholder="'.__('your comment','sonex').'"></textarea></p>',                                             
                     'label_submit' => esc_html__('Send Comment','sonex'),
                     'class_submit' => 'd-btn d-btn-normal d-btn-primary',
                     'comment_notes_before' => '',
                     'comment_notes_after' => '',                   
            )
        ?>

        <?php comment_form($comment_args); ?>

</div><!-- //LEAVE A COMMENT -->

<?php }else {}?>





<!-- //COMMENTS -->                