<?php
/* Header Logo */

function wi_head_logo($div = ''){
$div_sd = 'wi_logo'; if ( $div == '' ) { $div = $div_sd; } else { $div = $div_sd.' '.$div; }
global $wi_options, $post;
$wi_logo_upload          = $wi_options['wi_logo_upload']['url'];
$wi_logo_dark_upload     = $wi_options['wi_logo_dark_upload']['url'];

$wi_header_preset_meta = get_post_meta(get_the_ID(), 'wi_meta_header_preset', true);
$wi_header_preset      = b_i_g_header_preset($wi_header_preset_meta);
if(!is_search() && !is_404()) { $template_name = get_post_meta( $post->ID, '_wp_page_template', true ); }
if ( $wi_header_preset_meta != '' && $template_name = 'template-for-demo.php') {
	$wi_logo_upload      = $wi_header_preset['wi_logo_upload']['url'];
	$wi_logo_dark_upload = $wi_header_preset['wi_logo_upload']['url'];
}
ob_start();
?>

<?php if($wi_options['wi_logo_style'] == 1) {?>
	<div class="<?php echo esc_attr($div); ?> wi_logo_light">
		<a href="<?php echo esc_url(home_url()); ?>"><img alt="<?php echo esc_attr( get_bloginfo('name') ); ?>" width="<?php echo esc_attr($wi_options['wi_logo_style_width']);?>px" height="<?php echo esc_attr($wi_options['wi_logo_style_height']); ?>px" src="<?php echo esc_url($wi_logo_upload); ?>"></a>
	</div>
<?php } elseif ($wi_options['wi_logo_style'] == 2) {?>
	<div class="<?php echo esc_attr($div); ?> wi_logo_dark">
		<a href="<?php echo esc_url(home_url()); ?>"><img alt="<?php echo esc_attr( get_bloginfo('name') ); ?>" width="<?php echo esc_attr($wi_options['wi_logo_style_width']); ?>px" height="<?php echo esc_attr($wi_options['wi_logo_style_height']); ?>px" src="<?php echo esc_url($wi_logo_dark_upload); ?>"></a>
	</div>
<?php } elseif ($wi_options['wi_logo_style'] == 3) {?>
	<div class="<?php echo esc_attr($div); ?> wi_logo_custom">
		<?php echo balanceTags($wi_options['wi_logo_custom_field']);?>
	</div>
<?php } ?>
<?php
$output_string = ob_get_contents();
ob_end_clean();

echo !empty( $output_string ) ? $output_string : ''; 
} 

/* Header Cart */

function wi_head_cart($div = ''){
$div_sd = 'wi_cart'; if ( $div == '' ) { $div = $div_sd; } else { $div = $div_sd.' '.$div; }
$wi_options = get_option('wi_options'); 
ob_start();
?>
<?php if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) { ?>
	<div class="<?php echo esc_attr($div); ?>">
	<?php
		global $woocommerce;
		$qty = $woocommerce->cart->get_cart_contents_count();
		$total = $woocommerce->cart->get_cart_total();
		$cart_url = $woocommerce->cart->get_cart_url();
		if ($wi_options['wi_cart_val'] == 2) {
			echo '<a href="'.$cart_url.'" class="cart-icon"><i class="fa fa-shopping-cart"></i></a><a href="'.$cart_url.'" class="cart-total">'.$total.'</a>';
		} elseif ($wi_options['wi_cart_val'] == 3) {
			echo '<a href="'.$cart_url.'" class="cart-icon"><i class="fa fa-shopping-cart"></i></a><a href="'.$cart_url.'" class="cart-total">'.$qty.' - '.$total.'</a>';
		} else {
			echo '<a href="'.$cart_url.'" class="cart-icon"><i class="fa fa-shopping-cart"></i></a><a href="'.$cart_url.'" class="cart-total">'.$qty.'</a>'; 
		}
		?>
	</div>
<?php } ?>
<?php
$output_string = ob_get_contents();
ob_end_clean();

echo !empty( $output_string ) ? $output_string : ''; 
}


/* Top Bar Profile Links */

function wi_topbar_profile_links($div = ''){
$div_sd = 'top_profile_links'; if ( $div == '' ) { $div = $div_sd; } else { $div = $div_sd.' '.$div; }
$wi_options = get_option('wi_options');
ob_start();
?>
<div class="<?php echo esc_attr($div); ?>"><?php if ( is_user_logged_in() ) { ?>
	<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php echo esc_attr($wi_options['wi_topbar_profile_field_0']); ?>" class="topbar_signed_in"><?php echo esc_attr($wi_options['wi_topbar_profile_field_0']); ?></a>
<?php } else { ?>
	<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php echo esc_attr($wi_options['wi_topbar_profile_field_1']); ?>" class="topbar_sign_in"><?php echo esc_attr($wi_options['wi_topbar_profile_field_1']); ?></a>
	<?php echo esc_attr($wi_options['wi_topbar_profile_field_2']); ?>
	<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php echo esc_attr($wi_options['wi_topbar_profile_field_3']); ?>" class="topbar_register"><?php echo esc_attr($wi_options['wi_topbar_profile_field_3']); ?></a>
<?php } ?>
</div>
<?php
$output_string = ob_get_contents();
ob_end_clean();

echo !empty( $output_string ) ? $output_string : ''; 
}