<?php

/* Set the content width based on the theme's design and stylesheet.
------------------------------------------*/

if ( ! isset( $content_width ) ) $content_width = 1000; /* pixels */
// add_filter( 'show_admin_bar', '__return_false' );

/* Theme Setup
------------------------------------------*/
function b_i_g_setup() {
	// Title Tag
	add_theme_support( 'title-tag' );
	// Feed Links
	add_theme_support( 'automatic-feed-links' );
	// Recommended
	// Makes theme available for translation
	load_theme_textdomain( 'b-i-g', get_template_directory() . '/languages' );

	add_theme_support( 'custom-background');
	add_theme_support( 'custom-header' );
	remove_theme_support ( 'custom-background');
	remove_theme_support ( 'custom-header' );
}
add_action( 'after_setup_theme', 'b_i_g_setup' );

/* MetaBox Options
------------------------------------------*/

// Load MetaBox
if (file_exists(get_template_directory().'/theme-options/MetaBox/init.php')) {
    require_once get_template_directory() .'/theme-options/MetaBox/init.php';
}
if (file_exists(get_template_directory().'/theme-options/metabox.php')) {
    require_once get_template_directory() .'/theme-options/metabox.php';
}
// Load Redux extensions - MUST be loaded before your options are set
if (file_exists(get_template_directory().'/theme-options/Extensions/extensions-init.php')) {
    require_once get_template_directory() .'/theme-options/Extensions/extensions-init.php';
}   
// Like System
require_once get_template_directory() . '/theme-options/Functions/wi-post-like.php';
// Create social icons 
require_once get_template_directory() . '/theme-options/Functions/wi-social-icons.php';
// Create midbar short output 
require_once get_template_directory() . '/theme-options/Functions/wi-head-options.php';
// Create sidebar
require_once get_template_directory() . '/theme-options/Functions/wi-multi-sidebars.php';

/* Include Framework. (Theme options)
------------------------------------------*/

if ( !class_exists( 'ReduxFramework' ) && file_exists( get_template_directory() . '/theme-options/ReduxCore/framework.php' ) ) {
	require_once get_template_directory() . '/theme-options/ReduxCore/framework.php';
}
if ( !isset( $ct_options ) && file_exists( get_template_directory() . '/theme-options/options.php' ) ) {
	require_once get_template_directory() . '/theme-options/options.php';
}

/* Enqueue Style
------------------------------------------*/
require get_template_directory() . '/framework/style.php';

/* Enqueue JS
------------------------------------------*/
require get_template_directory() . '/framework/js.php';

/* Widgets
------------------------------------------*/

require_once get_template_directory() . '/framework/widgets/wi_flickr_widget.php';
require_once get_template_directory() . '/framework/widgets/wi_posts_widget.php';

/* Theme Menus
------------------------------------------*/

function b_i_g_menu() { 
  register_nav_menus(
    array(
	  'header_nav_01' 	=> esc_attr__('Header Nav 01','b-i-g'),
	  'header_nav_02' 	=> esc_attr__('Header Nav 02','b-i-g'),
	  'header_nav_03' 	=> esc_attr__('Header Nav 03','b-i-g'),
	  'header_nav_04' 	=> esc_attr__('Header Nav 04','b-i-g'),
	  'header_nav_05' 	=> esc_attr__('Header Nav 05','b-i-g'),
	  'header_nav_06' 	=> esc_attr__('Header Nav 06','b-i-g'),
	  'header_nav_07' 	=> esc_attr__('Header Nav 07','b-i-g'),
	  'topbar_menu'   	=> esc_attr__('Top Bar Menu','b-i-g'),
	  'navbar_menu'		=> esc_attr__('Nav Bar Menu','b-i-g'),
    )
  );
}
add_action( 'init', 'b_i_g_menu' );

/* Additional image sizes
------------------------------------------*/

add_image_size( 'b_i_g_portfolio-squrex2', 762,762, true );
add_image_size( 'b_i_g_portfolio-squre-lit', 400,400, true );
add_image_size( 'b_i_g_portfolio-wide', 762, 480, true );
add_image_size( 'b_i_g_related-posts-thumbnail', 400,400, true );

/* Register Sidebar UNLIMITED 
------------------------------------------*/

add_action( 'widgets_init', 'b_i_g_widgets_init' );
function b_i_g_widgets_init() {
if ( function_exists('register_sidebar') ){
	register_sidebar(array(
		'name' => esc_attr__('Blog Sidebar','b-i-g'),
		'id' => 'blog_sidebar',
		'description'   => esc_attr__( 'Add widgets here to appear in your sidebar.', 'b-i-g' ),
        'before_widget' => '<div class="wi_widget">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="wi_widget_title">',
        'after_title' => '</h4>'
    ));
	register_sidebar( array(
		'name' => esc_attr__('WooCommerce Page Sidebar','b-i-g'),
		'id' => 'woocommerce_sidebar',
		'description'   => esc_attr__( 'Add widgets here to appear in your woocommerce sidebar.', 'b-i-g' ),
		'before_widget' => '<div id="%1$s" class="widgetSidebar %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	));	
	register_sidebar(array(
		'name' => esc_attr__('Page Sidebar','b-i-g'),
		'id' => 'page_sidebar',
		'description'   => esc_attr__( 'Add widgets here to appear in your page sidebar.', 'b-i-g' ),
		'before_widget' => '<div class="wi_widget">',
        'after_widget' => '</div><div class="clearfix"></div>',
        'before_title' => '<div class="clearfix"></div><h4 class="wi_widget_title">',
        'after_title' => '</h4>'
	));
	register_sidebar(array(
		'name' => esc_attr__('Footer Sidebar 1','b-i-g'),
		'id' => 'footer_sidebar1',
		'description'   => esc_attr__( 'Add widgets here to appear in your footer area.', 'b-i-g' ),
		'before_widget' => '<div class="wi_widget">',
        'after_widget' => '</div><div class="clearfix"></div>',
        'before_title' => '<div class="clearfix"></div><h5 class="wi_widget_title_single">',
        'after_title' => '</h5>'
	));
	register_sidebar(array(
		'name' => esc_attr__('Footer Sidebar 2','b-i-g'),
		'id' => 'footer_sidebar2',
		'description'   => esc_attr__( 'Add widgets here to appear in your footer area.', 'b-i-g' ),
		'before_widget' => '<div class="wi_widget">',
        'after_widget' => '</div><div class="clearfix"></div>',
        'before_title' => '<div class="clearfix"></div><h5 class="wi_widget_title_single">',
        'after_title' => '</h5>'
	));
	register_sidebar(array(
		'name' => esc_attr__('Footer Sidebar 3','b-i-g'),
		'id' => 'footer_sidebar3',
		'description'   => esc_attr__( 'Add widgets here to appear in your footer area.', 'b-i-g' ),
		'before_widget' => '<div class="wi_widget">',
        'after_widget' => '</div><div class="clearfix"></div>',
        'before_title' => '<div class="clearfix"></div><h5 class="wi_widget_title_single">',
        'after_title' => '</h5>'
	));
	register_sidebar(array(
		'name' => esc_attr__('Footer Sidebar 4','b-i-g'),
		'id' => 'footer_sidebar4',
		'description'   => esc_attr__( 'Add widgets here to appear in your footer area.', 'b-i-g' ),
		'before_widget' => '<div class="wi_widget">',
        'after_widget' => '</div><div class="clearfix"></div>',
        'before_title' => '<div class="clearfix"></div><h5 class="wi_widget_title_single">',
        'after_title' => '</h5>'
	));	
	register_sidebar( array(
		'name' => esc_attr__('Portfolio Page Sidebar','b-i-g'),
		'id' => 'portfolio_sidebar',
		'description'   => esc_attr__( 'Add widgets here to appear in your portfolio sidebar.', 'b-i-g' ),
		'before_widget' => '<div id="%1$s" class="widgetSidebar %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
}

if ( function_exists( 'add_theme_support' ) ) { 
	add_theme_support( 'post-thumbnails' );
}

/* Content Start
------------------------------------------*/

function b_i_g_content_start() {
	$content_start_inline_style = get_post_meta(get_the_ID(), 'wi_meta_top_content_margin', true);
	$content_start = '<div class="wide_cont" id="wi_content" style'.'="padding-top:' . $content_start_inline_style  . '">';
	return $content_start;
}

/* WooCommerce
------------------------------------------*/

include_once ABSPATH . 'wp-admin/includes/plugin.php';
$url = site_url();
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ){
	require_once get_template_directory() . '/framework/woocommerce/index.php';
}

/* Automatic Plugin Activation
------------------------------------------*/

require_once get_template_directory() . '/framework/plugin-activation.php';

add_action('tgmpa_register', 'b_i_g_register_required_plugins');
function b_i_g_register_required_plugins() {
	$plugins = array(
		array(
			'name'     				=> esc_attr__('WI Plugin Territory','b-i-g'), // The plugin name
			'slug'     				=> 'wi-plugin-territory', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/wi-plugin-territory.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '1.0.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),		
		array(
			'name'     				=> esc_attr__('Redux Framework','b-i-g'), // The plugin name
			'slug'     				=> 'redux-framework', // The plugin slug (typically the folder name)
			//'source'   				=> get_template_directory_uri() . '/framework/plugins/vafpress-post-formats-ui.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('Widget Importer & Exporter','b-i-g'), // The plugin name
			'slug'     				=> 'widget-importer-exporter', // The plugin slug (typically the folder name)
			//'source'   				=> get_template_directory_uri() . '/framework/plugins/vafpress-post-formats-ui.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('Vafpress Post Formats UI','b-i-g'), // The plugin name
			'slug'     				=> 'vafpress-post-formats-ui', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/vafpress-post-formats-ui.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('Better Font Awesome','b-i-g'), // The plugin name
			'slug'     				=> 'better-font-awesome', // The plugin slug (typically the folder name)
		//	'source'   				=> get_template_directory_uri() . '/framework/plugins/contact-form-7.4.3.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('MailChimp for WordPress','b-i-g'), // The plugin name
			'slug'     				=> 'mailchimp-for-wp', // The plugin slug (typically the folder name)
		//	'source'   				=> get_template_directory_uri() . '/framework/plugins/contact-form-7.4.3.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('Contact Form 7','b-i-g'), // The plugin name
			'slug'     				=> 'contact-form-7', // The plugin slug (typically the folder name)
		//	'source'   				=> get_template_directory_uri() . '/framework/plugins/contact-form-7.4.3.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'               	=> esc_attr__('Simple Custom Post Order','b-i-g'),
			'slug'               	=> 'simple-custom-post-order',
			'required'          	=> true,
			'version'            	=> '',
			'force_activation'  	=> false,
			'force_deactivation' 	=> false,
			'external_url'      	=> '',
		),
		array(
			'name'               	=> esc_attr__('WP-PhotoNav','b-i-g'),
			'slug'               	=> 'wp-photonav',
			'required'          	=> true,
			'version'            	=> '',
			'force_activation'  	=> false,
			'force_deactivation' 	=> false,
			'external_url'      	=> '',
		),
		array(
			'name'     				=> esc_attr__('WooCommerce','b-i-g'), // The plugin name
			'slug'     				=> 'woocommerce', // The plugin slug (typically the folder name)
		//	'source'   				=> get_template_directory_uri() . '/framework/plugins/woocommerce.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),		
		array(
			'name'     				=> esc_attr__('Easy Social Share Buttons for WordPress','b-i-g'), // The plugin name
			'slug'     				=> 'easy-social-share-buttons3', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/easy-social-share-buttons3.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('Essential Grid','b-i-g'), // The plugin name
			'slug'     				=> 'essential-grid', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/essential-grid.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),	
		array(
			'name'     				=> esc_attr__('WPBakery Visual Composer','b-i-g'), // The plugin name
			'slug'     				=> 'js_composer', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/js_composer.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('LMM Menu','b-i-g'), // The plugin name
			'slug'     				=> 'lmm', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/lmm.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('Slider Revolution','b-i-g'), // The plugin name
			'slug'     				=> 'revslider', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/revslider.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('Ultimate VC Addons','b-i-g'), // The plugin name
			'slug'     				=> 'Ultimate_VC_Addons', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/Ultimate_VC_Addons.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> esc_attr__('Visual Composer Extensions All In One','b-i-g'), // The plugin name
			'slug'     				=> 'vc-extensions-bundle', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory_uri() . '/framework/plugins/vc-extensions-bundle.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
	);

	/**
	 * Array of configuration settings. Amend each line as needed.
	 * If you want the default strings to be available under your own theme domain,
	 * leave the strings uncommented.
	 * Some of the strings are added into a sprintf, so see the comments at the
	 * end of each line for what each argument will be.
	 */
	$config = array(
		'domain'       		=> 'b-i-g',         	// Text domain - likely want to be the same as your theme.
		'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
		'parent_menu_slug' 	=> 'themes.php', 				// Default parent menu slug
		'parent_url_slug' 	=> 'themes.php', 				// Default parent URL slug
		'menu'         		=> 'install-required-plugins', 	// Menu slug
		'has_notices'      	=> true,                       	// Show admin notices or not
		'is_automatic'    	=> true,					   	// Automatically activate plugins after installation or not
		'message' 			=> '',							// Message to output right before the plugins table
		'strings'      		=> array(
			'page_title'                       			=> esc_html__( 'Install Required Plugins','b-i-g'),
			'menu_title'                       			=> esc_html__( 'Install Plugins','b-i-g'),
			'installing'                       			=> esc_html__( 'Installing Plugin: %s','b-i-g'), // %1$s = plugin name
			'oops'                             			=> esc_html__( 'Something went wrong with the plugin API.','b-i-g'),
			'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.','b-i-g'), // %1$s = plugin name(s)
			'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.','b-i-g'), // %1$s = plugin name(s)
			'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.','b-i-g'), // %1$s = plugin name(s)
			'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.','b-i-g'), // %1$s = plugin name(s)
			'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.','b-i-g'), // %1$s = plugin name(s)
			'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.','b-i-g'), // %1$s = plugin name(s)
			'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.','b-i-g'), // %1$s = plugin name(s)
			'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.','b-i-g'), // %1$s = plugin name(s)
			'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins','b-i-g'),
			'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins','b-i-g'),
			'return'                           			=> esc_html__( 'Return to Required Plugins Installer','b-i-g'),
			'plugin_activated'                 			=> esc_html__( 'Plugin activated successfully.','b-i-g'),
			'complete' 									=> esc_html__( 'All plugins installed and activated successfully. %s','b-i-g'), // %1$s = dashboard link
			'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
		)
	);

	tgmpa($plugins, $config);
	
}

/* Include VC extends
------------------------------------------*/

include_once ABSPATH . 'wp-admin/includes/plugin.php';
if (is_plugin_active('js_composer/js_composer.php')){
require get_template_directory() . '/framework/vc.php';
}

/* Post Formats
------------------------------------------*/

add_theme_support( 'post-formats',
	array( 
		'image',
		'video',
		'audio',
		'gallery',
	)
);

add_filter('get_avatar','b_i_g_change_avatar_css');
function b_i_g_change_avatar_css($class) {
$class = str_replace("class='avatar", "class='avatar img-circle wi_avatar ", $class) ;
return $class;
}

/* Custom widgets
------------------------------------------*/

add_filter('wp_list_categories', 'b_i_g_add_span_cat_count');
function b_i_g_add_span_cat_count($links) {
$links = str_replace('</a> (', '</a> <span class="wi_cat_count">', $links);
$links = str_replace(')', '</span>', $links);
return $links;
}

add_filter('wp_list_archive', 'b_i_g_add_spann_cat_count');
function b_i_g_add_spann_cat_count($links) {
$links = str_replace('</a> (', '</a> <span class="wi_cat_count">', $links);
$links = str_replace(')', '</span>', $links);
return $links;
}

function b_i_g_tag_cloud_filter($args = array()) {
    $args['smallest'] = 8;
    $args['largest'] = 14;
    $args['unit'] = 'pt';
    return $args;
}
add_filter('widget_tag_cloud_args', 'b_i_g_tag_cloud_filter', 90);


/* Pagination
------------------------------------------*/

function b_i_g_wp_corenavi() {
    global $wp_query;

    $big = 999999999; // This needs to be an unlikely integer

    // For more options and info view the docs for paginate_links()
    // http://codex.wordpress.org/Function_Reference/paginate_links
    $paginate_links = paginate_links( array(
        'base' => str_replace( $big, '%#%', get_pagenum_link($big) ),
        'current' => max( 1, get_query_var('paged') ),
        'total' => $wp_query->max_num_pages,
        'mid_size' => 5
    ) );

    // Display the pagination if more than one page is found
    if ( $paginate_links ) {
        echo '<div class="pagination">';
        echo balanceTags($paginate_links);
        echo '</div><!--// end .pagination -->';
    }
}

/* Add Editor Style
------------------------------------------*/

function b_i_g_add_editor_styles() {
    add_editor_style( 'custom-editor-style.css' );
}
add_action( 'admin_init', 'b_i_g_add_editor_styles' );

/* WP Title
------------------------------------------*/

if ( ! function_exists( '_wp_render_title_tag' ) ) {
	function b_i_g_render_title() {
?>
<title><?php wp_title( '|', true, 'right' ); ?></title>
<?php
	}
	add_action( 'wp_head', 'b_i_g_render_title' );
}

/* Get likes meta
------------------------------------------*/

if (!function_exists('b_i_g_likes_meta')) {
	function b_i_g_likes_meta() {
		return sprintf(
			'<span class="entry-like">
					%s
			</span>',
			getPostLikeLink( get_the_ID() )
		);
	}
}

/* Blog Meta
------------------------------------------*/

if ( !function_exists( 'b_i_g_blog_meta' ) ) {
	

function b_i_g_blog_meta() {
$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'portfolio-squre-lit'); 	
$wi_options = get_option('wi_options'); ?>
<div class="wi_blog_meta">
	<?php if($wi_options['wi_blog_meta_date'] == '3' || is_single() || $large_image_url == '') { ?><span class="blog_meta"><?php the_time( get_option('date_format') ); ?></span><?php } ?>
	<?php if($wi_options['wi_blog_meta_likes'] != '1') { ?><span class="blog_meta"><?php echo b_i_g_likes_meta(); ?></span><?php } ?>
	<?php if($wi_options['wi_blog_meta_author'] != '1') { ?><span class="blog_meta"><?php echo esc_html__("By ",'b-i-g'); ?><?php the_author_posts_link() ?></span><?php } ?>
	<?php if($wi_options['wi_blog_meta_comments'] != '1') { ?><span class="blog_meta"><a href="<?php the_permalink() ?>#comments"><?php comments_number('0','1','%')?>  <?php echo esc_html__("Comments",'b-i-g')?></a></span><?php } ?>
</div>
<?php }}

/* Blog Date
------------------------------------------*/

if ( !function_exists( 'b_i_g_blog_meta_date' ) ) {
function b_i_g_blog_meta_date() { 
$wi_options = get_option('wi_options'); ?>
<?php if($wi_options['wi_blog_meta_date'] == '2') { ?>
<div class="wi_full_blog_post_date">
	<h2 class="wi_date_d"><?php the_time('d') ?></h2>
	<h4 class="wi_date_y colored"><?php the_time('M Y') ?></h4>
</div>
<?php } ?>
<?php }}


/* Content Type
------------------------------------------*/

if (!function_exists('b_i_g_post_content')) {
	function b_i_g_post_content($type, $excerpt_length) {
		switch ($type) {
			case '1':
				$length = (int)$excerpt_length;
				$length = $length == 0 ? 256 : $length;
				$string = get_the_excerpt(''); if(strlen($string) > 8) $string = substr($string, 0, $length);
				$post_content = $string;
				break;
			case '2':
				$post_content = the_content();
				break;
		}
		return $post_content;
	}
}

/* Set post thumbnails in admin
------------------------------------------*/

add_filter('manage_posts_columns', 'b_i_g_post_col', 5);
add_action('manage_posts_custom_column', 'b_i_g_posts_custom_columns', 5, 2);
 
function b_i_g_post_col($post_col_static) {
    $post_col_static['post_thumb_prev'] = 'Thumbnail';
    return $post_col_static;
}
 
function b_i_g_posts_custom_columns($post_col_name, $id) {
    if ($post_col_name === 'post_thumb_prev') :
        print the_post_thumbnail('thumbnail');
    endif;
}

/* Deal with a paid plugins
------------------------------------------*/

add_action ( 'acf/init', 'wi_cp_setup_acf_updates');
function wi_cp_setup_acf_updates () {
	acf_update_setting ( 'show_updates', false );
}

add_action( 'vc_before_init', 'wi_vc_set_as_theme' );
function wi_vc_set_as_theme () {
if ( function_exists ( 'vc_manager' ) ) {
	vc_manager()->disableUpdater (true);
	vc_manager()->setIsAsTheme (true);	
}

vc_set_as_theme();
}

add_action( 'init', 'wi_setup_revslider_as_theme' );
function wi_setup_revslider_as_theme () {
	if ( ! function_exists ( 'set_revslider_as_theme' ) ) { return; }
	set_revslider_as_theme();
}



/* Related Posts
------------------------------------------*/

if (!function_exists('b_i_g_get_posts_global')) {
	function b_i_g_get_posts_global() {
		global $post;
	}
}

/* Header Preset
------------------------------------------*/

if (!function_exists('b_i_g_header_preset')) {
	function b_i_g_header_preset($wi_header_preset_meta) {
		$theme_path_images = get_template_directory_uri() . '/framework/images/';
		$wi_header_preset ='';
		switch ($wi_header_preset_meta) {
			case '1':
				$wi_header_preset = array(
				'wi_logo_upload'                  => array('url'=> $theme_path_images . '/logos/logo-light.png' ),
				'wi_logo_dark_upload'             => array('url'=> $theme_path_images . '/logos/logo-dark.png' ),
				// topbar
				'wi_topbar'					 	  => 1,
				'wi_topbar_social'  		 	  => 3,
				'wi_topbar_cart'			 	  => 1,
				'wi_topbar_search'			 	  => 3,
				'wi_topbar_phone'	        	  => 2,
				'wi_topbar_phone_field'           => '1-800-633-3469',
				'wi_topbar_email' 	 		 	  => 2,
				'wi_topbar_email_field'           => 'admin@website.com',
				'wi_topbar_whours' 	 		 	  => 2,
				'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
				'wi_topbar_textmenu_position'	  => 2,
				'wi_topbar_textmenu'		 	  => 1,
				'wi_topbar_textmenu_field'        => 'Your Text or HTML',
				'wi_topbar_profile'			 	  => 2,
				// midbar
				'wi_midbar'						  => 1,
				'wi_midbar_custom_code'		  	  => 2,
				// if you need code
				'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
				',
				// if you need simple settings
				'wi_logo_style'				  	  => 1,
				'wi_midbar_logo'			  	  => 2,
				'wi_midbar_social'		 	 	  => 4,
				'wi_midbar_search'		  		  => 4,
				'wi_midbar_cart'		 	 	  => 4,
				// navbar
				'wi_navbar'					 	  => 1,
				'wi_header_nav_type'		 	  => '01',
				// colors
				'wi_top_st_separator'		  	  => '#4b4b4b',
				'wi_top_st_separator_first'  	  => 0,
				'wi_top_st_separator_last'	 	  => 1,
				'wi_top_st_t_color' 			  => '#4b4b4b',
				'wi_top_st_t_width' 			  => '1',
				'wi_top_st_b_color'				  => '#4b4b4b',
				'wi_top_st_b_width'				  => '1',
				'wi_top_st_bg'				 	  => '#212121',
				'wi_top_st_text_color'		 	  => '#ffffff',
				'wi_top_st_text_icons_color' 	  => '#ffffff',
				'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#ffd824'), 
				'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#ffd824'),
				'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#ffd824', 'active' => '#ffffff' ), 
				'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
				'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
				'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#ffd824', 'hover' => '#ffd824'),
				'wi_top_st_searcharea_color'  	  => '#ffffff',
				'wi_top_st_searcharea_bg'     	  => '#212121',
				'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#ffd824'),
				'wi_mid_st_bg' 					  => '#ffffff',
				'wi_mid_st_text_color'			  => '#212121',
				'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#ffd824'),
				'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#ffd824'),
				'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#ffd824' ),
				'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
				'wi_mid_st_cart_val'			  => array( 'regular' => '#212121', 'hover' => '#212121'),
				'wi_mid_st_cart_bg'				  => array( 'regular' => '#ffd824', 'hover' => '#ffd824'),
				'wi_navbar_border_color'		  => '#f0f0f0',
				);
				break;
			case '2':
				$wi_header_preset = array(
					'wi_logo_upload'                  => array('url'=> $theme_path_images . '/logos/logo-light-blue.png' ),
					'wi_logo_dark_upload'             => array('url'=> $theme_path_images . '/logos/logo-dark-blue.png' ),
					// topbar
					'wi_topbar'					 	  => 1,
					'wi_topbar_social'  		 	  => 1,
					'wi_topbar_cart'			 	  => 1,
					'wi_topbar_search'			 	  => 1,
					'wi_topbar_phone'	        	  => 2,
					'wi_topbar_phone_field'           => '1-800-633-3469',
					'wi_topbar_email' 	 		 	  => 2,
					'wi_topbar_email_field'           => 'admin@website.com',
					'wi_topbar_whours' 	 		 	  => 2,
					'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
					'wi_topbar_textmenu_position'	  => 3,
					'wi_topbar_textmenu'		 	  => 2,
					'wi_topbar_textmenu_field'        => 'Your Text or HTML',
					'wi_topbar_profile'			 	  => 1,
					// midbar
					'wi_midbar'						  => 1,
					'wi_midbar_custom_code'		  	  => 1,
					// if you need code
					'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
					',
					// if you need simple settings
					'wi_logo_style'				  	  => 1,
					'wi_midbar_logo'			  	  => 2,
					'wi_midbar_social'		 	 	  => 4,
					'wi_midbar_search'		  		  => 4,
					'wi_midbar_cart'		 	 	  => 4,
					// navbar
					'wi_navbar'					 	  => 1,
					'wi_header_nav_type'		 	  => '02',
					// colors
					'wi_top_st_separator'		  	  => '#4b4b4b',
					'wi_top_st_separator_first'  	  => 1,
					'wi_top_st_separator_last'	 	  => 1,
					'wi_top_st_t_color' 			  => '#4b4b4b',
					'wi_top_st_t_width' 			  => '1',
					'wi_top_st_b_color'				  => '#4b4b4b',
					'wi_top_st_b_width'				  => '1',
					'wi_top_st_bg'				 	  => '#212121',
					'wi_top_st_text_color'		 	  => '#ffffff',
					'wi_top_st_text_icons_color' 	  => '#ffffff',
					'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#00ccfd'), 
					'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#00ccfd'),
					'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#00ccfd', 'active' => '#ffffff' ), 
					'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_val'		  	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#00ccfd', 'hover' => '#00ccfd'),
					'wi_top_st_searcharea_color'  	  => '#ffffff',
					'wi_top_st_searcharea_bg'     	  => '#212121',
					'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#00ccfd'),
					'wi_mid_st_bg' 					  => '#ffffff',						
					'wi_mid_st_text_color'			  => '#212121',						
					'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#00ccfd'),
					'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#00ccfd'),
					'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#00ccfd' ),
					'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_mid_st_cart_bg'				  => array( 'regular' => '#00ccfd', 'hover' => '#00ccfd'),
					'wi_navbar_border_color'		  => '#f0f0f0',
					);
				break;
			case '3':
				$wi_header_preset = array(
					'wi_logo_upload'                  => array('url'=> $theme_path_images . '/logos/logo-light-brown.png' ),
					'wi_logo_dark_upload'             => array('url'=> $theme_path_images . '/logos/logo-dark-brown.png' ),
					// topbar
					'wi_topbar'					 	  => 2,
					'wi_topbar_social'  		 	  => 1,
					'wi_topbar_cart'			 	  => 3,
					'wi_topbar_search'			 	  => 1,
					'wi_topbar_phone'	        	  => 2,
					'wi_topbar_phone_field'           => '1-800-633-3469',
					'wi_topbar_email' 	 		 	  => 2,
					'wi_topbar_email_field'           => 'admin@website.com',
					'wi_topbar_whours' 	 		 	  => 2,
					'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
					'wi_topbar_textmenu_position'	  => 3,
					'wi_topbar_textmenu'		 	  => 2,
					'wi_topbar_textmenu_field'        => 'Your Text or HTML',
					'wi_topbar_profile'			 	  => 1,
					// midbar
					'wi_midbar'						  => 2,
					'wi_midbar_custom_code'		  	  => 1,
					// if you need code
					'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
					',
					// if you need simple settings
					'wi_logo_style'				  	  => 1,
					'wi_midbar_logo'			  	  => 3,
					'wi_midbar_social'		 	 	  => 1,
					'wi_midbar_search'		  		  => 1,
					'wi_midbar_cart'		 	 	  => 1,
					// navbar
					'wi_navbar'					 	  => 1,
					'wi_header_nav_type'		 	  => '03',
					// colors
					'wi_top_st_separator'		  	  => '#4b4b4b',
					'wi_top_st_separator_first'  	  => 1,
					'wi_top_st_separator_last'	 	  => 1,
					'wi_top_st_t_color' 			  => '#4b4b4b',
					'wi_top_st_t_width' 			  => '1',
					'wi_top_st_b_color'				  => '#4b4b4b',
					'wi_top_st_b_width'				  => '1',
					'wi_top_st_bg'				 	  => '#212121',
					'wi_top_st_text_color'		 	  => '#ffffff',
					'wi_top_st_text_icons_color' 	  => '#ffffff',
					'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#95532c'), 
					'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#95532c'),
					'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#95532c', 'active' => '#ffffff' ), 
					'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#95532c', 'hover' => '#95532c'),
					'wi_top_st_searcharea_color'  	  => '#ffffff',
					'wi_top_st_searcharea_bg'     	  => '#212121',
					'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#95532c'),
					'wi_mid_st_bg' 					  => '#ffffff',						
					'wi_mid_st_text_color'			  => '#212121',						
					'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#95532c'),
					'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#95532c'),
					'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#95532c' ),
					'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_mid_st_cart_bg'				  => array( 'regular' => '#95532c', 'hover' => '#95532c'),
					'wi_navbar_border_color'		  => 'transparent',
					);
				break;
			case '4':
				$wi_header_preset = array(
					'wi_logo_upload'                  => array('url'=> $theme_path_images . '/logos/logo-light-brown.png' ),
					'wi_logo_dark_upload'             => array('url'=> $theme_path_images . '/logos/logo-dark-brown.png' ),
					// topbar
					'wi_topbar'					 	  => 1,
					'wi_topbar_social'  		 	  => 1,
					'wi_topbar_cart'			 	  => 1,
					'wi_topbar_search'			 	  => 1,
					'wi_topbar_phone'	        	  => 3,
					'wi_topbar_phone_field'           => '1-800-633-3469',
					'wi_topbar_email' 	 		 	  => 3,
					'wi_topbar_email_field'           => 'admin@website.com',
					'wi_topbar_whours' 	 		 	  => 2,
					'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
					'wi_topbar_textmenu_position'	  => 2,
					'wi_topbar_textmenu'		 	  => 2,
					'wi_topbar_textmenu_field'        => 'Your Text or HTML',
					'wi_topbar_profile'			 	  => 1,
					// midbar
					'wi_midbar'						  => 2,
					'wi_midbar_custom_code'		  	  => 1,
					// if you need code
					'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
					',
					// if you need simple settings
					'wi_logo_style'				  	  => 1,
					'wi_midbar_logo'			  	  => 3,
					'wi_midbar_social'		 	 	  => 1,
					'wi_midbar_search'		  		  => 1,
					'wi_midbar_cart'		 	 	  => 1,
					// navbar
					'wi_navbar'					 	  => 1,
					'wi_header_nav_type'		 	  => '04',
					// colors
					'wi_top_st_separator'		  	  => 'transparent',
					'wi_top_st_separator_first'  	  => 1,
					'wi_top_st_separator_last'	 	  => 1,
					'wi_top_st_t_color' 			  => 'transparent',
					'wi_top_st_t_width' 			  => '1',
					'wi_top_st_b_color'				  => 'transparent',
					'wi_top_st_b_width'				  => '1',
					'wi_top_st_bg'				 	  => '#212121',
					'wi_top_st_text_color'		 	  => '#ffffff',
					'wi_top_st_text_icons_color' 	  => '#ffffff',
					'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#ffb900'), 
					'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#ffb900'),
					'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#ffb900', 'active' => '#ffffff' ), 
					'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#ffb900', 'hover' => '#ffb900'),
					'wi_top_st_searcharea_color'  	  => '#ffffff',
					'wi_top_st_searcharea_bg'     	  => '#212121',
					'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#ffb900'),
					'wi_mid_st_bg' 					  => '#ffffff',						
					'wi_mid_st_text_color'			  => '#212121',						
					'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#ffb900'),
					'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#ffb900'),
					'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#ffb900' ),
					'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_mid_st_cart_bg'				  => array( 'regular' => '#ffb900', 'hover' => '#ffb900'),
					'wi_navbar_border_color'		  => 'transparent',
					);
				break;
			case '5':
				$wi_header_preset = array(
					'wi_logo_upload'                  => array('url'=> $theme_path_images . '/logos/logo-light-azure.png' ),
					'wi_logo_dark_upload'             => array('url'=> $theme_path_images . '/logos/logo-dark-azure.png' ),
					// topbar
					'wi_topbar'					 	  => 1,
					'wi_topbar_social'  		 	  => 1,
					'wi_topbar_cart'			 	  => 1,
					'wi_topbar_search'			 	  => 3,
					'wi_topbar_phone'	        	  => 2,
					'wi_topbar_phone_field'           => '1-800-633-3469',
					'wi_topbar_email' 	 		 	  => 2,
					'wi_topbar_email_field'           => 'admin@website.com',
					'wi_topbar_whours' 	 		 	  => 2,
					'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
					'wi_topbar_textmenu_position'	  => 3,
					'wi_topbar_textmenu'		 	  => 2,
					'wi_topbar_textmenu_field'        => 'Your Text or HTML',
					'wi_topbar_profile'			 	  => 2,
					// midbar
					'wi_midbar'						  => 1,
					'wi_midbar_custom_code'		  	  => 1,
					// if you need code
					'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
					',
					// if you need simple settings
					'wi_logo_style'				  	  => 1,
					'wi_midbar_logo'			  	  => 3,
					'wi_midbar_social'		 	 	  => 1,
					'wi_midbar_search'		  		  => 1,
					'wi_midbar_cart'		 	 	  => 1,
					// navbar
					'wi_navbar'					 	  => 1,
					'wi_header_nav_type'		 	  => '05',
					// colors
					'wi_top_st_separator'		  	  => '#4b4b4b',
					'wi_top_st_separator_first'  	  => 1,
					'wi_top_st_separator_last'	 	  => 1,
					'wi_top_st_t_color' 			  => '#4b4b4b',
					'wi_top_st_t_width' 			  => '1',
					'wi_top_st_b_color'				  => '#4b4b4b',
					'wi_top_st_b_width'				  => '1',
					'wi_top_st_bg'				 	  => '#212121',
					'wi_top_st_text_color'		 	  => '#ffffff',
					'wi_top_st_text_icons_color' 	  => '#ffffff',
					'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea'), 
					'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea'),
					'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea', 'active' => '#ffffff' ), 
					'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#1bc0ea', 'hover' => '#1bc0ea'),
					'wi_top_st_searcharea_color'  	  => '#ffffff',
					'wi_top_st_searcharea_bg'     	  => '#212121',
					'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea'),
					'wi_mid_st_bg' 					  => '#ffffff',						
					'wi_mid_st_text_color'			  => '#212121',						
					'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#1bc0ea'),
					'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#1bc0ea'),
					'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#1bc0ea' ),
					'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_mid_st_cart_bg'				  => array( 'regular' => '#1bc0ea', 'hover' => '#1bc0ea'),
					'wi_navbar_border_color'		  => 'transparent',
					);
				break;
			case '6':
				$wi_header_preset = array(
					'wi_logo_upload'                  => array('url'=> $theme_path_images . '/logos/logo-light-red.png' ),
					'wi_logo_dark_upload'             => array('url'=> $theme_path_images . '/logos/logo-dark-red.png' ),
					// topbar
					'wi_topbar'					 	  => 1,
					'wi_topbar_social'  		 	  => 2,
					'wi_topbar_cart'			 	  => 1,
					'wi_topbar_search'			 	  => 1,
					'wi_topbar_phone'	        	  => 1,
					'wi_topbar_phone_field'           => '1-800-633-3469',
					'wi_topbar_email' 	 		 	  => 1,
					'wi_topbar_email_field'           => 'admin@website.com',
					'wi_topbar_whours' 	 		 	  => 1,
					'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
					'wi_topbar_textmenu_position'	  => 3,
					'wi_topbar_textmenu'		 	  => 2,
					'wi_topbar_textmenu_field'        => 'Your Text or HTML',
					'wi_topbar_profile'			 	  => 1,
					// midbar
					'wi_midbar'						  => 2,
					'wi_midbar_custom_code'		  	  => 1,
					// if you need code
					'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
					',
					// if you need simple settings
					'wi_logo_style'				  	  => 1,
					'wi_midbar_logo'			  	  => 3,
					'wi_midbar_social'		 	 	  => 1,
					'wi_midbar_search'		  		  => 1,
					'wi_midbar_cart'		 	 	  => 1,
					// navbar
					'wi_navbar'					 	  => 1,
					'wi_header_nav_type'		 	  => '06',
					// colors
					'wi_top_st_separator'		  	  => 'transparent',
					'wi_top_st_separator_first'  	  => 1,
					'wi_top_st_separator_last'	 	  => 1,
					'wi_top_st_t_color' 			  => 'transparent',
					'wi_top_st_t_width' 			  => '1',
					'wi_top_st_b_color'				  => 'transparent',
					'wi_top_st_b_width'				  => '1',
					'wi_top_st_bg'				 	  => '#212121',
					'wi_top_st_text_color'		 	  => '#ffffff',
					'wi_top_st_text_icons_color' 	  => '#ffffff',
					'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#d40d14'), 
					'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#d40d14'),
					'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#d40d14', 'active' => '#ffffff' ), 
					'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_val'		  	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#d40d14', 'hover' => '#d40d14'),
					'wi_top_st_searcharea_color'  	  => '#ffffff',
					'wi_top_st_searcharea_bg'     	  => '#212121',
					'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#d40d14'),
					'wi_mid_st_bg' 					  => '#ffffff',						
					'wi_mid_st_text_color'			  => '#212121',						
					'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#d40d14'),
					'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#d40d14'),
					'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#d40d14' ),
					'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_mid_st_cart_bg'				  => array( 'regular' => '#d40d14', 'hover' => '#d40d14'),
					'wi_navbar_border_color'		  => 'transparent',
					);
				break;
			case '7':
				$wi_header_preset = array(
					'wi_logo_upload'                  => array('url'=> $theme_path_images . '/logos/logo-light-law.png' ),
					'wi_logo_dark_upload'             => array('url'=> $theme_path_images . '/logos/logo-dark-law.png' ),
					// topbar
					'wi_topbar'					 	  => 2,
					'wi_topbar_social'  		 	  => 2,
					'wi_topbar_cart'			 	  => 1,
					'wi_topbar_search'			 	  => 1,
					'wi_topbar_phone'	        	  => 1,
					'wi_topbar_phone_field'           => '1-800-633-3469',
					'wi_topbar_email' 	 		 	  => 1,
					'wi_topbar_email_field'           => 'admin@website.com',
					'wi_topbar_whours' 	 		 	  => 1,
					'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
					'wi_topbar_textmenu_position'	  => 3,
					'wi_topbar_textmenu'		 	  => 2,
					'wi_topbar_textmenu_field'        => 'Your Text or HTML',
					'wi_topbar_profile'			 	  => 1,
					// midbar
					'wi_midbar'						  => 2,
					'wi_midbar_custom_code'		  	  => 1,
					// if you need code
					'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
					',
					// if you need simple settings
					'wi_logo_style'				  	  => 1,
					'wi_midbar_logo'			  	  => 3,
					'wi_midbar_social'		 	 	  => 1,
					'wi_midbar_search'		  		  => 1,
					'wi_midbar_cart'		 	 	  => 1,
					// navbar
					'wi_navbar'					 	  => 1,
					'wi_header_nav_type'		 	  => '07',
					// colors
					'wi_top_st_separator'		  	  => 'transparent',
					'wi_top_st_separator_first'  	  => 1,
					'wi_top_st_separator_last'	 	  => 1,
					'wi_top_st_t_color' 			  => 'transparent',
					'wi_top_st_t_width' 			  => '1',
					'wi_top_st_b_color'				  => 'transparent',
					'wi_top_st_b_width'				  => '1',
					'wi_top_st_bg'				 	  => '#212121',
					'wi_top_st_text_color'		 	  => '#ffffff',
					'wi_top_st_text_icons_color' 	  => '#ffffff',
					'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#b09679'), 
					'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#b09679'),
					'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#b09679', 'active' => '#ffffff' ), 
					'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_val'		  	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#b09679', 'hover' => '#b09679'),
					'wi_top_st_searcharea_color'  	  => '#ffffff',
					'wi_top_st_searcharea_bg'     	  => '#212121',
					'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#b09679'),
					'wi_mid_st_bg' 					  => '#ffffff',						
					'wi_mid_st_text_color'			  => '#212121',						
					'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#b09679'),
					'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#b09679'),
					'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#b09679' ),
					'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
					'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
					'wi_mid_st_cart_bg'				  => array( 'regular' => '#b09679', 'hover' => '#b09679'),
					'wi_navbar_border_color'		  => 'transparent',
					);
				break;
		}
		return $wi_header_preset;
	}
}

/* Color Preset
------------------------------------------*/

if (!function_exists('b_i_g_color_preset')) {
	function b_i_g_color_preset($wi_color_preset_meta) {
		$wi_color_preset = '';
		switch ($wi_color_preset_meta) {
			case '1':
				$wi_color_preset = array(
				'wi_accent_color'               => '#ffd824',
				'wi_accent_dark_color'          => '#212121',
				'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#212121' ),
				'wi_accent_buttons_bg_color'    => array( 'regular' => '#212121', 'hover' => '#ffd824' ),
				'wi_accent_top_button_color'    => '#212121',
				'wi_accent_top_button_bg_color' => '#ffd824',				
				);
				break;
			case '2':
				$wi_color_preset = array(
				'wi_accent_color'               => '#00ccfd',
				'wi_accent_dark_color'          => '#212121',
				'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
				'wi_accent_buttons_bg_color'    => array( 'regular' => '#212121', 'hover' => '#00ccfd' ),
				'wi_accent_top_button_color'    => '#ffffff',
				'wi_accent_top_button_bg_color' => '#00ccfd',				
				);
				break;
			case '3':
				$wi_color_preset = array(
				'wi_accent_color'               => '#95532c',
				'wi_accent_dark_color'          => '#212121',
				'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
				'wi_accent_buttons_bg_color'    => array( 'regular' => '#95532c', 'hover' => '#95532c' ),
				'wi_accent_top_button_color'    => '#ffffff',
				'wi_accent_top_button_bg_color' => '#95532c',				
				);
				break;
			case '4':
				$wi_color_preset = array(
				'wi_accent_color'               => '#ffb900',
				'wi_accent_dark_color'          => '#212121',
				'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
				'wi_accent_buttons_bg_color'    => array( 'regular' => '#212121', 'hover' => '#ffb900' ),
				'wi_accent_top_button_color'    => '#ffffff',
				'wi_accent_top_button_bg_color' => '#ffb900',				
				);
				break;
			case '5':
				$wi_color_preset = array(
				'wi_accent_color'               => '#1bc0ea',
				'wi_accent_dark_color'          => '#212121',
				'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
				'wi_accent_buttons_bg_color'    => array( 'regular' => '#1bc0ea', 'hover' => '#30cff8' ),
				'wi_accent_top_button_color'    => '#ffffff',
				'wi_accent_top_button_bg_color' => '#1bc0ea',				
				);
				break;	
			case '6':
				$wi_color_preset = array(
				'wi_accent_color'               => '#d40d14',
				'wi_accent_dark_color'          => '#212121',
				'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
				'wi_accent_buttons_bg_color'    => array( 'regular' => '#d40d14', 'hover' => '#e6262d' ),
				'wi_accent_top_button_color'    => '#ffffff',
				'wi_accent_top_button_bg_color' => '#d40d14',		
				);
				break;
			case '7':
				$wi_color_preset = array(
				'wi_accent_color'               => '#b09679',
				'wi_accent_dark_color'          => '#212121',
				'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
				'wi_accent_buttons_bg_color'    => array( 'regular' => '#b09679', 'hover' => '#957858' ),
				'wi_accent_top_button_color'    => '#ffffff',
				'wi_accent_top_button_bg_color' => '#b09679',		
				);
				break;
		}
		return $wi_color_preset;
	}
}

/* Footer Preset
------------------------------------------*/

if (!function_exists('b_i_g_footer_preset')) {
	function b_i_g_footer_preset($wi_footer_preset_meta) {
		$wi_footer_preset = '';
		switch ($wi_footer_preset_meta) {
			case '1':
				$wi_footer_preset = array(
				'wi_footer_widget_areas'        => '4',
				'wi_foo_bg_color'               => '#212121',
				'wi_foo_headings_color'         => '#ffffff',
				'wi_foo_text_color'             => '#c2c2c2',
				'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#ffd824' ),
				'wi_foo_bottom_border'          => '3',
				'wi_foo_bottom_border_color'    => '#ffd824',
				'wi_foo_bt_bar_bg_color'        => '#252525',
				'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#ffd824' ),
				'wi_foo_bt_bar_border'          => '1',
				'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
				);
				break;
			case '2':
				$wi_footer_preset = array(
				'wi_footer_widget_areas'        => '4',
				'wi_foo_bg_color'               => '#212121',
				'wi_foo_headings_color'         => '#ffffff',
				'wi_foo_text_color'             => '#c2c2c2',
				'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#00ccfd' ),
				'wi_foo_bottom_border'          => '3',
				'wi_foo_bottom_border_color'    => '#00ccfd',
				'wi_foo_bt_bar_bg_color'        => '#252525',
				'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#00ccfd' ),
				'wi_foo_bt_bar_border'          => '1',
				'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
				);
				break;
			case '3':
				$wi_footer_preset = array(
				'wi_footer_widget_areas'        => '4',
				'wi_foo_bg_color'               => '#212121',
				'wi_foo_headings_color'         => '#ffffff',
				'wi_foo_text_color'             => '#c2c2c2',
				'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#95532c' ),
				'wi_foo_bottom_border'          => '3',
				'wi_foo_bottom_border_color'    => '#95532c',
				'wi_foo_bt_bar_bg_color'        => '#252525',
				'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#95532c' ),
				'wi_foo_bt_bar_border'          => '1',
				'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
				);
				break;
			case '4':
				$wi_footer_preset = array(
				'wi_footer_widget_areas'        => '4',
				'wi_foo_bg_color'               => '#212121',
				'wi_foo_headings_color'         => '#ffffff',
				'wi_foo_text_color'             => '#c2c2c2',
				'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#ffb900' ),
				'wi_foo_bottom_border'          => '3',
				'wi_foo_bottom_border_color'    => '#ffb900',
				'wi_foo_bt_bar_bg_color'        => '#252525',
				'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#ffb900' ),
				'wi_foo_bt_bar_border'          => '1',
				'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
				);
				break;
			case '5':
				$wi_footer_preset = array(
				'wi_footer_widget_areas'        => '4',
				'wi_foo_bg_color'               => '#212121',
				'wi_foo_headings_color'         => '#ffffff',
				'wi_foo_text_color'             => '#c2c2c2',
				'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea' ),
				'wi_foo_bottom_border'          => '3',
				'wi_foo_bottom_border_color'    => '#1bc0ea',
				'wi_foo_bt_bar_bg_color'        => '#252525',
				'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea' ),
				'wi_foo_bt_bar_border'          => '1',
				'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
				);
				break;
			case '6':
				$wi_footer_preset = array(
				'wi_footer_widget_areas'        => '4',
				'wi_foo_bg_color'               => '#212121',
				'wi_foo_headings_color'         => '#ffffff',
				'wi_foo_text_color'             => '#c2c2c2',
				'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#d40d14' ),
				'wi_foo_bottom_border'          => '3',
				'wi_foo_bottom_border_color'    => '#d40d14',
				'wi_foo_bt_bar_bg_color'        => '#252525',
				'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#d40d14' ),
				'wi_foo_bt_bar_border'          => '1',
				'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
				);
				break;
			case '7':
				$wi_footer_preset = array(
				'wi_footer_widget_areas'        => '3',
				'wi_foo_bg_color'               => '#2D2C35',
				'wi_foo_headings_color'         => '#ffffff',
				'wi_foo_text_color'             => '#848484',
				'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#b09679' ),
				'wi_foo_bottom_border'          => '3',
				'wi_foo_bottom_border_color'    => '#b09679',
				'wi_foo_bt_bar_bg_color'        => '#2D2C35',
				'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#b09679' ),
				'wi_foo_bt_bar_border'          => '1',
				'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
				);
				break;
		}
		return $wi_footer_preset;
	}
}

/* Search Forms */

function b_i_g_header_search_form( $form ) {
		$form = '<form class="wi-searchbar-form" method="get" action="' . esc_url(home_url('/')) . '">';
		$form .= '<button type="submit" class="wi-searchbar-submit"><i class="fa fa-search"></i></button>';
		$form .= '<input class="wi-searchbar-field" type="search" placeholder="' . esc_attr_x( 'Search', "placeholder",'b-i-g') . '" value="' . get_search_query() . '" name="s" title="' . esc_attr_x( 'Search for:', 'label','b-i-g') . '" /> ';
		$form .= '</form>';
		return $form;
}

function b_i_g_header_search_form_output() {
	add_filter( 'get_search_form', 'b_i_g_header_search_form' );
	get_search_form();
	remove_filter( 'get_search_form', 'b_i_g_header_search_form' );
}

/* Header Favicon */
	
add_action('wp_head','b_i_g_favicon_wp_head');
function b_i_g_favicon_wp_head() {
	if ( function_exists( 'wp_site_icon' )) { wp_site_icon(); } 
	$wi_options = get_option('wi_options');
	if ( !function_exists( 'has_site_icon' ) || ! has_site_icon() ) { 
	echo '<link rel="shortcut icon" href="' . stripslashes($wi_options['wi_header_favicon']['url']) . '"/>';
	}
}

/**
 * Get all sliders in array
 * @result alias => title
 */
function all_rev_sliders_in_array(){
  if (class_exists('RevSlider')) {
    $theslider     = new RevSlider();
    $arrSliders = $theslider->getArrSliders();
    $arrA     = array();
    $arrT     = array();
    foreach($arrSliders as $slider){
      $arrA[]     = $slider->getAlias();
      $arrT[]     = $slider->getTitle();
    }
    if($arrA && $arrT){
      $result = array_combine($arrA, $arrT);
		$arrSliders[0] = 'Select a Slider';
    }
    else {
      $result = false;
    }
    return $result;
  }
}