<?php
$wi_options = get_option('wi_options');

$hex = $wi_options['wi_accent_color'];
list($r, $g, $b) = sscanf($hex, "#%02x%02x%02x");
$rgbacolor = "rgba("."$r".","."$g".","."$b".",0.5)";

?>

/* Compiled CSS
 *
 *
 * Main Palette
----------------------------------------------- */

/* accent color */

a, a:focus, a:hover { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.btn:hover { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.before-after-yellow.cq-beforeafter .cq-beforeafter-handle.lightgray i{ background: <?php echo balanceTags($wi_options['wi_accent_color']); ?> !important; }
.yellow-background-hover:hover { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?> !important; border-color: <?php echo balanceTags($wi_options['wi_accent_color']); ?> !important; }
.menu-footer-container li a:hover:before { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.draggable-timeline-theme-color .cq-infobox { border-color: <?php echo balanceTags($wi_options['wi_accent_color']); ?> !important; }
.draggable-timeline-theme-color .cq-infobox:before { border-color: <?php echo balanceTags($wi_options['wi_accent_color']); ?> transparent !important; }
.draggable-timeline-theme-color .cq-infobox .cq-titlebar, .draggable-timeline-theme-color .cq-infobox .cq-titlecontainer { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?> !important; }
.colored { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_topbar a:hover { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_cart a.cart-total { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_cart a.cart-total:before { border-color: transparent <?php echo balanceTags($wi_options['wi_accent_color']); ?> transparent transparent; }
#lmm .widget.widget_shopping_cart a.button:hover { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?> !important; }
.wpcf7-submit { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wpcf7-validation-errors, .wpcf7-mail-sent-ok { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_news_title a:hover { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_widget a:hover { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_blog_meta a:hover {	color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_date_y { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
#wp-calendar a { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
#wp-calendar caption { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_tweet_time > a.twitter_time { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.list-star li:before { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.fn a, .wi_commente_holder h4 a { color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_ticket_commentlist > li ul .comment-body { border-color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.bypostauthor .fn:before { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
#back-top a { background: <?php echo balanceTags($wi_options['wi_accent_color']); ?>; }
.wi_footer_copyrights a:hover {	color: <?php echo balanceTags($wi_options['wi_accent_color']); ?>;}

/* accent dark color */

::selection { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
body { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.btn { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.btn:hover { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.btn_black { background: none repeat scroll 0 0 <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.testimonials-01 .cq-vectorcard-content { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.cq-scroll-notification { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?> !important; }
.cq-scroll-notification a { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; border-color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.cq-testimonialcarousel .testimonial-info h4 { margin:10px auto !important; color:<?php echo balanceTags($wi_options['wi_accent_dark_color']); ?> !important; }
.eg-winvader-main-colored-wrapper .wi_quote_count { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.eg-winvader-main-colored-wrapper .wi_more_btn { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.header_cart_button { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_menu_content_holder > ul > li > a:after { background: none repeat scroll 0 0 <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
#wi_menu-toggle:after, #wi_menu-toggle:before { background: none repeat scroll 0 0 <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
#wi_menu-toggle { background: none repeat scroll 0 0 <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_menu_content_holder > ul > li > a:after { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_topbar { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_searchbar {	background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.mid_cart.wi_cart a.cart-icon:hover { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_cart a.cart-total { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
#lmm .widget.widget_shopping_cart a.button { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?> !important; }
#lmm .widget.widget_shopping_cart a.button:hover { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?> !important; }
.wi-right-arrow-dark:after { border-left-color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi-left-arrow-dark:after { border-right-color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.winvader-main .esg-cartbutton { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.winvader-main .esg-cartbutton .esgicon-basket { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.winvader-main .esg-navigationbutton:hover,.winvader-main .esg-filterbutton:hover,.winvader-main .esg-sortbutton:hover,.winvader-main .esg-sortbutton-order:hover,.winvader-main .esg-cartbutton a:hover,.winvader-main .esg-filterbutton.selected { border-color: transparent;	color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.winvader-main .esg-navigationbutton:hover * { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.winvader-main .esg-sortbutton-order.tp-desc:hover { border-color: transparent; color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.winvader-main .esg-filterbutton.selected .esg-filter-checked,.winvader-main .esg-filterbutton:hover .esg-filter-checked { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_readmore_btn { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wpcf7-submit { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wpcf7-submit:hover { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.widget_shopping_cart_content .empty { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.searchsubmit { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_widget .io_widget_title { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_widget a { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_blog_meta a { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_full_blog_post_date { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.tag_line .breadcrumbs h4 { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.tag_line h4 { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_breadcrumbs a:hover { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_breadcrumbs .current { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
#wp-calendar caption { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.tagcloud a:hover { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.pride_pg .page-numbers { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.pride_pg .page-numbers:not(.current):hover { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.page-numbers.current { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
ol.wi_ticket_commentlist > li:before { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
ol.wi_ticket_commentlist > li:after { border-color: transparent <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?> transparent transparent; }
.show-grid .show-grid [class*="col-md-"] { background-color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_ticket_commentlist .comment-meta a { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_ticket_commentlist li .comment-body .reply a { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_post_share_icons div { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_blog_tags a { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_blog_tags a:hover {	background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
#back-top a { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_back_btn:hover { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_footer_holder { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.wi_f_widget .wpcf7-submit { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.soc_round { border-color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.cbutton { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.cbutton:hover { background: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }
.cbutton.cbutton--click,.cbutton:focus { color: <?php echo balanceTags($wi_options['wi_accent_dark_color']); ?>; }

/* go top color */

#back-top a { color: <?php echo balanceTags($wi_options['wi_accent_top_button_color']); ?>; background: <?php echo balanceTags($wi_options['wi_accent_top_button_bg_color']); ?>; }

/* theme buttons color
 * 
 * regular */

.btn,
.wpcf7-submit,
.woocommerce ul.products li.product .button,
.widget_shopping_cart_content a.button.wc-forward, 
.widget_shopping_cart_content a.button.checkout,
.widget_price_filter .price_slider_amount .button,
.page-numbers.current,
#lmm .widget.widget_shopping_cart a.button { color: <?php echo balanceTags($wi_options['wi_accent_buttons_color']['regular']); ?> !important; background: <?php echo balanceTags($wi_options['wi_accent_buttons_bg_color']['regular']); ?> !important;  }

/* hover */

.btn:hover,
.wpcf7-submit:hover,
.woocommerce ul.products li.product .button:hover,
.widget_shopping_cart_content a.button.wc-forward:hover, 
.widget_shopping_cart_content a.button.checkout:hover,
.widget_price_filter .price_slider_amount .button:hover,
#lmm .widget.widget_shopping_cart a.button:hover { color: <?php echo balanceTags($wi_options['wi_accent_buttons_color']['hover']); ?> !important; background: <?php echo balanceTags($wi_options['wi_accent_buttons_bg_color']['hover']); ?> !important; }

/* Main Reset
----------------------------------------------- */

body {
	font-family: <?php echo balanceTags($wi_options['wi_main_body_typography']['font-family']); ?>;
	font-size: <?php echo balanceTags($wi_options['wi_main_body_typography']['font-size']); ?>;
	font-weight: <?php echo balanceTags($wi_options['wi_main_body_typography']['font-weight']); ?>;
	letter-spacing: <?php echo balanceTags($wi_options['wi_main_body_typography']['letter-spacing']); ?>;
	line-height: <?php echo balanceTags($wi_options['wi_main_body_typography']['line-height']); ?>px;
	color: <?php echo balanceTags($wi_options['wi_main_body_typography']['color']); ?>;	
}

a { color: <?php echo balanceTags($wi_options['wi_main_links_typography']['regular']); ?>; }
a:hover { color: <?php echo balanceTags($wi_options['wi_main_links_typography']['hover']); ?>; }

h1, h2, h3, h4, h5, h6:not(.wi_blog_legend_descr) {
	font-family: <?php echo balanceTags($wi_options['wi_headings_typography']['font-family']); ?>;
	font-weight: <?php echo balanceTags($wi_options['wi_headings_typography']['font-weight']); ?>;
	letter-spacing: <?php echo balanceTags($wi_options['wi_headings_typography']['letter-spacing']); ?>;
	color: <?php echo balanceTags($wi_options['wi_headings_typography']['color']); ?>;	
}

h1 a, h2 a, h3 a, h4 a, h5 a { color: <?php echo balanceTags($wi_options['wi_headings_links_typography']['regular']); ?> }
h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover { color: <?php echo balanceTags($wi_options['wi_headings_links_typography']['hover']); ?> }

/* vc */

@media (min-width: 1200px) { .container { width: <?php echo balanceTags($wi_options['wi_custom_bootstrap_maxsize']); ?>px; max-width: 100%; } }
@media (min-width: 1200px) {  #lmm .container { width: <?php echo balanceTags($wi_options['wi_custom_bootstrap_maxsize']); ?>px !important; max-width: 100%; } }


body { background:url('<?php echo esc_url($wi_options['wi_background_upload']['url']); ?>'); background-size: <?php echo balanceTags($wi_options['wi_pattern_size']); ?> auto;}
.preloader-holder { background:url('<?php echo esc_url($wi_options['wi_background_upload']['url']); ?>'); background-size: <?php echo balanceTags($wi_options['wi_pattern_size']); ?> auto;}

/* Header Styling
----------------------------------------------- */

.lmm-navbar-nav { border-color: <?php echo balanceTags($wi_options['wi_navbar_border_color']); ?> !important; }
<?php if ( $wi_options['wi_navbar_border_color'] != 'transparent' ) { ?>
	.lmm-navbar-brand { padding-left: 30px !important; padding-right: 30px !important; }
<?php } else { ?>
	.lmm-navbar-nav { border-left-width: 0px; border-right-width: 0px; }
<?php } ?>


.wi_tb_st>div>div {
	border-left-color: <?php echo balanceTags($wi_options['wi_top_st_separator']); ?>;
}

.wi_tb_st>div {
	border-right-color: <?php echo balanceTags($wi_options['wi_top_st_separator']); ?>;
}
<?php if ( $wi_options['wi_top_st_separator_first'] == 0 ) { ?>
.wi_tb_st>div:first-child { border-right-color: transparent; }
<?php } else {?>
.wi_tb_st>div:first-child { border-right-color: <?php echo balanceTags($wi_options['wi_top_st_separator']); ?>; }
<?php }?>

<?php if ( $wi_options['wi_top_st_separator_last'] == 0 ) { ?>
.wi_tb_st .float-right>div:first-child { border-left-color:transparent; }
<?php } else {?>
.wi_tb_st .float-right>div:first-child { border-left-color: <?php echo balanceTags($wi_options['wi_top_st_separator']); ?>; }
<?php }?>

<?php if ( $wi_options['wi_top_st_separator'] == 'transparent' ) { ?> 
.wi_tb_st>div>div, .wi_tb_st>div { border-left: none; border-right: none; }
.wi_tb_st .float-left>div:first-child { padding-left: 0px; }
.wi_tb_st .float-right>div:last-child, .wi_tb_st .float-right>div.last-child { padding-right: 0px; }
<?php } ?>
/* topbar */

.wi_topbar { background-color: <?php echo balanceTags($wi_options['wi_top_st_bg']); ?>; }

.wi_topbar { border-top-color: <?php echo balanceTags($wi_options['wi_top_st_t_color']); ?>; border-top-width: <?php echo balanceTags($wi_options['wi_top_st_t_width']); ?>px; }	
.wi_topbar { border-bottom-color: <?php echo balanceTags($wi_options['wi_top_st_b_color']); ?>; border-bottom-width: <?php echo balanceTags($wi_options['wi_top_st_b_width']); ?>px; }

.wi_topbar { color: <?php echo balanceTags($wi_options['wi_top_st_text_color']); ?>; }
.wi_topbar .top_phone:before, .wi_topbar .top_email:before, .wi_topbar .top_whours:before { color: <?php echo balanceTags($wi_options['wi_top_st_text_icons_color']); ?>; }

.wi_topbar a { color: <?php echo balanceTags($wi_options['wi_top_st_text_link_color']['regular']); ?>; }
.wi_topbar a:hover { color: <?php echo balanceTags($wi_options['wi_top_st_text_link_color']['hover']); ?>; }

.wi_topbar .top_social a { color: <?php echo balanceTags($wi_options['wi_top_st_social_color']['regular']); ?>; }
.wi_topbar .top_social a:hover { color: <?php echo balanceTags($wi_options['wi_top_st_social_color']['hover']); ?>; } 

.wi_topbar .top_search { color: <?php echo balanceTags($wi_options['wi_top_st_search_color']['regular']); ?>; }
.wi_topbar .top_search:hover { color: <?php echo balanceTags($wi_options['wi_top_st_search_color']['hover']); ?>; }
.wi_topbar .top_search_close { color: <?php echo balanceTags($wi_options['wi_top_st_search_color']['active']); ?>; }

.wi_topbar .top_cart a.cart-icon { color: <?php echo balanceTags($wi_options['wi_top_st_cart_color']['regular']); ?>; }
.wi_topbar .top_cart:hover a.cart-icon { color: <?php echo balanceTags($wi_options['wi_top_st_cart_color']['hover']); ?>; }

.wi_topbar .top_cart a.cart-total { color: <?php echo balanceTags($wi_options['wi_top_st_cart_val']['regular']); ?>; }
.wi_topbar .top_cart:hover a.cart-total { color: <?php echo balanceTags($wi_options['wi_top_st_cart_val']['hover']); ?>; }

.wi_topbar .top_cart a.cart-total { color: <?php echo balanceTags($wi_options['wi_top_st_cart_val']['regular']); ?>; }
.wi_topbar .top_cart:hover a.cart-total { color: <?php echo balanceTags($wi_options['wi_top_st_cart_val']['hover']); ?>; }

.wi_topbar .top_cart a.cart-total:before { border-color: transparent <?php echo balanceTags($wi_options['wi_top_st_cart_bg']['regular']); ?> transparent transparent; }
.wi_topbar .top_cart:hover a.cart-total:before { border-color: transparent <?php echo balanceTags($wi_options['wi_top_st_cart_bg']['hover']); ?> transparent transparent; }

.wi_topbar .top_cart a.cart-total { background-color: <?php echo balanceTags($wi_options['wi_top_st_cart_bg']['regular']); ?>; }
.wi_topbar .top_cart:hover a.cart-total { background-color: <?php echo balanceTags($wi_options['wi_top_st_cart_bg']['hover']); ?>; }

.wi_searchbar { color: <?php echo balanceTags($wi_options['wi_top_st_searcharea_color']); ?>; }
.wi_searchbar { background-color: <?php echo balanceTags($wi_options['wi_top_st_searcharea_bg']); ?>; }

.wi_searchbar .wi-searchbar-submit { color: <?php echo balanceTags($wi_options['wi_top_st_searcharea_icon_color']['regular']); ?>; }
.wi_searchbar .wi-searchbar-submit:hover { color: <?php echo balanceTags($wi_options['wi_top_st_searcharea_icon_color']['hover']); ?>; }

/* midbar */

.wi_midbar { background-color: <?php echo balanceTags($wi_options['wi_mid_st_bg']); ?>; }

.wi_midbar .mid_social a { color: <?php echo balanceTags($wi_options['wi_mid_st_social_color']['regular']); ?>; }
.wi_midbar .mid_social a:hover { color: <?php echo balanceTags($wi_options['wi_mid_st_social_color']['hover']); ?>; } 

.wi_midbar .mid_search { color: <?php echo balanceTags($wi_options['wi_mid_st_search_color']['regular']); ?>; }
.wi_midbar .mid_search:hover { color: <?php echo balanceTags($wi_options['wi_mid_st_search_color']['hover']); ?>; }
.wi_midbar .mid_search_close { color: <?php echo balanceTags($wi_options['wi_mid_st_search_color']['active']); ?>; }

.wi_midbar .mid_cart a.cart-icon { color: <?php echo balanceTags($wi_options['wi_mid_st_cart_color']['regular']); ?>; }
.wi_midbar .mid_cart:hover a.cart-icon { color: <?php echo balanceTags($wi_options['wi_mid_st_cart_color']['hover']); ?>; }

.wi_midbar .mid_cart a.cart-total { color: <?php echo balanceTags($wi_options['wi_mid_st_cart_val']['regular']); ?>; }
.wi_midbar .mid_cart:hover a.cart-total { color: <?php echo balanceTags($wi_options['wi_mid_st_cart_val']['hover']); ?>; }

.wi_midbar .mid_cart a.cart-total { color: <?php echo balanceTags($wi_options['wi_mid_st_cart_val']['regular']); ?>; }
.wi_midbar .mid_cart:hover a.cart-total { color: <?php echo balanceTags($wi_options['wi_mid_st_cart_val']['hover']); ?>; }

.wi_midbar .mid_cart a.cart-total:before { border-color: transparent <?php echo balanceTags($wi_options['wi_mid_st_cart_bg']['regular']); ?> transparent transparent; }
.wi_midbar .mid_cart:hover a.cart-total:before { border-color: transparent <?php echo balanceTags($wi_options['wi_mid_st_cart_bg']['hover']); ?> transparent transparent; }

.wi_midbar .mid_cart a.cart-total { background-color: <?php echo balanceTags($wi_options['wi_mid_st_cart_bg']['regular']); ?>; }
.wi_midbar .mid_cart:hover a.cart-total { background-color: <?php echo balanceTags($wi_options['wi_mid_st_cart_bg']['hover']); ?>; }

.midbar-cutom-code { color: <?php echo balanceTags($wi_options['wi_mid_st_text_color']); ?>; }
.midbar-cutom-code a { color: <?php echo balanceTags($wi_options['wi_mid_st_text_link_color']['regular']); ?>; }
.midbar-cutom-code a:hover { color: <?php echo balanceTags($wi_options['wi_mid_st_text_link_color']['hover']); ?>; }

/* Footer Styling
----------------------------------------------- */

.wi_footer_holder { border-bottom-width: <?php echo balanceTags($wi_options['wi_foo_bottom_border']); ?>px; border-bottom-color: <?php echo balanceTags($wi_options['wi_foo_bottom_border_color']); ?>; background: <?php echo balanceTags($wi_options['wi_foo_bg_color']); ?>; }

.wi_footer_copyrights { border-top-width: <?php echo balanceTags($wi_options['wi_foo_bt_bar_border']); ?>px; border-top-color: <?php echo balanceTags($wi_options['wi_foo_bt_bar_color']['rgba']); ?>; background: <?php echo balanceTags($wi_options['wi_foo_bt_bar_bg_color']); ?>; }

.wi_widget_title_single { color: <?php echo balanceTags($wi_options['wi_foo_headings_color']); ?>}
.wi_footer { color: <?php echo balanceTags($wi_options['wi_foo_text_color']); ?>}

.wi_tweet_time > a.twitter_time { color: <?php echo balanceTags($wi_options['wi_foo_text_link_color']['hover']); ?>; }
.wi_footer a { color: <?php echo balanceTags($wi_options['wi_foo_text_link_color']['regular']); ?>}
.wi_footer a:hover { color: <?php echo balanceTags($wi_options['wi_foo_text_link_color']['hover']); ?>; }

.wi_footer_copyrights a { color: <?php echo balanceTags($wi_options['wi_foo_bt_bar_link_color']['regular']); ?>}
.wi_footer_copyrights a:hover { color: <?php echo balanceTags($wi_options['wi_foo_bt_bar_link_color']['hover']); ?>; }


<?php echo balanceTags($wi_options['wi_custom_css']); ?>