<?php

class lmm_panel {

    function __construct() {

        if (defined('LIQUIDA'))
            return;

        if (!is_admin())
            return;

        add_filter('admin_body_class', array($this, 'add_body_class'));

        if (!current_user_can('switch_themes'))
            return;

        add_action('admin_menu', array($this, 'remove_redux_menu'), 12);

        add_action('admin_menu', array($this, 'register_menu_panel'));

        add_filter('redux/options/' . LMM . '/args', array($this, 'lmm_menu_panel'));

        add_filter('redux/' . LMM . '/panel/template/header.tpl.php', array($this, 'lmm_redux_header'));

        add_action('redux/' . LMM . '/panel/before', array($this, 'lmm_panel_header'));
    }

    function remove_redux_menu() {
        remove_submenu_page('tools.php', 'redux-about');
    }

    function register_menu_panel() {

        global $submenu; // this is a global from WordPress

        add_menu_page(LMM_NAME . ' Panel', LMM_NAME, "edit_posts", "lmm_menu_welcome", array($this, "lmm_view_welcome"), LMM_URL_ASSETS . '/backend/images/icon.svg', 3);
        add_submenu_page("lmm_menu_welcome", 'Install demos', 'Install demos', 'edit_posts', 'lmm_menu_demos', array($this, "lmm_menu_demos"));
        //add_submenu_page("lmm_menu_welcome", 'Support', 'Support', 'edit_posts', 'lmm_menu_support', array($this, "lmm_menu_support"));
        add_submenu_page("lmm_menu_welcome", 'System status', 'System status', 'edit_posts', 'lmm_system_status', array($this, "lmm_system_status"));

        $submenu['lmm_menu_welcome'][0][0] = 'Welcome';
    }

    function lmm_redux_header($path = false) {
        return dirname(__FILE__) . '/lib/redux/template/header.tpl.php';
    }

    function lmm_view_welcome() {
        require_once 'panel/welcome.php';
    }

    function lmm_menu_demos() {
        require_once 'panel/demos.php';
    }

    function lmm_system_status() {
        require_once 'panel/system.php';
    }

    function lmm_panel_header() {
        require_once 'panel/header.php';
    }

    function lmm_menu_panel($args) {

        $args['menu_type'] = 'submenu';
        $args['page_parent'] = 'lmm_menu_welcome';
        $args['page_slug'] = LMM_PANEL;
        $args['allow_sub_menu'] = true;
        $args['display_name'] = __('Menu Panel', 'lmm');
        $args['menu_title'] = __('Menu Panel', 'lmm');
        $args['page'] = __('Menu Panel', 'lmm');

        return $args;
    }

    static function add_body_class($classes) {

        global $pagenow;

        $screen = get_current_screen();

        if (strpos($screen->base, sanitize_title(LMM_NAME)) === false && $screen->base != 'toplevel_page_lmm_menu_welcome')
            return $classes;

        $classes .= 'admin-color-liquida';


        return $classes;
    }

}

new lmm_panel();
