<?php
/**
 * Copied from Walker_Nav_Menu_Edit class in core
 * 
 * Create HTML list of nav menu input items.
 *
 * @package WordPress
 * @since 3.0.0
 * @uses Walker_Nav_Menu
 */
//scripts support --------------------------------------------------------------

add_action('admin_head-nav-menus.php', 'lmm_navmenus_scripts', 990);

function lmm_navmenus_scripts() {

    wp_enqueue_style('lmm-navmenu');

    wp_enqueue_script('lmm-admin');

    wp_enqueue_script('lmm-modal');

    wp_enqueue_media();
}

// add modal box ---------------------------------------------------------------
add_action('admin_footer-nav-menus.php', 'lmm_modal_box');

//admin walker -----------------------------------------------------------------
add_filter('wp_edit_nav_menu_walker', 'lmm_custom_nav_edit_walker', 2015, 2);

function lmm_custom_nav_edit_walker($walker, $menu_id) {
    return 'lmm_navwalker_edit';
}

add_action('print_media_templates', 'lmm_background_settings_hook');

function lmm_background_settings_hook() {
// define your backbone template;
// the "tmpl-" prefix is required,
// and your input field should have a data-setting attribute
// matching the shortcode name
    ?>
    <script type="text/html" id="tmpl-attachment-background">
        <div class="attachment-info">
            <h2>Background Settings</h2>
            <label class="setting">
                <span>Position</span>
                <select data-setting="position">
                    <option value="left top">left top</option>
                    <option value="left center">left center</option>
                    <option value="left bottom">left bottom</option>
                    <option value="right top">right top</option>
                    <option value="right center">right center</option>
                    <option value="right bottom" selected>right bottom</option>
                    <option value="center top">center top</option>
                    <option value="center center">center center</option>
                    <option value="center bottom">center bottom</option>
                </select>
            </label>
            <label class="setting">
                <span>Repeat</span>
                <select data-setting="repeat">
                    <option selected value="repeat">repeat</option>
                    <option value="no-repeat" selected>no-repeat</option>
                </select>
            </label>
            <label class="setting">
                <span>Attachment</span>
                <select data-setting="attachment">               
                    <option value="scroll">scroll</option>
                    <option value="fixed" selected>fixed</option>
                    <option value="local">local</option>
                    <option value="initial">initial</option>
                    <option value="inherit">inherti</option>
                </select>
            </label>
            <label class="setting">
                <span>Size</span>
                <select data-setting="size">               
                    <option value="auto">auto</option>
                    <option value="cover">cover</option>
                    <option value="contain" selected>contain</option>
                </select>
            </label>
        </script>
    </div>

    <?php
}

class lmm_navwalker_edit extends Walker_Nav_Menu {

    public function add_icon($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('icon', $item->admin['fields']))
            return;
        ?>
        <!-- lmm icon -->
        <p class="field-icon description description-wide">
            <label for="edit-menu-item-icon-<?php echo $item_id; ?>">
                <a class="add_icon" href="#" data-toggle="modal" data-target="#modalIcon" data-backdrop="true" data-id="edit-menu-item-icon-<?php echo $item_id; ?>" data-value="<?php echo esc_attr($item->icon); ?>"><?php _e('+ Add Icon', 'lmm') ?></a>
                <input type="text" id="edit-menu-item-icon-<?php echo $item_id; ?>" class="widefat code edit-menu-item-icon" name="menu-item-icon[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->icon); ?>" />
            </label>
        </p>
        <!-- /lmm icon -->
        <?php
    }

    public function add_icon_logout($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('icon_logout', $item->admin['fields']))
            return;
        ?>
        <!-- lmm icon logout -->
        <p class="field-icon description description-wide">
            <label for="edit-menu-item-icon-logout-<?php echo $item_id; ?>">
                <a class="add_icon" href="#" data-toggle="modal" data-target="#modalIcon" data-backdrop="true" data-id="edit-menu-item-icon-logout-<?php echo $item_id; ?>" data-value="<?php echo esc_attr($item->icon); ?>"><?php _e('+ Add Icon Logout', 'lmm') ?></a>
                <input type="text" id="edit-menu-item-icon-logout-<?php echo $item_id; ?>" class="widefat code edit-menu-item-icon-logout" name="menu-item-icon-logout[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->icon); ?>" />
            </label>
        </p>
        <!-- /lmm icon logout -->
        <?php
    }

    public function add_subtitle($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('subtitle', $item->admin['fields']))
            return;
        ?>
        <!-- lmm subtitle -->
        <p class="description description-wide">
            <label for="edit-menu-item-subtitle-<?php echo $item_id; ?>">
                <?php _e('Subtitle'); ?><br />
                <input type="text" id="edit-menu-item-subtitle-<?php echo $item_id; ?>" class="widefat edit-menu-item-subtitle" name="menu-item-subtitle[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->subtitle); ?>" />
            </label>
        </p>
        <!-- /lmm subtitle -->
        <?php
    }

    public function add_float($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('float', $item->admin['fields']))
            return;
        ?>
        <!-- lmm float -->
        <p class="field-float description description-wide lmm-mega-menu custom-show-lvl-0 taxonomy-show-lvl-0 post_type-show-lvl-0 lmm-icon-show-lvl-0 lmm-mega-show lmm-tabs-show lmm-login-show lmm-cart-show lmm-search-show lmm-social-show">
            <label for="edit-menu-item-wide-float-<?php echo $item_id; ?>">
                <?php _e('Float', 'lmm'); ?><br />
                <select id="edit-menu-item-float-<?php echo $item_id; ?>" class="widefat code edit-menu-item-float" name="menu-item-float[<?php echo $item_id; ?>]">
                    <option value="" <?php if ($item->float == '') echo "selected"; ?> >Default</option>
                    <option value="float-opposite" <?php if ($item->float == 'float-opposite') echo "selected"; ?> >Opposite</option>
                </select>
            </label>
        </p>
        <!-- /lmm float -->
        <?php
    }

    public function add_post_thumbnail($item_id, $item) {

        if ($item->type != 'post_type')
            return;

        //var_dump($item->admin['fields']['thumb']);
        ?>
        <!-- thumbnail -->
        <p class="field-link-thumb description description-wide lmm-mega-menu post_type-show-lvl-1 post_type-show-lvl-2 post_type-show-lvl-3">
            <label for="edit-menu-item-thumb-<?php echo $item_id; ?>">
                <?php _e('Show featured image', 'lmm'); ?>
                <select id="edit-menu-item-thumb-<?php echo $item_id; ?>" class="widefat code edit-menu-item-thumb" name="menu-item-thumb[<?php echo $item_id; ?>]">
                    <?php foreach ($item->admin['fields']['thumb'] as $key => $name): ?>
                        <option value="<?php echo $key; ?>" <?php if ($item->thumb == $key) echo "selected"; ?> ><?php echo $name; ?></option>
                    <?php endforeach; ?>
                </select>
            </label>
        </p>
        <!-- /thumbnail -->
        <?php
    }

    public function add_dropdown_align($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('dropdown_align', $item->admin['fields']))
            return;
        ?>
        <!-- lmm dropdown align -->
        <p class="field-dropdown description description-wide lmm-mega-menu custom-show taxonomy-show-lvl-0 post_type-show lmm-mega-show lmm-tabs-show lmm-login-show lmm-cart-show lmm-search-show" >
            <label for="edit-menu-item-wide-dropdown-<?php echo $item_id; ?>">
                <?php _e('Dropdown Align', 'lmm'); ?><br />
                <select id="edit-menu-item-dropdown-<?php echo $item_id; ?>" class="widefat code edit-menu-item-dropdown" name="menu-item-dropdown[<?php echo $item_id; ?>]">
                    <option value="" <?php if ($item->dropdown == '') echo "selected"; ?> >Dropdown Right</option>
                    <option value="dropdown-left" <?php if ($item->dropdown == 'dropdown-left') echo "selected"; ?> >Dropdown Left</option>
                </select> 
            </label>
        </p>
        <!-- /lmm dropdown align -->
        <?php
    }

    public function add_options($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('options', $item->admin['fields']))
            return;
        ?>
        <!-- lmm options -->
        <p class="field-cart description description-wide">
            <label for="edit-menu-item-wide-options-<?php echo $item_id; ?>">
                <?php _e('Options', 'lmm'); ?><br />
                <select id="edit-menu-item-options-<?php echo $item_id; ?>" class="widefat code edit-menu-item-options" name="menu-item-options[<?php echo $item_id; ?>]">
                    <?php foreach ($item->admin['fields']['options'] as $key => $name): ?>
                        <option value="<?php echo $key; ?>" <?php if ($item->options == $key) echo "selected"; ?> ><?php echo $name; ?></option>
                    <?php endforeach; ?>
                </select>
            </label>
        </p>
        <!-- /lmm options -->
        <?php
    }

    public function add_sub_columns_new($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('sub_columns', $item->admin['fields']))
            return;
        ?>
        <!-- lmm sub columns -->
        <p class="field-columns description description-wide">
            <label for="edit-menu-item-mega-sub-columns-<?php echo $item_id; ?>">
                <a class="add_icon" href="#" data-toggle="modal" data-target="#modalColumnOffset" data-backdrop="true" data-id="edit-menu-item-mega-sub-columns-<?php echo $item_id; ?>" data-field="subcolumns" data-value="<?php echo esc_attr($item->mega_sub_columns); ?>"><?php _e('+ Set Width', 'lmm') ?></a>
                <input type="text" id="edit-menu-item-mega-sub-columns-<?php echo $item_id; ?>" class="widefat code edit-menu-item-mega-sub-columns" name="menu-item-mega-sub-columns[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->mega_sub_columns); ?>" readonly/>
            </label>
        </p>

        <!-- /lmm sub columns -->
        <?php
    }

    public function add_columns_new($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('columns', $item->admin['fields']))
            return;
        ?>
        <!-- lmm columns -->
        <p class="field-columns description description-wide">
            <label for="edit-menu-item-mega-columns-<?php echo $item_id; ?>">
                <a class="add_icon" href="#" data-toggle="modal" data-target="#modalColumnOffset" data-backdrop="true" data-id="edit-menu-item-mega-columns-<?php echo $item_id; ?>" data-field="columns" data-value="<?php echo esc_attr($item->mega_columns); ?>"><?php _e('+ Set Width', 'lmm') ?></a>
                <input type="text" id="edit-menu-item-mega-columns-<?php echo $item_id; ?>" class="widefat code edit-menu-item-mega-columns" name="menu-item-mega-columns[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->mega_columns); ?>" readonly/>
            </label>
        </p>

        <!-- /lmm columns -->
        <?php
    }

    public function add_background($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('background', $item->admin['fields']))
            return;
        ?>
        <!-- lmm background -->
        <p class="field-mega-background description description-wide lmm-mega-menu lmm-mega-show lmm-tabs-show">
            <?php
            $_src = !empty($item->mega_background_thumbnail_id) ? wp_get_attachment_image_src($item->mega_background_thumbnail_id, 'thumbnail') : false;

            $have_background = ( strlen($_src[0]) > 0 ? 'active' : '' );
            ?>

            <span class="field-mega-background-wrapper <?php echo $have_background; ?>">
                <span class="edit-menu-item-mega-background-thumbnail">
                    <?php if ($have_background): ?>
                        <img src="<?php echo esc_attr($_src[0]); ?>" width="50" height="50" id="mega-background-thumbnail-menu-item-<?php echo $item_id; ?>" title="menu-item-<?php echo $item_id; ?>-background" alt="menu-item-<?php echo $item_id; ?>-background">
                    <?php endif ?>
                </span>
                <span class="edit-menu-item-mega-background-text"><?php _e('Select background image', 'lmm'); ?></span>
                <a id="<?php echo $item_id; ?>" class="custom_clear_mega_image" href="javascript:void(0)" ><?php _e('Remove Image', 'lmm'); ?></a>
                <a id="<?php echo $item_id; ?>" class="custom_upload_mega_image" href="javascript:void(0)"><?php _e('Select Image', 'lmm'); ?></a>

                <span class="edit-menu-item-mega-background-css"><?php
                    if ($have_background): echo $item->mega_background_position . ',' . $item->mega_background_repeat . ',' . $item->mega_background_attachment . ',' . $item->mega_background_size;
                    endif
                    ?></span>                
                <input type="hidden" id="edit-menu-item-mega-background-thumbnail-id-<?php echo $item_id; ?>" class="widefat edit-menu-item-mega-background-thumbnail-id" name="menu-item-mega-background-thumbnail-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->mega_background_thumbnail_id); ?>" />
                <input type="hidden" id="edit-menu-item-mega-background-position-<?php echo $item_id; ?>" class="widefat edit-menu-item-mega-background-position" name="menu-item-mega-background-position[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->mega_background_position); ?>" />
                <input type="hidden" id="edit-menu-item-mega-background-repeat-<?php echo $item_id; ?>" class="widefat edit-menu-item-mega-background-repeat" name="menu-item-mega-background-repeat[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->mega_background_repeat); ?>" />
                <input type="hidden" id="edit-menu-item-mega-background-attachment-<?php echo $item_id; ?>" class="widefat edit-menu-item-mega-background-attachment" name="menu-item-mega-background-attachment[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->mega_background_attachment); ?>" />
                <input type="hidden" id="edit-menu-item-mega-background-size-<?php echo $item_id; ?>" class="widefat edit-menu-item-mega-background-size" name="menu-item-mega-background-size[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->mega_background_size); ?>" />
            </span>
        </p>
        <!-- /lmm background -->
        <?php
    }

    public function add_widget($item_id, $item) {

        if (empty($item->admin['fields']) || !array_key_exists('widget', $item->admin['fields']))
            return;
        ?>
        <!-- lmm widget -->
        <p class="field-wide-widget description description-wide lmm-mega-menu widget-show">
            <label for="edit-menu-item-mega-sidebar-<?php echo $item_id; ?>">
                <span class="description"><?php _e('Display a Widget Area', 'lmm'); ?></span>
                <?php echo lmm_select_sidebar($item_id, esc_attr($item->mega_sidebar)); ?>
            </label>
        </p>
        <!-- /lmm widget -->
        <?php
    }

    public function add_settings($item) {

        $item_id = esc_attr($item->ID);

        $this->add_post_thumbnail($item_id, $item);

        $this->add_icon($item_id, $item);

        $this->add_icon_logout($item_id, $item);

        $this->add_subtitle($item_id, $item);

        $this->add_float($item_id, $item);

        $this->add_sub_columns_new($item_id, $item);

        $this->add_dropdown_align($item_id, $item);

        $this->add_options($item_id, $item);

        $this->add_columns_new($item_id, $item);

        $this->add_background($item_id, $item);

        $this->add_widget($item_id, $item);
        ?>

        <!-- lmm common fields -->                      
        <p class="field-hidden description description-wide lmm-mega-menu custom-show-lvl-0 taxonomy-show-lvl-0 post_type-show-lvl-0 lmm-icon-show-lvl-0 lmm-social-show lmm-mega-show lmm-tabs-show lmm-login-show lmm-cart-show lmm-search-show" >
            <label for="edit-menu-item-wide-hidden-<?php echo $item_id; ?>">
                <?php _e('Hidden on', 'lmm'); ?><br />
                <select multiple id="edit-menu-item-hidden-<?php echo $item_id; ?>" class="widefat code edit-menu-item-hidden" name="menu-item-hidden[<?php echo $item_id; ?>][]">
                    <option value="" <?php if ($item->hidden == '') echo "selected"; ?> ></option>
                    <option value="hidden-xs" <?php if (is_array($item->hidden) && in_array('hidden-xs', $item->hidden)) echo "selected"; ?> >Hidden XS</option>
                    <option value="hidden-sm" <?php if (is_array($item->hidden) && in_array('hidden-sm', $item->hidden)) echo "selected"; ?> >Hidden SM</option>
                    <option value="hidden-md" <?php if (is_array($item->hidden) && in_array('hidden-md', $item->hidden)) echo "selected"; ?> >Hidden MD</option>
                    <option value="hidden-lg" <?php if (is_array($item->hidden) && in_array('hidden-lg', $item->hidden)) echo "selected"; ?> >Hidden LG</option>
                </select> 
            </label>
        </p>
        <!-- /lmm common fields -->

        <?php
    }

    public function add_subitem($item = false) {

        if (!is_array($item->admin_subitem))
            return;

        $item_id = esc_attr($item->ID);
        ?>

        <!-- lmm button-->
        <span class="lmm-add-to-menu">
            <input type="hidden" class="menu-item-parent-id" name="menu-item[-1][menu-item-parent-id]" value="<?php echo $item_id; ?>">
            <input type="hidden" class="menu-subitem-type" name="menu-item[-1][menu-item-type]" value="custom">
            <input type="hidden" class="menu-subitem-title" name="menu-item[-1][menu-item-title]" value="<?php echo $item->admin_subitem['title']; ?>">     
            <input type="hidden" class="menu-subitem-url" name="menu-item[-1][menu-item-url]" value="<?php echo $item->admin_subitem['url']; ?>">
            <input type="hidden" class="menu-subitem-lmm" name="menu-item[-1][menu-item-lmm]" value="<?php echo $item->admin['subitem']; ?>">
            <input type="hidden" class="menu-subitem-mega-columns" name="menu-item[-1][menu-item-mega-columns]" value="<?php echo $item->admin_subitem['columns']; ?>">     
            <input class="submit-add-lmm-subitem button-primary right" value="<?php printf(__('Add %1$s', 'lmm'), $item->admin_subitem['label']); ?>" name="add-lmm-custom-menu-item" id="submit-lmm-custom-menu-subitem-<?php echo $item_id; ?>" type="button">
            <span class="spinner"></span>
        </span>
        <!-- /lmm button-->

        <?php
    }

    /**
     * Starts the list before the elements are added.
     *
     * @see Walker_Nav_Menu::start_lvl()
     *
     * @since 3.0.0
     *
     * @param string $output Passed by reference.
     * @param int    $depth  Depth of menu item. Used for padding.
     * @param array  $args   Not used.
     */
    public function start_lvl(&$output, $depth = 0, $args = array()) {
        
    }

    /**
     * Ends the list of after the elements are added.
     *
     * @see Walker_Nav_Menu::end_lvl()
     *
     * @since 3.0.0
     *
     * @param string $output Passed by reference.
     * @param int    $depth  Depth of menu item. Used for padding.
     * @param array  $args   Not used.
     */
    public function end_lvl(&$output, $depth = 0, $args = array()) {
        
    }

    /**
     * Start the element output.
     *
     * @see Walker_Nav_Menu::start_el()
     * @since 3.0.0
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param object $item   Menu item data object.
     * @param int    $depth  Depth of menu item. Used for padding.
     * @param array  $args   Not used.
     * @param int    $id     Not used.
     */
    public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {

        global $_wp_nav_menu_max_depth;

        $_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;

        ob_start();
        $item_id = esc_attr($item->ID);
        $removed_args = array(
            'action',
            'customlink-tab',
            'edit-menu-item',
            'menu-item',
            'page-tab',
            '_wpnonce',
        );

        $description = $item->description;

        if ('taxonomy' == $item->type) {
            $original_title = get_term_field('name', $item->object_id, $item->object, 'raw');
            if (is_wp_error($original_title))
                $original_title = false;
        } elseif ('post_type' == $item->type) {
            $original_object = get_post($item->object_id);
            $original_title = get_the_title($original_object->ID);

            $item->description = empty($item->description) ? $original_object->post_excerpt : $item->description;
        }

        $classes = array(
            'menu-item menu-item-depth-' . $depth,
            'menu-item-' . esc_attr($item->object),
            'menu-item-edit-' . ( ( isset($_GET['edit-menu-item']) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive'),
        );

//$item->description = $original_excerpt;

        $title = $item->title;

        if (!empty($item->_invalid)) {
            $classes[] = 'menu-item-invalid';
            /* translators: %s: title of menu item which is invalid */
            $title = sprintf(__('%s (Invalid)'), $item->title);
        } elseif (isset($item->post_status) && 'draft' == $item->post_status) {
            $classes[] = 'pending';
            /* translators: %s: title of menu item in draft status */
            $title = sprintf(__('%s (Pending)'), $item->title);
        }

        $title = (!isset($item->label) || '' == $item->label ) ? $title : $item->label;

        $submenu_text = '';
        if (0 == $depth)
            $submenu_text = 'style="display: none;"';
        ?>
        <li id="menu-item-<?php echo $item_id; ?>" class="<?php echo implode(' ', $classes); ?>">
            <dl class="menu-item-bar">
                <dt class="menu-item-handle">
                <span class="item-title">
                    <!-- lmm icon -->
                    <i id="edit-menu-item-icon-<?php echo $item_id; ?>_replace" class="<?php echo $item->icon ?>"></i>
                    <!-- /lmm icon -->
                    <span class="menu-item-title"><?php echo esc_html($title); ?></span> 
                    <span class="is-submenu" <?php echo $submenu_text; ?>><?php _e('sub item'); ?></span>
                </span>
                <span class="item-controls">
                    <span class="item-type"><?php echo esc_html($item->type_label); ?></span>
                    <span class="item-order hide-if-js">
                        <a href="<?php
                        echo wp_nonce_url(
                                add_query_arg(
                                        array(
                            'action' => 'move-up-menu-item',
                            'menu-item' => $item_id,
                                        ), remove_query_arg($removed_args, admin_url('nav-menus.php'))
                                ), 'move-menu_item'
                        );
                        ?>" class="item-move-up"><abbr title="<?php esc_attr_e('Move up'); ?>">&#8593;</abbr></a>
                        |
                        <a href="<?php
                        echo wp_nonce_url(
                                add_query_arg(
                                        array(
                            'action' => 'move-down-menu-item',
                            'menu-item' => $item_id,
                                        ), remove_query_arg($removed_args, admin_url('nav-menus.php'))
                                ), 'move-menu_item'
                        );
                        ?>" class="item-move-down"><abbr title="<?php esc_attr_e('Move down'); ?>">&#8595;</abbr></a>
                    </span>
                    <a class="item-edit" id="edit-<?php echo $item_id; ?>" title="<?php esc_attr_e('Edit Menu Item'); ?>" href="<?php
                    echo ( isset($_GET['edit-menu-item']) && $item_id == $_GET['edit-menu-item'] ) ? admin_url('nav-menus.php') : add_query_arg('edit-menu-item', $item_id, remove_query_arg($removed_args, admin_url('nav-menus.php#menu-item-settings-' . $item_id)));
                    ?>"><?php _e('Edit Menu Item'); ?></a>
                </span>
                </dt>
            </dl>

            <div class="menu-item-settings" id="menu-item-settings-<?php echo $item_id; ?>">
                <?php if ('custom' == $item->type || 'lmm-icon' == $item->lmm) : ?>
                    <p class="field-url description description-wide">
                        <label for="edit-menu-item-url-<?php echo $item_id; ?>">
                            <?php _e('URL'); ?><br />
                            <input type="text" id="edit-menu-item-url-<?php echo $item_id; ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->url); ?>" />
                        </label>
                    </p>
                <?php endif; ?>
                <p class="description description-thin">
                    <label for="edit-menu-item-title-<?php echo $item_id; ?>">
                        <?php _e('Navigation Label'); ?><br />
                        <input type="text" id="edit-menu-item-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->title); ?>" />
                    </label>
                </p>
                <p class="description description-thin lmm-mega-menu custom-show lmm-icon-show taxonomy-show post_type-show lmm-mega-show lmm-tabs-show tab-show lmm-cart-show lmm-login-show">
                    <label for="edit-menu-item-attr-title-<?php echo $item_id; ?>">
                        <?php _e('Title Attribute'); ?><br />
                        <input type="text" id="edit-menu-item-attr-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->post_excerpt); ?>" />
                    </label>
                </p>
                <p class="field-link-target description lmm-mega-menu custom-show lmm-icon-show taxonomy-show post_type-show">
                    <label for="edit-menu-item-target-<?php echo $item_id; ?>">
                        <input type="checkbox" id="edit-menu-item-target-<?php echo $item_id; ?>" value="_blank" name="menu-item-target[<?php echo $item_id; ?>]"<?php checked($item->target, '_blank'); ?> />
                        <?php _e('Open link in a new window/tab'); ?>
                    </label>
                </p>
                <p class="field-css-classes description description-thin">
                    <label for="edit-menu-item-classes-<?php echo $item_id; ?>">
                        <?php _e('CSS Classes (optional)'); ?><br />
                        <input type="text" id="edit-menu-item-classes-<?php echo $item_id; ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo $item_id; ?>]" value="<?php echo esc_attr(implode(' ', $item->classes)); ?>" />
                    </label>
                </p>
                <p class="field-xfn description description-thin lmm-mega-menu custom-show lmm-icon-show taxonomy-show post_type-show">
                    <label for="edit-menu-item-xfn-<?php echo $item_id; ?>">
                        <?php _e('Link Relationship (XFN)'); ?><br />
                        <input type="text" id="edit-menu-item-xfn-<?php echo $item_id; ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->xfn); ?>" />
                    </label>
                </p>
                <p class="field-description description description-wide lmm-mega-menu custom-show taxonomy-show post_type-show">
                    <label for="edit-menu-item-description-<?php echo $item_id; ?>">
                        <?php _e('Description'); ?><br />
                        <textarea id="edit-menu-item-description-<?php echo $item_id; ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo $item_id; ?>]"><?php echo esc_html($item->description); // textarea_escaped                                                                                                                        ?></textarea>
                        <span class="description"><?php _e('The description will be displayed in the menu if the current theme supports it.'); ?></span>
                    </label>
                </p>

                <?php $this->add_settings($item); ?>

                <?php
                // support for nav menu roles
                do_action('wp_nav_menu_item_custom_fields', $item_id, $item, $depth, $args);
                ?>

                <?php if ($item->object != 'lmm'): ?>
                    <p class="field-move hide-if-no-js description description-wide">
                        <label>
                            <span><?php _e('Move'); ?></span>
                            <a href="#" class="menus-move menus-move-up" data-dir="up"><?php _e('Up one'); ?></a>
                            <a href="#" class="menus-move menus-move-down" data-dir="down"><?php _e('Down one'); ?></a>
                            <a href="#" class="menus-move menus-move-left" data-dir="left"></a>
                            <a href="#" class="menus-move menus-move-right" data-dir="right"></a>
                            <a href="#" class="menus-move menus-move-top" data-dir="top"><?php _e('To the top'); ?></a>
                        </label>
                    </p>
                <?php endif; ?>
                <div class="menu-item-actions description-wide submitbox">
                    <?php if ('custom' != $item->type && $original_title !== false) : ?>
                        <p class="link-to-original">
                            <?php printf(__('Original: %s'), '<a href="' . esc_attr($item->url) . '">' . esc_html($original_title) . '</a>'); ?>
                        </p>
                    <?php endif; ?>

                    <?php $this->add_subitem($item); ?>

                    <a class="item-delete submitdelete deletion" id="delete-<?php echo $item_id; ?>" href="<?php
                    echo wp_nonce_url(
                            add_query_arg(
                                    array(
                        'action' => 'delete-menu-item',
                        'menu-item' => $item_id,
                                    ), admin_url('nav-menus.php')
                            ), 'delete-menu_item_' . $item_id
                    );
                    ?>"><?php _e('Remove'); ?></a> <span class="meta-sep hide-if-no-js"> | </span> <a class="item-cancel submitcancel hide-if-no-js" id="cancel-<?php echo $item_id; ?>" href="<?php echo esc_url(add_query_arg(array('edit-menu-item' => $item_id, 'cancel' => time()), admin_url('nav-menus.php')));
                    ?>#menu-item-settings-<?php echo $item_id; ?>"><?php _e('Cancel'); ?></a>
                </div>

                <input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo $item_id; ?>]" value="<?php echo $item_id; ?>" />
                <input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->object_id); ?>" />
                <input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->object); ?>" />
                <input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->menu_item_parent); ?>" />
                <input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->menu_order); ?>" />
                <input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->type); ?>" />
                <!-- lmm data -->
                <input class="menu-item-data-lmm" type="hidden" name="menu-item-lmm[<?php echo $item_id; ?>]" value="<?php echo esc_attr($item->lmm); ?>" />
                <!-- /lmm data -->
            </div><!-- .menu-item-settings-->
            <ul class="menu-item-transport"></ul>
            <?php
            $output .= ob_get_clean();
        }

    }

// Walker_Nav_Menu_Edit

