<?php

//default options --------------------------------------------------------------

add_filter('lmm_hook_options_config_defaults', 'lmm_hook_defaults', 1);

function lmm_hook_defaults($defaults) {

    $defaults['lmm_locations'] = array(
        'lmm-location-1' => 1
    );

    $defaults['lmm_widgets'] = array(
        'lmm-widget-1' => 'LMM Widget Area 1',
        'lmm-widget-2' => 'LMM Widget Area 2',
        'lmm-widget-3' => 'LMM Widget Area 3',
        'lmm-widget-4' => 'LMM Widget Area 4',
        'lmm-widget-5' => 'LMM Widget Area 5',
        'lmm-widget-6' => 'LMM Widget Area 6',
        'lmm-widget-7' => 'LMM Widget Area 7',
        'lmm-widget-8' => 'LMM Widget Area 8',
        'lmm-widget-9' => 'LMM Widget Area 9',
        'lmm-widget-10' => 'LMM Widget Area 10',
        'lmm-widget-11' => 'LMM Widget Area 11',
        'lmm-widget-12' => 'LMM Widget Area 12',
    );

    $defaults['lmm_viewport'] = 1;

    $defaults['lmm_styles'] = 1;

    $defaults['lmm_styles_normalize'] = 1;

    $defaults['lmm_styles_widgets'] = 1;

    $defaults['lmm_styles_bootstrap'] = 1;

    $defaults['lmm_styles_icons'] = 'fontawesome';

    $defaults['lmm_styles_pscrollbar'] = 1;

    return $defaults;
}

add_filter('lmm_hook_options_general_defaults', 'lmm_hook_defaults_general', 1);

function lmm_hook_defaults_general($defaults) {

    $defaults['scheme_lmm_navbar_breakpoint'] = '768';

    $defaults['scheme_lmm_container_gutter'] = '30';

    $defaults['scheme_lmm_screen_md_width'] = '992';
    $defaults['scheme_lmm_screen_lg_width'] = '1200';

    $defaults['scheme_lmm_container_small_width'] = '720';
    $defaults['scheme_lmm_container_medium_width'] = '940';
    $defaults['scheme_lmm_container_large_width'] = '1140';


    $defaults['scheme_lmm_general_font'] = array(
        'font-family' => 'Verdana, Geneva, sans-serif',
        //'google' => true,
        'font-size' => '11',
        'font-weight' => '400',
    );

    $defaults['scheme_lmm_navbar_font'] = array(
        'font-family' => 'Verdana, Geneva, sans-serif',
        //'google' => true,
        'font-size' => '11',
        'font-weight' => '400',
    );

    $defaults['scheme_lmm_dropdown_font'] = array(
        'font-family' => 'Verdana, Geneva, sans-serif',
        //'google' => true,
        'font-size' => '11',
        'font-weight' => '400',
    );

    return $defaults;
}

add_filter('lmm_hook_options_locations_defaults', 'lmm_hook_defaults_locations', 1);

function lmm_hook_defaults_locations($defaults) {

    $lmm = get_option(LMM, array());

    // layout defaults ---------------------------------------------------------
    $defaults['all_integration'] = 'auto';
    $defaults['all_integration_filters'] = 1;
    // layout defaults ---------------------------------------------------------
    $defaults['all_navbar_mode'] = 'horizontal';
    $defaults['all_navbar_mode_horizontal'] = 'button';
    $defaults['all_navbar_mode_vertical'] = 'collapsed';
    $defaults['all_navbar_mode_vertical_float'] = 'right';
    $defaults['all_navbar_mode_horizontal_align'] = 'right';
    $defaults['all_navbar_mode_vertical_collapsed'] = array(
        'offcanvas-xs' => 1,
        'offcanvas-sm' => 1,
        'offcanvas-md' => 0,
        'offcanvas-lg' => 0
    );
    $defaults['all_navbar_sticky'] = 1;
    $defaults['all_navbar_sticky_offset'] = '90';
    $defaults['all_navbar_sticky_logo'] = 0;
    $defaults['all_navbar_width'] = 'container-auto';
    $defaults['all_navbar_separator'] = '';
    $defaults['all_navbar_caret'] = 'lmm-hide-carets';
    $defaults['all_navbar_trigger'] = 'lmm-trigger-hoverintent';
    $defaults['all_navbar_classes'] = 'my_class';
    $defaults['all_navbar_logo'] = array(
        'url' => LMM_URL . 'assets/frontend/images/logo.png'
    );
    $defaults['all_navbar_hover_effect'] = '';

    $defaults['all_dropdown_triangle'] = '';
    $defaults['all_dropdown_animation'] = 'lmm_rtl';
    // navbar defaults ---------------------------------------------------------
    $defaults['scheme_all_navbar_height'] = '60';
    $defaults['scheme_all_navbar_width'] = '260';
    $defaults['scheme_all_navbar_toggle_icon'] = '#ffffff';
    $defaults['scheme_all_navbar_toggle_border'] = 'transparent';
    $defaults['scheme_all_navbar_toggle_bg'] = 'transparent';
    $defaults['scheme_all_navbar_toggle_hover'] = '#444444';
    $defaults['scheme_all_navbar_background'] = 'color';
    $defaults['scheme_all_navbar_background_color'] = array(
        'color' => '#333333',
        'alpha' => '1'
    );
    $defaults['scheme_all_navbar_background_to'] = array(
        'color' => '#000000',
        'alpha' => '1'
    );

    $defaults['scheme_all_navbar_background_deg'] = '17';
    $defaults['scheme_all_navbar_border'] = 'transparent';
    $defaults['scheme_all_navbar_sharp'] = array(
        'color' => '#ffffff',
        'alpha' => '0.5'
    );
    $defaults['scheme_all_navbar_text'] = '#aaaaaa';

    $defaults['scheme_all_navbar_logo_bg'] = array(
        'color' => '#ffffff',
        'alpha' => '0'
    );
    
    $defaults['scheme_all_navbar_logo_height'] = '40';
    
    $defaults['scheme_all_navbar_link'] = '#f1f1f1';
    $defaults['scheme_all_navbar_link_hover'] = '#ffffff';
    $defaults['scheme_all_navbar_link_hover_bg'] = array('color' => '#111111', 'alpha' => '1');
    $defaults['scheme_all_navbar_link_hover_effect'] = array('color' => '#fb88dd', 'alpha' => '1');
    $defaults['scheme_all_navbar_link_margin'] = array('border-top' => '0', 'border-right' => '0', 'border-left' => '0', 'border-bottom' => '0');
    $defaults['scheme_all_navbar_link_radius'] = 0;
    $defaults['scheme_all_navbar_link_transform'] = 'uppercase';
    $defaults['scheme_all_navbar_link_icon'] = '#eeeeee';
    $defaults['scheme_all_navbar_link_icon_hover'] = '#ffffff';
    $defaults['scheme_all_navbar_link_subtitle'] = '#eeeeee';
    $defaults['scheme_all_navbar_link_subtitle_hover'] = '#ffffff';
    $defaults['scheme_all_navbar_search_bg'] = '#555555';
    $defaults['scheme_all_navbar_search_border'] = '#555555';
    $defaults['scheme_all_navbar_search_color'] = '#dddddd';
    $defaults['scheme_all_navbar_cart_bubble'] = '#fb88dd';
    $defaults['scheme_all_navbar_cart_bubble_color'] = '#ffffff';
    $defaults['scheme_all_navbar_sticky_height'] = '60';
    $defaults['scheme_all_navbar_sticky_background'] = array('color' => '#ffffff', 'alpha' => '0');
    $defaults['scheme_all_navbar_sticky_logo_height'] = '40';
    // dropdown defaults -------------------------------------------------------
    $defaults['scheme_all_dropdown_margin'] = 0;
    $defaults['scheme_all_dropdown_radius'] = 0;
    $defaults['scheme_all_dropdown_border'] = array('border-all' => '3', 'border-top' => '0', 'border-color' => '#000000');
    $defaults['scheme_all_dropdown_background'] = array('color' => '#111111', 'alpha' => '1');
    $defaults['scheme_all_dropdown_title'] = '#ffffff';
    $defaults['scheme_all_dropdown_title_border'] = array('border-all' => '1', 'border-top' => '1', 'border-color' => '#fb88dd', 'border-style' => 'solid');
    $defaults['scheme_all_dropdown_link'] = '#cccccc';
    $defaults['scheme_all_dropdown_link_hover'] = '#fb88dd';
    $defaults['scheme_all_dropdown_link_hover_bg'] = array('color' => '#000000', 'alpha' => '1');
    $defaults['scheme_all_dropdown_link_border'] = array('border-all' => '1', 'border-top' => '1', 'border-color' => '#000000', 'border-style' => 'solid');
    $defaults['scheme_all_dropdown_link_transform'] = 'none';
    $defaults['scheme_all_dropdown_link_icon'] = '#fb88dd';
    $defaults['scheme_all_dropdown_link_icon_hover'] = '#a9a9a9';
    $defaults['scheme_all_dropdown_link_subtitle'] = '#a0a0a0';
    $defaults['scheme_all_dropdown_link_subtitle_hover'] = '#cccccc';

    return $defaults;
}

add_filter('lmm_hook_options_social_defaults', 'lmm_hook_defaults_social');

function lmm_hook_defaults_social($defaults) {

    $defaults['lmm_social'] = array(
        array(
            'title' => 'Facebook',
            'icon' => 'fa fa-facebook-f',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
        array(
            'title' => 'Twitter',
            'icon' => 'fa fa-twitter',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
        array(
            'title' => 'Google Wallet',
            'icon' => 'fa fa-google-wallet',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
        array(
            'title' => 'Github',
            'icon' => 'fa fa-github-alt',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
        array(
            'title' => 'RSS',
            'icon' => 'fa fa-rss',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
    );

    return $defaults;
}

add_filter('lmm_hook_options_css_default', 'lmm_hook_default_css', 1);

function lmm_hook_default_css($css = '') {
    $css = '.custom {}';
    return $css;
}
