/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2017-02-15 08:36:54 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_gtj8dk_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_cwa` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `cwa_name` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `cwa_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cwa_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cwa_widget_class` text COLLATE utf8mb4_unicode_ci,
  `cwa_widget_wrapper` text COLLATE utf8mb4_unicode_ci,
  `cwa_widget_header_class` text COLLATE utf8mb4_unicode_ci,
  `cwa_widget_header_wrapper` text COLLATE utf8mb4_unicode_ci,
  `cwa_type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_updated` date NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_dmm_menu` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `menu_location` varchar(255) NOT NULL,
  `menu_desc` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_dmm_url_groups` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL,
  `url_list` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_dmm_url_mapping` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `group_id` int(20) NOT NULL,
  `menu_replace` varchar(255) NOT NULL,
  `replaced_menu` varchar(255) DEFAULT NULL,
  `new_menu` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_eg_grids` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `postparams` text NOT NULL,
  `params` text NOT NULL,
  `layers` mediumtext NOT NULL,
  `settings` text,
  `last_modified` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_eg_item_elements` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `settings` mediumtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_eg_item_skins` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `layers` mediumtext NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_eg_navigation_skins` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `css` mediumtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_frm_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `type` text COLLATE utf8mb4_unicode_ci,
  `default_value` longtext COLLATE utf8mb4_unicode_ci,
  `options` longtext COLLATE utf8mb4_unicode_ci,
  `field_order` int(11) DEFAULT '0',
  `required` int(1) DEFAULT NULL,
  `field_options` longtext COLLATE utf8mb4_unicode_ci,
  `form_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `field_key` (`field_key`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_frm_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `parent_form_id` int(11) DEFAULT '0',
  `logged_in` tinyint(1) DEFAULT NULL,
  `editable` tinyint(1) DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT '0',
  `default_template` tinyint(1) DEFAULT '0',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `options` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_key` (`form_key`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_frm_item_metas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  `field_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `field_id` (`field_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_frm_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `ip` text COLLATE utf8mb4_unicode_ci,
  `form_id` int(11) DEFAULT NULL,
  `post_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `parent_item_id` int(11) DEFAULT '0',
  `is_draft` tinyint(1) DEFAULT '0',
  `updated_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_key` (`item_key`),
  KEY `form_id` (`form_id`),
  KEY `post_id` (`post_id`),
  KEY `user_id` (`user_id`),
  KEY `parent_item_id` (`parent_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_content_status` (
  `rid` bigint(20) NOT NULL,
  `nid` bigint(20) NOT NULL,
  `timestamp` datetime NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_core_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `module` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `origin` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `flag` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_template` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_code` (`lang_code`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `english_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL,
  `default_locale` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tag` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `encode_url` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `english_name` (`english_name`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_languages_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_code` (`language_code`,`display_language_code`)
) ENGINE=InnoDB AUTO_INCREMENT=3970 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_locale_map` (
  `code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(35) COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `code` (`code`,`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_message_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `from_language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `to_language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rid` (`rid`),
  KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_node` (
  `nid` bigint(20) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_reminders` (
  `id` bigint(20) NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `can_delete` tinyint(4) NOT NULL,
  `show` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_string_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) NOT NULL,
  `url_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_to_url_id` (`url_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21622 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gtj8dk_icl_string_positions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) NOT NULL,
  `kind` tinyint(4) DEFAULT NULL,
  `position_in_page` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_id` (`string_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5861 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_string_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `string_translation_id` bigint(20) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_translation_id` (`string_translation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_string_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `translator_id` bigint(20) unsigned DEFAULT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `batch_id` int(11) NOT NULL DEFAULT '0',
  `translation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_language` (`string_id`,`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_string_urls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_string_lang_url` (`language`,`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gtj8dk_icl_strings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` varchar(160) CHARACTER SET utf8 DEFAULT NULL,
  `name` varchar(160) CHARACTER SET utf8 DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `string_package_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'LINE',
  `title` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `gettext_context` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain_name_context_md5` varchar(32) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_domain_name_context_md5` (`domain_name_context_md5`),
  KEY `language_context` (`language`,`context`)
) ENGINE=InnoDB AUTO_INCREMENT=25907 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_translate` (
  `tid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `field_type` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_format` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_translate` tinyint(4) NOT NULL,
  `field_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_data_translated` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_finished` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `job_id` (`job_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_translate_job` (
  `job_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `translator_id` int(10) unsigned NOT NULL,
  `translated` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `manager_id` int(10) unsigned NOT NULL,
  `revision` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  KEY `rid` (`rid`,`translator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_translation_batches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `ts_url` text COLLATE utf8mb4_unicode_ci,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_translation_status` (
  `rid` bigint(20) NOT NULL AUTO_INCREMENT,
  `translation_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `translator_id` bigint(20) NOT NULL,
  `needs_update` tinyint(4) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch_id` int(11) NOT NULL DEFAULT '0',
  `translation_package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  `_prevstate` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `translation_id` (`translation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_icl_translations` (
  `translation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `element_type` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post_post',
  `element_id` bigint(20) DEFAULT NULL,
  `trid` bigint(20) NOT NULL,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_language_code` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`translation_id`),
  UNIQUE KEY `trid_lang` (`trid`,`language_code`),
  UNIQUE KEY `el_type_id` (`element_type`,`element_id`),
  KEY `trid` (`trid`),
  KEY `id_type_language` (`element_id`,`element_type`,`language_code`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_newsletter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `surname` varchar(100) NOT NULL DEFAULT '',
  `sex` char(1) NOT NULL DEFAULT 'n',
  `status` char(1) NOT NULL DEFAULT 'S',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `token` varchar(50) NOT NULL DEFAULT '',
  `feed` tinyint(4) NOT NULL DEFAULT '0',
  `feed_time` bigint(20) NOT NULL DEFAULT '0',
  `country` varchar(4) NOT NULL DEFAULT '',
  `list_1` tinyint(4) NOT NULL DEFAULT '0',
  `list_2` tinyint(4) NOT NULL DEFAULT '0',
  `list_3` tinyint(4) NOT NULL DEFAULT '0',
  `list_4` tinyint(4) NOT NULL DEFAULT '0',
  `list_5` tinyint(4) NOT NULL DEFAULT '0',
  `list_6` tinyint(4) NOT NULL DEFAULT '0',
  `list_7` tinyint(4) NOT NULL DEFAULT '0',
  `list_8` tinyint(4) NOT NULL DEFAULT '0',
  `list_9` tinyint(4) NOT NULL DEFAULT '0',
  `list_10` tinyint(4) NOT NULL DEFAULT '0',
  `list_11` tinyint(4) NOT NULL DEFAULT '0',
  `list_12` tinyint(4) NOT NULL DEFAULT '0',
  `list_13` tinyint(4) NOT NULL DEFAULT '0',
  `list_14` tinyint(4) NOT NULL DEFAULT '0',
  `list_15` tinyint(4) NOT NULL DEFAULT '0',
  `list_16` tinyint(4) NOT NULL DEFAULT '0',
  `list_17` tinyint(4) NOT NULL DEFAULT '0',
  `list_18` tinyint(4) NOT NULL DEFAULT '0',
  `list_19` tinyint(4) NOT NULL DEFAULT '0',
  `list_20` tinyint(4) NOT NULL DEFAULT '0',
  `profile_1` varchar(255) NOT NULL DEFAULT '',
  `profile_2` varchar(255) NOT NULL DEFAULT '',
  `profile_3` varchar(255) NOT NULL DEFAULT '',
  `profile_4` varchar(255) NOT NULL DEFAULT '',
  `profile_5` varchar(255) NOT NULL DEFAULT '',
  `profile_6` varchar(255) NOT NULL DEFAULT '',
  `profile_7` varchar(255) NOT NULL DEFAULT '',
  `profile_8` varchar(255) NOT NULL DEFAULT '',
  `profile_9` varchar(255) NOT NULL DEFAULT '',
  `profile_10` varchar(255) NOT NULL DEFAULT '',
  `profile_11` varchar(255) NOT NULL DEFAULT '',
  `profile_12` varchar(255) NOT NULL DEFAULT '',
  `profile_13` varchar(255) NOT NULL DEFAULT '',
  `profile_14` varchar(255) NOT NULL DEFAULT '',
  `profile_15` varchar(255) NOT NULL DEFAULT '',
  `profile_16` varchar(255) NOT NULL DEFAULT '',
  `profile_17` varchar(255) NOT NULL DEFAULT '',
  `profile_18` varchar(255) NOT NULL DEFAULT '',
  `profile_19` varchar(255) NOT NULL DEFAULT '',
  `profile_20` varchar(255) NOT NULL DEFAULT '',
  `referrer` varchar(50) NOT NULL DEFAULT '',
  `http_referer` varchar(255) NOT NULL DEFAULT '',
  `wp_user_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `test` tinyint(4) NOT NULL DEFAULT '0',
  `flow` tinyint(4) NOT NULL DEFAULT '0',
  `unsub_email_id` int(11) NOT NULL DEFAULT '0',
  `unsub_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_newsletter_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci,
  `message_text` longtext COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('new','sending','sent','paused') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'new',
  `total` int(11) NOT NULL DEFAULT '0',
  `last_id` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) NOT NULL DEFAULT '0',
  `send_on` int(11) NOT NULL DEFAULT '0',
  `track` tinyint(4) NOT NULL DEFAULT '0',
  `editor` tinyint(4) NOT NULL DEFAULT '0',
  `sex` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `query` longtext COLLATE utf8mb4_unicode_ci,
  `preferences` longtext COLLATE utf8mb4_unicode_ci,
  `options` longtext COLLATE utf8mb4_unicode_ci,
  `token` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `open_count` int(10) unsigned NOT NULL DEFAULT '0',
  `click_count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_newsletter_sent` (
  `email_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `open` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `error` varchar(100) NOT NULL DEFAULT '',
  `ip` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`email_id`,`user_id`),
  KEY `user_id` (`user_id`),
  KEY `email_id` (`email_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_newsletter_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `email_id` int(11) NOT NULL DEFAULT '0',
  `link_id` int(11) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `anchor` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=37898 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3651 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=4546 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `params` text NOT NULL,
  `advanced` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_wfBadLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gtj8dk_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`unixday`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfBlocks` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `wfsn` tinyint(3) unsigned DEFAULT '0',
  `permanent` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`IP`),
  KEY `k1` (`wfsn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfBlocksAdv` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `blockType` char(2) NOT NULL,
  `blockString` varchar(255) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `reason` varchar(255) NOT NULL,
  `totalBlocked` int(10) unsigned DEFAULT '0',
  `lastBlocked` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfConfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfCrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gtj8dk_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=1996 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gtj8dk_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` binary(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB AUTO_INCREMENT=1317 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfKnownFileList` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8579 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gtj8dk_wfLockedOut` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfLocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfNet404s` (
  `sig` binary(16) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `URI` varchar(1000) NOT NULL,
  PRIMARY KEY (`sig`),
  KEY `k1` (`ctime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfNotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfReverseCache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gtj8dk_wfSNIPCache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfScanners` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gtj8dk_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=16290 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfThrottleLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `startTime` int(10) unsigned NOT NULL,
  `endTime` int(10) unsigned NOT NULL,
  `timesThrottled` int(10) unsigned NOT NULL,
  `lastReason` varchar(255) NOT NULL,
  PRIMARY KEY (`IP`),
  KEY `k2` (`endTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_wfVulnScanners` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gtj8dk_woocommerce_api_keys` (
  `key_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` longtext COLLATE utf8mb4_unicode_ci,
  `attribute_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `download_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `order_id` bigint(20) NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(191),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_woocommerce_order_items` (
  `order_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_woocommerce_sessions` (
  `session_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint(20) NOT NULL,
  PRIMARY KEY (`session_key`),
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `location_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint(20) NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`(191)),
  KEY `tax_rate_state` (`tax_rate_state`(191)),
  KEY `tax_rate_class` (`tax_rate_class`(191)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gtj8dk_woocommerce_termmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `woocommerce_term_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `woocommerce_term_id` (`woocommerce_term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_gtj8dk_cwa */
INSERT INTO `wp_gtj8dk_cwa` VALUES("1", "financial_widget", "", "financialwidget", "", "li", "", "h2", "widget", "2016-08-10");

/* INSERT TABLE DATA: wp_gtj8dk_dmm_menu */
INSERT INTO `wp_gtj8dk_dmm_menu` VALUES("1", "cru-trading", "Cru Trading Website");
INSERT INTO `wp_gtj8dk_dmm_menu` VALUES("2", "cru-logistics", "Cru Logistics Website");
INSERT INTO `wp_gtj8dk_dmm_menu` VALUES("3", "cru-railcar-services", "Cru Railcar Services Website");

/* INSERT TABLE DATA: wp_gtj8dk_duplicator_packages */
INSERT INTO `wp_gtj8dk_duplicator_packages` VALUES("1", "20170215_crulogisticscruvictoriainve", "58a410ef22f424957170215082727", "40", "2017-02-15 08:27:48", "webmaster", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-15 08:27:27\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.25\";s:10:\"VersionPHP\";s:6:\"5.6.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";s:1:\"1\";s:4:\"Name\";s:36:\"20170215_crulogisticscruvictoriainve\";s:4:\"Hash\";s:29:\"58a410ef22f424957170215082727\";s:8:\"NameHash\";s:66:\"20170215_crulogisticscruvictoriainve_58a410ef22f424957170215082727\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/home/testingaccount/cru.gomyitguy.com/crurailsystems/wp-snapshots/tmp\";s:8:\"StoreURL\";s:57:\"http://www.cru.gomyitguy.com/crurailsystems/wp-snapshots/\";s:8:\"ScanFile\";s:76:\"20170215_crulogisticscruvictoriainve_58a410ef22f424957170215082727_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"webmaster\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:78:\"20170215_crulogisticscruvictoriainve_58a410ef22f424957170215082727_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/home/testingaccount/cru.gomyitguy.com/crurailsystems\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:80:\"20170215_crulogisticscruvictoriainve_58a410ef22f424957170215082727_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:16:\"crulogis_railcar\";s:10:\"OptsDBUser\";s:16:\"crulogis_railcar\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:33:\"http://crurailcar.thecrugroup.com\";s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-15 08:27:27\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.25\";s:10:\"VersionPHP\";s:6:\"5.6.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20170215_crulogisticscruvictoriainve\";s:4:\"Hash\";s:29:\"58a410ef22f424957170215082727\";s:8:\"NameHash\";s:66:\"20170215_crulogisticscruvictoriainve_58a410ef22f424957170215082727\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/home/testingaccount/cru.gomyitguy.com/crurailsystems/wp-snapshots/tmp\";s:8:\"StoreURL\";s:57:\"http://www.cru.gomyitguy.com/crurailsystems/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";r:53;s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:14620037;s:4:\"File\";s:79:\"20170215_crulogisticscruvictoriainve_58a410ef22f424957170215082727_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:150:\"/home/testingaccount/cru.gomyitguy.com/crurailsystems/wp-snapshots/tmp/20170215_crulogisticscruvictoriainve_58a410ef22f424957170215082727_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:8:\"Database\";r:88;}");
INSERT INTO `wp_gtj8dk_duplicator_packages` VALUES("2", "20170215_crulogisticscruvictoriainve", "58a413026df3d1443170215083618", "20", "2017-02-15 08:36:54", "webmaster", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-15 08:36:18\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.25\";s:10:\"VersionPHP\";s:6:\"5.6.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:36:\"20170215_crulogisticscruvictoriainve\";s:4:\"Hash\";s:29:\"58a413026df3d1443170215083618\";s:8:\"NameHash\";s:66:\"20170215_crulogisticscruvictoriainve_58a413026df3d1443170215083618\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/home/testingaccount/cru.gomyitguy.com/crurailsystems/wp-snapshots/tmp\";s:8:\"StoreURL\";s:57:\"http://www.cru.gomyitguy.com/crurailsystems/wp-snapshots/\";s:8:\"ScanFile\";s:76:\"20170215_crulogisticscruvictoriainve_58a413026df3d1443170215083618_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"webmaster\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:78:\"20170215_crulogisticscruvictoriainve_58a413026df3d1443170215083618_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/home/testingaccount/cru.gomyitguy.com/crurailsystems\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-15 08:36:18\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.25\";s:10:\"VersionPHP\";s:6:\"5.6.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20170215_crulogisticscruvictoriainve\";s:4:\"Hash\";s:29:\"58a413026df3d1443170215083618\";s:8:\"NameHash\";s:66:\"20170215_crulogisticscruvictoriainve_58a413026df3d1443170215083618\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/home/testingaccount/cru.gomyitguy.com/crurailsystems/wp-snapshots/tmp\";s:8:\"StoreURL\";s:57:\"http://www.cru.gomyitguy.com/crurailsystems/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:80:\"20170215_crulogisticscruvictoriainve_58a413026df3d1443170215083618_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:16:\"crulogis_railcar\";s:10:\"OptsDBUser\";s:16:\"crulogis_railcar\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:33:\"http://crurailcar.thecrugroup.com\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:79:\"20170215_crulogisticscruvictoriainve_58a413026df3d1443170215083618_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_gtj8dk_eg_item_skins */
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("1", "Washington", "washington", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#000000\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"65\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#3f424a\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"50\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"50\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"source-post\":\"title\"}},null,{\"id\":\"8\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"9\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("2", "Adams", "adams", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#89af72\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"8\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("3", "Jefferson", "jefferson", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#e33a0c\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},null,{\"id\":\"3\",\"order\":3,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\"}},null,{\"id\":\"5\",\"order\":6,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"&nbsp; &nbsp;\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"8\",\"order\":4,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("4", "Madison", "madison", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#585c67\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#585c67\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipvertical\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"flipverticalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"19\",\"1\":\"19\",\"2\":\"19\",\"3\":\"19\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"25\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"19\",\"1\":\"19\",\"2\":\"19\",\"3\":\"19\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"25\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"35\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"35\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"45\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\"}},{\"id\":\"6\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"7\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("5", "Monroe", "monroe", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#0a0a0a\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"50\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"30\",\"3\":\"0\"},\"padding\":{\"0\":\"3\",\"1\":\"15\",\"2\":\"2\",\"3\":\"15\"},\"background-color\":\"#89af72\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#ffffff\",\"shadow-alpha\":\"0\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"3\",\"3\":\"0\"},\"border-radius\":{\"0\":\"3\",\"1\":\"3\",\"2\":\"3\",\"3\":\"3\"},\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"30\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#9bc184\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"0\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"3\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"3\",\"1\":\"3\",\"2\":\"3\",\"3\":\"3\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"Read More\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"4\",\"1\":\"12\",\"2\":\"3\",\"3\":\"12\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"0\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"20\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"out\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"8\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"24\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"30\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"3\",\"1\":\"12\",\"2\":\"4\",\"3\":\"12\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"0\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"20\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("6", "Quincy", "quincy", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#2d3039\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"75\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#2d3039\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"pressback\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"10\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#2d3039\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#2d3039\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"10\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#2d3039\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#2d3039\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\"}},null,{\"id\":\"5\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"6\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("7", "Jackson", "jackson", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#eeeeee\",\"full-padding\":[\"5\",\"5\",\"5\",\"5\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"zoomback\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#f5f5f5\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#eeeeee\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"5\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-jackson-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-jackson-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#f5f5f5\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#eeeeee\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"18\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#888888\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewleft\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"cat_list\"}},{\"id\":\"6\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"7\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("8", "VanBuren", "vanburen", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#0a0606\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#363839\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"15\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"20\",\"2\":\"0\",\"3\":\"20\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flyleft\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},null,{\"id\":\"2\",\"order\":3,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flyright\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"date\"}},{\"id\":\"3\",\"order\":1,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("9", "HenryHarrison", "henryharrison", "{\"eg-item-skin-element-last-id\":\"5\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#31a5cb\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"10\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"20\",\"2\":\"0\",\"3\":\"20\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"0\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},null,{\"id\":\"2\",\"order\":3,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"27\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"0\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"27\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"normal\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"0\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"5\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-plus\"}},null,{\"id\":\"5\",\"order\":1,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("10", "Tyler", "tyler", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-unlink\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"8\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("11", "Polk", "polk", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"95\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"46\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\"}},{\"id\":\"3\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"57\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("12", "Taylor", "taylor", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"flipdown\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("13", "Fillmore", "fillmore", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-0{cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-0{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"13\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"align\":\"c_c\",\"margin-unit\":\"px\",\"source-post\":\"date\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-1{ cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-1{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-unlink\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("14", "Pierce", "pierce", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-pierce-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-pierce-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-pierce-element-1{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-pierce-element-1{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"source-post\":\"excerpt\",\"tag-type\":\"div\",\"align\":\"c_c\",\"css-hover\":\"\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("15", "Buchanan", "buchanan", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slidedown\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"21\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"40\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("16", "Lincoln", "lincoln", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"5\",\"1\":\"10\",\"2\":\"5\",\"3\":\"10\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"1\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"13\",\"1\":\"13\",\"2\":\"13\",\"3\":\"13\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"25\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-link\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"1\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"13\",\"1\":\"13\",\"2\":\"13\",\"3\":\"13\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"25\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-link-ext\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"13\",\"1\":\"13\",\"2\":\"13\",\"3\":\"13\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"25\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-mail\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("17", "Johnson", "johnson", "{\"eg-item-skin-element-last-id\":\"12\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#008e85\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"covergrowup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"40\",\"2\":\"0\",\"3\":\"40\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-johnson-element-0{}\",\"css-hover\":\".eg-johnson-element-0{}\",\"tag-type\":\"div\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":0,\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"1\",\"3\":\"0\"},\"padding\":{\"0\":\"13\",\"1\":\"13\",\"2\":\"13\",\"3\":\"13\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"25\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-johnson-element-1{}\",\"css-hover\":\".eg-johnson-element-1{}\",\"tag-type\":\"div\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},null,{\"id\":\"3\",\"order\":1,\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"1\",\"3\":\"0\"},\"padding\":{\"0\":\"13\",\"1\":\"13\",\"2\":\"13\",\"3\":\"13\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"25\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-johnson-element-3{}\",\"css-hover\":\".eg-johnson-element-3{}\",\"tag-type\":\"div\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-videocam\"}},{\"id\":\"4\",\"order\":2,\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"1\",\"3\":\"0\"},\"padding\":{\"0\":\"13\",\"1\":\"13\",\"2\":\"13\",\"3\":\"13\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"25\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\"}},{\"id\":\"5\",\"order\":2,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\"}},{\"id\":\"12\",\"order\":1,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("18", "Grant", "grant", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"20\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"20\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-grant-element-0{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-grant-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":0,\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"13\",\"1\":\"13\",\"2\":\"13\",\"3\":\"13\"},\"background-color\":\"#000000\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"40\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\"}},{\"id\":\"2\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#000000\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-text\":\"READ MORE\"}},{\"id\":\"3\",\"order\":1,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\"}},null,null,{\"id\":\"6\",\"order\":3,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"excerpt\",\"transition-type\":\"\"}},{\"id\":\"22\",\"order\":2,\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("19", "Hayes", "hayes", "{\"eg-item-skin-element-last-id\":\"23\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"20\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"20\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"1\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"10\"},\"padding\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("20", "Garfield", "garfield", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#000000\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"75\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"20\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"20\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"#000000\",\"bg-alpha\":\"25\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#000000\",\"bg-alpha\":\"25\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"date\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#333333\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("21", "Arthur", "arthur", "{\"eg-item-skin-element-last-id\":\"31\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#89af72\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"75\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"30\",\"30\",\"25\",\"30\"],\"content-border\":[\"0\",\"0\",\"1\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"20\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"28\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"5\",\"1\":\"10\",\"2\":\"4\",\"3\":\"10\"},\"background-color\":\"#000000\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\"}},{\"id\":\"26\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"1\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#aaaaaa\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_categories\"}},{\"id\":\"31\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"30\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"5\",\"1\":\"10\",\"2\":\"5\",\"3\":\"10\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("22", "Cleveland", "cleveland", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#000000\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"75\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#333333\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#333333\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"20\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"20\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-cleveland-element-0{}\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-cleveland-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":0,\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"13\",\"1\":\"13\",\"2\":\"13\",\"3\":\"13\"},\"background-color\":\"#000000\",\"bg-alpha\":\"25\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\"}},{\"id\":\"2\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"5\",\"1\":\"10\",\"2\":\"5\",\"3\":\"10\"},\"background-color\":\"#000000\",\"bg-alpha\":\"25\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\"}},{\"id\":\"3\",\"order\":1,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#555555\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#555555\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"date\"}},{\"id\":\"4\",\"order\":2,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\"}},null,{\"id\":\"6\",\"order\":5,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#eeeeee\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\"}},{\"id\":\"22\",\"order\":4,\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("23", "Harrison", "harrison", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"85\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#363839\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"20\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"20\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"date\",\"transition-type\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"10\"},\"padding\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("24", "McKinley", "mckinley", "{\"eg-item-skin-element-last-id\":\"30\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#13c0df\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"65\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slide\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"10\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#13c0df\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"25\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"5\",\"1\":\"10\",\"2\":\"3\",\"3\":\"10\"},\"background-color\":\"#000000\",\"bg-alpha\":\"15\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"50\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"SHOW IMAGE\"}},{\"id\":\"28\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"5\"},\"padding\":{\"0\":\"5\",\"1\":\"10\",\"2\":\"3\",\"3\":\"10\"},\"background-color\":\"#000000\",\"bg-alpha\":\"15\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"50\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"transition\":\"slide\",\"transition-type\":\"\",\"delay\":\"20\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"PLAY VIDEO\"}},{\"id\":\"3\",\"order\":1,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\"}},null,{\"id\":\"6\",\"order\":3,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\"}},null,{\"id\":\"29\",\"order\":2,\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"30\",\"order\":4,\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("25", "Roosevelt", "roosevelt", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#222222\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"50\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#333333\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#333333\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"zoomback\",\"cover-group-animation\":\"none\",\"media-animation\":\"shifttotop\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"20\",\"1\":\"20\",\"2\":\"20\",\"3\":\"20\"},\"background-color\":\"#333333\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-roosevelt-element-0{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-roosevelt-element-0{}\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"9\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"10\",\"2\":\"60\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#000000\",\"bg-alpha\":\"50\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"75\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-roosevelt-element-2{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-roosevelt-element-2{}\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#000000\",\"bg-alpha\":\"50\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"75\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("26", "HowardTaft", "howardtaft", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#6f212c\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"75\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#000000\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#000000\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slide\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-howardtaft-element-0{letter-spacing:1px;}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-0{}\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\".eg-howardtaft-element-2{ min-width:50px}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-2{}\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"200\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"true\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#000000\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"2\",\"1\":\"2\",\"2\":\"2\",\"3\":\"2\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-play\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("27", "WoodrowWilson", "woodrowwilson", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"20\",\"2\":\"0\",\"3\":\"20\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"3\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#89af72\",\"border-style\":\"solid\",\"css\":\".eg-howardtaft-element-2{ min-width:50px}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-2{}\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"anemptytextlline\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"4\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("28", "Harding", "harding", "{\"eg-item-skin-element-last-id\":\"17\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"0\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"0\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"40\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"Frontend Developer\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"3\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\"}},{\"id\":\"4\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"5\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"50\",\"source-post\":\"excerpt\"}},{\"id\":\"6\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("29", "Coolidge", "coolidge", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"0\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"15\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"33\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-tools\\\"><\\/i>\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\"}},{\"id\":\"4\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"5\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"40\",\"source-post\":\"excerpt\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"14\",\"color\":\"#40dc8d\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"20\",\"0\",\"0\",\"-15\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-angle-right\\\"><\\/i> Learn More\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("30", "Herbert Hoover", "herbert-hoover", "{\"eg-item-skin-element-last-id\":\"25\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"0\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"0\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"source-post\":\"title\"}},{\"id\":\"24\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#000000\",\"bg-alpha\":\"50\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"75\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"true\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#aaaaaa\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\", \",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#000000\",\"bg-alpha\":\"50\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"75\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-play\"}},{\"id\":\"10\",\"order\":\"10\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#c32524\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-pinterest\",\"link-type-url\":\"#\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"source-separate\":\",\",\"source-post\":\"excerpt\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#4672b3\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-facebook-1\",\"link-type-url\":\"#\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#099bcc\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-twitter-1\",\"link-type-url\":\"#\"}},{\"id\":\"2\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#da4a38\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-gplus-1\",\"link-type-url\":\"#\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("31", "Eisenhower", "eisenhower", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"0\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"15\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"15\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#000000\",\"bg-alpha\":\"85\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"#000000\",\"bg-alpha\":\"85\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-icon\":\"eg-icon-forward\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("32", "J.F.Kennedy", "j-f-kennedy", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"0\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#111111\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#111111\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"15\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"15\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"19\",\"1\":\"19\",\"2\":\"19\",\"3\":\"19\"},\"background-color\":\"#000000\",\"bg-alpha\":\"85\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"19\",\"1\":\"19\",\"2\":\"19\",\"3\":\"19\"},\"background-color\":\"#000000\",\"bg-alpha\":\"85\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"19\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"50\",\"1\":\"50\",\"2\":\"50\",\"3\":\"50\"},\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-icon\":\"eg-icon-forward\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#888888\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("33", "Lyndon Johnson", "lyndon-johnson", "{\"eg-item-skin-element-last-id\":\"2\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#000000\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"75\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"covergrowup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon%\\\" \\/>\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("34", "Ulysses S. Grant", "ulysses-s-grant", "{\"eg-item-skin-element-last-id\":\"11\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"0\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#f5f5f5\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:400\",\"Raleway:700,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"80\",\"1\":\"0\",\"2\":\"-6\",\"3\":\"0\"},\"padding\":{\"0\":\"1\",\"1\":\"10\",\"2\":\"5\",\"3\":\"10\"},\"background-color\":\"#000000\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-price\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"30\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"title\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"excerpt\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"transition-type\":\"out\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"SHIPPING INCL.\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"20\",\"2\":\"17\",\"3\":\"20\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"1\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line1\"}},{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"20\",\"2\":\"17\",\"3\":\"20\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"1\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line2\"}},{\"id\":\"7\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"20\",\"2\":\"17\",\"3\":\"20\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"1\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line3\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"20\",\"2\":\"17\",\"3\":\"20\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"1\",\"1\":\"0\",\"2\":\"1\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line4\"}},{\"id\":\"9\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"20\",\"1\":\"0\",\"2\":\"15\",\"3\":\"0\"},\"padding\":{\"0\":\"8\",\"1\":\"25\",\"2\":\"8\",\"3\":\"25\"},\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-text\":\"BUY NOW\"}},{\"id\":\"11\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("35", "Richard Nixon", "richard-nixon", "{\"eg-item-skin-element-last-id\":\"12\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#363839\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"0\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#252525\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#444444\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#252525\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"80\",\"1\":\"0\",\"2\":\"-6\",\"3\":\"0\"},\"padding\":{\"0\":\"1\",\"1\":\"10\",\"2\":\"5\",\"3\":\"10\"},\"background-color\":\"#000000\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"<span style=\\\"font-size:30px; font-weight:300;\\\">$<\\/span> 24.99\"}},{\"id\":\"1\",\"order\":0,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"title\"}},null,{\"id\":\"3\",\"order\":1,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"excerpt\"}},{\"id\":\"4\",\"order\":3,\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"transition-type\":\"out\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"SHIPPING INCL.\"}},{\"id\":\"5\",\"order\":2,\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"4gb Webspace Included\"}},{\"id\":\"6\",\"order\":3,\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"2 Domains\"}},{\"id\":\"7\",\"order\":4,\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"PHP5 Enabled\"}},{\"id\":\"8\",\"order\":5,\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"24h Support\"}},{\"id\":\"9\",\"order\":6,\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"15\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-text\":\"BUY NOW\"}},{\"id\":\"11\",\"order\":7,\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"12\",\"order\":1,\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("36", "Gerald Ford", "gerald-ford", "{\"eg-item-skin-element-last-id\":\"15\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"25\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#f5f5f5\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"30\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"PREMIUM PRODUCT\"}},{\"id\":\"14\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#000000\",\"bg-alpha\":\"65\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"The best for your small business\"}},{\"id\":\"15\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#000000\",\"bg-alpha\":\"65\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-basket\"}},{\"id\":\"11\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"0\",\"20\"],\"background-color\":\"#eeeeee\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"<span style=\\\"font-size:30px; font-weight:300;\\\">$<\\/span> 39.99\"}},{\"id\":\"12\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"15\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"20\",\"20\"],\"background-color\":\"#eeeeee\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"INCL. SHIPPING\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"4GB Webspace Included\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"2 Domains\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"PHP5 Enabled\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"20\",\"20\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"24h Support\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"20\",\"1\":\"0\",\"2\":\"20\",\"3\":\"0\"},\"padding\":{\"0\":\"8\",\"1\":\"25\",\"2\":\"8\",\"3\":\"25\"},\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"BUY NOW\"}},{\"id\":\"13\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("37", "Jimmy Carter", "jimmy-carter", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"0\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"30\",\"30\",\"27\",\"30\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"27\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"3\",\"6\",\"1\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"3dturnright\",\"media-animation-delay\":\"8\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"15\",\"color\":\"#363839\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"5\",\"1\":\"10\",\"2\":\"5\",\"3\":\"10\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"75\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"I\'m a custom caption\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Droid Serif\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"title\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"5\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#aaaaaa\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\", \",\"source-post\":\"cat_list\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"15\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":[\"-5\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#e74124\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"9\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"ADD ANYTHING\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"5\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"num_comments\"}},{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"7\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"9\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"source-separate\":\",\",\"source-post\":\"excerpt\"}},{\"id\":\"10\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"11\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"15\",\"line-height\":\"14\",\"color\":\"#e74124\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"15\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Droid Serif\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-angle-right\\\"><\\/i> Read More\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("38", "Ronald Reagan", "ronald-reagan", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"4\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"10\",\"1\":\"20\",\"2\":\"10\",\"3\":\"20\"},\"background-color\":\"#4d384b\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"6\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\"\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date_modified\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"23\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"10\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"title\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\", \",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\"}},{\"id\":\"8\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"28\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#000000\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"28\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\"}},{\"id\":\"4\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"num_comments\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"words\",\"limit-num\":\"20\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"20\",\"color\":\"#444444\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"7\",\"0\",\"0\",\"0\"],\"padding\":[\"15\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-post\":\"excerpt\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("39", "GeorgeBush", "georgebush", "{\"eg-item-skin-element-last-id\":\"4\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"content\",\"container-background-color\":\"#e33a0c\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"covergrowup\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Raleway:400,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"3\",\"enable-hover\":\"\",\"font-size\":\"35\",\"line-height\":\"38\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"20\",\"1\":\"0\",\"2\":\"0\",\"3\":\"20\"},\"padding\":{\"0\":\"0\",\"1\":\"20\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"source-post\":\"title\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"words\",\"limit-num\":\"8\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"5\",\"1\":\"0\",\"2\":\"20\",\"3\":\"20\"},\"padding\":{\"0\":\"0\",\"1\":\"20\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"source-post\":\"excerpt\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("40", "Essential Preview", "essential-preview", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#0a0a0a\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"75\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#000000\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:700;800\"]}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"4\",\"1\":\"12\",\"2\":\"3\",\"3\":\"12\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"10\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"0\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"20\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"0\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"3\",\"1\":\"10\",\"2\":\"2\",\"3\":\"10\"},\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#ffffff\",\"shadow-alpha\":\"0\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"24\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ff4d1c\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"0\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"meta\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"Check it Out\",\"link-type-meta\":\"eg-demogrid-link\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("41", "More Demo Examples", "more-demo-examples", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#404655\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"60\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#000000\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:700;800\"]}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"4\",\"1\":\"12\",\"2\":\"3\",\"3\":\"12\"},\"background-color\":\"#000000\",\"bg-alpha\":\"75\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"0\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"20\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"0\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"10\",\"2\",\"10\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#ffffff\",\"shadow-alpha\":\"0\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"24\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ff4d1c\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"0\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"meta\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"Check it Out\",\"link-type-meta\":\"eg-demogrid-link\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("42", "Wilbert", "wilbert", "{\"eg-item-skin-element-last-id\":\"2\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#111111\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"65\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon%\\\" \\/>\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("43", "Phillie", "phillie", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#ffffff\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"1\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#ffffff\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Raleway:700,800,900\"]}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"0\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon-dark%\\\" \\/>\"}},{\"id\":\"3\",\"order\":0,\"container\":\"tl\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"2\",\"1\":\"7\",\"2\":\"2\",\"3\":\"7\"},\"background-color\":\"#000000\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"81.67\",\"left-right\":\"38.5\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"%\",\"margin-unit\":\"px\",\"source-post\":\"title\"}}]", NULL);
INSERT INTO `wp_gtj8dk_eg_item_skins` VALUES("44", "Jason", "jason", "{\"eg-item-skin-element-last-id\":\"32\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"20\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"true\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"20\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\"}},{\"id\":\"32\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#89af72\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\"}},{\"id\":\"31\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"30\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#000000\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\"}},{\"id\":\"26\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"bg-alpha\":\"20\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"28\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"5\",\"1\":\"10\",\"2\":\"4\",\"3\":\"10\"},\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"5\",\"1\":\"5\",\"2\":\"5\",\"3\":\"5\"},\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"5\",\"1\":\"5\",\"2\":\"5\",\"3\":\"5\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e33a0c\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\"}}]", NULL);

/* INSERT TABLE DATA: wp_gtj8dk_eg_navigation_skins */
INSERT INTO `wp_gtj8dk_eg_navigation_skins` VALUES("1", "Flat Light", "flat-light", "/********************************\r\n	-	FLAT LIGHT BUTTONS -\r\n*********************************/\r\n.flat-light .navigationbuttons,\r\n.flat-light .esg-pagination,\r\n.flat-light .esg-filters{	text-transform:uppercase;\r\n							text-align: center;\r\n						}\r\n\r\n.flat-light .esg-filterbutton,\r\n.flat-light .esg-navigationbutton,\r\n.flat-light .esg-sortbutton,\r\n.flat-light .esg-cartbutton {	color:#000;\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								position: relative;\r\n								z-index:2;\r\n								padding:1px 30px;\r\n								border:none;\r\n								line-height:38px;\r\n								border-radius:5px;\r\n								-moz-border-radius:5px;\r\n								-webkit-border-radius:5px;\r\n								font-size:12px;\r\n								font-weight:700;\r\n								font-family:\"Open Sans\",sans-serif;\r\n								display: inline-block;\r\n								background: #fff;\r\n								margin-bottom:5px;\r\n							}\r\n\r\n.flat-light .esg-navigationbutton	{ padding:2px 12px; }\r\n.flat-light .esg-navigationbutton *	{ color:#000; }\r\n.flat-light .esg-pagination-button:last-child { margin-right: 0; }\r\n\r\n.flat-light  .esg-sortbutton-wrapper,\r\n.flat-light  .esg-cartbutton-wrapper { display:inline-block; }\r\n.flat-light  .esg-sortbutton-order,\r\n.flat-light  .esg-cartbutton-order {	display:inline-block;\r\n										vertical-align:top;\r\n										border:none;\r\n										width:40px;\r\n										line-height:40px;\r\n										border-radius:5px;\r\n										-moz-border-radius:5px;\r\n										-webkit-border-radius:5px;\r\n										font-size:12px;\r\n										font-weight:700;\r\n										color:#999;\r\n										cursor: pointer;\r\n										background:#eee;\r\n										background: #fff;\r\n										margin-left:5px;\r\n									}\r\n\r\n.flat-light .esg-cartbutton {	color:#fff;\r\n								cursor: default !important;\r\n							}\r\n.flat-light .esg-cartbutton .esgicon-basket	{\r\n												color:#fff;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n											}\r\n.flat-light .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.flat-light .esg-sortbutton,\r\n.flat-light .esg-cartbutton {	display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:0px;\r\n								border-radius:5px;\r\n								-moz-border-radius:5px;\r\n								-webkit-border-radius:5px;\r\n							}\r\n\r\n.flat-light .esg-navigationbutton:hover,\r\n.flat-light .esg-filterbutton:hover,\r\n.flat-light .esg-sortbutton:hover,\r\n.flat-light .esg-sortbutton-order:hover,\r\n.flat-light .esg-cartbutton-order:hover,\r\n.flat-light .esg-filterbutton.selected {\r\n										border-color:none;color:#000;\r\n										background:#fff;\r\n									   }\r\n\r\n.flat-light .esg-navigationbutton:hover * { color:#333; }\r\n\r\n.flat-light .esg-sortbutton-order.tp-desc:hover	{ color:#333; }\r\n\r\n.flat-light .esg-filter-checked	{	padding:1px 3px;\r\n									color:#cbcbcb;\r\n									background:#cbcbcb;\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:300;\r\n									line-height:9px;\r\n									vertical-align: middle;\r\n								}\r\n.flat-light .esg-filterbutton.selected .esg-filter-checked,\r\n.flat-light .esg-filterbutton:hover .esg-filter-checked	{\r\n															padding:1px 3px 1px 3px;\r\n															color:#fff;\r\n															background:#000;\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:300;\r\n															line-height:9px;\r\n															vertical-align: middle;\r\n														}");
INSERT INTO `wp_gtj8dk_eg_navigation_skins` VALUES("2", "Flat Dark", "flat-dark", "/********************************\r\n	-	FLAT DARK BUTTONS -\r\n*********************************/\r\n.flat-dark .navigationbuttons,\r\n.flat-dark .esg-pagination,\r\n.flat-dark .esg-filters {\r\n							text-transform:uppercase;\r\n							text-align: center;\r\n						}\r\n\r\n.flat-dark .esg-filterbutton,\r\n.flat-dark .esg-navigationbutton,\r\n.flat-dark .esg-sortbutton,\r\n.flat-dark .esg-cartbutton {color:#fff;\r\n							margin-right:5px;\r\n							cursor:pointer;\r\n							padding:1px 30px;\r\n							border:none;\r\n							line-height:38px;\r\n							border-radius:5px;\r\n							-moz-border-radius:5px;\r\n							-webkit-border-radius:5px;\r\n							font-size:12px;\r\n							font-weight:600;\r\n							font-family:\"Open Sans\",sans-serif;\r\n							display: inline-block;\r\n							background:#3a3a3a;\r\n							background: rgba(0,0,0,0.2);\r\n							margin-bottom:5px;\r\n							}\r\n\r\n.flat-dark .esg-navigationbutton { padding:1px 18px; }\r\n.flat-dark .esg-navigationbutton * { color:#fff; }\r\n.flat-dark .esg-pagination-button:last-child,\r\n.flat-dark .esg-filterbutton:last-child{ margin-right: 0; }\r\n.flat-dark .esg-left, .flat-dark .esg-right { padding:1px 12px; }\r\n\r\n.flat-dark  .esg-sortbutton-wrapper,\r\n.flat-dark  .esg-cartbutton-wrapper	{ display:inline-block; }\r\n.flat-dark  .esg-sortbutton-order,\r\n.flat-dark  .esg-cartbutton-order { display:inline-block;\r\n									vertical-align:top;\r\n									border:none;\r\n									width:40px;\r\n									line-height:40px;\r\n									border-radius:5px;\r\n									-moz-border-radius:5px;\r\n									-webkit-border-radius:5px;\r\n									font-size:12px;\r\n									font-weight:700;\r\n									color:#999;\r\n									cursor: pointer;\r\n									background:#eee;\r\n									background: rgba(0,0,0,0.2);\r\n									margin-left:5px;\r\n								}\r\n\r\n.flat-dark .esg-cartbutton {color:#fff;\r\n							cursor: default !important;\r\n							}\r\n.flat-dark .esg-cartbutton .esgicon-basket {color:#fff;\r\n											font-size:15px;\r\n											line-height:15px;\r\n											margin-right:10px;\r\n											}\r\n.flat-dark  .esg-cartbutton-wrapper	{ cursor: default !important; }\r\n\r\n.flat-dark .esg-sortbutton,\r\n.flat-dark .esg-cartbutton { display:inline-block;\r\n							position:relative;\r\n							cursor: pointer;\r\n							margin-right:0px;\r\n							border-radius:5px;\r\n							-moz-border-radius:5px;\r\n							-webkit-border-radius:5px;\r\n							}\r\n\r\n.flat-dark .esg-navigationbutton:hover,\r\n.flat-dark .esg-filterbutton:hover,\r\n.flat-dark .esg-sortbutton:hover,\r\n.flat-dark .esg-sortbutton-order:hover,\r\n.flat-dark .esg-cartbutton-order:hover,\r\n.flat-dark .esg-filterbutton.selected { color:#fff;\r\n										border-color:none;\r\n										background:#4a4a4a;\r\n										background: rgba(0,0,0,0.5);\r\n									 }\r\n\r\n.flat-dark .esg-navigationbutton:hover * { color:#fff; }\r\n.flat-dark .esg-sortbutton-order.tp-desc:hover	{ color:#fff; }\r\n.flat-dark .esg-filter-checked {padding:1px 3px;\r\n								color:transparent;\r\n								background:#000;\r\n								background: rgba(0,0,0,0.2);\r\n								margin-left:7px;\r\n								font-size:9px;\r\n								font-weight:300;\r\n								line-height:9px;\r\n								vertical-align: middle:\r\n								}\r\n								\r\n.flat-dark .esg-filterbutton.selected .esg-filter-checked,\r\n.flat-dark .esg-filterbutton:hover .esg-filter-checked {padding:1px 3px 1px 3px;\r\n														color:#fff;\r\n														background:#000;\r\n														background: rgba(0,0,0,0.2);\r\n														margin-left:7px;\r\n														font-size:9px;\r\n														font-weight:300;\r\n														line-height:9px;\r\n														vertical-align: middle\r\n														}");
INSERT INTO `wp_gtj8dk_eg_navigation_skins` VALUES("3", "Minimal Dark", "minimal-dark", "/********************************\r\n	-	MINIMAL DARK BUTTONS -\r\n*********************************/\r\n\r\n.minimal-dark .navigationbuttons,\r\n.minimal-dark .esg-pagination,\r\n.minimal-dark .esg-filters { text-align: center; }\r\n\r\n.minimal-dark .esg-filterbutton,\r\n.minimal-dark .esg-navigationbutton,\r\n.minimal-dark .esg-sortbutton,\r\n.minimal-dark .esg-cartbutton { color:#fff;\r\n								color:rgba(255,255,255,1);\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								padding:0px 17px;\r\n								border:1px solid rgb(255,255,255);\r\n								border:1px solid rgba(255,255,255,0.1);\r\n								line-height:38px;\r\n								border-radius:5px;\r\n								-moz-border-radius:5px;\r\n								-webkit-border-radius:5px;\r\n								font-size:12px;\r\n								font-weight:600;\r\n								font-family:\"Open Sans\",sans-serif;\r\n								display: inline-block;\r\n								background:transparent;\r\n								margin-bottom:5px;\r\n								}\r\n\r\n\r\n.minimal-dark .esg-navigationbutton * {\r\n										color:#fff;\r\n										color:rgba(255,255,255,1);\r\n									}\r\n.minimal-dark .esg-navigationbutton	{ padding:0px 11px; }\r\n.minimal-dark .esg-pagination-button { padding:0px 16px; }\r\n.minimal-dark .esg-pagination-button:last-child { margin-right: 0; }\r\n\r\n.minimal-dark  .esg-sortbutton-wrapper,\r\n.minimal-dark  .esg-cartbutton-wrapper { display:inline-block; }\r\n.minimal-dark  .esg-sortbutton-order,\r\n.minimal-dark  .esg-cartbutton-order {  display:inline-block;\r\n										vertical-align:top;\r\n										border:1px solid rgb(255,255,255);\r\n										border:1px solid rgba(255,255,255,0.1);\r\n										width:40px;\r\n										line-height:38px;\r\n										border-radius: 0px 5px 5px 0px;\r\n										-moz-border-radius: 0px 5px 5px 0px;\r\n										-webkit-border-radius: 0px 5px 5px 0px;\r\n										font-size:12px;\r\n										font-weight:600;\r\n										color:#fff;\r\n										cursor: pointer;\r\n										background:transparent;\r\n									}\r\n\r\n.minimal-dark .esg-cartbutton {\r\n								color:#fff;\r\n								cursor: default !important;\r\n							  }\r\n.minimal-dark .esg-cartbutton .esgicon-basket {\r\n												color:#fff;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n											  }\r\n.minimal-dark  .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.minimal-dark .esg-sortbutton,\r\n.minimal-dark .esg-cartbutton {\r\n								display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:0px;\r\n								border-right:none;\r\n								border-radius:5px 0px 0px 5px;\r\n								-moz-border-radius:5px 0px 0px 5px;\r\n								-webkit-border-radius:5px 0px 0px 5px;\r\n							   }\r\n\r\n.minimal-dark .esg-navigationbutton:hover,\r\n.minimal-dark .esg-filterbutton:hover,\r\n.minimal-dark .esg-sortbutton:hover,\r\n.minimal-dark .esg-sortbutton-order:hover,\r\n.minimal-dark .esg-cartbutton-order:hover,\r\n.minimal-dark .esg-filterbutton.selected {\r\n											border-color:#fff;\r\n											border-color:rgba(255,255,255,0.2);\r\n											color:#fff;\r\n											box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\r\n											background:#333;\r\n											background: rgba(255,255,255,0.1);\r\n										  }\r\n\r\n.minimal-dark .esg-navigationbutton:hover * { color:#fff; }\r\n\r\n.minimal-dark .esg-sortbutton-order.tp-desc:hover {	border-color:#fff;\r\n													border-color:rgba(255,255,255,0.2);\r\n													color:#fff;\r\n													box-shadow: 0px -3px 5px 0px rgba(0,0,0,0.13) !important;\r\n												  }\r\n\r\n.minimal-dark .esg-filter-checked {\r\n									padding:1px 3px;\r\n									color:transparent;\r\n									background:#000;\r\n									background: rgba(0,0,0,0.10);\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:300;\r\n									line-height:9px;\r\n									vertical-align: middle;\r\n								  }\r\n.minimal-dark .esg-filterbutton.selected .esg-filter-checked,\r\n.minimal-dark .esg-filterbutton:hover .esg-filter-checked {\r\n															padding:1px 3px 1px 3px;\r\n															color:#fff;\r\n															background:#000;\r\n															background: rgba(0,0,0,0.10);\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:300;\r\n															line-height:9px;\r\n															vertical-align: middle;\r\n														  }");
INSERT INTO `wp_gtj8dk_eg_navigation_skins` VALUES("4", "Minimal Light", "minimal-light", "/******************************\r\n	-	MINIMAL LIGHT SKIN	-\r\n********************************/\r\n\r\n.minimal-light .navigationbuttons,\r\n.minimal-light .esg-pagination,\r\n.minimal-light .esg-filters { text-align: center; }\r\n\r\n.minimal-light .esg-filterbutton,\r\n.minimal-light .esg-navigationbutton,\r\n.minimal-light .esg-sortbutton,\r\n.minimal-light .esg-cartbutton a{ \r\n								color:#999;\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								padding:0px 16px;\r\n								border:1px solid #e5e5e5;\r\n								line-height:38px;\r\n								border-radius:5px;\r\n								-moz-border-radius:5px;\r\n								-webkit-border-radius:5px;\r\n								font-size:12px;\r\n								font-weight:700;\r\n								font-family:\"Open Sans\",sans-serif;\r\n								display: inline-block;\r\n								background:#fff;\r\n								margin-bottom:5px;\r\n							  }\r\n\r\n/*.minimal-light .esg-cartbutton a { color: #999; }*/\r\n\r\n.minimal-light .esg-navigationbutton * { color:#999; }\r\n.minimal-light .esg-navigationbutton	{ padding:0px 16px; }\r\n.minimal-light .esg-pagination-button:last-child { margin-right: 0; }\r\n.minimal-light .esg-left, .minimal-light .esg-right	{ padding:0px 11px; }\r\n\r\n.minimal-light  .esg-sortbutton-wrapper,\r\n.minimal-light  .esg-cartbutton-wrapper { display:inline-block; }\r\n.minimal-light  .esg-sortbutton-order,\r\n.minimal-light  .esg-cartbutton-order {	display:inline-block;\r\n										vertical-align:top;\r\n										border:1px solid #e5e5e5;\r\n										width:40px;\r\n										line-height:38px;\r\n										border-radius: 0px 5px 5px 0px;\r\n										-moz-border-radius: 0px 5px 5px 0px;\r\n										-webkit-border-radius: 0px 5px 5px 0px;\r\n										font-size:12px;\r\n										font-weight:700;\r\n										color:#999;\r\n										cursor: pointer;\r\n										background:#fff;\r\n									   }\r\n\r\n.minimal-light .esg-cartbutton {\r\n								color:#333;\r\n								cursor: default !important;\r\n								}\r\n.minimal-light .esg-cartbutton .esgicon-basket {color:#333;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n												}\r\n.minimal-light  .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.minimal-light .esg-sortbutton,\r\n.minimal-light .esg-cartbutton { display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:0px;\r\n								border-right:none;\r\n								border-radius:5px 0px 0px 5px;\r\n								-moz-border-radius:5px 0px 0px 5px;\r\n								-webkit-border-radius:5px 0px 0px 5px;\r\n								}\r\n\r\n.minimal-light .esg-navigationbutton:hover,\r\n.minimal-light .esg-filterbutton:hover,\r\n.minimal-light .esg-sortbutton:hover,\r\n.minimal-light .esg-sortbutton-order:hover,\r\n.minimal-light .esg-cartbutton a:hover,\r\n.minimal-light .esg-filterbutton.selected {\r\n											background-color:#fff;\r\n											border-color:#bbb;\r\n											color:#333;\r\n											box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\r\n										  }\r\n\r\n.minimal-light .esg-navigationbutton:hover * { color:#333; }\r\n\r\n.minimal-light .esg-sortbutton-order.tp-desc:hover {\r\n													border-color:#bbb;\r\n													color:#333;\r\n													box-shadow: 0px -3px 5px 0px rgba(0,0,0,0.13) !important;\r\n												   }\r\n\r\n.minimal-light .esg-filter-checked { \r\n									padding:1px 3px;\r\n									color:#cbcbcb;\r\n									background:#cbcbcb;\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:300;\r\n									line-height:9px;\r\n									vertical-align: middle;\r\n									}\r\n.minimal-light .esg-filterbutton.selected .esg-filter-checked,\r\n.minimal-light .esg-filterbutton:hover .esg-filter-checked {\r\n															padding:1px 3px 1px 3px;\r\n															color:#fff;\r\n															background:#000;\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:300;\r\n															line-height:9px;\r\n															vertical-align: middle;\r\n														   }");
INSERT INTO `wp_gtj8dk_eg_navigation_skins` VALUES("5", "Simple Light", "simple-light", "/******************************\r\n	-	SIMPLE LIGHT SKIN	-\r\n********************************/\r\n\r\n.simple-light .navigationbuttons,\r\n.simple-light .esg-pagination,\r\n.simple-light .esg-filters { text-align: center; }\r\n\r\n.simple-light .esg-filterbutton,\r\n.simple-light .esg-navigationbutton,\r\n.simple-light .esg-sortbutton,\r\n.simple-light .esg-cartbutton a {\r\n								color:#000;\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								padding:0px 11px;\r\n								border:1px solid #e5e5e5;\r\n								line-height:30px;\r\n								font-size:12px;\r\n								font-weight:400;\r\n								font-family:\\\\\\\"Open Sans\\\\\\\",sans-serif;\r\n								display: inline-block;\r\n								background:#eee;\r\n								margin-bottom:5px;\r\n							  }\r\n\r\n.simple-light .esg-navigationbutton * {	color:#000; }\r\n.simple-light .esg-left,\r\n.simple-light .esg-right { color:#000; padding:0px 7px;}\r\n.simple-light .esg-pagination-button:last-child { margin-right: 0; }\r\n\r\n.simple-light .esg-sortbutton-wrapper,\r\n.simple-light .esg-cartbutton-wrapper {	display:inline-block; }\r\n.simple-light .esg-sortbutton-order,\r\n.simple-light .esg-cartbutton-order {\r\n									display: inline-block;\r\n									vertical-align: top;\r\n									border: 1px solid #e5e5e5;\r\n									width: 29px;\r\n									line-height: 30px;\r\n									font-size: 9px;\r\n									font-weight: 400;\r\n									color: #000;\r\n									cursor: pointer;\r\n									background: #eee;\r\n									}\r\n\r\n.simple-light .esg-cartbutton {\r\n								color:#333;\r\n								cursor: default !important;\r\n							  }\r\n.simple-light .esg-cartbutton .esgicon-basket {\r\n												color:#333;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n											  }\r\n.simple-light  .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.simple-light .esg-sortbutton,\r\n.simple-light .esg-cartbutton {\r\n								display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:5px;\r\n							  }\r\n\r\n\r\n.simple-light .esg-navigationbutton:hover,\r\n.simple-light .esg-filterbutton:hover,\r\n.simple-light .esg-sortbutton:hover,\r\n.simple-light .esg-sortbutton-order:hover,\r\n.simple-light .esg-cartbutton a:hover,\r\n.simple-light .esg-filterbutton.selected {\r\n											background-color:#fff;\r\n											border-color:#bbb;\r\n											color:#333;\r\n											box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\r\n										 }\r\n\r\n.simple-light .esg-navigationbutton:hover * { color:#333; }\r\n\r\n.simple-light .esg-sortbutton-order.tp-desc:hover {\r\n													border-color:#bbb;\r\n													color:#333;\r\n													box-shadow: 0px -3px 5px 0px rgba(0,0,0,0.13) !important;\r\n												  }\r\n\r\n.simple-light .esg-filter-checked {\r\n									padding:3px;\r\n									color:#c5c5c5;\r\n									background:#ddd;\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:400;\r\n									line-height:20px;\r\n									vertical-align: middle;\r\n								  }\r\n.simple-light .esg-filterbutton.selected .esg-filter-checked,\r\n.simple-light .esg-filterbutton:hover .esg-filter-checked {\r\n															padding: 3px;\r\n															color:#fff;\r\n															background:#000;\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:400;\r\n															line-height:20px;\r\n															vertical-align: middle\r\n														}");
INSERT INTO `wp_gtj8dk_eg_navigation_skins` VALUES("6", "Simple Dark", "simple-dark", "/********************************\r\n-	SIMPLE DARK BUTTONS -\r\n*********************************/\r\n\r\n.simple-dark .navigationbuttons,\r\n.simple-dark .esg-pagination,\r\n.simple-dark .esg-filters {	text-align: center; }\r\n\r\n.simple-dark .esg-filterbutton,\r\n.simple-dark .esg-navigationbutton,\r\n.simple-dark .esg-sortbutton,\r\n.simple-dark .esg-cartbutton {\r\n								color:#fff;\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								padding:0px 10px;\r\n								border:1px solid rgb(255,255,255);\r\n								border:1px solid rgba(255,255,255,0.15);\r\n								line-height:29px;\r\n								font-size:12px;\r\n								font-weight:600;\r\n								font-family:\"Open Sans\",sans-serif;\r\n								display: inline-block;\r\n								background: rgba(255,255,255,0.08 );\r\n								margin-bottom:5px;\r\n							  }\r\n\r\n.simple-dark .esg-navigationbutton * {\r\n										color:#fff;\r\n									 }\r\n.simple-dark .esg-left, .simple-dark .esg-right { padding:0px 5px !important; }\r\n\r\n.simple-dark  .esg-sortbutton-wrapper,\r\n.simple-dark  .esg-cartbutton-wrapper {	display:inline-block; }\r\n.simple-dark  .esg-sortbutton-order,\r\n.simple-dark  .esg-cartbutton-order {\r\n									display: inline-block;\r\n									vertical-align: top;\r\n									border:1px solid rgb(255,255,255);\r\n									border:1px solid rgba(255,255,255,0.15);\r\n									width: 29px;\r\n									line-height: 29px;\r\n									font-size: 9px;\r\n									font-weight: 600;\r\n									color: #fff;\r\n									cursor: pointer;\r\n									background: rgba(255,255,255,0.08 );\r\n									}\r\n\r\n.simple-dark .esg-cartbutton {\r\n							color:#fff;\r\n							cursor: default !important;\r\n							}\r\n							\r\n.simple-dark .esg-cartbutton .esgicon-basket {\r\n												color:#fff;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n											  }\r\n.simple-dark  .esg-cartbutton-wrapper {	cursor: default !important; }\r\n\r\n.simple-dark .esg-sortbutton,\r\n.simple-dark .esg-cartbutton {\r\n								display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:5px;\r\n							  }\r\n\r\n\r\n.simple-dark .esg-navigationbutton:hover,\r\n.simple-dark .esg-filterbutton:hover,\r\n.simple-dark .esg-sortbutton:hover,\r\n.simple-dark .esg-sortbutton-order:hover,\r\n.simple-dark .esg-cartbutton-order:hover,\r\n.simple-dark .esg-filterbutton.selected {\r\n										border-color:#fff;\r\n										color:#000;\r\n										box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\r\n										background:#fff;\r\n										}\r\n\r\n.simple-dark .esg-navigationbutton:hover * { color:#000; }\r\n.simple-dark .esg-pagination-button:last-child { margin-right: 0; }\r\n\r\n.simple-dark .esg-sortbutton-order.tp-desc:hover {\r\n													border-color:#fff;\r\n													border-color:rgba(255,255,255,0.2);\r\n													color:#000;\r\n													box-shadow: 0px -3px 5px 0px rgba(0,0,0,0.13) !important;\r\n												 }\r\n\r\n.simple-dark .esg-filter-checked {\r\n									padding:1px;\r\n									color:transparent;\r\n									background:#000;\r\n									background: rgba(255,255,255,0.15);\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:300;\r\n									line-height:9px;\r\n									vertical-align: middle;\r\n								  }\r\n\r\n.simple-dark .esg-filterbutton.selected .esg-filter-checked,\r\n.simple-dark .esg-filterbutton:hover .esg-filter-checked {\r\n															padding:1px;\r\n															color:#000;\r\n															background:#fff;\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:300;\r\n															line-height:9px;\r\n															vertical-align: middle;\r\n														  }");
INSERT INTO `wp_gtj8dk_eg_navigation_skins` VALUES("7", "Text Dark", "text-dark", "/********************************\r\n-	TEXT DARK BUTTONS -\r\n*********************************/\r\n\r\n.text-dark .navigationbuttons,\r\n.text-dark .esg-pagination,\r\n.text-dark .esg-filters { text-align: center; }\r\n\r\n.text-dark .esg-filterbutton,\r\n.text-dark .esg-navigationbutton,\r\n.text-dark .esg-sortbutton,\r\n.text-dark .esg-cartbutton {\r\n							color:#fff;\r\n							color:rgba(255,255,255,0.4);\r\n							margin-right:5px;\r\n							cursor:pointer;\r\n							padding:0px 15px 0px 10px;\r\n							line-height:20px;\r\n							font-size:12px;\r\n							font-weight:600;\r\n							font-family:\"Open Sans\",sans-serif;\r\n							display: inline-block;\r\n							background:transparent;\r\n							margin-bottom:5px;\r\n						  }\r\n\r\n.text-dark .esg-navigationbutton * {\r\n									color:#fff;\r\n									color:rgba(255,255,255,0.4);\r\n								   }\r\n\r\n.text-dark  .esg-sortbutton-wrapper,\r\n.text-dark  .esg-cartbutton-wrapper { display:inline-block; }\r\n.text-dark  .esg-sortbutton-order,\r\n.text-dark  .esg-cartbutton-order {\r\n									display: inline-block;\r\n									vertical-align: middle;\r\n									width: 29px;\r\n									line-height: 20px;\r\n									font-size: 9px;\r\n									font-weight: 700;\r\n									color:#fff;\r\n									color:rgba(255,255,255,0.4);\r\n									cursor: pointer;\r\n									background: transparent;\r\n								  }\r\n\r\n.text-dark .esg-cartbutton {\r\n							color:#fff;\r\n							color:rgba(255,255,255,0.4);\r\n							cursor: default !important;\r\n							}\r\n.text-dark .esg-cartbutton .esgicon-basket {\r\n											color:#fff;\r\n											color:rgba(255,255,255,0.4);\r\n											font-size:15px;\r\n											line-height:15px;\r\n											margin-right:10px;\r\n											}\r\n.text-dark  .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.text-dark .esg-sortbutton,\r\n.text-dark .esg-cartbutton {\r\n							display:inline-block;\r\n							position:relative;\r\n							cursor: pointer;\r\n							margin-right:0px;\r\n							}\r\n\r\n.text-dark .esg-navigationbutton:hover,\r\n.text-dark .esg-filterbutton:hover,\r\n.text-dark .esg-sortbutton:hover,\r\n.text-dark .esg-filterbutton.selected,\r\n.text-dark .esg-sortbutton-order:hover,\r\n.text-dark .esg-cartbutton-order:hover { color:#fff; }\r\n\r\n.text-dark .esg-navigationbutton:hover,\r\n.text-dark .esg-filterbutton:hover span:first-child,\r\n.text-dark .esg-filterbutton.selected span:first-child { text-decoration: none; }\r\n\r\n.text-dark .esg-filterbutton {\r\n								border-right:1px solid #fff;\r\n								border-right:1px solid rgba(255,255,255,0.15);\r\n							  }\r\n.text-dark .esg-filterbutton:last-child	{ border-right:none; }\r\n\r\n.text-dark .esg-sortbutton-order {\r\n									padding-left:10px;\r\n									border-left:1px solid #fff;\r\n									border-left:1px solid rgba(255,255,255,0.15);\r\n								 }\r\n\r\n.text-dark .esg-navigationbutton:hover * { color:#fff; }\r\n\r\n.text-dark .esg-sortbutton-order.tp-desc:hover {\r\n												border-color:#fff;\r\n												border-color:rgba(255,255,255,0.15);\r\n												color:#fff;\r\n												}\r\n\r\n.text-dark .esg-filter-checked {\r\n								padding:1px 3px;\r\n								color:transparent;\r\n								background:#000;\r\n								background: rgba(0,0,0,0.10);\r\n								margin-left:7px;\r\n								font-size:9px;\r\n								font-weight:300;\r\n								line-height:9px;\r\n								vertical-align: middle;\r\n								}\r\n\r\n.text-dark .esg-filter-checked * { }\r\n.text-dark .esg-filterbutton.selected .esg-filter-checked,\r\n.text-dark .esg-filterbutton:hover .esg-filter-checked {\r\n														padding:1px 3px 1px 3px;\r\n														color:#fff;\r\n														background:#000;\r\n														background: rgba(0,0,0,0.10);\r\n														margin-left:7px;\r\n														font-size:9px;\r\n														font-weight:300;\r\n														line-height:9px;\r\n														vertical-align: middle\r\n														}");
INSERT INTO `wp_gtj8dk_eg_navigation_skins` VALUES("8", "Text Light", "text-light", "/********************************\r\n-	TEXT LIGHT BUTTONS -\r\n*********************************/\r\n\r\n.text-light .navigationbuttons,\r\n.text-light .esg-pagination,\r\n.text-light .esg-filters {\r\n						text-align: center;\r\n						position: relative;\r\n						z-index:2;\r\n						}\r\n\r\n.text-light .esg-filterbutton,\r\n.text-light .esg-navigationbutton,\r\n.text-light .esg-sortbutton,\r\n.text-light .esg-cartbutton {\r\n							color:#999;\r\n							margin-right:5px;\r\n							cursor:pointer;\r\n							padding:0px 15px 0px 10px;\r\n							line-height:20px;\r\n							font-size:12px;\r\n							font-weight:600;\r\n							font-family:\"Open Sans\",sans-serif;\r\n							display: inline-block;\r\n							background:transparent;\r\n							margin-bottom:5px;\r\n							}\r\n\r\n.text-light .esg-navigationbutton * { color:#999; }\r\n\r\n.text-light  .esg-sortbutton-wrapper,\r\n.text-light  .esg-cartbutton-wrapper { display:inline-block; }\r\n.text-light  .esg-sortbutton-order,\r\n.text-light  .esg-cartbutton-order {\r\n									display: inline-block;\r\n									vertical-align: middle;\r\n									width: 29px;\r\n									line-height: 20px;\r\n									font-size: 9px;\r\n									font-weight: 700;\r\n									color:#999;\r\n									cursor: pointer;\r\n									background: transparent;\r\n									}\r\n\r\n.text-light .esg-cartbutton {\r\n							color:#999;\r\n							cursor: default !important;\r\n							}\r\n.text-light .esg-cartbutton .esgicon-basket {\r\n											color:#999;\r\n											font-size:15px;\r\n											line-height:15px;\r\n											margin-right:10px;\r\n											}\r\n.text-light .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.text-light .esg-sortbutton,\r\n.text-light .esg-cartbutton {\r\n							display:inline-block;\r\n							position:relative;\r\n							cursor: pointer;\r\n							margin-right:0px;\r\n							}\r\n\r\n.text-light .esg-navigationbutton:hover,\r\n.text-light .esg-filterbutton:hover,\r\n.text-light .esg-sortbutton:hover,\r\n.text-light .esg-filterbutton.selected,\r\n.text-light .esg-sortbutton-order:hover,\r\n.text-light .esg-cartbutton-order:hover { color:#444; }\r\n\r\n.text-light .esg-navigationbutton:hover,\r\n.text-light .esg-filterbutton:hover span:first-child,\r\n.text-light .esg-filterbutton.selected span:first-child { text-decoration: underline; }\r\n\r\n.text-light .esg-filterbutton {	border-right:1px solid #e5e5e5; }\r\n.text-light .esg-filterbutton:last-child { border-right:none; }\r\n\r\n.text-light .esg-sortbutton-order {\r\n									padding-left:10px;\r\n									border-left:1px solid #e5e5e5;\r\n								  }\r\n\r\n.text-light .esg-navigationbutton:hover * {	color:#444; }\r\n\r\n.text-light .esg-sortbutton-order.tp-desc:hover {\r\n												border-color:#e5e5e5;\r\n												color:#444;\r\n												}\r\n\r\n.text-light .esg-filter-checked {\r\n								padding:1px 3px;\r\n								color:transparent;\r\n								background:#eee;\r\n								background: rgba(0,0,0,0.05);\r\n								margin-left:7px;\r\n								font-size:9px;\r\n								font-weight:300;\r\n								line-height:9px;\r\n								vertical-align: middle;\r\n								}\r\n.text-light .esg-filter-checked * { }\r\n.text-light .esg-filterbutton.selected .esg-filter-checked,\r\n.text-light .esg-filterbutton:hover .esg-filter-checked {\r\n														padding:1px 3px 1px 3px;\r\n														color:#333;\r\n														background:#eee;\r\n														background: rgba(0,0,0,0.05);\r\n														margin-left:7px;\r\n														font-size:9px;\r\n														font-weight:300;\r\n														line-height:9px;\r\n														vertical-align: middle;\r\n														}\r\n");

/* INSERT TABLE DATA: wp_gtj8dk_frm_fields */
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("1", "qh4icy", "Name", "First", "text", NULL, NULL, "1", "1", "a:4:{s:5:\"blank\";s:0:\"\";s:14:\"separate_value\";i:0;s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "1", "2016-07-11 03:25:52");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("2", "ocfup1", "Last", "Last", "text", NULL, NULL, "2", "1", "a:4:{s:5:\"label\";s:6:\"hidden\";s:5:\"blank\";s:0:\"\";s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "1", "2016-07-11 03:25:52");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("3", "29yf4d", "Email", "", "email", NULL, NULL, "3", "1", "a:4:{s:5:\"blank\";s:0:\"\";s:7:\"invalid\";s:34:\"Please enter a valid email address\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "1", "2016-07-11 03:25:52");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("4", "itt5me", "Website", "", "url", NULL, NULL, "4", "0", "a:4:{s:5:\"blank\";s:0:\"\";s:7:\"invalid\";s:28:\"Please enter a valid website\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "1", "2016-07-11 03:25:52");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("5", "e6lis6", "Subject", "", "text", NULL, NULL, "5", "1", "a:3:{s:5:\"blank\";s:0:\"\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "1", "2016-07-11 03:25:52");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("6", "9jv0r1", "Message", "", "textarea", NULL, NULL, "6", "1", "a:4:{s:3:\"max\";s:1:\"5\";s:5:\"blank\";s:0:\"\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "1", "2016-07-11 03:25:52");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("7", "62n6q3", "Captcha", "", "captcha", NULL, NULL, "7", "0", "a:5:{s:5:\"label\";s:4:\"none\";s:5:\"blank\";s:0:\"\";s:14:\"clear_on_focus\";i:0;s:13:\"default_blank\";i:0;s:10:\"in_section\";i:0;}", "1", "2016-07-11 03:25:52");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("8", "386hqz", "MLS ID", "", "text", NULL, NULL, "0", "1", "a:2:{s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("9", "u0xugh", "Featured", "", "checkbox", NULL, "a:1:{i:0;s:8:\"Featured\";}", "1", "0", "a:3:{s:5:\"label\";s:6:\"hidden\";s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("10", "pb9ojs", "Street Address", "e.g., \"123 Main St\"", "text", NULL, NULL, "2", "1", "a:2:{s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("11", "zo1tzb", "City", "e.g., \"Anytown\"", "text", NULL, NULL, "3", "1", "a:2:{s:7:\"classes\";s:14:\"frm_first_half\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("12", "gc1dn6", "State", "", "select", NULL, "a:51:{i:0;s:0:\"\";i:1;s:7:\"Alabama\";i:2;s:6:\"Alaska\";i:3;s:8:\"Arkansas\";i:4;s:7:\"Arizona\";i:5;s:10:\"California\";i:6;s:8:\"Colorado\";i:7;s:11:\"Connecticut\";i:8;s:8:\"Delaware\";i:9;s:7:\"Florida\";i:10;s:7:\"Georgia\";i:11;s:6:\"Hawaii\";i:12;s:5:\"Idaho\";i:13;s:8:\"Illinois\";i:14;s:7:\"Indiana\";i:15;s:4:\"Iowa\";i:16;s:6:\"Kansas\";i:17;s:8:\"Kentucky\";i:18;s:9:\"Louisiana\";i:19;s:5:\"Maine\";i:20;s:8:\"Maryland\";i:21;s:13:\"Massachusetts\";i:22;s:8:\"Michigan\";i:23;s:9:\"Minnesota\";i:24;s:11:\"Mississippi\";i:25;s:8:\"Missouri\";i:26;s:7:\"Montana\";i:27;s:8:\"Nebraska\";i:28;s:6:\"Nevada\";i:29;s:13:\"New Hampshire\";i:30;s:10:\"New Jersey\";i:31;s:10:\"New Mexico\";i:32;s:8:\"New York\";i:33;s:14:\"North Carolina\";i:34;s:12:\"North Dakota\";i:35;s:4:\"Ohio\";i:36;s:8:\"Oklahoma\";i:37;s:6:\"Oregon\";i:38;s:12:\"Pennsylvania\";i:39;s:12:\"Rhode Island\";i:40;s:14:\"South Carolina\";i:41;s:12:\"South Dakota\";i:42;s:9:\"Tennessee\";i:43;s:5:\"Texas\";i:44;s:4:\"Utah\";i:45;s:7:\"Vermont\";i:46;s:8:\"Virginia\";i:47;s:10:\"Washington\";i:48;s:13:\"West Virginia\";i:49;s:9:\"Wisconsin\";i:50;s:7:\"Wyoming\";}", "4", "1", "a:3:{s:4:\"size\";i:0;s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("13", "lsxk7v", "Zip Code", "", "text", NULL, NULL, "5", "1", "a:2:{s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("14", "2c498o", "Type", "", "select", NULL, "a:7:{i:0;s:0:\"\";i:1;s:18:\"Single Family Home\";i:2;s:29:\"Condo/Townhome/Row Home/Co-Op\";i:3;s:17:\"Multi-Family Home\";i:4;s:15:\"Mfd/Mobile Home\";i:5;s:13:\"Farms/Ranches\";i:6;s:4:\"Land\";}", "6", "0", "a:3:{s:4:\"size\";i:0;s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("15", "iy0xub", "Property Status", "", "select", "Active", "a:5:{i:0;s:6:\"Active\";i:1;s:12:\"Sale Pending\";i:2;s:4:\"Sold\";i:3;s:13:\"Lease Pending\";i:4;s:6:\"Rented\";}", "7", "1", "a:3:{s:4:\"size\";i:0;s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("16", "q7hrhe", "List Price", "", "text", NULL, NULL, "8", "1", "a:3:{s:4:\"size\";s:3:\"110\";s:7:\"classes\";s:16:\"frm_first_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("17", "afngim", "List Date", "", "date", "[date]", NULL, "9", "0", "a:4:{s:4:\"size\";i:110;s:3:\"max\";s:2:\"10\";s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("18", "fanb9y", "Sale Price", "", "text", NULL, NULL, "10", "0", "a:3:{s:4:\"size\";i:110;s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("19", "s6xy3e", "Sale Date", "", "date", NULL, NULL, "11", "0", "a:4:{s:4:\"size\";s:3:\"110\";s:3:\"max\";s:2:\"10\";s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("20", "owhy0q", "Brief Blurb", "e.g., \"Nice 4BR home west of Lantana\"", "text", NULL, NULL, "12", "0", "a:2:{s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("21", "5r1v0u", "Description", "A more detailed description", "textarea", NULL, NULL, "13", "1", "a:4:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:1:\"5\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("22", "l9fov", "Year Built", "", "text", NULL, NULL, "14", "0", "a:3:{s:4:\"size\";s:3:\"110\";s:7:\"classes\";s:16:\"frm_first_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("23", "7pi9af", "Bedrooms", "", "text", NULL, NULL, "15", "0", "a:3:{s:4:\"size\";s:3:\"110\";s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("24", "n0oo3a", "Full Baths", "", "text", NULL, NULL, "16", "0", "a:3:{s:4:\"size\";s:3:\"110\";s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("25", "4qq2jl", "Garage Spaces", "", "text", NULL, NULL, "17", "0", "a:3:{s:4:\"size\";s:3:\"110\";s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("26", "3kx7jj", "Sqft (Living)", "", "text", NULL, NULL, "18", "0", "a:3:{s:4:\"size\";s:3:\"110\";s:7:\"classes\";s:16:\"frm_first_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("27", "oepsb9", "Sqft (Total)", "", "text", NULL, NULL, "19", "0", "a:3:{s:4:\"size\";s:3:\"110\";s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("28", "aixg5q", "Acres", "", "text", NULL, NULL, "20", "0", "a:3:{s:4:\"size\";s:3:\"110\";s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("29", "kd8ky1", "Main Photo URL", "If using a photo that is already online, you can insert the URL here.", "image", NULL, NULL, "21", "0", "a:2:{s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("30", "vjpn1j", "Main Photo Upload", "Or if you would like to upload the photo, this would be a good spot.", "file", NULL, NULL, "22", "0", "a:2:{s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("31", "g53yrt", "NextGen Gallery ID", "If you would like to post a Photo Gallery, insert the NextGen gallery ID for this home here.", "text", NULL, NULL, "23", "0", "a:2:{s:4:\"size\";s:3:\"110\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("32", "78tdwz", "Property Features", "", "divider", NULL, NULL, "24", "0", "a:3:{s:5:\"label\";s:3:\"top\";s:7:\"classes\";s:15:\"frm_first_third\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("33", "s10vrv", "General Features", "", "checkbox", NULL, "a:10:{i:0;s:7:\"Balcony\";i:1;s:3:\"BBQ\";i:2;s:9:\"Courtyard\";i:3;s:16:\"Horse Facilities\";i:4;s:10:\"Greenhouse\";i:5;s:12:\"Lease Option\";i:6;s:12:\"Pets Allowed\";i:7;s:15:\"RV/Boat Parking\";i:8;s:11:\"Spa/Hot Tub\";i:9;s:15:\"Tennis Court(s)\";}", "25", "0", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:32;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("34", "6dyzc6", "Interior", "", "checkbox", NULL, "a:14:{i:0;s:12:\"Ceiling Fans\";i:1;s:22:\"Custom Window Covering\";i:2;s:19:\"Disability Features\";i:3;s:21:\"Energy Efficient Home\";i:4;s:15:\"Hardwood Floors\";i:5;s:13:\"Home Warranty\";i:6;s:8:\"Intercom\";i:7;s:4:\"Pool\";i:8;s:8:\"Skylight\";i:9;s:13:\"Window Blinds\";i:10;s:16:\"Window Coverings\";i:11;s:22:\"Window Drapes/Curtains\";i:12;s:15:\"Window Shutters\";i:13;s:15:\"Vaulted Ceiling\";}", "26", "0", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:32;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("35", "uls2o", "End Section", "", "end_divider", NULL, NULL, "28", "0", "a:1:{s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("36", "l7ijq5", "Column 2", "", "divider", NULL, NULL, "29", "0", "a:3:{s:5:\"label\";s:6:\"hidden\";s:7:\"classes\";s:9:\"frm_third\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("37", "k7q7sq", "Rooms", "", "checkbox", NULL, "a:6:{i:0;s:11:\"Dining Room\";i:1;s:11:\"Family Room\";i:2;s:10:\"Den/Office\";i:3;s:8:\"Basement\";i:4;s:12:\"Laundry Room\";i:5;s:9:\"Game Room\";}", "30", "0", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:36;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("38", "u87v1u", "Air Conditioning", "", "checkbox", NULL, "a:2:{i:0;s:11:\"Central Air\";i:1;s:10:\"Forced Air\";}", "31", "0", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:36;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("39", "ofp1g3", "Heat", "", "checkbox", NULL, "a:8:{i:0;s:7:\"Central\";i:1;s:8:\"Electric\";i:2;s:14:\"Multiple Units\";i:3;s:11:\"Natural Gas\";i:4;s:5:\"Solar\";i:5;s:12:\"Wall Furnace\";i:6;s:4:\"Wood\";i:7;s:4:\"None\";}", "32", "0", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:36;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("40", "e8o297", "Fireplace", "", "checkbox", NULL, "a:4:{i:0;s:12:\"Freestanding\";i:1;s:11:\"Gas Burning\";i:2;s:7:\"Two-way\";i:3;s:12:\"Wood Burning\";}", "33", "0", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:36;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("41", "sij389f", "End Section", "", "end_divider", NULL, NULL, "34", "0", "a:1:{s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("42", "jjhjln", "Column 3", "", "divider", NULL, NULL, "35", "0", "a:3:{s:5:\"label\";s:6:\"hidden\";s:7:\"classes\";s:9:\"frm_third\";s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("43", "o3qvfd", "Lot Features", "", "checkbox", NULL, "a:13:{i:0;s:10:\"Corner Lot\";i:1;s:10:\"Cul-de-Sac\";i:2;s:24:\"Golf Course Lot/Frontage\";i:3;s:16:\"Golf Course View\";i:4;s:10:\"Waterfront\";i:5;s:9:\"City View\";i:6;s:9:\"Lake View\";i:7;s:18:\"Hill/Mountain View\";i:8;s:10:\"Ocean View\";i:9;s:9:\"Park View\";i:10;s:10:\"River View\";i:11;s:10:\"Water View\";i:12;s:4:\"View\";}", "36", "0", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:42;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("44", "ukpfvd", "Community Features", "", "checkbox", NULL, "a:11:{i:0;s:21:\"Recreation Facilities\";i:1;s:27:\"Community Security Features\";i:2;s:26:\"Community Swimming Pool(s)\";i:3;s:25:\"Community Boat Facilities\";i:4;s:22:\"Community Clubhouse(s)\";i:5;s:26:\"Community Horse Facilities\";i:6;s:25:\"Community Tennis Court(s)\";i:7;s:17:\"Community Park(s)\";i:8;s:14:\"Community Golf\";i:9;s:16:\"Senior Community\";i:10;s:24:\"Community Spa/Hot Tub(s)\";}", "37", "0", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:42;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("45", "5v9rs", "End Section", "", "end_divider", NULL, NULL, "38", "0", "a:1:{s:10:\"in_section\";i:0;}", "2", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("46", "wwtp30", "Name", "First", "text", NULL, NULL, "1", "1", "a:2:{s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("47", "oag1ms", "Last", "Last", "text", NULL, NULL, "2", "1", "a:3:{s:5:\"label\";s:6:\"hidden\";s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("48", "xnkv8k", "Email", "", "email", NULL, NULL, "3", "1", "a:3:{s:7:\"invalid\";s:34:\"Please enter a valid email address\";s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("49", "7ch5ll", "Website", "", "url", NULL, NULL, "4", "0", "a:3:{s:7:\"invalid\";s:28:\"Please enter a valid website\";s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("50", "3l3cwp", "Address", "", "text", NULL, NULL, "5", "1", "a:2:{s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("51", "puitbx", "Address Line 2", "", "text", NULL, NULL, "6", "0", "a:2:{s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("52", "w8z3lb", "City", "", "text", NULL, NULL, "7", "1", "a:2:{s:7:\"classes\";s:14:\"frm_first_half\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("53", "9c57wk", "State", "", "select", NULL, "a:53:{i:0;s:0:\"\";i:1;s:2:\"AL\";i:2;s:2:\"AK\";i:3;s:2:\"AR\";i:4;s:2:\"AZ\";i:5;s:2:\"CA\";i:6;s:2:\"CO\";i:7;s:2:\"CT\";i:8;s:2:\"DE\";i:9;s:2:\"DC\";i:10;s:2:\"FL\";i:11;s:2:\"GA\";i:12;s:2:\"HI\";i:13;s:2:\"ID\";i:14;s:2:\"IL\";i:15;s:2:\"IN\";i:16;s:2:\"IA\";i:17;s:2:\"KS\";i:18;s:2:\"KY\";i:19;s:2:\"LA\";i:20;s:2:\"ME\";i:21;s:2:\"MH\";i:22;s:2:\"MD\";i:23;s:2:\"MA\";i:24;s:2:\"MI\";i:25;s:2:\"MN\";i:26;s:2:\"MS\";i:27;s:2:\"MO\";i:28;s:2:\"MT\";i:29;s:2:\"NE\";i:30;s:2:\"NV\";i:31;s:2:\"NH\";i:32;s:2:\"NJ\";i:33;s:2:\"NM\";i:34;s:2:\"NY\";i:35;s:2:\"NC\";i:36;s:2:\"ND\";i:37;s:2:\"OH\";i:38;s:2:\"OK\";i:39;s:2:\"OR\";i:40;s:2:\"PA\";i:41;s:2:\"RI\";i:42;s:2:\"SC\";i:43;s:2:\"SD\";i:44;s:2:\"TN\";i:45;s:2:\"TX\";i:46;s:2:\"UT\";i:47;s:2:\"VT\";i:48;s:2:\"VA\";i:49;s:2:\"WA\";i:50;s:2:\"WV\";i:51;s:2:\"WI\";i:52;s:2:\"WY\";}", "8", "1", "a:3:{s:4:\"size\";i:0;s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("54", "xk12lc", "Postal Code", "", "text", NULL, NULL, "9", "0", "a:2:{s:7:\"classes\";s:10:\"frm_fourth\";s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("55", "j9nrol", "Country", "", "select", NULL, "a:220:{i:0;s:0:\"\";i:1;s:11:\"Afghanistan\";i:2;s:7:\"Albania\";i:3;s:7:\"Algeria\";i:4;s:14:\"American Samoa\";i:5;s:7:\"Andorra\";i:6;s:6:\"Angola\";i:7;s:8:\"Anguilla\";i:8;s:10:\"Antarctica\";i:9;s:19:\"Antigua and Barbuda\";i:10;s:9:\"Argentina\";i:11;s:7:\"Armenia\";i:12;s:5:\"Aruba\";i:13;s:9:\"Australia\";i:14;s:7:\"Austria\";i:15;s:10:\"Azerbaijan\";i:16;s:7:\"Bahamas\";i:17;s:7:\"Bahrain\";i:18;s:10:\"Bangladesh\";i:19;s:8:\"Barbados\";i:20;s:7:\"Belarus\";i:21;s:7:\"Belgium\";i:22;s:6:\"Belize\";i:23;s:5:\"Benin\";i:24;s:7:\"Bermuda\";i:25;s:6:\"Bhutan\";i:26;s:7:\"Bolivia\";i:27;s:22:\"Bosnia and Herzegovina\";i:28;s:8:\"Botswana\";i:29;s:13:\"Bouvet Island\";i:30;s:6:\"Brazil\";i:31;s:30:\"British Indian Ocean Territory\";i:32;s:6:\"Brunei\";i:33;s:8:\"Bulgaria\";i:34;s:12:\"Burkina Faso\";i:35;s:7:\"Burundi\";i:36;s:8:\"Cambodia\";i:37;s:8:\"Cameroon\";i:38;s:6:\"Canada\";i:39;s:10:\"Cape Verde\";i:40;s:14:\"Cayman Islands\";i:41;s:24:\"Central African Republic\";i:42;s:4:\"Chad\";i:43;s:5:\"Chile\";i:44;s:5:\"China\";i:45;s:16:\"Christmas Island\";i:46;s:23:\"Cocos (Keeling) Islands\";i:47;s:8:\"Colombia\";i:48;s:7:\"Comoros\";i:49;s:5:\"Congo\";i:50;s:12:\"Cook Islands\";i:51;s:10:\"Costa Rica\";i:52;s:14:\"Côte d\'Ivoire\";i:53;s:18:\"Croatia (Hrvatska)\";i:54;s:4:\"Cuba\";i:55;s:6:\"Cyprus\";i:56;s:14:\"Czech Republic\";i:57;s:11:\"Congo (DRC)\";i:58;s:7:\"Denmark\";i:59;s:8:\"Djibouti\";i:60;s:8:\"Dominica\";i:61;s:18:\"Dominican Republic\";i:62;s:10:\"East Timor\";i:63;s:7:\"Ecuador\";i:64;s:5:\"Egypt\";i:65;s:11:\"El Salvador\";i:66;s:17:\"Equatorial Guinea\";i:67;s:7:\"Eritrea\";i:68;s:7:\"Estonia\";i:69;s:8:\"Ethiopia\";i:70;s:33:\"Falkland Islands (Islas Malvinas)\";i:71;s:13:\"Faroe Islands\";i:72;s:12:\"Fiji Islands\";i:73;s:7:\"Finland\";i:74;s:6:\"France\";i:75;s:13:\"French Guiana\";i:76;s:16:\"French Polynesia\";i:77;s:35:\"French Southern and Antarctic Lands\";i:78;s:5:\"Gabon\";i:79;s:6:\"Gambia\";i:80;s:7:\"Georgia\";i:81;s:7:\"Germany\";i:82;s:5:\"Ghana\";i:83;s:9:\"Gibraltar\";i:84;s:6:\"Greece\";i:85;s:9:\"Greenland\";i:86;s:7:\"Grenada\";i:87;s:10:\"Guadeloupe\";i:88;s:4:\"Guam\";i:89;s:9:\"Guatemala\";i:90;s:6:\"Guinea\";i:91;s:13:\"Guinea-Bissau\";i:92;s:6:\"Guyana\";i:93;s:5:\"Haiti\";i:94;s:8:\"Honduras\";i:95;s:13:\"Hong Kong SAR\";i:96;s:7:\"Hungary\";i:97;s:7:\"Iceland\";i:98;s:5:\"India\";i:99;s:9:\"Indonesia\";i:100;s:4:\"Iran\";i:101;s:4:\"Iraq\";i:102;s:7:\"Ireland\";i:103;s:6:\"Israel\";i:104;s:5:\"Italy\";i:105;s:7:\"Jamaica\";i:106;s:5:\"Japan\";i:107;s:6:\"Jordan\";i:108;s:10:\"Kazakhstan\";i:109;s:5:\"Kenya\";i:110;s:8:\"Kiribati\";i:111;s:5:\"Korea\";i:112;s:6:\"Kuwait\";i:113;s:10:\"Kyrgyzstan\";i:114;s:4:\"Laos\";i:115;s:6:\"Latvia\";i:116;s:7:\"Lebanon\";i:117;s:7:\"Lesotho\";i:118;s:7:\"Liberia\";i:119;s:5:\"Libya\";i:120;s:13:\"Liechtenstein\";i:121;s:9:\"Lithuania\";i:122;s:10:\"Luxembourg\";i:123;s:9:\"Macao SAR\";i:124;s:38:\"Macedonia, Former Yugoslav Republic of\";i:125;s:10:\"Madagascar\";i:126;s:6:\"Malawi\";i:127;s:8:\"Malaysia\";i:128;s:8:\"Maldives\";i:129;s:4:\"Mali\";i:130;s:5:\"Malta\";i:131;s:16:\"Marshall Islands\";i:132;s:10:\"Martinique\";i:133;s:10:\"Mauritania\";i:134;s:9:\"Mauritius\";i:135;s:7:\"Mayotte\";i:136;s:6:\"Mexico\";i:137;s:10:\"Micronesia\";i:138;s:7:\"Moldova\";i:139;s:6:\"Monaco\";i:140;s:8:\"Mongolia\";i:141;s:10:\"Montserrat\";i:142;s:7:\"Morocco\";i:143;s:10:\"Mozambique\";i:144;s:7:\"Myanmar\";i:145;s:7:\"Namibia\";i:146;s:5:\"Nauru\";i:147;s:5:\"Nepal\";i:148;s:11:\"Netherlands\";i:149;s:11:\"New Zealand\";i:150;s:9:\"Nicaragua\";i:151;s:5:\"Niger\";i:152;s:7:\"Nigeria\";i:153;s:6:\"Norway\";i:154;s:4:\"Oman\";i:155;s:8:\"Pakistan\";i:156;s:5:\"Palau\";i:157;s:9:\"Palestine\";i:158;s:6:\"Panama\";i:159;s:16:\"Papua New Guinea\";i:160;s:8:\"Paraguay\";i:161;s:4:\"Peru\";i:162;s:11:\"Philippines\";i:163;s:6:\"Poland\";i:164;s:8:\"Portugal\";i:165;s:11:\"Puerto Rico\";i:166;s:5:\"Qatar\";i:167;s:7:\"Romania\";i:168;s:6:\"Russia\";i:169;s:6:\"Rwanda\";i:170;s:21:\"Saint Kitts and Nevis\";i:171;s:11:\"Saint Lucia\";i:172;s:32:\"Saint Vincent and the Grenadines\";i:173;s:5:\"Samoa\";i:174;s:10:\"San Marino\";i:175;s:21:\"Sao Tome and Principe\";i:176;s:12:\"Saudi Arabia\";i:177;s:7:\"Senegal\";i:178;s:21:\"Serbia and Montenegro\";i:179;s:10:\"Seychelles\";i:180;s:12:\"Sierra Leone\";i:181;s:9:\"Singapore\";i:182;s:8:\"Slovakia\";i:183;s:8:\"Slovenia\";i:184;s:15:\"Solomon Islands\";i:185;s:7:\"Somalia\";i:186;s:12:\"South Africa\";i:187;s:5:\"Spain\";i:188;s:9:\"Sri Lanka\";i:189;s:5:\"Sudan\";i:190;s:8:\"Suriname\";i:191;s:9:\"Swaziland\";i:192;s:6:\"Sweden\";i:193;s:11:\"Switzerland\";i:194;s:5:\"Syria\";i:195;s:6:\"Taiwan\";i:196;s:10:\"Tajikistan\";i:197;s:8:\"Tanzania\";i:198;s:8:\"Thailand\";i:199;s:4:\"Togo\";i:200;s:5:\"Tonga\";i:201;s:19:\"Trinidad and Tobago\";i:202;s:7:\"Tunisia\";i:203;s:6:\"Turkey\";i:204;s:12:\"Turkmenistan\";i:205;s:6:\"Tuvalu\";i:206;s:6:\"Uganda\";i:207;s:7:\"Ukraine\";i:208;s:20:\"United Arab Emirates\";i:209;s:14:\"United Kingdom\";i:210;s:13:\"United States\";i:211;s:7:\"Uruguay\";i:212;s:10:\"Uzbekistan\";i:213;s:7:\"Vanuatu\";i:214;s:12:\"Vatican City\";i:215;s:9:\"Venezuela\";i:216;s:7:\"Vietnam\";i:217;s:5:\"Yemen\";i:218;s:6:\"Zambia\";i:219;s:8:\"Zimbabwe\";}", "10", "1", "a:2:{s:4:\"size\";i:1;s:10:\"in_section\";i:0;}", "3", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("56", "x1dzdf", "Name", "First", "text", NULL, NULL, "1", "1", "a:2:{s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "4", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("57", "57mz9h", "Last", "Last", "text", NULL, NULL, "2", "1", "a:3:{s:5:\"label\";s:6:\"hidden\";s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "4", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("58", "7df6al", "Email", "", "email", NULL, NULL, "3", "1", "a:3:{s:7:\"invalid\";s:34:\"Please enter a valid email address\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "4", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("59", "4hh35l", "Home Phone", "", "phone", NULL, NULL, "4", "0", "a:2:{s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "4", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("60", "24gocg", "Mobile Phone", "", "phone", NULL, NULL, "5", "0", "a:2:{s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "4", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("61", "vnv7we", "Address", "", "address", NULL, NULL, "6", "1", "a:2:{s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "4", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("62", "8l3som", "Employment Desired", "", "radio", NULL, "a:3:{i:0;s:9:\"Full-time\";i:1;s:9:\"Part-time\";i:2;s:19:\"Full- or Part- time\";}", "12", "1", "a:2:{s:13:\"default_blank\";i:0;s:10:\"in_section\";i:0;}", "4", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("63", "pjluad", "Attach Resume", "", "file", NULL, NULL, "13", "0", "a:2:{s:6:\"attach\";i:1;s:10:\"in_section\";i:0;}", "4", "2016-07-11 03:32:08");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("64", "x1dzdf2", "Name", "First", "text", "", NULL, "0", "1", "a:62:{s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";s:1:\"0\";s:13:\"default_blank\";s:1:\"0\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;}", "6", "2016-07-11 03:35:40");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("65", "57mz9h2", "Last", "Last", "text", "", NULL, "1", "1", "a:62:{s:5:\"label\";s:6:\"hidden\";s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";s:1:\"0\";s:13:\"default_blank\";s:1:\"0\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;}", "6", "2016-07-11 03:35:40");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("66", "7df6al2", "Email", "", "email", "", NULL, "2", "1", "a:62:{s:7:\"invalid\";s:34:\"Please enter a valid email address\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";s:1:\"0\";s:13:\"default_blank\";s:1:\"0\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;}", "6", "2016-07-11 03:35:40");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("67", "4hh35l2", "Home Phone", "", "phone", "", NULL, "3", "0", "a:62:{s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:21:\"Home Phone is invalid\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";s:1:\"0\";s:13:\"default_blank\";s:1:\"0\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;}", "6", "2016-07-11 03:35:40");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("68", "24gocg2", "Mobile Phone", "", "phone", "", NULL, "4", "1", "a:62:{s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:23:\"Mobile Phone is invalid\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";s:1:\"0\";s:13:\"default_blank\";s:1:\"0\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;}", "6", "2016-07-11 03:35:40");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("69", "vnv7we2", "Address", "", "address", "a:6:{s:5:\"line1\";s:0:\"\";s:5:\"line2\";s:0:\"\";s:4:\"city\";s:0:\"\";s:5:\"state\";s:0:\"\";s:3:\"zip\";s:0:\"\";s:7:\"country\";s:0:\"\";}", NULL, "5", "1", "a:60:{s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";s:1:\"0\";s:13:\"default_blank\";s:1:\"0\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:26:\"This value must be unique.\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:12:\"address_type\";s:13:\"international\";s:9:\"city_desc\";s:4:\"City\";s:10:\"state_desc\";s:14:\"State/Province\";s:8:\"zip_desc\";s:10:\"Zip/Postal\";}", "6", "2016-07-11 03:35:40");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("70", "8l3som2", "Employment Desired", "", "radio", "", "a:3:{i:0;s:9:\"Full-time\";i:1;s:9:\"Part-time\";i:2;s:19:\"Full- or Part- time\";}", "8", "1", "a:56:{s:13:\"default_blank\";i:0;s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";i:0;s:7:\"classes\";s:0:\"\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";s:1:\"0\";}", "6", "2016-07-11 03:35:40");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("71", "pjluad2", "Attach Resume", "", "file", "", NULL, "6", "0", "a:56:{s:6:\"attach\";s:1:\"1\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:24:\"Attach Resume is invalid\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";i:0;s:13:\"default_blank\";i:0;s:7:\"classes\";s:18:\"frm_first frm_half\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";s:1:\"0\";s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:26:\"This value must be unique.\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;}", "6", "2016-07-11 03:35:40");
INSERT INTO `wp_gtj8dk_frm_fields` VALUES("72", "7o6ec", "Job Application Upload", "", "file", "", NULL, "7", "1", "a:56:{s:6:\"attach\";s:1:\"1\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:33:\"Job Application Upload is invalid\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";i:0;s:13:\"default_blank\";i:0;s:7:\"classes\";s:17:\"frm_last frm_half\";s:12:\"captcha_size\";s:7:\"default\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";s:1:\"0\";s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:26:\"This value must be unique.\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;}", "6", "2016-07-11 03:35:53");

/* INSERT TABLE DATA: wp_gtj8dk_frm_forms */
INSERT INTO `wp_gtj8dk_frm_forms` VALUES("1", "contact", "Contact Us", "We would like to hear from you. Please send us a message by filling out the form below and we will get back with you shortly.", "0", "0", "0", "1", "1", "published", "a:33:{s:12:\"submit_value\";s:6:\"Submit\";s:14:\"success_action\";s:7:\"message\";s:11:\"success_msg\";s:54:\"Your responses were successfully submitted. Thank you!\";s:9:\"show_form\";i:0;s:7:\"akismet\";s:0:\"\";s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:10:\"form_class\";s:0:\"\";s:12:\"custom_style\";i:1;s:11:\"before_html\";s:217:\"<legend class=\"frm_hidden\">[form_name]</legend>\n[if form_name]<h3 class=\"frm_form_title\">[form_name]</h3>[/if form_name]\n[if form_description]<div class=\"frm_description\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:440:\"<div class=\"frm_submit\">\n[if back_button]<input type=\"button\" value=\"[back_label]\" name=\"frm_prev_page\" formnovalidate=\"formnovalidate\" class=\"frm_prev_page\" [back_hook] />[/if back_button]\n<input type=\"submit\" value=\"[button_label]\" [button_action] />\n<img class=\"frm_ajax_loading\" src=\"[frmurl]/images/ajax_loader.gif\" alt=\"Sending\"/>\n[if save_draft]<a href=\"#\" class=\"frm_save_draft\" [draft_hook]>[draft_label]</a>[/if save_draft]\n</div>\";s:10:\"edit_value\";s:6:\"Update\";s:8:\"edit_msg\";s:39:\"Your submission was successfully saved.\";s:11:\"edit_action\";s:7:\"message\";s:8:\"edit_url\";s:0:\"\";s:12:\"edit_page_id\";i:0;s:14:\"logged_in_role\";s:0:\"\";s:10:\"save_draft\";i:0;s:9:\"draft_msg\";s:26:\"Your draft has been saved.\";s:13:\"editable_role\";s:0:\"\";s:18:\"open_editable_role\";s:2:\"-1\";s:4:\"copy\";i:0;s:12:\"single_entry\";i:0;s:17:\"single_entry_type\";s:4:\"user\";s:15:\"success_page_id\";s:0:\"\";s:11:\"success_url\";s:0:\"\";s:11:\"ajax_submit\";i:0;s:17:\"cookie_expiration\";i:8000;s:10:\"prev_value\";s:8:\"Previous\";s:12:\"submit_align\";s:0:\"\";s:11:\"js_validate\";i:0;s:13:\"protect_files\";i:0;}", "2009-11-24 00:17:31");
INSERT INTO `wp_gtj8dk_frm_forms` VALUES("2", "frmprorealestatelistings", "Real Estate Listings", "", "0", "0", "0", "1", "1", "published", "a:33:{s:12:\"submit_value\";s:6:\"Submit\";s:14:\"success_action\";s:7:\"message\";s:11:\"success_msg\";s:54:\"Your responses were successfully submitted. Thank you!\";s:9:\"show_form\";i:0;s:7:\"akismet\";s:0:\"\";s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:10:\"form_class\";s:0:\"\";s:12:\"custom_style\";i:1;s:11:\"before_html\";s:217:\"<legend class=\"frm_hidden\">[form_name]</legend>\n[if form_name]<h3 class=\"frm_form_title\">[form_name]</h3>[/if form_name]\n[if form_description]<div class=\"frm_description\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:440:\"<div class=\"frm_submit\">\n[if back_button]<input type=\"button\" value=\"[back_label]\" name=\"frm_prev_page\" formnovalidate=\"formnovalidate\" class=\"frm_prev_page\" [back_hook] />[/if back_button]\n<input type=\"submit\" value=\"[button_label]\" [button_action] />\n<img class=\"frm_ajax_loading\" src=\"[frmurl]/images/ajax_loader.gif\" alt=\"Sending\"/>\n[if save_draft]<a href=\"#\" class=\"frm_save_draft\" [draft_hook]>[draft_label]</a>[/if save_draft]\n</div>\";s:10:\"edit_value\";s:6:\"Update\";s:8:\"edit_msg\";s:39:\"Your submission was successfully saved.\";s:11:\"edit_action\";s:7:\"message\";s:8:\"edit_url\";s:0:\"\";s:12:\"edit_page_id\";i:0;s:14:\"logged_in_role\";s:0:\"\";s:10:\"save_draft\";i:0;s:9:\"draft_msg\";s:26:\"Your draft has been saved.\";s:13:\"editable_role\";s:0:\"\";s:18:\"open_editable_role\";s:2:\"-1\";s:4:\"copy\";i:0;s:12:\"single_entry\";i:0;s:17:\"single_entry_type\";s:4:\"user\";s:15:\"success_page_id\";s:0:\"\";s:11:\"success_url\";s:0:\"\";s:11:\"ajax_submit\";i:0;s:17:\"cookie_expiration\";i:8000;s:10:\"prev_value\";s:8:\"Previous\";s:12:\"submit_align\";s:0:\"\";s:11:\"js_validate\";i:0;s:13:\"protect_files\";i:0;}", "2016-03-23 17:54:12");
INSERT INTO `wp_gtj8dk_frm_forms` VALUES("3", "frmprocontact", "User Information", "Gather address info", "0", "0", "0", "1", "1", "published", "a:33:{s:12:\"submit_value\";s:6:\"Submit\";s:14:\"success_action\";s:7:\"message\";s:11:\"success_msg\";s:54:\"Your responses were successfully submitted. Thank you!\";s:9:\"show_form\";i:0;s:7:\"akismet\";s:0:\"\";s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:10:\"form_class\";s:0:\"\";s:12:\"custom_style\";i:1;s:11:\"before_html\";s:217:\"<legend class=\"frm_hidden\">[form_name]</legend>\n[if form_name]<h3 class=\"frm_form_title\">[form_name]</h3>[/if form_name]\n[if form_description]<div class=\"frm_description\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:440:\"<div class=\"frm_submit\">\n[if back_button]<input type=\"button\" value=\"[back_label]\" name=\"frm_prev_page\" formnovalidate=\"formnovalidate\" class=\"frm_prev_page\" [back_hook] />[/if back_button]\n<input type=\"submit\" value=\"[button_label]\" [button_action] />\n<img class=\"frm_ajax_loading\" src=\"[frmurl]/images/ajax_loader.gif\" alt=\"Sending\"/>\n[if save_draft]<a href=\"#\" class=\"frm_save_draft\" [draft_hook]>[draft_label]</a>[/if save_draft]\n</div>\";s:10:\"edit_value\";s:6:\"Update\";s:8:\"edit_msg\";s:39:\"Your submission was successfully saved.\";s:11:\"edit_action\";s:7:\"message\";s:8:\"edit_url\";s:0:\"\";s:12:\"edit_page_id\";i:0;s:14:\"logged_in_role\";s:0:\"\";s:10:\"save_draft\";i:0;s:9:\"draft_msg\";s:26:\"Your draft has been saved.\";s:13:\"editable_role\";s:0:\"\";s:18:\"open_editable_role\";s:2:\"-1\";s:4:\"copy\";i:0;s:12:\"single_entry\";i:0;s:17:\"single_entry_type\";s:4:\"user\";s:15:\"success_page_id\";s:0:\"\";s:11:\"success_url\";s:0:\"\";s:11:\"ajax_submit\";i:0;s:17:\"cookie_expiration\";i:8000;s:10:\"prev_value\";s:8:\"Previous\";s:12:\"submit_align\";s:0:\"\";s:11:\"js_validate\";i:0;s:13:\"protect_files\";i:0;}", "2010-02-08 03:37:08");
INSERT INTO `wp_gtj8dk_frm_forms` VALUES("4", "frmproapplication", "Job Application", "", "0", "0", "0", "1", "1", "published", "a:33:{s:12:\"submit_value\";s:6:\"Submit\";s:14:\"success_action\";s:7:\"message\";s:11:\"success_msg\";s:54:\"Your responses were successfully submitted. Thank you!\";s:9:\"show_form\";i:0;s:7:\"akismet\";s:0:\"\";s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:10:\"form_class\";s:0:\"\";s:12:\"custom_style\";i:1;s:11:\"before_html\";s:217:\"<legend class=\"frm_hidden\">[form_name]</legend>\n[if form_name]<h3 class=\"frm_form_title\">[form_name]</h3>[/if form_name]\n[if form_description]<div class=\"frm_description\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:440:\"<div class=\"frm_submit\">\n[if back_button]<input type=\"button\" value=\"[back_label]\" name=\"frm_prev_page\" formnovalidate=\"formnovalidate\" class=\"frm_prev_page\" [back_hook] />[/if back_button]\n<input type=\"submit\" value=\"[button_label]\" [button_action] />\n<img class=\"frm_ajax_loading\" src=\"[frmurl]/images/ajax_loader.gif\" alt=\"Sending\"/>\n[if save_draft]<a href=\"#\" class=\"frm_save_draft\" [draft_hook]>[draft_label]</a>[/if save_draft]\n</div>\";s:10:\"edit_value\";s:6:\"Update\";s:8:\"edit_msg\";s:39:\"Your submission was successfully saved.\";s:11:\"edit_action\";s:7:\"message\";s:8:\"edit_url\";s:0:\"\";s:12:\"edit_page_id\";i:0;s:14:\"logged_in_role\";s:0:\"\";s:10:\"save_draft\";i:0;s:9:\"draft_msg\";s:26:\"Your draft has been saved.\";s:13:\"editable_role\";s:0:\"\";s:18:\"open_editable_role\";s:2:\"-1\";s:4:\"copy\";i:0;s:12:\"single_entry\";i:0;s:17:\"single_entry_type\";s:4:\"user\";s:15:\"success_page_id\";s:0:\"\";s:11:\"success_url\";s:0:\"\";s:11:\"ajax_submit\";i:0;s:17:\"cookie_expiration\";i:8000;s:10:\"prev_value\";s:8:\"Previous\";s:12:\"submit_align\";s:0:\"\";s:11:\"js_validate\";i:0;s:13:\"protect_files\";i:0;}", "2011-03-09 23:03:46");
INSERT INTO `wp_gtj8dk_frm_forms` VALUES("6", "frmproapplication2", "Job Application", "", "0", "0", "0", "0", "0", "published", "a:33:{s:12:\"submit_value\";s:6:\"Submit\";s:14:\"success_action\";s:7:\"message\";s:11:\"success_msg\";s:54:\"Your responses were successfully submitted. Thank you!\";s:9:\"show_form\";i:0;s:7:\"akismet\";s:0:\"\";s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:10:\"form_class\";s:0:\"\";s:12:\"custom_style\";i:1;s:11:\"before_html\";s:217:\"<legend class=\"frm_hidden\">[form_name]</legend>\n[if form_name]<h3 class=\"frm_form_title\">[form_name]</h3>[/if form_name]\n[if form_description]<div class=\"frm_description\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:440:\"<div class=\"frm_submit\">\n[if back_button]<input type=\"button\" value=\"[back_label]\" name=\"frm_prev_page\" formnovalidate=\"formnovalidate\" class=\"frm_prev_page\" [back_hook] />[/if back_button]\n<input type=\"submit\" value=\"[button_label]\" [button_action] />\n<img class=\"frm_ajax_loading\" src=\"[frmurl]/images/ajax_loader.gif\" alt=\"Sending\"/>\n[if save_draft]<a href=\"#\" class=\"frm_save_draft\" [draft_hook]>[draft_label]</a>[/if save_draft]\n</div>\";s:10:\"edit_value\";s:6:\"Update\";s:8:\"edit_msg\";s:39:\"Your submission was successfully saved.\";s:11:\"edit_action\";s:7:\"message\";s:8:\"edit_url\";s:0:\"\";s:12:\"edit_page_id\";i:0;s:14:\"logged_in_role\";s:0:\"\";s:10:\"save_draft\";i:0;s:9:\"draft_msg\";s:26:\"Your draft has been saved.\";s:13:\"editable_role\";s:0:\"\";s:18:\"open_editable_role\";s:2:\"-1\";s:4:\"copy\";i:0;s:12:\"single_entry\";i:0;s:17:\"single_entry_type\";s:4:\"user\";s:15:\"success_page_id\";s:0:\"\";s:11:\"success_url\";s:0:\"\";s:11:\"ajax_submit\";i:0;s:17:\"cookie_expiration\";i:8000;s:10:\"prev_value\";s:8:\"Previous\";s:12:\"submit_align\";s:0:\"\";s:11:\"js_validate\";i:0;s:13:\"protect_files\";i:0;}", "2016-07-11 03:35:40");

/* INSERT TABLE DATA: wp_gtj8dk_icl_flags */
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("1", "ar", "ar.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("2", "bg", "bg.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("3", "bs", "bs.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("4", "ca", "ca.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("5", "cs", "cs.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("6", "cy", "cy.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("7", "da", "da.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("8", "de", "de.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("9", "el", "el.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("10", "en", "en.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("11", "eo", "eo.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("12", "es", "es.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("13", "et", "et.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("14", "eu", "eu.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("15", "fa", "fa.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("16", "fi", "fi.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("17", "fr", "fr.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("18", "ga", "ga.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("19", "he", "he.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("20", "hi", "hi.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("21", "hr", "hr.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("22", "hu", "hu.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("23", "hy", "hy.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("24", "id", "id.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("25", "is", "is.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("26", "it", "it.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("27", "ja", "ja.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("28", "ko", "ko.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("29", "ku", "ku.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("30", "la", "la.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("31", "lt", "lt.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("32", "lv", "lv.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("33", "mk", "mk.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("34", "mn", "mn.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("35", "ms", "ms.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("36", "mt", "mt.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("37", "nb", "nb.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("38", "ne", "ne.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("39", "nl", "nl.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("40", "pa", "pa.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("41", "pl", "pl.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("42", "pt-br", "pt-br.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("43", "pt-pt", "pt-pt.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("44", "qu", "qu.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("45", "ro", "ro.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("46", "ru", "ru.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("47", "sk", "sk.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("48", "sl", "sl.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("49", "so", "so.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("50", "sq", "sq.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("51", "sr", "sr.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("52", "sv", "sv.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("53", "ta", "ta.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("54", "th", "th.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("55", "tr", "tr.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("56", "uk", "uk.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("57", "ur", "ur.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("58", "uz", "uz.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("59", "vi", "vi.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("60", "yi", "yi.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("61", "zh-hans", "zh-hans.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("62", "zh-hant", "zh-hant.png", "0");
INSERT INTO `wp_gtj8dk_icl_flags` VALUES("63", "zu", "zu.png", "0");

/* INSERT TABLE DATA: wp_gtj8dk_icl_languages */
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("1", "en", "English", "1", "1", "en_US", "en", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("2", "es", "Spanish", "1", "1", "es_ES", "es", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("3", "de", "German", "1", "0", "de_DE", "de", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("4", "fr", "French", "1", "0", "fr_FR", "fr", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("5", "ar", "Arabic", "0", "0", "ar", "ar", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("6", "bs", "Bosnian", "0", "0", "", "bs", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("7", "bg", "Bulgarian", "0", "0", "bg_BG", "bg", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("8", "ca", "Catalan", "0", "0", "ca", "ca", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("9", "cs", "Czech", "0", "0", "cs_CZ", "cs", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("10", "sk", "Slovak", "0", "0", "sk_SK", "sk", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("11", "cy", "Welsh", "0", "0", "cy", "cy", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("12", "da", "Danish", "1", "0", "da_DK", "da", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("13", "el", "Greek", "0", "0", "el", "el", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("14", "eo", "Esperanto", "0", "0", "eo", "eo", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("15", "et", "Estonian", "0", "0", "et", "et", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("16", "eu", "Basque", "0", "0", "eu", "eu", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("17", "fa", "Persian", "0", "0", "fa_IR", "fa", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("18", "fi", "Finnish", "0", "0", "fi", "fi", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("19", "ga", "Irish", "0", "0", "", "ga", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("20", "he", "Hebrew", "0", "0", "he_IL", "he", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("21", "hi", "Hindi", "0", "0", "", "hi", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("22", "hr", "Croatian", "0", "0", "hr", "hr", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("23", "hu", "Hungarian", "0", "0", "hu_HU", "hu", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("24", "hy", "Armenian", "0", "0", "", "hy", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("25", "id", "Indonesian", "0", "0", "id_ID", "id", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("26", "is", "Icelandic", "0", "0", "is_IS", "is", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("27", "it", "Italian", "1", "0", "it_IT", "it", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("28", "ja", "Japanese", "1", "0", "ja", "ja", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("29", "ko", "Korean", "0", "0", "ko_KR", "ko", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("30", "ku", "Kurdish", "0", "0", "ku", "ku", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("31", "la", "Latin", "0", "0", "", "la", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("32", "lv", "Latvian", "0", "0", "lv", "lv", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("33", "lt", "Lithuanian", "0", "0", "lt", "lt", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("34", "mk", "Macedonian", "0", "0", "mk_MK", "mk", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("35", "mt", "Maltese", "0", "0", "", "mt", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("36", "mn", "Mongolian", "0", "0", "", "mn", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("37", "ne", "Nepali", "0", "0", "", "ne", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("38", "nl", "Dutch", "1", "0", "nl_NL", "nl", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("39", "nb", "Norwegian Bokmål", "0", "0", "nb_NO", "nb", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("40", "pa", "Punjabi", "0", "0", "", "pa", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("41", "pl", "Polish", "0", "0", "pl_PL", "pl", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("42", "pt-pt", "Portuguese, Portugal", "0", "0", "pt_PT", "pt-pt", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("43", "pt-br", "Portuguese, Brazil", "0", "0", "pt_BR", "pt-br", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("44", "qu", "Quechua", "0", "0", "", "qu", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("45", "ro", "Romanian", "0", "0", "ro_RO", "ro", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("46", "ru", "Russian", "1", "0", "ru_RU", "ru", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("47", "sl", "Slovenian", "0", "0", "sl_SI", "sl", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("48", "so", "Somali", "0", "0", "", "so", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("49", "sq", "Albanian", "0", "0", "", "sq", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("50", "sr", "Serbian", "0", "0", "sr_RS", "sr", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("51", "sv", "Swedish", "0", "0", "sv_SE", "sv", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("52", "ta", "Tamil", "0", "0", "", "ta", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("53", "th", "Thai", "0", "0", "th", "th", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("54", "tr", "Turkish", "0", "0", "tr", "tr", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("55", "uk", "Ukrainian", "0", "0", "uk_UA", "uk", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("56", "ur", "Urdu", "0", "0", "", "ur", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("57", "uz", "Uzbek", "0", "0", "uz_UZ", "uz", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("58", "vi", "Vietnamese", "0", "0", "vi", "vi", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("59", "yi", "Yiddish", "0", "0", "", "yi", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("60", "zh-hans", "Chinese (Simplified)", "1", "0", "zh_CN", "zh-hans", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("61", "zu", "Zulu", "0", "0", "", "zu", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("62", "zh-hant", "Chinese (Traditional)", "1", "0", "zh_TW", "zh-hant", "0");
INSERT INTO `wp_gtj8dk_icl_languages` VALUES("63", "ms", "Malay", "0", "0", "ms_MY", "ms", "0");

/* INSERT TABLE DATA: wp_gtj8dk_icl_languages_translations */
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1", "en", "en", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2", "en", "es", "Inglés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("3", "en", "de", "Englisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("4", "en", "fr", "Anglais");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("5", "en", "ar", "الإنجليزية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("6", "en", "bs", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("7", "en", "bg", "Английски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("8", "en", "ca", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("9", "en", "cs", "Angličtina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("10", "en", "sk", "Angličtina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("11", "en", "cy", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("12", "en", "da", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("13", "en", "el", "Αγγλικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("14", "en", "eo", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("15", "en", "et", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("16", "en", "eu", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("17", "en", "fa", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("18", "en", "fi", "englanti");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("19", "en", "ga", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("20", "en", "he", "אנגלית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("21", "en", "hi", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("22", "en", "hr", "Engleski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("23", "en", "hu", "angol");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("24", "en", "hy", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("25", "en", "id", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("26", "en", "is", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("27", "en", "it", "Inglese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("28", "en", "ja", "英語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("29", "en", "ko", "영어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("30", "en", "ku", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("31", "en", "la", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("32", "en", "lv", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("33", "en", "lt", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("34", "en", "mk", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("35", "en", "mt", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("36", "en", "mn", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("37", "en", "ne", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("38", "en", "nl", "Engels");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("39", "en", "nb", "Engelsk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("40", "en", "pa", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("41", "en", "pl", "angielski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("42", "en", "pt-pt", "Inglês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("43", "en", "pt-br", "Inglês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("44", "en", "qu", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("45", "en", "ro", "Engleză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("46", "en", "ru", "Английский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("47", "en", "sl", "Angleščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("48", "en", "so", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("49", "en", "sq", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("50", "en", "sr", "енглески");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("51", "en", "sv", "Engelska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("52", "en", "ta", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("53", "en", "th", "อังกฤษ");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("54", "en", "tr", "İngilizce");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("55", "en", "uk", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("56", "en", "ur", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("57", "en", "uz", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("58", "en", "vi", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("59", "en", "yi", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("60", "en", "zh-hans", "英语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("61", "en", "zu", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("62", "en", "zh-hant", "英語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("63", "en", "ms", "English");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("64", "es", "en", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("65", "es", "es", "Español");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("66", "es", "de", "Spanisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("67", "es", "fr", "Espagnol");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("68", "es", "ar", "الأسبانية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("69", "es", "bs", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("70", "es", "bg", "Испански");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("71", "es", "ca", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("72", "es", "cs", "Španělský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("73", "es", "sk", "Španielčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("74", "es", "cy", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("75", "es", "da", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("76", "es", "el", "Ισπανικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("77", "es", "eo", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("78", "es", "et", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("79", "es", "eu", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("80", "es", "fa", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("81", "es", "fi", "espanja");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("82", "es", "ga", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("83", "es", "he", "ספרדית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("84", "es", "hi", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("85", "es", "hr", "španjolski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("86", "es", "hu", "spanyol");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("87", "es", "hy", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("88", "es", "id", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("89", "es", "is", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("90", "es", "it", "Spagnolo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("91", "es", "ja", "スペイン語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("92", "es", "ko", "스페인어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("93", "es", "ku", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("94", "es", "la", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("95", "es", "lv", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("96", "es", "lt", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("97", "es", "mk", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("98", "es", "mt", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("99", "es", "mn", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("100", "es", "ne", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("101", "es", "nl", "Spaans");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("102", "es", "nb", "Spansk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("103", "es", "pa", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("104", "es", "pl", "hiszpański");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("105", "es", "pt-pt", "Espanhol");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("106", "es", "pt-br", "Espanhol");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("107", "es", "qu", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("108", "es", "ro", "Spaniolă");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("109", "es", "ru", "Испанский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("110", "es", "sl", "Španščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("111", "es", "so", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("112", "es", "sq", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("113", "es", "sr", "шпански");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("114", "es", "sv", "Spanska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("115", "es", "ta", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("116", "es", "th", "สเปน");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("117", "es", "tr", "İspanyolca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("118", "es", "uk", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("119", "es", "ur", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("120", "es", "uz", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("121", "es", "vi", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("122", "es", "yi", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("123", "es", "zh-hans", "西班牙语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("124", "es", "zu", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("125", "es", "zh-hant", "西班牙語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("126", "es", "ms", "Spanish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("127", "de", "en", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("128", "de", "es", "Alemán");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("129", "de", "de", "Deutsch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("130", "de", "fr", "Allemand");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("131", "de", "ar", "الألمانية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("132", "de", "bs", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("133", "de", "bg", "Немски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("134", "de", "ca", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("135", "de", "cs", "Němec");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("136", "de", "sk", "Nemčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("137", "de", "cy", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("138", "de", "da", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("139", "de", "el", "Γερμανικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("140", "de", "eo", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("141", "de", "et", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("142", "de", "eu", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("143", "de", "fa", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("144", "de", "fi", "saksa");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("145", "de", "ga", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("146", "de", "he", "גרמנית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("147", "de", "hi", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("148", "de", "hr", "Njemački");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("149", "de", "hu", "német");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("150", "de", "hy", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("151", "de", "id", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("152", "de", "is", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("153", "de", "it", "Tedesco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("154", "de", "ja", "ドイツ語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("155", "de", "ko", "독어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("156", "de", "ku", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("157", "de", "la", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("158", "de", "lv", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("159", "de", "lt", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("160", "de", "mk", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("161", "de", "mt", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("162", "de", "mn", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("163", "de", "ne", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("164", "de", "nl", "Duits");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("165", "de", "nb", "Tysk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("166", "de", "pa", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("167", "de", "pl", "niemiecki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("168", "de", "pt-pt", "Alemão");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("169", "de", "pt-br", "Alemão");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("170", "de", "qu", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("171", "de", "ro", "Germană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("172", "de", "ru", "Немецкий");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("173", "de", "sl", "Nemščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("174", "de", "so", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("175", "de", "sq", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("176", "de", "sr", "немачки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("177", "de", "sv", "Tyska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("178", "de", "ta", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("179", "de", "th", "เยอรมัน");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("180", "de", "tr", "Almanca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("181", "de", "uk", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("182", "de", "ur", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("183", "de", "uz", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("184", "de", "vi", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("185", "de", "yi", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("186", "de", "zh-hans", "德语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("187", "de", "zu", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("188", "de", "zh-hant", "德語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("189", "de", "ms", "German");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("190", "fr", "en", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("191", "fr", "es", "Francés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("192", "fr", "de", "Französisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("193", "fr", "fr", "Français");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("194", "fr", "ar", "الفرنسية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("195", "fr", "bs", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("196", "fr", "bg", "Френски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("197", "fr", "ca", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("198", "fr", "cs", "Francouzština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("199", "fr", "sk", "Francúzština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("200", "fr", "cy", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("201", "fr", "da", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("202", "fr", "el", "Γαλλικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("203", "fr", "eo", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("204", "fr", "et", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("205", "fr", "eu", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("206", "fr", "fa", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("207", "fr", "fi", "ranska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("208", "fr", "ga", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("209", "fr", "he", "צרפתית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("210", "fr", "hi", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("211", "fr", "hr", "Francuzi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("212", "fr", "hu", "francia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("213", "fr", "hy", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("214", "fr", "id", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("215", "fr", "is", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("216", "fr", "it", "Francese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("217", "fr", "ja", "フランス語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("218", "fr", "ko", "불어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("219", "fr", "ku", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("220", "fr", "la", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("221", "fr", "lv", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("222", "fr", "lt", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("223", "fr", "mk", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("224", "fr", "mt", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("225", "fr", "mn", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("226", "fr", "ne", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("227", "fr", "nl", "Frans");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("228", "fr", "nb", "Fransk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("229", "fr", "pa", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("230", "fr", "pl", "francuski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("231", "fr", "pt-pt", "Francês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("232", "fr", "pt-br", "Francês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("233", "fr", "qu", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("234", "fr", "ro", "Franceză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("235", "fr", "ru", "Французский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("236", "fr", "sl", "Francoščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("237", "fr", "so", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("238", "fr", "sq", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("239", "fr", "sr", "француски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("240", "fr", "sv", "Franska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("241", "fr", "ta", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("242", "fr", "th", "ฝรั่งเศส");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("243", "fr", "tr", "Fransızca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("244", "fr", "uk", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("245", "fr", "ur", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("246", "fr", "uz", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("247", "fr", "vi", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("248", "fr", "yi", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("249", "fr", "zh-hans", "法语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("250", "fr", "zu", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("251", "fr", "zh-hant", "法語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("252", "fr", "ms", "French");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("253", "ar", "en", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("254", "ar", "es", "Árabe");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("255", "ar", "de", "Arabisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("256", "ar", "fr", "Arabe");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("257", "ar", "ar", "العربية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("258", "ar", "bs", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("259", "ar", "bg", "Арабски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("260", "ar", "ca", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("261", "ar", "cs", "Arabština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("262", "ar", "sk", "Arabčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("263", "ar", "cy", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("264", "ar", "da", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("265", "ar", "el", "Αραβικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("266", "ar", "eo", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("267", "ar", "et", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("268", "ar", "eu", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("269", "ar", "fa", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("270", "ar", "fi", "arabia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("271", "ar", "ga", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("272", "ar", "he", "ערבית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("273", "ar", "hi", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("274", "ar", "hr", "Arapski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("275", "ar", "hu", "arab");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("276", "ar", "hy", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("277", "ar", "id", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("278", "ar", "is", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("279", "ar", "it", "Arabo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("280", "ar", "ja", "アラビア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("281", "ar", "ko", "아랍어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("282", "ar", "ku", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("283", "ar", "la", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("284", "ar", "lv", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("285", "ar", "lt", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("286", "ar", "mk", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("287", "ar", "mt", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("288", "ar", "mn", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("289", "ar", "ne", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("290", "ar", "nl", "Arabisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("291", "ar", "nb", "Arabisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("292", "ar", "pa", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("293", "ar", "pl", "arabski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("294", "ar", "pt-pt", "Árabe");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("295", "ar", "pt-br", "Árabe");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("296", "ar", "qu", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("297", "ar", "ro", "Arabică");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("298", "ar", "ru", "Арабский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("299", "ar", "sl", "Arabščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("300", "ar", "so", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("301", "ar", "sq", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("302", "ar", "sr", "арапски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("303", "ar", "sv", "Arabiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("304", "ar", "ta", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("305", "ar", "th", "อารบิก");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("306", "ar", "tr", "Arapça");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("307", "ar", "uk", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("308", "ar", "ur", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("309", "ar", "uz", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("310", "ar", "vi", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("311", "ar", "yi", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("312", "ar", "zh-hans", "阿拉伯语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("313", "ar", "zu", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("314", "ar", "zh-hant", "阿拉伯語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("315", "ar", "ms", "Arabic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("316", "bs", "en", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("317", "bs", "es", "Bosnio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("318", "bs", "de", "Bosnisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("319", "bs", "fr", "Bosnien");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("320", "bs", "ar", "البوسنية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("321", "bs", "bs", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("322", "bs", "bg", "Босненски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("323", "bs", "ca", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("324", "bs", "cs", "Bosenština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("325", "bs", "sk", "Bosniačtina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("326", "bs", "cy", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("327", "bs", "da", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("328", "bs", "el", "Βοσνιακα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("329", "bs", "eo", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("330", "bs", "et", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("331", "bs", "eu", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("332", "bs", "fa", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("333", "bs", "fi", "bosnia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("334", "bs", "ga", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("335", "bs", "he", "בוסנית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("336", "bs", "hi", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("337", "bs", "hr", "Bosanski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("338", "bs", "hu", "bosnyák");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("339", "bs", "hy", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("340", "bs", "id", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("341", "bs", "is", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("342", "bs", "it", "Bosniaco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("343", "bs", "ja", "ボスニア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("344", "bs", "ko", "보즈니아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("345", "bs", "ku", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("346", "bs", "la", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("347", "bs", "lv", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("348", "bs", "lt", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("349", "bs", "mk", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("350", "bs", "mt", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("351", "bs", "mn", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("352", "bs", "ne", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("353", "bs", "nl", "Bosnisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("354", "bs", "nb", "Bosnisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("355", "bs", "pa", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("356", "bs", "pl", "bośniacki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("357", "bs", "pt-pt", "Bósnio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("358", "bs", "pt-br", "Bósnio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("359", "bs", "qu", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("360", "bs", "ro", "Bosniacă");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("361", "bs", "ru", "Боснийский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("362", "bs", "sl", "Bosanski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("363", "bs", "so", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("364", "bs", "sq", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("365", "bs", "sr", "босански");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("366", "bs", "sv", "Bosniska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("367", "bs", "ta", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("368", "bs", "th", "บอสเนียน");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("369", "bs", "tr", "Boşnakça");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("370", "bs", "uk", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("371", "bs", "ur", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("372", "bs", "uz", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("373", "bs", "vi", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("374", "bs", "yi", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("375", "bs", "zh-hans", "波斯尼亚语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("376", "bs", "zu", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("377", "bs", "zh-hant", "波士尼亞語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("378", "bs", "ms", "Bosnian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("379", "bg", "en", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("380", "bg", "es", "Búlgaro");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("381", "bg", "de", "Bulgarisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("382", "bg", "fr", "Bulgare");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("383", "bg", "ar", "البلغارية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("384", "bg", "bs", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("385", "bg", "bg", "Български");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("386", "bg", "ca", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("387", "bg", "cs", "Bulharština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("388", "bg", "sk", "Bulharčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("389", "bg", "cy", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("390", "bg", "da", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("391", "bg", "el", "Βουλγαρικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("392", "bg", "eo", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("393", "bg", "et", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("394", "bg", "eu", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("395", "bg", "fa", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("396", "bg", "fi", "bulgaria");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("397", "bg", "ga", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("398", "bg", "he", "בולגרית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("399", "bg", "hi", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("400", "bg", "hr", "Bugarski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("401", "bg", "hu", "bolgár");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("402", "bg", "hy", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("403", "bg", "id", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("404", "bg", "is", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("405", "bg", "it", "Bulgaro");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("406", "bg", "ja", "ブルガリア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("407", "bg", "ko", "불가리아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("408", "bg", "ku", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("409", "bg", "la", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("410", "bg", "lv", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("411", "bg", "lt", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("412", "bg", "mk", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("413", "bg", "mt", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("414", "bg", "mn", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("415", "bg", "ne", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("416", "bg", "nl", "Bulgaars");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("417", "bg", "nb", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("418", "bg", "pa", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("419", "bg", "pl", "bułgarski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("420", "bg", "pt-pt", "Búlgaro");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("421", "bg", "pt-br", "Búlgaro");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("422", "bg", "qu", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("423", "bg", "ro", "Bulgară");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("424", "bg", "ru", "Болгарский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("425", "bg", "sl", "Bolgarščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("426", "bg", "so", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("427", "bg", "sq", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("428", "bg", "sr", "бугарски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("429", "bg", "sv", "Bulgariska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("430", "bg", "ta", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("431", "bg", "th", "บัลแกเรียน");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("432", "bg", "tr", "Bulgarca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("433", "bg", "uk", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("434", "bg", "ur", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("435", "bg", "uz", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("436", "bg", "vi", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("437", "bg", "yi", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("438", "bg", "zh-hans", "保加利亚语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("439", "bg", "zu", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("440", "bg", "zh-hant", "保加利亞語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("441", "bg", "ms", "Bulgarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("442", "ca", "en", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("443", "ca", "es", "Catalán");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("444", "ca", "de", "Katalanisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("445", "ca", "fr", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("446", "ca", "ar", "الكاتالوينية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("447", "ca", "bs", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("448", "ca", "bg", "Каталонски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("449", "ca", "ca", "Català");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("450", "ca", "cs", "Katalánština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("451", "ca", "sk", "Katalánčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("452", "ca", "cy", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("453", "ca", "da", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("454", "ca", "el", "Καταλανικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("455", "ca", "eo", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("456", "ca", "et", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("457", "ca", "eu", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("458", "ca", "fa", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("459", "ca", "fi", "katalaani");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("460", "ca", "ga", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("461", "ca", "he", "קטלאנית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("462", "ca", "hi", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("463", "ca", "hr", "Katalonski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("464", "ca", "hu", "katalán");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("465", "ca", "hy", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("466", "ca", "id", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("467", "ca", "is", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("468", "ca", "it", "Catalano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("469", "ca", "ja", "カタルーニャ語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("470", "ca", "ko", "카탈로니아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("471", "ca", "ku", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("472", "ca", "la", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("473", "ca", "lv", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("474", "ca", "lt", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("475", "ca", "mk", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("476", "ca", "mt", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("477", "ca", "mn", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("478", "ca", "ne", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("479", "ca", "nl", "Catalaans");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("480", "ca", "nb", "catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("481", "ca", "pa", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("482", "ca", "pl", "kataloński");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("483", "ca", "pt-pt", "Catalão");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("484", "ca", "pt-br", "Catalão");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("485", "ca", "qu", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("486", "ca", "ro", "Catalană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("487", "ca", "ru", "Каталанский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("488", "ca", "sl", "Katalonščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("489", "ca", "so", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("490", "ca", "sq", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("491", "ca", "sr", "каталонски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("492", "ca", "sv", "Katalanska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("493", "ca", "ta", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("494", "ca", "th", "คะตะลาน");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("495", "ca", "tr", "Katalan dili");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("496", "ca", "uk", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("497", "ca", "ur", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("498", "ca", "uz", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("499", "ca", "vi", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("500", "ca", "yi", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("501", "ca", "zh-hans", "加泰罗尼亚语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("502", "ca", "zu", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("503", "ca", "zh-hant", "加泰羅尼亞語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("504", "ca", "ms", "Catalan");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("505", "cs", "en", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("506", "cs", "es", "Checo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("507", "cs", "de", "Tschechisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("508", "cs", "fr", "Tchèque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("509", "cs", "ar", "التشيكية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("510", "cs", "bs", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("511", "cs", "bg", "Чешки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("512", "cs", "ca", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("513", "cs", "cs", "Čeština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("514", "cs", "sk", "Čeština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("515", "cs", "cy", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("516", "cs", "da", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("517", "cs", "el", "Τσεχικη");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("518", "cs", "eo", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("519", "cs", "et", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("520", "cs", "eu", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("521", "cs", "fa", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("522", "cs", "fi", "tsekki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("523", "cs", "ga", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("524", "cs", "he", "צ\'כית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("525", "cs", "hi", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("526", "cs", "hr", "češki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("527", "cs", "hu", "cseh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("528", "cs", "hy", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("529", "cs", "id", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("530", "cs", "is", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("531", "cs", "it", "Ceco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("532", "cs", "ja", "チェコ語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("533", "cs", "ko", "체코슬로바키아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("534", "cs", "ku", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("535", "cs", "la", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("536", "cs", "lv", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("537", "cs", "lt", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("538", "cs", "mk", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("539", "cs", "mt", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("540", "cs", "mn", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("541", "cs", "ne", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("542", "cs", "nl", "Tsjechisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("543", "cs", "nb", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("544", "cs", "pa", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("545", "cs", "pl", "czeski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("546", "cs", "pt-pt", "Tcheco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("547", "cs", "pt-br", "Tcheco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("548", "cs", "qu", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("549", "cs", "ro", "Cehă");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("550", "cs", "ru", "Чешский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("551", "cs", "sl", "Češčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("552", "cs", "so", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("553", "cs", "sq", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("554", "cs", "sr", "чешки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("555", "cs", "sv", "Tjeckiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("556", "cs", "ta", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("557", "cs", "th", "เช็ก");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("558", "cs", "tr", "Çekçe");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("559", "cs", "uk", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("560", "cs", "ur", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("561", "cs", "uz", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("562", "cs", "vi", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("563", "cs", "yi", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("564", "cs", "zh-hans", "捷克语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("565", "cs", "zu", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("566", "cs", "zh-hant", "捷克語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("567", "cs", "ms", "Czech");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("568", "sk", "en", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("569", "sk", "es", "Eslavo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("570", "sk", "de", "Slowakisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("571", "sk", "fr", "Slave");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("572", "sk", "ar", "السلافية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("573", "sk", "bs", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("574", "sk", "bg", "Словашки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("575", "sk", "ca", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("576", "sk", "cs", "Slovenština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("577", "sk", "sk", "Slovenčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("578", "sk", "cy", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("579", "sk", "da", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("580", "sk", "el", "Σλαβικη");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("581", "sk", "eo", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("582", "sk", "et", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("583", "sk", "eu", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("584", "sk", "fa", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("585", "sk", "fi", "slaavi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("586", "sk", "ga", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("587", "sk", "he", "סלאבית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("588", "sk", "hi", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("589", "sk", "hr", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("590", "sk", "hu", "szláv");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("591", "sk", "hy", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("592", "sk", "id", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("593", "sk", "is", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("594", "sk", "it", "Slavo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("595", "sk", "ja", "スラヴ語派");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("596", "sk", "ko", "슬라브어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("597", "sk", "ku", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("598", "sk", "la", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("599", "sk", "lv", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("600", "sk", "lt", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("601", "sk", "mk", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("602", "sk", "mt", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("603", "sk", "mn", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("604", "sk", "ne", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("605", "sk", "nl", "Slavisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("606", "sk", "nb", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("607", "sk", "pa", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("608", "sk", "pl", "słowacki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("609", "sk", "pt-pt", "Eslavo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("610", "sk", "pt-br", "Eslavo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("611", "sk", "qu", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("612", "sk", "ro", "Slavă");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("613", "sk", "ru", "Славянский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("614", "sk", "sl", "Slovaščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("615", "sk", "so", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("616", "sk", "sq", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("617", "sk", "sr", "словачки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("618", "sk", "sv", "Slavisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("619", "sk", "ta", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("620", "sk", "th", "สลาวิก");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("621", "sk", "tr", "Slav dili");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("622", "sk", "uk", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("623", "sk", "ur", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("624", "sk", "uz", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("625", "sk", "vi", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("626", "sk", "yi", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("627", "sk", "zh-hans", "斯拉夫语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("628", "sk", "zu", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("629", "sk", "zh-hant", "斯拉夫語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("630", "sk", "ms", "Slovak");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("631", "cy", "en", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("632", "cy", "es", "Galés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("633", "cy", "de", "Walisisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("634", "cy", "fr", "Gallois");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("635", "cy", "ar", "الولزية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("636", "cy", "bs", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("637", "cy", "bg", "Уелски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("638", "cy", "ca", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("639", "cy", "cs", "Velšský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("640", "cy", "sk", "Welština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("641", "cy", "cy", "Cymraeg");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("642", "cy", "da", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("643", "cy", "el", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("644", "cy", "eo", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("645", "cy", "et", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("646", "cy", "eu", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("647", "cy", "fa", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("648", "cy", "fi", "kymri");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("649", "cy", "ga", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("650", "cy", "he", "וולשית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("651", "cy", "hi", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("652", "cy", "hr", "Velški");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("653", "cy", "hu", "vels");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("654", "cy", "hy", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("655", "cy", "id", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("656", "cy", "is", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("657", "cy", "it", "Gallese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("658", "cy", "ja", "ウェールズ語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("659", "cy", "ko", "웨일즈어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("660", "cy", "ku", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("661", "cy", "la", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("662", "cy", "lv", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("663", "cy", "lt", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("664", "cy", "mk", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("665", "cy", "mt", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("666", "cy", "mn", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("667", "cy", "ne", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("668", "cy", "nl", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("669", "cy", "nb", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("670", "cy", "pa", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("671", "cy", "pl", "walijski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("672", "cy", "pt-pt", "Galês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("673", "cy", "pt-br", "Galês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("674", "cy", "qu", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("675", "cy", "ro", "Galeză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("676", "cy", "ru", "Валлийский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("677", "cy", "sl", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("678", "cy", "so", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("679", "cy", "sq", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("680", "cy", "sr", "велшки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("681", "cy", "sv", "Walesiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("682", "cy", "ta", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("683", "cy", "th", "เวลช์");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("684", "cy", "tr", "Galce");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("685", "cy", "uk", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("686", "cy", "ur", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("687", "cy", "uz", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("688", "cy", "vi", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("689", "cy", "yi", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("690", "cy", "zh-hans", "威尔士语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("691", "cy", "zu", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("692", "cy", "zh-hant", "威爾士語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("693", "cy", "ms", "Welsh");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("694", "da", "en", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("695", "da", "es", "Danés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("696", "da", "de", "Dänisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("697", "da", "fr", "Danois");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("698", "da", "ar", "الدانماركية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("699", "da", "bs", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("700", "da", "bg", "Датски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("701", "da", "ca", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("702", "da", "cs", "Dánský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("703", "da", "sk", "Dánčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("704", "da", "cy", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("705", "da", "da", "Dansk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("706", "da", "el", "Δανεζικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("707", "da", "eo", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("708", "da", "et", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("709", "da", "eu", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("710", "da", "fa", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("711", "da", "fi", "tanska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("712", "da", "ga", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("713", "da", "he", "דנית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("714", "da", "hi", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("715", "da", "hr", "Danski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("716", "da", "hu", "dán");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("717", "da", "hy", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("718", "da", "id", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("719", "da", "is", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("720", "da", "it", "Danese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("721", "da", "ja", "デンマーク語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("722", "da", "ko", "덴마크어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("723", "da", "ku", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("724", "da", "la", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("725", "da", "lv", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("726", "da", "lt", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("727", "da", "mk", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("728", "da", "mt", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("729", "da", "mn", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("730", "da", "ne", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("731", "da", "nl", "Deens");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("732", "da", "nb", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("733", "da", "pa", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("734", "da", "pl", "duński");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("735", "da", "pt-pt", "Dinamarquês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("736", "da", "pt-br", "Dinamarquês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("737", "da", "qu", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("738", "da", "ro", "Daneză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("739", "da", "ru", "Датский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("740", "da", "sl", "Danščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("741", "da", "so", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("742", "da", "sq", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("743", "da", "sr", "дански");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("744", "da", "sv", "Danska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("745", "da", "ta", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("746", "da", "th", "เดนมาร์ก");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("747", "da", "tr", "Danca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("748", "da", "uk", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("749", "da", "ur", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("750", "da", "uz", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("751", "da", "vi", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("752", "da", "yi", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("753", "da", "zh-hans", "丹麦语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("754", "da", "zu", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("755", "da", "zh-hant", "丹麥語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("756", "da", "ms", "Danish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("757", "el", "en", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("758", "el", "es", "Griego");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("759", "el", "de", "Griechisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("760", "el", "fr", "Grec moderne");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("761", "el", "ar", "اليونانية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("762", "el", "bs", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("763", "el", "bg", "Гръцки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("764", "el", "ca", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("765", "el", "cs", "Řečtina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("766", "el", "sk", "Gréčtina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("767", "el", "cy", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("768", "el", "da", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("769", "el", "el", "Ελληνικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("770", "el", "eo", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("771", "el", "et", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("772", "el", "eu", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("773", "el", "fa", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("774", "el", "fi", "kreikka");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("775", "el", "ga", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("776", "el", "he", "יוונית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("777", "el", "hi", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("778", "el", "hr", "Grčki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("779", "el", "hu", "görög");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("780", "el", "hy", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("781", "el", "id", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("782", "el", "is", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("783", "el", "it", "Greco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("784", "el", "ja", "ギリシア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("785", "el", "ko", "그리스어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("786", "el", "ku", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("787", "el", "la", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("788", "el", "lv", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("789", "el", "lt", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("790", "el", "mk", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("791", "el", "mt", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("792", "el", "mn", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("793", "el", "ne", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("794", "el", "nl", "Grieks");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("795", "el", "nb", "Gresk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("796", "el", "pa", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("797", "el", "pl", "grecki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("798", "el", "pt-pt", "Grego");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("799", "el", "pt-br", "Grego");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("800", "el", "qu", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("801", "el", "ro", "Greacă");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("802", "el", "ru", "Греческий");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("803", "el", "sl", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("804", "el", "so", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("805", "el", "sq", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("806", "el", "sr", "грчки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("807", "el", "sv", "Grekiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("808", "el", "ta", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("809", "el", "th", "กรีก");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("810", "el", "tr", "Yunanca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("811", "el", "uk", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("812", "el", "ur", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("813", "el", "uz", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("814", "el", "vi", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("815", "el", "yi", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("816", "el", "zh-hans", "希腊语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("817", "el", "zu", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("818", "el", "zh-hant", "希臘語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("819", "el", "ms", "Greek");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("820", "eo", "en", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("821", "eo", "es", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("822", "eo", "de", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("823", "eo", "fr", "Espéranto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("824", "eo", "ar", "الاسبرانتو");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("825", "eo", "bs", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("826", "eo", "bg", "Есперанто");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("827", "eo", "ca", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("828", "eo", "cs", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("829", "eo", "sk", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("830", "eo", "cy", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("831", "eo", "da", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("832", "eo", "el", "Εσπεραντο");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("833", "eo", "eo", "Esperanta");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("834", "eo", "et", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("835", "eo", "eu", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("836", "eo", "fa", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("837", "eo", "fi", "esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("838", "eo", "ga", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("839", "eo", "he", "אספרנטו");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("840", "eo", "hi", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("841", "eo", "hr", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("842", "eo", "hu", "eszperantó");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("843", "eo", "hy", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("844", "eo", "id", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("845", "eo", "is", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("846", "eo", "it", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("847", "eo", "ja", "エスペラント語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("848", "eo", "ko", "에스페란토어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("849", "eo", "ku", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("850", "eo", "la", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("851", "eo", "lv", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("852", "eo", "lt", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("853", "eo", "mk", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("854", "eo", "mt", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("855", "eo", "mn", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("856", "eo", "ne", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("857", "eo", "nl", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("858", "eo", "nb", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("859", "eo", "pa", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("860", "eo", "pl", "esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("861", "eo", "pt-pt", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("862", "eo", "pt-br", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("863", "eo", "qu", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("864", "eo", "ro", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("865", "eo", "ru", "Эсперанто");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("866", "eo", "sl", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("867", "eo", "so", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("868", "eo", "sq", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("869", "eo", "sr", "есперанто");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("870", "eo", "sv", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("871", "eo", "ta", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("872", "eo", "th", "เอสเปอรันโต");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("873", "eo", "tr", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("874", "eo", "uk", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("875", "eo", "ur", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("876", "eo", "uz", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("877", "eo", "vi", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("878", "eo", "yi", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("879", "eo", "zh-hans", "世界语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("880", "eo", "zu", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("881", "eo", "zh-hant", "世界語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("882", "eo", "ms", "Esperanto");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("883", "et", "en", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("884", "et", "es", "Estonio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("885", "et", "de", "Estnisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("886", "et", "fr", "Estonien");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("887", "et", "ar", "الأستونية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("888", "et", "bs", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("889", "et", "bg", "Естонски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("890", "et", "ca", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("891", "et", "cs", "Estonština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("892", "et", "sk", "Estónčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("893", "et", "cy", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("894", "et", "da", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("895", "et", "el", "Εσθονικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("896", "et", "eo", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("897", "et", "et", "Eesti");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("898", "et", "eu", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("899", "et", "fa", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("900", "et", "fi", "eesti");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("901", "et", "ga", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("902", "et", "he", "אסטונית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("903", "et", "hi", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("904", "et", "hr", "Estonski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("905", "et", "hu", "észt");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("906", "et", "hy", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("907", "et", "id", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("908", "et", "is", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("909", "et", "it", "Estone");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("910", "et", "ja", "エストニア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("911", "et", "ko", "에스토니아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("912", "et", "ku", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("913", "et", "la", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("914", "et", "lv", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("915", "et", "lt", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("916", "et", "mk", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("917", "et", "mt", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("918", "et", "mn", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("919", "et", "ne", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("920", "et", "nl", "Ests");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("921", "et", "nb", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("922", "et", "pa", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("923", "et", "pl", "estoński");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("924", "et", "pt-pt", "Estoniano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("925", "et", "pt-br", "Estoniano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("926", "et", "qu", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("927", "et", "ro", "Estoniană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("928", "et", "ru", "Эстонский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("929", "et", "sl", "Estonščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("930", "et", "so", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("931", "et", "sq", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("932", "et", "sr", "естонски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("933", "et", "sv", "Estniska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("934", "et", "ta", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("935", "et", "th", "เอสโตเนียน");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("936", "et", "tr", "Estonya dili");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("937", "et", "uk", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("938", "et", "ur", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("939", "et", "uz", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("940", "et", "vi", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("941", "et", "yi", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("942", "et", "zh-hans", "爱沙尼亚语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("943", "et", "zu", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("944", "et", "zh-hant", "愛沙尼亞語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("945", "et", "ms", "Estonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("946", "eu", "en", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("947", "eu", "es", "Euskera");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("948", "eu", "de", "Baskisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("949", "eu", "fr", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("950", "eu", "ar", "لغة الباسك");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("951", "eu", "bs", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("952", "eu", "bg", "Баски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("953", "eu", "ca", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("954", "eu", "cs", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("955", "eu", "sk", "Baskičtina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("956", "eu", "cy", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("957", "eu", "da", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("958", "eu", "el", "Βασκικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("959", "eu", "eo", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("960", "eu", "et", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("961", "eu", "eu", "Euskara");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("962", "eu", "fa", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("963", "eu", "fi", "baski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("964", "eu", "ga", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("965", "eu", "he", "בסקית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("966", "eu", "hi", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("967", "eu", "hr", "Baskijski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("968", "eu", "hu", "baszk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("969", "eu", "hy", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("970", "eu", "id", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("971", "eu", "is", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("972", "eu", "it", "Basco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("973", "eu", "ja", "バスク語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("974", "eu", "ko", "바스크어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("975", "eu", "ku", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("976", "eu", "la", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("977", "eu", "lv", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("978", "eu", "lt", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("979", "eu", "mk", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("980", "eu", "mt", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("981", "eu", "mn", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("982", "eu", "ne", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("983", "eu", "nl", "Baskisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("984", "eu", "nb", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("985", "eu", "pa", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("986", "eu", "pl", "baskijski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("987", "eu", "pt-pt", "Basco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("988", "eu", "pt-br", "Basco");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("989", "eu", "qu", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("990", "eu", "ro", "Bască");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("991", "eu", "ru", "Баскский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("992", "eu", "sl", "Baskovščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("993", "eu", "so", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("994", "eu", "sq", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("995", "eu", "sr", "баскијски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("996", "eu", "sv", "Baskiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("997", "eu", "ta", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("998", "eu", "th", "บาสค์");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("999", "eu", "tr", "Bask dili");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1000", "eu", "uk", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1001", "eu", "ur", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1002", "eu", "uz", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1003", "eu", "vi", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1004", "eu", "yi", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1005", "eu", "zh-hans", "巴斯克语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1006", "eu", "zu", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1007", "eu", "zh-hant", "巴斯克語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1008", "eu", "ms", "Basque");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1009", "fa", "en", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1010", "fa", "es", "Persa");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1011", "fa", "de", "Persisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1012", "fa", "fr", "Perse");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1013", "fa", "ar", "الفارسية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1014", "fa", "bs", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1015", "fa", "bg", "Персийски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1016", "fa", "ca", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1017", "fa", "cs", "Perský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1018", "fa", "sk", "Perzština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1019", "fa", "cy", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1020", "fa", "da", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1021", "fa", "el", "Περσικος");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1022", "fa", "eo", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1023", "fa", "et", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1024", "fa", "eu", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1025", "fa", "fa", "فارسی");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1026", "fa", "fi", "persia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1027", "fa", "ga", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1028", "fa", "he", "פרסית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1029", "fa", "hi", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1030", "fa", "hr", "Perzijski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1031", "fa", "hu", "perzsa");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1032", "fa", "hy", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1033", "fa", "id", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1034", "fa", "is", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1035", "fa", "it", "Persiano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1036", "fa", "ja", "ペルシア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1037", "fa", "ko", "페르시아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1038", "fa", "ku", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1039", "fa", "la", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1040", "fa", "lv", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1041", "fa", "lt", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1042", "fa", "mk", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1043", "fa", "mt", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1044", "fa", "mn", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1045", "fa", "ne", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1046", "fa", "nl", "Perzisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1047", "fa", "nb", "Persisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1048", "fa", "pa", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1049", "fa", "pl", "perski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1050", "fa", "pt-pt", "Persa");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1051", "fa", "pt-br", "Persa");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1052", "fa", "qu", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1053", "fa", "ro", "Persană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1054", "fa", "ru", "Персидский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1055", "fa", "sl", "Perzijski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1056", "fa", "so", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1057", "fa", "sq", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1058", "fa", "sr", "персијски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1059", "fa", "sv", "Persiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1060", "fa", "ta", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1061", "fa", "th", "เปอร์เซียน");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1062", "fa", "tr", "Farsça");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1063", "fa", "uk", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1064", "fa", "ur", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1065", "fa", "uz", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1066", "fa", "vi", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1067", "fa", "yi", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1068", "fa", "zh-hans", "波斯语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1069", "fa", "zu", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1070", "fa", "zh-hant", "波斯語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1071", "fa", "ms", "Persian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1072", "fi", "en", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1073", "fi", "es", "Finlandés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1074", "fi", "de", "Finnisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1075", "fi", "fr", "Finnois");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1076", "fi", "ar", "الفنلندية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1077", "fi", "bs", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1078", "fi", "bg", "Фински");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1079", "fi", "ca", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1080", "fi", "cs", "Finský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1081", "fi", "sk", "Fínština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1082", "fi", "cy", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1083", "fi", "da", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1084", "fi", "el", "Φινλανδικη");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1085", "fi", "eo", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1086", "fi", "et", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1087", "fi", "eu", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1088", "fi", "fa", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1089", "fi", "fi", "Suomi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1090", "fi", "ga", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1091", "fi", "he", "פינית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1092", "fi", "hi", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1093", "fi", "hr", "Finski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1094", "fi", "hu", "finn");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1095", "fi", "hy", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1096", "fi", "id", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1097", "fi", "is", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1098", "fi", "it", "Finlandese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1099", "fi", "ja", "フィンランド語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1100", "fi", "ko", "핀란드어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1101", "fi", "ku", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1102", "fi", "la", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1103", "fi", "lv", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1104", "fi", "lt", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1105", "fi", "mk", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1106", "fi", "mt", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1107", "fi", "mn", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1108", "fi", "ne", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1109", "fi", "nl", "Fins");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1110", "fi", "nb", "Finsk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1111", "fi", "pa", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1112", "fi", "pl", "fiński");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1113", "fi", "pt-pt", "Finlandês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1114", "fi", "pt-br", "Finlandês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1115", "fi", "qu", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1116", "fi", "ro", "Finlandeză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1117", "fi", "ru", "Финский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1118", "fi", "sl", "Finski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1119", "fi", "so", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1120", "fi", "sq", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1121", "fi", "sr", "фински");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1122", "fi", "sv", "Finska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1123", "fi", "ta", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1124", "fi", "th", "ฟินนิช");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1125", "fi", "tr", "Fince");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1126", "fi", "uk", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1127", "fi", "ur", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1128", "fi", "uz", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1129", "fi", "vi", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1130", "fi", "yi", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1131", "fi", "zh-hans", "芬兰语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1132", "fi", "zu", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1133", "fi", "zh-hant", "芬蘭語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1134", "fi", "ms", "Finnish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1135", "ga", "en", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1136", "ga", "es", "Irlandés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1137", "ga", "de", "Irisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1138", "ga", "fr", "Irlandais");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1139", "ga", "ar", "الأيرلندية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1140", "ga", "bs", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1141", "ga", "bg", "Ирландски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1142", "ga", "ca", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1143", "ga", "cs", "Irský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1144", "ga", "sk", "Írština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1145", "ga", "cy", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1146", "ga", "da", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1147", "ga", "el", "Ιρλανδικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1148", "ga", "eo", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1149", "ga", "et", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1150", "ga", "eu", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1151", "ga", "fa", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1152", "ga", "fi", "iiri");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1153", "ga", "ga", "Gaeilge");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1154", "ga", "he", "אירית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1155", "ga", "hi", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1156", "ga", "hr", "Irci");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1157", "ga", "hu", "ír");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1158", "ga", "hy", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1159", "ga", "id", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1160", "ga", "is", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1161", "ga", "it", "Irlandese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1162", "ga", "ja", "アイルランド語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1163", "ga", "ko", "아일랜드어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1164", "ga", "ku", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1165", "ga", "la", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1166", "ga", "lv", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1167", "ga", "lt", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1168", "ga", "mk", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1169", "ga", "mt", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1170", "ga", "mn", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1171", "ga", "ne", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1172", "ga", "nl", "Iers");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1173", "ga", "nb", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1174", "ga", "pa", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1175", "ga", "pl", "irlandzki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1176", "ga", "pt-pt", "Irlandês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1177", "ga", "pt-br", "Irlandês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1178", "ga", "qu", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1179", "ga", "ro", "Irlandeză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1180", "ga", "ru", "Ирландский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1181", "ga", "sl", "Irski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1182", "ga", "so", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1183", "ga", "sq", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1184", "ga", "sr", "ирски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1185", "ga", "sv", "Irländska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1186", "ga", "ta", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1187", "ga", "th", "ไอริช");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1188", "ga", "tr", "İrlanda dili");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1189", "ga", "uk", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1190", "ga", "ur", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1191", "ga", "uz", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1192", "ga", "vi", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1193", "ga", "yi", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1194", "ga", "zh-hans", "爱尔兰语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1195", "ga", "zu", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1196", "ga", "zh-hant", "愛爾蘭語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1197", "ga", "ms", "Irish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1198", "he", "en", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1199", "he", "es", "Hebreo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1200", "he", "de", "Hebräisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1201", "he", "fr", "Hébreu");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1202", "he", "ar", "العبرية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1203", "he", "bs", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1204", "he", "bg", "Иврит");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1205", "he", "ca", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1206", "he", "cs", "Hebrejština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1207", "he", "sk", "Hebrejčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1208", "he", "cy", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1209", "he", "da", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1210", "he", "el", "Εβραικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1211", "he", "eo", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1212", "he", "et", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1213", "he", "eu", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1214", "he", "fa", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1215", "he", "fi", "heprea");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1216", "he", "ga", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1217", "he", "he", "עברית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1218", "he", "hi", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1219", "he", "hr", "Hebrejski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1220", "he", "hu", "héber");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1221", "he", "hy", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1222", "he", "id", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1223", "he", "is", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1224", "he", "it", "Ebraico");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1225", "he", "ja", "ヘブライ語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1226", "he", "ko", "히브리어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1227", "he", "ku", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1228", "he", "la", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1229", "he", "lv", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1230", "he", "lt", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1231", "he", "mk", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1232", "he", "mt", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1233", "he", "mn", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1234", "he", "ne", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1235", "he", "nl", "Hebreeuws");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1236", "he", "nb", "Hebraisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1237", "he", "pa", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1238", "he", "pl", "hebrajski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1239", "he", "pt-pt", "Hebraico");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1240", "he", "pt-br", "Hebraico");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1241", "he", "qu", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1242", "he", "ro", "Ebraică");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1243", "he", "ru", "Иврит");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1244", "he", "sl", "Hebrejščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1245", "he", "so", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1246", "he", "sq", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1247", "he", "sr", "Хебрејски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1248", "he", "sv", "Hebreiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1249", "he", "ta", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1250", "he", "th", "ฮิบรู");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1251", "he", "tr", "İbranice");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1252", "he", "uk", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1253", "he", "ur", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1254", "he", "uz", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1255", "he", "vi", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1256", "he", "yi", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1257", "he", "zh-hans", "希伯来语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1258", "he", "zu", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1259", "he", "zh-hant", "希伯來語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1260", "he", "ms", "Hebrew");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1261", "hi", "en", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1262", "hi", "es", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1263", "hi", "de", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1264", "hi", "fr", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1265", "hi", "ar", "الهندية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1266", "hi", "bs", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1267", "hi", "bg", "Хинди");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1268", "hi", "ca", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1269", "hi", "cs", "Hindština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1270", "hi", "sk", "Hindčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1271", "hi", "cy", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1272", "hi", "da", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1273", "hi", "el", "Ινδικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1274", "hi", "eo", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1275", "hi", "et", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1276", "hi", "eu", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1277", "hi", "fa", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1278", "hi", "fi", "hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1279", "hi", "ga", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1280", "hi", "he", "הודית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1281", "hi", "hi", "हिन्दी");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1282", "hi", "hr", "Hindski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1283", "hi", "hu", "hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1284", "hi", "hy", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1285", "hi", "id", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1286", "hi", "is", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1287", "hi", "it", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1288", "hi", "ja", "ヒンディー語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1289", "hi", "ko", "힌두어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1290", "hi", "ku", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1291", "hi", "la", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1292", "hi", "lv", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1293", "hi", "lt", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1294", "hi", "mk", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1295", "hi", "mt", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1296", "hi", "mn", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1297", "hi", "ne", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1298", "hi", "nl", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1299", "hi", "nb", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1300", "hi", "pa", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1301", "hi", "pl", "hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1302", "hi", "pt-pt", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1303", "hi", "pt-br", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1304", "hi", "qu", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1305", "hi", "ro", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1306", "hi", "ru", "Хинди");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1307", "hi", "sl", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1308", "hi", "so", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1309", "hi", "sq", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1310", "hi", "sr", "хинди");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1311", "hi", "sv", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1312", "hi", "ta", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1313", "hi", "th", "ฮินดิ");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1314", "hi", "tr", "Hintçe");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1315", "hi", "uk", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1316", "hi", "ur", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1317", "hi", "uz", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1318", "hi", "vi", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1319", "hi", "yi", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1320", "hi", "zh-hans", "印地语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1321", "hi", "zu", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1322", "hi", "zh-hant", "印地語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1323", "hi", "ms", "Hindi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1324", "hr", "en", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1325", "hr", "es", "Croata");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1326", "hr", "de", "Kroatisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1327", "hr", "fr", "Croate");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1328", "hr", "ar", "الكرواتية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1329", "hr", "bs", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1330", "hr", "bg", "Хърватски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1331", "hr", "ca", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1332", "hr", "cs", "Chorvatský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1333", "hr", "sk", "Chorvátština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1334", "hr", "cy", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1335", "hr", "da", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1336", "hr", "el", "Κροατικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1337", "hr", "eo", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1338", "hr", "et", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1339", "hr", "eu", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1340", "hr", "fa", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1341", "hr", "fi", "kroatia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1342", "hr", "ga", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1343", "hr", "he", "קרוטאית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1344", "hr", "hi", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1345", "hr", "hr", "Hrvatski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1346", "hr", "hu", "horvát");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1347", "hr", "hy", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1348", "hr", "id", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1349", "hr", "is", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1350", "hr", "it", "Croato");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1351", "hr", "ja", "クロアチア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1352", "hr", "ko", "크로아시아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1353", "hr", "ku", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1354", "hr", "la", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1355", "hr", "lv", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1356", "hr", "lt", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1357", "hr", "mk", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1358", "hr", "mt", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1359", "hr", "mn", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1360", "hr", "ne", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1361", "hr", "nl", "Kroatisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1362", "hr", "nb", "Kroatisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1363", "hr", "pa", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1364", "hr", "pl", "chorwacki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1365", "hr", "pt-pt", "Croata");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1366", "hr", "pt-br", "Croata");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1367", "hr", "qu", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1368", "hr", "ro", "Croată");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1369", "hr", "ru", "Хорватский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1370", "hr", "sl", "Hrvaški");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1371", "hr", "so", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1372", "hr", "sq", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1373", "hr", "sr", "хрватски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1374", "hr", "sv", "Kroatiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1375", "hr", "ta", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1376", "hr", "th", "โครเอเชีย");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1377", "hr", "tr", "Hırvatça");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1378", "hr", "uk", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1379", "hr", "ur", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1380", "hr", "uz", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1381", "hr", "vi", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1382", "hr", "yi", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1383", "hr", "zh-hans", "克罗地亚语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1384", "hr", "zu", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1385", "hr", "zh-hant", "克羅地亞語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1386", "hr", "ms", "Croatian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1387", "hu", "en", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1388", "hu", "es", "Húngaro");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1389", "hu", "de", "Ungarisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1390", "hu", "fr", "Hongrois");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1391", "hu", "ar", "الهنغارية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1392", "hu", "bs", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1393", "hu", "bg", "Унгарски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1394", "hu", "ca", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1395", "hu", "cs", "Maďarština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1396", "hu", "sk", "Maďarčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1397", "hu", "cy", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1398", "hu", "da", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1399", "hu", "el", "Ουγγρικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1400", "hu", "eo", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1401", "hu", "et", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1402", "hu", "eu", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1403", "hu", "fa", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1404", "hu", "fi", "unkari");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1405", "hu", "ga", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1406", "hu", "he", "הונגרית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1407", "hu", "hi", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1408", "hu", "hr", "Mađarski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1409", "hu", "hu", "Magyar");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1410", "hu", "hy", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1411", "hu", "id", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1412", "hu", "is", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1413", "hu", "it", "Ungherese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1414", "hu", "ja", "ハンガリー語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1415", "hu", "ko", "헝가리어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1416", "hu", "ku", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1417", "hu", "la", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1418", "hu", "lv", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1419", "hu", "lt", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1420", "hu", "mk", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1421", "hu", "mt", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1422", "hu", "mn", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1423", "hu", "ne", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1424", "hu", "nl", "Hongaars");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1425", "hu", "nb", "Ungarsk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1426", "hu", "pa", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1427", "hu", "pl", "węgierski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1428", "hu", "pt-pt", "Húngaro");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1429", "hu", "pt-br", "Húngaro");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1430", "hu", "qu", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1431", "hu", "ro", "Ungară");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1432", "hu", "ru", "Венгерский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1433", "hu", "sl", "Madžarski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1434", "hu", "so", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1435", "hu", "sq", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1436", "hu", "sr", "мађарски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1437", "hu", "sv", "Ungerska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1438", "hu", "ta", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1439", "hu", "th", "ฮังการี");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1440", "hu", "tr", "Macarca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1441", "hu", "uk", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1442", "hu", "ur", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1443", "hu", "uz", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1444", "hu", "vi", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1445", "hu", "yi", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1446", "hu", "zh-hans", "匈牙利语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1447", "hu", "zu", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1448", "hu", "zh-hant", "匈牙利語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1449", "hu", "ms", "Hungarian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1450", "hy", "en", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1451", "hy", "es", "Armenio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1452", "hy", "de", "Armenisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1453", "hy", "fr", "Arménien");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1454", "hy", "ar", "الأرمينية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1455", "hy", "bs", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1456", "hy", "bg", "Арменски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1457", "hy", "ca", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1458", "hy", "cs", "Arménský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1459", "hy", "sk", "Arménčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1460", "hy", "cy", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1461", "hy", "da", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1462", "hy", "el", "Αρμενικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1463", "hy", "eo", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1464", "hy", "et", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1465", "hy", "eu", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1466", "hy", "fa", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1467", "hy", "fi", "armenia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1468", "hy", "ga", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1469", "hy", "he", "ארמנית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1470", "hy", "hi", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1471", "hy", "hr", "Armenac");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1472", "hy", "hu", "örmény");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1473", "hy", "hy", "հայերեն");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1474", "hy", "id", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1475", "hy", "is", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1476", "hy", "it", "Armeno");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1477", "hy", "ja", "アルメニア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1478", "hy", "ko", "아르메니아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1479", "hy", "ku", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1480", "hy", "la", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1481", "hy", "lv", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1482", "hy", "lt", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1483", "hy", "mk", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1484", "hy", "mt", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1485", "hy", "mn", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1486", "hy", "ne", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1487", "hy", "nl", "Armeens");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1488", "hy", "nb", "Armensk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1489", "hy", "pa", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1490", "hy", "pl", "ormiański");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1491", "hy", "pt-pt", "Arménio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1492", "hy", "pt-br", "Arménio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1493", "hy", "qu", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1494", "hy", "ro", "Armeană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1495", "hy", "ru", "Армянский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1496", "hy", "sl", "Armenski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1497", "hy", "so", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1498", "hy", "sq", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1499", "hy", "sr", "јерменски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1500", "hy", "sv", "Armeniska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1501", "hy", "ta", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1502", "hy", "th", "อาร์เมเนีย");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1503", "hy", "tr", "Ermenice");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1504", "hy", "uk", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1505", "hy", "ur", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1506", "hy", "uz", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1507", "hy", "vi", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1508", "hy", "yi", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1509", "hy", "zh-hans", "亚美尼亚语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1510", "hy", "zu", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1511", "hy", "zh-hant", "亞美尼亞語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1512", "hy", "ms", "Armenian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1513", "id", "en", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1514", "id", "es", "Indonesio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1515", "id", "de", "Indonesisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1516", "id", "fr", "Indonésien");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1517", "id", "ar", "الأندونيسية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1518", "id", "bs", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1519", "id", "bg", "Индонезийски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1520", "id", "ca", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1521", "id", "cs", "Indonéský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1522", "id", "sk", "Indonézčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1523", "id", "cy", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1524", "id", "da", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1525", "id", "el", "Ινδονησιακα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1526", "id", "eo", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1527", "id", "et", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1528", "id", "eu", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1529", "id", "fa", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1530", "id", "fi", "indonesia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1531", "id", "ga", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1532", "id", "he", "אינדונזית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1533", "id", "hi", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1534", "id", "hr", "Indonezijski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1535", "id", "hu", "indonéz");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1536", "id", "hy", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1537", "id", "id", "Indonesia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1538", "id", "is", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1539", "id", "it", "Indonesiano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1540", "id", "ja", "インドネシア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1541", "id", "ko", "인도네시아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1542", "id", "ku", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1543", "id", "la", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1544", "id", "lv", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1545", "id", "lt", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1546", "id", "mk", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1547", "id", "mt", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1548", "id", "mn", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1549", "id", "ne", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1550", "id", "nl", "Indonesisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1551", "id", "nb", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1552", "id", "pa", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1553", "id", "pl", "indonezyjski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1554", "id", "pt-pt", "Indonésio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1555", "id", "pt-br", "Indonésio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1556", "id", "qu", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1557", "id", "ro", "Indoneziană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1558", "id", "ru", "Индонезийский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1559", "id", "sl", "Indonezijski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1560", "id", "so", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1561", "id", "sq", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1562", "id", "sr", "индонезијски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1563", "id", "sv", "Indonesiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1564", "id", "ta", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1565", "id", "th", "อินโดนีเซีย");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1566", "id", "tr", "Endonezya dili");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1567", "id", "uk", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1568", "id", "ur", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1569", "id", "uz", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1570", "id", "vi", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1571", "id", "yi", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1572", "id", "zh-hans", "印度尼西亚语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1573", "id", "zu", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1574", "id", "zh-hant", "印尼語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1575", "id", "ms", "Indonesian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1576", "is", "en", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1577", "is", "es", "Islandés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1578", "is", "de", "Isländisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1579", "is", "fr", "Islandais");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1580", "is", "ar", "الأيسلاندية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1581", "is", "bs", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1582", "is", "bg", "Исландски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1583", "is", "ca", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1584", "is", "cs", "Islandský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1585", "is", "sk", "Islančina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1586", "is", "cy", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1587", "is", "da", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1588", "is", "el", "Ισλανδικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1589", "is", "eo", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1590", "is", "et", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1591", "is", "eu", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1592", "is", "fa", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1593", "is", "fi", "islanti");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1594", "is", "ga", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1595", "is", "he", "איסלנדית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1596", "is", "hi", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1597", "is", "hr", "Islandski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1598", "is", "hu", "izlandi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1599", "is", "hy", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1600", "is", "id", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1601", "is", "is", "Íslenska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1602", "is", "it", "Islandese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1603", "is", "ja", "アイスランド語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1604", "is", "ko", "아이슬랜드어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1605", "is", "ku", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1606", "is", "la", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1607", "is", "lv", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1608", "is", "lt", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1609", "is", "mk", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1610", "is", "mt", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1611", "is", "mn", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1612", "is", "ne", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1613", "is", "nl", "Ijslands");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1614", "is", "nb", "Islandsk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1615", "is", "pa", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1616", "is", "pl", "islandzki");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1617", "is", "pt-pt", "Islandês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1618", "is", "pt-br", "Islandês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1619", "is", "qu", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1620", "is", "ro", "Islandeză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1621", "is", "ru", "Исландский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1622", "is", "sl", "Islandski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1623", "is", "so", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1624", "is", "sq", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1625", "is", "sr", "исландски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1626", "is", "sv", "Isländska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1627", "is", "ta", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1628", "is", "th", "ไอซ์แลนด์");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1629", "is", "tr", "İzlandaca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1630", "is", "uk", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1631", "is", "ur", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1632", "is", "uz", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1633", "is", "vi", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1634", "is", "yi", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1635", "is", "zh-hans", "冰岛语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1636", "is", "zu", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1637", "is", "zh-hant", "冰島語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1638", "is", "ms", "Icelandic");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1639", "it", "en", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1640", "it", "es", "Italiano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1641", "it", "de", "Italienisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1642", "it", "fr", "Italien");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1643", "it", "ar", "الإيطالية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1644", "it", "bs", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1645", "it", "bg", "Италиански");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1646", "it", "ca", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1647", "it", "cs", "Ital");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1648", "it", "sk", "Taliančina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1649", "it", "cy", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1650", "it", "da", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1651", "it", "el", "Ιταλικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1652", "it", "eo", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1653", "it", "et", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1654", "it", "eu", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1655", "it", "fa", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1656", "it", "fi", "italia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1657", "it", "ga", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1658", "it", "he", "איטלקית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1659", "it", "hi", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1660", "it", "hr", "Talijanski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1661", "it", "hu", "olasz");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1662", "it", "hy", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1663", "it", "id", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1664", "it", "is", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1665", "it", "it", "Italiano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1666", "it", "ja", "イタリア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1667", "it", "ko", "이태리어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1668", "it", "ku", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1669", "it", "la", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1670", "it", "lv", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1671", "it", "lt", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1672", "it", "mk", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1673", "it", "mt", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1674", "it", "mn", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1675", "it", "ne", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1676", "it", "nl", "Italiaans");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1677", "it", "nb", "Italiensk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1678", "it", "pa", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1679", "it", "pl", "włoski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1680", "it", "pt-pt", "Italiano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1681", "it", "pt-br", "Italiano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1682", "it", "qu", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1683", "it", "ro", "Italiană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1684", "it", "ru", "Итальянский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1685", "it", "sl", "Italijanski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1686", "it", "so", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1687", "it", "sq", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1688", "it", "sr", "италијански");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1689", "it", "sv", "Italienska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1690", "it", "ta", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1691", "it", "th", "อิตาลี");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1692", "it", "tr", "İtalyanca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1693", "it", "uk", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1694", "it", "ur", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1695", "it", "uz", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1696", "it", "vi", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1697", "it", "yi", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1698", "it", "zh-hans", "意大利语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1699", "it", "zu", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1700", "it", "zh-hant", "義大利語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1701", "it", "ms", "Italian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1702", "ja", "en", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1703", "ja", "es", "Japonés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1704", "ja", "de", "Japanisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1705", "ja", "fr", "Japonais");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1706", "ja", "ar", "اليابانية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1707", "ja", "bs", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1708", "ja", "bg", "Японски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1709", "ja", "ca", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1710", "ja", "cs", "Japonský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1711", "ja", "sk", "Japonština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1712", "ja", "cy", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1713", "ja", "da", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1714", "ja", "el", "Ιαπωνικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1715", "ja", "eo", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1716", "ja", "et", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1717", "ja", "eu", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1718", "ja", "fa", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1719", "ja", "fi", "japani");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1720", "ja", "ga", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1721", "ja", "he", "יפנית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1722", "ja", "hi", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1723", "ja", "hr", "Japanski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1724", "ja", "hu", "japán");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1725", "ja", "hy", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1726", "ja", "id", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1727", "ja", "is", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1728", "ja", "it", "Giapponese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1729", "ja", "ja", "日本語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1730", "ja", "ko", "일어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1731", "ja", "ku", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1732", "ja", "la", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1733", "ja", "lv", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1734", "ja", "lt", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1735", "ja", "mk", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1736", "ja", "mt", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1737", "ja", "mn", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1738", "ja", "ne", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1739", "ja", "nl", "Japans");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1740", "ja", "nb", "Japansk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1741", "ja", "pa", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1742", "ja", "pl", "japoński");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1743", "ja", "pt-pt", "Japonês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1744", "ja", "pt-br", "Japonês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1745", "ja", "qu", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1746", "ja", "ro", "Japoneză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1747", "ja", "ru", "Японский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1748", "ja", "sl", "Japonski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1749", "ja", "so", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1750", "ja", "sq", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1751", "ja", "sr", "јапански");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1752", "ja", "sv", "Japanska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1753", "ja", "ta", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1754", "ja", "th", "ญี่ปุ่น");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1755", "ja", "tr", "Japonca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1756", "ja", "uk", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1757", "ja", "ur", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1758", "ja", "uz", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1759", "ja", "vi", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1760", "ja", "yi", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1761", "ja", "zh-hans", "日语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1762", "ja", "zu", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1763", "ja", "zh-hant", "日語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1764", "ja", "ms", "Japanese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1765", "ko", "en", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1766", "ko", "es", "Coreano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1767", "ko", "de", "Koreanisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1768", "ko", "fr", "Coréen");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1769", "ko", "ar", "الكورية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1770", "ko", "bs", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1771", "ko", "bg", "Корейски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1772", "ko", "ca", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1773", "ko", "cs", "Korejský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1774", "ko", "sk", "Kórejčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1775", "ko", "cy", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1776", "ko", "da", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1777", "ko", "el", "Κορεατικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1778", "ko", "eo", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1779", "ko", "et", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1780", "ko", "eu", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1781", "ko", "fa", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1782", "ko", "fi", "korea");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1783", "ko", "ga", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1784", "ko", "he", "קוראנית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1785", "ko", "hi", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1786", "ko", "hr", "Korejski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1787", "ko", "hu", "koreai");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1788", "ko", "hy", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1789", "ko", "id", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1790", "ko", "is", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1791", "ko", "it", "Coreano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1792", "ko", "ja", "韓国語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1793", "ko", "ko", "한국어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1794", "ko", "ku", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1795", "ko", "la", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1796", "ko", "lv", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1797", "ko", "lt", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1798", "ko", "mk", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1799", "ko", "mt", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1800", "ko", "mn", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1801", "ko", "ne", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1802", "ko", "nl", "Koreaans");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1803", "ko", "nb", "Koreanske");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1804", "ko", "pa", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1805", "ko", "pl", "koreański");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1806", "ko", "pt-pt", "Coreano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1807", "ko", "pt-br", "Coreano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1808", "ko", "qu", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1809", "ko", "ro", "Coreană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1810", "ko", "ru", "Корейский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1811", "ko", "sl", "Korejski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1812", "ko", "so", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1813", "ko", "sq", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1814", "ko", "sr", "корејски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1815", "ko", "sv", "Koreanska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1816", "ko", "ta", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1817", "ko", "th", "เกาหลี");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1818", "ko", "tr", "Kore dili");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1819", "ko", "uk", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1820", "ko", "ur", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1821", "ko", "uz", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1822", "ko", "vi", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1823", "ko", "yi", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1824", "ko", "zh-hans", "韩语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1825", "ko", "zu", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1826", "ko", "zh-hant", "韓語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1827", "ko", "ms", "Korean");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1828", "ku", "en", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1829", "ku", "es", "Kurdo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1830", "ku", "de", "Kurdisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1831", "ku", "fr", "Kurde");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1832", "ku", "ar", "الكردية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1833", "ku", "bs", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1834", "ku", "bg", "Кюрдски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1835", "ku", "ca", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1836", "ku", "cs", "Kurdský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1837", "ku", "sk", "Kurdština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1838", "ku", "cy", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1839", "ku", "da", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1840", "ku", "el", "Κουρδικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1841", "ku", "eo", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1842", "ku", "et", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1843", "ku", "eu", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1844", "ku", "fa", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1845", "ku", "fi", "kurdi");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1846", "ku", "ga", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1847", "ku", "he", "כורדית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1848", "ku", "hi", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1849", "ku", "hr", "Kurdski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1850", "ku", "hu", "kurd");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1851", "ku", "hy", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1852", "ku", "id", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1853", "ku", "is", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1854", "ku", "it", "Curdo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1855", "ku", "ja", "クルド語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1856", "ku", "ko", "쿠르드어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1857", "ku", "ku", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1858", "ku", "la", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1859", "ku", "lv", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1860", "ku", "lt", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1861", "ku", "mk", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1862", "ku", "mt", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1863", "ku", "mn", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1864", "ku", "ne", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1865", "ku", "nl", "Koerdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1866", "ku", "nb", "Kurdisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1867", "ku", "pa", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1868", "ku", "pl", "kurdyjski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1869", "ku", "pt-pt", "Curdo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1870", "ku", "pt-br", "Curdo");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1871", "ku", "qu", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1872", "ku", "ro", "Kurdă");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1873", "ku", "ru", "Курдский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1874", "ku", "sl", "Kurdščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1875", "ku", "so", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1876", "ku", "sq", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1877", "ku", "sr", "курдски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1878", "ku", "sv", "Kurdiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1879", "ku", "ta", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1880", "ku", "th", "เคอร์ดิช");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1881", "ku", "tr", "Kürtçe");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1882", "ku", "uk", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1883", "ku", "ur", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1884", "ku", "uz", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1885", "ku", "vi", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1886", "ku", "yi", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1887", "ku", "zh-hans", "库尔德语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1888", "ku", "zu", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1889", "ku", "zh-hant", "庫爾德語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1890", "ku", "ms", "Kurdish");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1891", "la", "en", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1892", "la", "es", "Latín");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1893", "la", "de", "Latein");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1894", "la", "fr", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1895", "la", "ar", "اللاتينية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1896", "la", "bs", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1897", "la", "bg", "Латински");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1898", "la", "ca", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1899", "la", "cs", "Latina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1900", "la", "sk", "Latinčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1901", "la", "cy", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1902", "la", "da", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1903", "la", "el", "Λατινικη");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1904", "la", "eo", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1905", "la", "et", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1906", "la", "eu", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1907", "la", "fa", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1908", "la", "fi", "latina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1909", "la", "ga", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1910", "la", "he", "לטינית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1911", "la", "hi", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1912", "la", "hr", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1913", "la", "hu", "latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1914", "la", "hy", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1915", "la", "id", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1916", "la", "is", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1917", "la", "it", "Latino");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1918", "la", "ja", "ラテン語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1919", "la", "ko", "라틴어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1920", "la", "ku", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1921", "la", "la", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1922", "la", "lv", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1923", "la", "lt", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1924", "la", "mk", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1925", "la", "mt", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1926", "la", "mn", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1927", "la", "ne", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1928", "la", "nl", "Latijn");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1929", "la", "nb", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1930", "la", "pa", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1931", "la", "pl", "łaciński");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1932", "la", "pt-pt", "Latim");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1933", "la", "pt-br", "Latim");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1934", "la", "qu", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1935", "la", "ro", "Latină");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1936", "la", "ru", "Латинский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1937", "la", "sl", "Latinščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1938", "la", "so", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1939", "la", "sq", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1940", "la", "sr", "латински");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1941", "la", "sv", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1942", "la", "ta", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1943", "la", "th", "ละติน");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1944", "la", "tr", "Latince");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1945", "la", "uk", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1946", "la", "ur", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1947", "la", "uz", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1948", "la", "vi", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1949", "la", "yi", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1950", "la", "zh-hans", "拉丁语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1951", "la", "zu", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1952", "la", "zh-hant", "拉丁語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1953", "la", "ms", "Latin");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1954", "lv", "en", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1955", "lv", "es", "Letón");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1956", "lv", "de", "Lettisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1957", "lv", "fr", "Letton");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1958", "lv", "ar", "اللاتفية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1959", "lv", "bs", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1960", "lv", "bg", "Латвийски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1961", "lv", "ca", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1962", "lv", "cs", "Lotyština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1963", "lv", "sk", "Lotyština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1964", "lv", "cy", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1965", "lv", "da", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1966", "lv", "el", "Λετονικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1967", "lv", "eo", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1968", "lv", "et", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1969", "lv", "eu", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1970", "lv", "fa", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1971", "lv", "fi", "latvia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1972", "lv", "ga", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1973", "lv", "he", "לטבית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1974", "lv", "hi", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1975", "lv", "hr", "Letonski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1976", "lv", "hu", "lett");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1977", "lv", "hy", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1978", "lv", "id", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1979", "lv", "is", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1980", "lv", "it", "Lettone");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1981", "lv", "ja", "ラトビア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1982", "lv", "ko", "라트비아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1983", "lv", "ku", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1984", "lv", "la", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1985", "lv", "lv", "Latviešu");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1986", "lv", "lt", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1987", "lv", "mk", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1988", "lv", "mt", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1989", "lv", "mn", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1990", "lv", "ne", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1991", "lv", "nl", "Lets");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1992", "lv", "nb", "Latvisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1993", "lv", "pa", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1994", "lv", "pl", "łotewski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1995", "lv", "pt-pt", "Letão");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1996", "lv", "pt-br", "Letão");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1997", "lv", "qu", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1998", "lv", "ro", "Letoniană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("1999", "lv", "ru", "латышский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2000", "lv", "sl", "Latvijščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2001", "lv", "so", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2002", "lv", "sq", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2003", "lv", "sr", "летонски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2004", "lv", "sv", "Lettiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2005", "lv", "ta", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2006", "lv", "th", "ลัตเวีย");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2007", "lv", "tr", "Letonca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2008", "lv", "uk", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2009", "lv", "ur", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2010", "lv", "uz", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2011", "lv", "vi", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2012", "lv", "yi", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2013", "lv", "zh-hans", "拉脱维亚语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2014", "lv", "zu", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2015", "lv", "zh-hant", "拉脫維亞語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2016", "lv", "ms", "Latvian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2017", "lt", "en", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2018", "lt", "es", "Lituano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2019", "lt", "de", "Litauisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2020", "lt", "fr", "Lituanien");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2021", "lt", "ar", "اللتوانية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2022", "lt", "bs", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2023", "lt", "bg", "Литовски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2024", "lt", "ca", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2025", "lt", "cs", "litevský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2026", "lt", "sk", "Litovčina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2027", "lt", "cy", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2028", "lt", "da", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2029", "lt", "el", "Λιθουανικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2030", "lt", "eo", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2031", "lt", "et", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2032", "lt", "eu", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2033", "lt", "fa", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2034", "lt", "fi", "liettua");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2035", "lt", "ga", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2036", "lt", "he", "ליטאית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2037", "lt", "hi", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2038", "lt", "hr", "Litvanski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2039", "lt", "hu", "litván");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2040", "lt", "hy", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2041", "lt", "id", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2042", "lt", "is", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2043", "lt", "it", "Lituano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2044", "lt", "ja", "リトアニア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2045", "lt", "ko", "리투아니아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2046", "lt", "ku", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2047", "lt", "la", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2048", "lt", "lv", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2049", "lt", "lt", "Lietuvos");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2050", "lt", "mk", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2051", "lt", "mt", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2052", "lt", "mn", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2053", "lt", "ne", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2054", "lt", "nl", "Litouws");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2055", "lt", "nb", "Litauisk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2056", "lt", "pa", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2057", "lt", "pl", "litewski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2058", "lt", "pt-pt", "Lituano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2059", "lt", "pt-br", "Lituano");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2060", "lt", "qu", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2061", "lt", "ro", "Lituaniană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2062", "lt", "ru", "Литовский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2063", "lt", "sl", "Litovščina");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2064", "lt", "so", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2065", "lt", "sq", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2066", "lt", "sr", "литвански");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2067", "lt", "sv", "Litauiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2068", "lt", "ta", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2069", "lt", "th", "ลิธัวเนีย");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2070", "lt", "tr", "Litvanyaca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2071", "lt", "uk", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2072", "lt", "ur", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2073", "lt", "uz", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2074", "lt", "vi", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2075", "lt", "yi", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2076", "lt", "zh-hans", "立陶宛语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2077", "lt", "zu", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2078", "lt", "zh-hant", "立陶宛語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2079", "lt", "ms", "Lithuanian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2080", "mk", "en", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2081", "mk", "es", "Macedonio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2082", "mk", "de", "Mazedonisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2083", "mk", "fr", "Macédonien");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2084", "mk", "ar", "المقدونية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2085", "mk", "bs", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2086", "mk", "bg", "Македонски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2087", "mk", "ca", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2088", "mk", "cs", "Makedonský");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2089", "mk", "sk", "Macedónština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2090", "mk", "cy", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2091", "mk", "da", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2092", "mk", "el", "Μακεδονικο");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2093", "mk", "eo", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2094", "mk", "et", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2095", "mk", "eu", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2096", "mk", "fa", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2097", "mk", "fi", "makedonia");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2098", "mk", "ga", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2099", "mk", "he", "מקדונית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2100", "mk", "hi", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2101", "mk", "hr", "Makedonski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2102", "mk", "hu", "macedón");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2103", "mk", "hy", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2104", "mk", "id", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2105", "mk", "is", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2106", "mk", "it", "Macedone");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2107", "mk", "ja", "マケドニア語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2108", "mk", "ko", "마케도니아어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2109", "mk", "ku", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2110", "mk", "la", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2111", "mk", "lv", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2112", "mk", "lt", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2113", "mk", "mk", "македонски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2114", "mk", "mt", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2115", "mk", "mn", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2116", "mk", "ne", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2117", "mk", "nl", "Macedonisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2118", "mk", "nb", "Makedonsk");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2119", "mk", "pa", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2120", "mk", "pl", "macedoński");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2121", "mk", "pt-pt", "Macedônio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2122", "mk", "pt-br", "Macedônio");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2123", "mk", "qu", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2124", "mk", "ro", "Macedoniană");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2125", "mk", "ru", "Македонский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2126", "mk", "sl", "Makedonski");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2127", "mk", "so", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2128", "mk", "sq", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2129", "mk", "sr", "македонски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2130", "mk", "sv", "Makedonska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2131", "mk", "ta", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2132", "mk", "th", "มาซิโดเนีย");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2133", "mk", "tr", "Makedonyaca");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2134", "mk", "uk", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2135", "mk", "ur", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2136", "mk", "uz", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2137", "mk", "vi", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2138", "mk", "yi", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2139", "mk", "zh-hans", "马其顿语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2140", "mk", "zu", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2141", "mk", "zh-hant", "馬其頓語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2142", "mk", "ms", "Macedonian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2143", "mt", "en", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2144", "mt", "es", "Maltés");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2145", "mt", "de", "Maltesisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2146", "mt", "fr", "Maltais");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2147", "mt", "ar", "المالطية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2148", "mt", "bs", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2149", "mt", "bg", "Малтийски");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2150", "mt", "ca", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2151", "mt", "cs", "Maltština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2152", "mt", "sk", "Maltézština");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2153", "mt", "cy", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2154", "mt", "da", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2155", "mt", "el", "Μαλτεζικα");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2156", "mt", "eo", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2157", "mt", "et", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2158", "mt", "eu", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2159", "mt", "fa", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2160", "mt", "fi", "malta");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2161", "mt", "ga", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2162", "mt", "he", "מלטזית");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2163", "mt", "hi", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2164", "mt", "hr", "Malteški");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2165", "mt", "hu", "máltai");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2166", "mt", "hy", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2167", "mt", "id", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2168", "mt", "is", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2169", "mt", "it", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2170", "mt", "ja", "マルタ語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2171", "mt", "ko", "몰타어");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2172", "mt", "ku", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2173", "mt", "la", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2174", "mt", "lv", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2175", "mt", "lt", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2176", "mt", "mk", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2177", "mt", "mt", "Malti");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2178", "mt", "mn", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2179", "mt", "ne", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2180", "mt", "nl", "Maltees");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2181", "mt", "nb", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2182", "mt", "pa", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2183", "mt", "pl", "maltański");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2184", "mt", "pt-pt", "Maltês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2185", "mt", "pt-br", "Maltês");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2186", "mt", "qu", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2187", "mt", "ro", "Malteză");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2188", "mt", "ru", "Мальтийский");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2189", "mt", "sl", "Malteški");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2190", "mt", "so", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2191", "mt", "sq", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2192", "mt", "sr", "малтешки");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2193", "mt", "sv", "Maltesiska");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2194", "mt", "ta", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2195", "mt", "th", "มอลทีส");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2196", "mt", "tr", "Malta dili");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2197", "mt", "uk", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2198", "mt", "ur", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2199", "mt", "uz", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2200", "mt", "vi", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2201", "mt", "yi", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2202", "mt", "zh-hans", "马耳他语");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2203", "mt", "zu", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2204", "mt", "zh-hant", "馬爾他語");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2205", "mt", "ms", "Maltese");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2206", "mn", "en", "Mongolian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2207", "mn", "es", "Mongol");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2208", "mn", "de", "Mongolisch");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2209", "mn", "fr", "Mongol");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2210", "mn", "ar", "المنغولية");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2211", "mn", "bs", "Mongolian");
INSERT INTO `wp_gtj8dk_icl_languages_translations` VALUES("2212", "mn", "bg", "Монголски");
INSERT INTO `wp_gtj8dk_icl_langu