<?php

// lmm visual composer ---------------------------------------------------------

if (class_exists('WPBakeryVisualComposerAbstract')) {

    add_action('init', 'lmmmenu_vc', 14);

    function lmmmenu_vc() {

        class WPBakeryShortCode_lmmmenu_vc extends WPBakeryShortCode {

            protected function content($atts, $content = null) {

                $theme_location = '';
                
                $allow_metaboxes = '';

                extract(shortcode_atts(array('theme_location' => ''), $atts));

                if (!$theme_location) {
                    _e('Select theme location', 'lmm');
                    return;
                }

                $args = array(
                    'echo' => false,
                    'allow_metaboxes' => $allow_metaboxes == 'false' ? false : true,
                    'theme_location' => $theme_location,
                );

                return lmmmenu($args);

                //return do_shortcode('[lmmmenu theme_location="' . $theme_location . '"]') . "\n";
            }

        }

        vc_map(
                array('base' => 'lmmmenu_vc',
                    'name' => __('LMM Menu', 'lmm'),
                    'icon' => '',
                    'category' => __('Content', 'lmm'),
                    'description' => __('LMM Menu shortcode', 'lmm'),
                    'params' => array(
                        array(
                            'type' => 'dropdown',
                            'heading' => __('Theme Location', 'lmm'),
                            'param_name' => 'theme_location',
                            'value' => lmm_vc_locations(),
                            'description' => __('Choose a menu theme location.', 'lmm')
                        ),
                    )
                )
        );
    }

    function lmm_vc_locations($locations = array()) {

        global $lmm_locations;

        foreach ($lmm_locations as $key => $location) {

            if (!$location['instance'] || !$location['subsection'])
                continue;

            $locations[$location['name']] = $key;
        }

        return $locations;
    }

}
