<?php

function lmm_getfonticons($get = 'name', $return = array()) {

    global $lmm_icons;

    if (!is_array($lmm_icons))
        return;

    foreach ($lmm_icons as $font => $values) {

        if (!isset($values[$get]))
            continue;

        $return[$font] = $values[$get];
    }

    return $return;
}

// config developer options ----------------------------------------------------
function lmm_options_developer($options = array(), $developer = array()) {

    $developer = apply_filters('lmm_hook_options_developer', $developer);

    if (empty($developer) || !is_array($developer))
        return false;

    $options = array_merge($options, $developer);

    return $options;
}

// config user options ---------------------------------------------------------

function lmm_options_config($sections, $defaults = array()) {

    $defaults = apply_filters('lmm_hook_options_config_defaults', $defaults);

    $sections[] = array(
        'id' => 'lmm_config',
        'title' => __('Config', 'lmm'),
        'icon' => 'lmm-cog',
        'customizer' => false,
        'permissions' => 'manage_options',
        'fields' => array(
            array(
                'id' => 'lmm_locations',
                'type' => 'checkbox',
                'data' => 'menu_locations',
                'title' => __('Locations', 'lmm'),
                'subtitle' => __('Activate lmm in these theme locations.', 'lmm'),
                'default' => $defaults['lmm_locations']
            ),
            array(
                'id' => 'lmm_widgets',
                'type' => 'custom_locations',
                'title' => __('Widget Areas', 'lmm'),
                'subtitle' => __('Register your custom sidebars.', 'lmm'),
                'slug' => 'lmm-widget',
                'validate' => 'no_special_chars',
                'default' => $defaults['lmm_widgets']
            ),
            array(
                'id' => 'lmm_viewport',
                'type' => 'switch',
                'title' => __('Viewport', 'lmm'),
                'subtitle' => __('Include the viewport meta tag in site head.', 'lmm'),
                'compiler' => false,
                'default' => $defaults['lmm_viewport'],
            ),
            array(
                'id' => 'lmm_styles',
                'type' => 'switch',
                'title' => __('Stylesheet', 'lmm'),
                'subtitle' => __('Load lmmmenu styles in your theme.', 'lmm'),
                'compiler' => false,
                'default' => $defaults['lmm_styles'],
            ),
            array(
                'id' => 'lmm_styles_normalize',
                'type' => 'switch',
                'title' => __('Normalize', 'lmm'),
                'subtitle' => __('Try to clean residual styling of the theme.', 'lmm'),
                'required' => array(
                    'lmm_styles',
                    '=',
                    1
                ),
                'compiler' => false,
                'default' => $defaults['lmm_styles_normalize'],
            ),
            array(
                'id' => 'lmm_styles_bootstrap',
                'type' => 'switch',
                'title' => __('Bootstrap', 'lmm'),
                'subtitle' => __('Load necessary bootstrap 3 styles.', 'lmm'),
                'required' => array(
                    'lmm_styles',
                    '=',
                    1
                ),
                'compiler' => false,
                'default' => $defaults['lmm_styles_bootstrap'],
            ),
            array(
                'id' => 'lmm_styles_widgets',
                'type' => 'switch',
                'title' => __('Widgets', 'lmm'),
                'subtitle' => __('Load LMM default widgets style.', 'lmm'),
                'required' => array(
                    'lmm_styles',
                    '=',
                    1
                ),
                'compiler' => false,
                'default' => $defaults['lmm_styles_widgets'],
            ),
            array(
                'id' => 'lmm_styles_pscrollbar',
                'type' => 'switch',
                'title' => __('Perfect ScrollBar', 'lmm'),
                'subtitle' => __('Perfect scroll bar for vertical menus.', 'lmm'),
                'compiler' => false,
                'default' => $defaults['lmm_styles_pscrollbar'],
            ),
            array(
                'id' => 'lmm_styles_icons',
                'type' => 'select',
                'options' => lmm_getfonticons('name'),
                'title' => __('Font Icons', 'lmm'),
                'subtitle' => __('Select the fonticon for your menus.', 'lmm'),
                'required' => array(
                    'lmm_styles',
                    '=',
                    1
                ),
                'compiler' => false,
                'default' => $defaults['lmm_styles_icons'],
            ),
        ),
    );

    return $sections;
}

// general options -------------------------------------------------------------

function lmm_options_general($sections, $defaults = array()) {

    $defaults = apply_filters('lmm_hook_options_general_defaults', $defaults);

    $sections[] = array(
        'id' => 'lmm_general',
        'title' => __('General', 'lmm'),
        'icon' => 'lmm-params',
        'customizer' => false,
        'permissions' => 'edit_theme_options',
        'fields' => array(
            array(
                'id' => 'scheme_lmm_navbar_breakpoint',
                'type' => 'slider',
                'title' => __('Breakpoint', 'lmm'),
                'subtitle' => __('Point at which the navbar becomes uncollapsed.', 'lmm'),
                'min' => '480',
                'step' => '1',
                'max' => '940',
                'compiler' => true,
                'default' => $defaults['scheme_lmm_navbar_breakpoint']
            ),
            array(
                'id' => 'scheme_lmm_container_gutter',
                'type' => 'slider',
                'title' => __('Gutter', 'lmm'),
                'subtitle' => __('Padding between columns. Gets divided in half for the left and right.', 'lmm'),
                'min' => '0',
                'step' => '2',
                'max' => '60',
                'compiler' => true,
                'default' => $defaults['scheme_lmm_container_gutter']
            ),
            // fonts --------------------------------------------
            // -------------------------------------------------------------
            array(
                'id' => 'fonts_divider',
                'type' => 'section',
                'title' => __('Fonts', 'lmm'),
                'indent' => false
            ),
            array(
                'id' => 'scheme_lmm_general_font',
                'type' => 'typography',
                'title' => __('General Font', 'lmm'),
                'subtitle' => __('Specify the font properties.', 'lmm'),
                'font-weight' => true,
                'font-size' => true,
                'line-height' => false,
                'google' => true,
                'text-align' => false,
                'color' => false,
                'subsets' => true,
                'compiler' => true,
                'default' => $defaults['scheme_lmm_general_font']
            ),
            array(
                'id' => 'scheme_lmm_navbar_font',
                'type' => 'typography',
                'title' => __('Navbar Font', 'lmm'),
                'subtitle' => __('Specify the font properties.', 'lmm'),
                'font-weight' => true,
                'font-size' => true,
                'line-height' => false,
                'google' => true,
                'text-align' => false,
                'color' => false,
                'subsets' => true,
                'compiler' => true,
                'default' => $defaults['scheme_lmm_navbar_font']
            ),
            array(
                'id' => 'scheme_lmm_dropdown_font',
                'type' => 'typography',
                'title' => __('Dropdown Font', 'lmm'),
                'subtitle' => __('Specify the font properties.', 'lmm'),
                'font-weight' => true,
                'font-size' => true,
                'line-height' => false,
                'google' => true,
                'text-align' => false,
                'color' => false,
                'subsets' => true,
                'compiler' => true,
                'default' => $defaults['scheme_lmm_dropdown_font']
            ),
        )
    );

    $sections[] = array(
        'id' => 'lmm_bootstrap',
        'title' => __('Bootstrap', 'lmm'),
        //'icon' => 'fa fa-cogs',
        'subsection' => true,
        'customizer' => false,
        'permissions' => 'edit_theme_options',
        'fields' => array(
            array(
                'id' => 'bootstrap_info',
                'type' => 'info',
                'title' => __('Bootstrap Deactivated', 'lmm'),
                'style' => 'critical',
                'desc' => sprintf('<p>%1$s</p><p>%2$s</p>', __('You\'ve deactivated the bootstrap stylesheet load. This options will not take effect.', 'lmm'), __('Make sure your theme is loading the bootstrap stylesheet and javascript files otherwise the menu will not work correctly', 'lmm')),
                'required' => array(
                    'lmm_styles_bootstrap',
                    '!=',
                    1
                ),
            ),
            array(
                'id' => 'scheme_lmm_screen_md_width',
                'type' => 'slider',
                'title' => __('Screen Medium', 'lmm'),
                'subtitle' => __('Medium screens breakpoint.', 'lmm'),
                'min' => '800',
                'step' => '1',
                'max' => '1200',
                'compiler' => true,
                'default' => $defaults['scheme_lmm_screen_md_width']
            ),
            array(
                'id' => 'scheme_lmm_screen_lg_width',
                'type' => 'slider',
                'title' => __('Screen Large', 'lmm'),
                'subtitle' => __('Large screens breakpoint.', 'lmm'),
                'min' => '801',
                'step' => '1',
                'max' => '1600',
                'compiler' => true,
                'default' => $defaults['scheme_lmm_screen_lg_width']
            ),
            // container -------------------------------------------------------
            // -----------------------------------------------------------------
            array(
                'id' => 'container_divider',
                'type' => 'section',
                'title' => __('Container Width', 'lmm'),
                'indent' => false
            ),
            array(
                'id' => 'scheme_lmm_container_small_width',
                'type' => 'slider',
                'title' => __('Small', 'lmm'),
                'subtitle' => __('Container max width in small screens (Breakpoint or lower).', 'lmm'),
                'min' => '480',
                'step' => '2',
                'max' => '992',
                'compiler' => true,
                'default' => $defaults['scheme_lmm_container_small_width']
            ),
            array(
                'id' => 'scheme_lmm_container_medium_width',
                'type' => 'slider',
                'title' => __('Medium', 'lmm'),
                'subtitle' => __('Container max width in medium screens.', 'lmm'),
                'min' => '768',
                'step' => '2',
                'max' => '992',
                'compiler' => true,
                'default' => $defaults['scheme_lmm_container_medium_width']
            ),
            array(
                'id' => 'scheme_lmm_container_large_width',
                'type' => 'slider',
                'title' => __('Large', 'lmm'),
                'subtitle' => __('Container max width in large screens.', 'lmm'),
                'min' => '992',
                'step' => '2',
                'max' => '1200',
                'compiler' => true,
                'default' => $defaults['scheme_lmm_container_large_width']
            ),
        )
    );

    return $sections;
}

// location options ------------------------------------------------------------

function lmm_options_locations_defaults($defaults = array()) {

    global $lmm_locations;

    $defaults = apply_filters('lmm_hook_options_locations_defaults', $defaults);

    foreach ($defaults as $default => $value) {

        if (strpos($default, 'all_') === false) {
            continue;
        }

        foreach ($lmm_locations as $key => $location) {

            $key = str_replace('all_', $key . '_', $default);

            if (isset($defaults[$key])) {
                continue;
            }

            $defaults[$key] = $value;
        }
    }

    return $defaults;
}

function lmm_options_locations($sections) {

    global $lmm_locations;

    $defaults = lmm_options_locations_defaults();

    foreach ($lmm_locations as $key => $location) {

        if (!$location['style'])
            continue;

        $sections[] = array(
            'id' => 'lmm_layout_' . $key,
            'title' => $location['name'],
            'class' => 'lmm_location_' . $key,
            'icon' => $key == 'all' ? 'lmm-th-menu-outline' : 'lmm-th-menu',
            'heading' => sprintf(__('Layout settings for %1$s', 'lmm'), $location['name']),
            'subsection' => false,
            'customizer' => false,
            'permissions' => 'edit_theme_options',
            'fields' => array(
                array(
                    'id' => $key . '_navbar_mode',
                    'type' => 'image_select',
                    'title' => __('Menu', 'lmm'),
                    'subtitle' => __('Select the menu mode in desktop screens.', 'lmm'),
                    'options' => array(
                        'horizontal' => array(
                            'alt' => __('Horizontal', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_horizontal.png'
                        ),
                        'vertical' => array(
                            'alt' => __('Vertical', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_vertical_right.png'
                        ),
                    ),
                    'default' => $defaults[$key . '_navbar_mode'],
                ),
                array(
                    'id' => $key . '_navbar_mode_horizontal',
                    'type' => 'image_select',
                    'title' => __('Mobile', 'lmm'),
                    'subtitle' => __('Select the menu mode in mobile devices.', 'lmm'),
                    'options' => array(
                        'button' => array(
                            'alt' => __('Button', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_horizontal_button.png'
                        ),
                        'collapsed' => array(
                            'alt' => __('Collapsed', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_horizontal_collapsed.png'
                        ),
                        'offcanvas' => array(
                            'alt' => __('Offcanvas', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_horizontal_offcanvas.png'
                        ),
                    ),
                    'required' => array(
                        $key . '_navbar_mode',
                        '=',
                        'horizontal'
                    ),
                    'default' => $defaults[$key . '_navbar_mode_horizontal'],
                ),
                array(
                    'id' => $key . '_navbar_mode_vertical',
                    'type' => 'image_select',
                    'title' => __('Mode', 'lmm'),
                    'subtitle' => __('Select the vertical menu mode in desktop screens.', 'lmm'),
                    'subtitle' => __('Select the menu mode in mobile devices.', 'lmm'),
                    'options' => array(
                        'button' => array(
                            'alt' => __('Button', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_vertical_button.png'
                        ),
                        'collapsed' => array(
                            'alt' => __('Collapsed', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_vertical_right.png'
                        ),
                        'inherit' => array(
                            'alt' => __('Inherit', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_vertical_inherit.png'
                        ),
                    ),
                    'required' => array(
                        $key . '_navbar_mode',
                        '=',
                        'vertical'
                    ),
                    'default' => $defaults[$key . '_navbar_mode_vertical'],
                ),
                array(
                    'id' => $key . '_navbar_mode_vertical_float',
                    'type' => 'image_select',
                    'title' => __('Float', 'lmm'),
                    'subtitle' => __('Vertical menu position.', 'lmm'),
                    'options' => array(
                        'left' => array(
                            'alt' => __('Left', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_vertical_left.png'
                        ),
                        'right' => array(
                            'alt' => __('Right', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_vertical_right.png'
                        ),
                    ),
                    'default' => $defaults[$key . '_navbar_mode_vertical_float'],
                ),
                array(
                    'id' => $key . '_navbar_mode_vertical_collapsed',
                    'type' => 'checkbox',
                    'title' => __('Hide', 'lmm'),
                    'subtitle' => __('Hide vertical menu in the next screen sizes.', 'lmm'),
                    'options' => array(
                        'offcanvas-xs' => 'XS',
                        'offcanvas-sm' => 'SM',
                        'offcanvas-md' => 'MD',
                        'offcanvas-lg' => 'LG'
                    ),
                    'default' => $defaults[$key . '_navbar_mode_vertical_collapsed'],
                ),
                array(
                    'id' => $key . '_navbar_mode_horizontal_align',
                    'type' => 'image_select',
                    'title' => __('Align Items', 'lmm'),
                    'subtitle' => __('Select the items alignment.', 'lmm'),
                    'options' => array(
                        'left' => array(
                            'alt' => __('Left', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_horizontal_align_left.png'
                        ),
                        'center' => array(
                            'alt' => __('Left', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_horizontal_align_center.png'
                        ),
                        'right' => array(
                            'alt' => __('Right', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/menu_horizontal_align_right.png'
                        ),
                    ),
                    'default' => $defaults[$key . '_navbar_mode_horizontal_align'],
                ),
                array(
                    'id' => $key . '_navbar_width',
                    'type' => 'image_select',
                    'title' => __('Width', 'lmm'),
                    'subtitle' => __('Select the size of the navbar container.', 'lmm'),
                    'options' => array(
                        'container' => array(
                            'alt' => __('Container', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/width_container.png'
                        ),
                        'container fixed' => array(
                            'alt' => __('Fixed', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/width_fixed.png'
                        ),
                        'container-fluid' => array(
                            'alt' => __('Fluid', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/width_fluid.png'
                        ),
                        'container-auto' => array(
                            'alt' => __('Auto', 'lmm'),
                            'img' => LMM_URL_ASSETS . 'backend/images/layouts/width_auto.png'
                        ),
                    ),
                    /* 'hint' => array(
                      'title' => __('Navbar & menu container width', 'lmm'),
                      'content' => __(''
                      . '<p>This options allows you to set the navbar & menu container behavour.</p>'
                      . '<p><b>Container:</b> The navbar width fits the 100% of the parent container. And the menu container will take its width depending on screen sizes. See LMM General > Bootstrap.</p>'
                      . '<p><b>Fluid:</b> The navbar width fits the 100% of the parent container. If the navbar is sticky the menu container width will be the 100% of the window.</p>'
                      . '<p><b>Auto:</b> The navbar width fits the 100% of the parent container. If the navbar is sticky the menu container width will be the same as the parent container.</p>'
                      . '<p><b>Fixed:</b> Is them same behavour as Container, but the navbar width will be the same as the menu container. This is great for floating menus.</p>', 'lmm'),
                      ), */
                    'default' => $defaults[$key . '_navbar_width'],
                ),
                array(
                    'id' => $key . '_navbar_width_container',
                    'type' => 'info',
                    'title' => __('Container', 'lmm'),
                    'style' => 'success',
                    'desc' => __('The navbar width fits the 100% of the parent container. And the menu container will take its width depending on screen sizes. See LMM General > Bootstrap.', 'lmm'),
                    'required' => array(
                        $key . '_navbar_width',
                        '=',
                        'container'
                    ),
                ),
                array(
                    'id' => $key . '_navbar_width_fluid',
                    'type' => 'info',
                    'title' => __('Fluid', 'lmm'),
                    'style' => 'success',
                    'desc' => __('The navbar width fits the 100% of the parent container. If the navbar is sticky the menu container width will be the 100% of the window.', 'lmm'),
                    'required' => array(
                        $key . '_navbar_width',
                        '=',
                        'container-fluid'
                    ),
                ),
                array(
                    'id' => $key . '_navbar_width_auto',
                    'type' => 'info',
                    'title' => __('Auto', 'lmm'),
                    'style' => 'success',
                    'desc' => __('The navbar width fits the 100% of the parent container. If the navbar is sticky the menu container width will be the same as the parent container.', 'lmm'),
                    'required' => array(
                        $key . '_navbar_width',
                        '=',
                        'container-auto'
                    ),
                ),
                array(
                    'id' => $key . '_navbar_width_fixed',
                    'type' => 'info',
                    'title' => __('Fixed', 'lmm'),
                    'style' => 'success',
                    'desc' => __('Is them same behavour as Container, but the navbar width will be the same as the menu container. This is great for floating menus.', 'lmm'),
                    'required' => array(
                        $key . '_navbar_width',
                        '=',
                        'container fixed'
                    ),
                ),
                array(
                    'id' => $key . '_navbar_classes',
                    'type' => 'text',
                    'customizer' => false,
                    'title' => __('Classes', 'lmm'),
                    'subtitle' => __('Include your own classes in the menu.', 'lmm'),
                    'default' => $defaults[$key . '_navbar_classes'],
                ),
                // navbar ---------------------------------------------------
                // -------------------------------------------------------------
                array(
                    'id' => $key . '_navbar_divider',
                    'type' => 'section',
                    'title' => __('Navbar', 'lmm'),
                    'indent' => false
                ),
                array(
                    'id' => $key . '_navbar_separator',
                    'type' => 'button_set',
                    'title' => __('Separator', 'lmm'),
                    'subtitle' => __('Show links separator.', 'lmm'),
                    'options' => array(
                        '' => __('None', 'lmm'),
                        'lmm-separators-smooth' => __('Smooth', 'lmm'),
                        'lmm-separators-sharp' => __('Sharp', 'lmm')
                    ),
                    'default' => $defaults[$key . '_navbar_separator'],
                ),
                array(
                    'id' => $key . '_navbar_caret',
                    'type' => 'button_set',
                    'title' => __('Caret', 'lmm'),
                    'subtitle' => __('Show carets on items with dropdown menus.', 'lmm'),
                    'options' => array(
                        '' => __('Show', 'lmm'),
                        'lmm-hide-carets' => __('Hide', 'lmm')
                    ),
                    'default' => $defaults[$key . '_navbar_caret'],
                ),
                array(
                    'id' => $key . '_navbar_logo',
                    'type' => 'media',
                    'title' => __('Logo', 'lmm'),
                    'subtitle' => __('Upload the navbar logo.', 'lmm'),
                    'default' => $defaults[$key . '_navbar_logo']
                ),
                array(
                    'id' => $key . '_navbar_hover_effect',
                    'type' => 'select',
                    'options' => array(
                        '' => __('None', 'lmm'),
                        'lmm-hover-slidebar sl-top' => __('SlideBar Top (Horizontal)', 'lmm'),
                        'lmm-hover-slidebar sl-middle' => __('SlideBar Middle (Horizontal)', 'lmm'),
                        'lmm-hover-slidebar sl-bottom' => __('SlideBar Bottom (Horizontal)', 'lmm'),
                    ),
                    'required' => array(
                        $key . '_navbar_mode',
                        '=',
                        'horizontal'
                    ),
                    'title' => __('Hover Effect', 'lmm'),
                    'subtitle' => __('Select the animation for the dropdowns.', 'lmm'),
                    'default' => $defaults[$key . '_navbar_hover_effect'],
                ),
                // sticky ------------------------------------------------------
                // -------------------------------------------------------------
                array(
                    'id' => $key . '_navbar_sticky_divider',
                    'type' => 'section',
                    'title' => __('Sticky', 'lmm'),
                    'indent' => false
                ),
                array(
                    'id' => $key . '_navbar_sticky',
                    'type' => 'switch',
                    'title' => __('Sticky', 'lmm'),
                    'subtitle' => __('Make the menu sticky on scroll.', 'lmm'),
                    'default' => $defaults[$key . '_navbar_sticky'],
                ),
                array(
                    'id' => $key . '_navbar_sticky_offset',
                    'type' => 'slider',
                    'title' => __('Sticky scroll offset', 'lmm'),
                    'subtitle' => __('Set the length of the scroll for each user to pass before the menu will stick to the top of the window.', 'lmm'),
                    'min' => '0',
                    'step' => '1',
                    'max' => '340',
                    'required' => array(
                        $key . '_navbar_sticky',
                        '=',
                        1
                    ),
                    'default' => $defaults[$key . '_navbar_sticky_offset'],
                ),
                array(
                    'id' => $key . '_navbar_sticky_logo',
                    'type' => 'switch',
                    'title' => __('Sticky Logo', 'lmm'),
                    'subtitle' => __('Hide logo until the navbar be sticky.', 'lmm'),
                    'required' => array(
                        $key . '_navbar_sticky',
                        '=',
                        1
                    ),
                    'default' => $defaults[$key . '_navbar_sticky_logo'],
                ),
                // dropdowns ---------------------------------------------------
                // -------------------------------------------------------------
                array(
                    'id' => $key . '_dropdown_divider',
                    'type' => 'section',
                    'title' => __('Dropdown', 'lmm'),
                    'indent' => false
                ),
                array(
                    'id' => $key . '_navbar_trigger',
                    'type' => 'button_set',
                    'title' => __('Trigger', 'lmm'),
                    'options' => array(
                        'lmm-trigger-hoverintent' => __('Hover', 'lmm'),
                        'lmm-trigger-click' => __('Click', 'lmm')
                    ),
                    'subtitle' => __('Open dropdown menu on mouseover or click.', 'lmm'),
                    'default' => $defaults[$key . '_navbar_trigger'],
                ),
                array(
                    'id' => $key . '_dropdown_triangle',
                    'type' => 'button_set',
                    'title' => __('Dropdown Triangle', 'lmm'),
                    'subtitle' => __('Show dropdown triangle.', 'lmm'),
                    'options' => array(
                        'lmm-dropdown-triangle' => __('Show', 'lmm'),
                        '' => __('Hide', 'lmm')
                    ),
                    'default' => $defaults[$key . '_dropdown_triangle'],
                ),
                array(
                    'id' => $key . '_dropdown_animation',
                    'type' => 'select',
                    'options' => apply_filters('lmm_hook_animations', array(
                        'lmm_btt' => __('Bottom to top', 'lmm'),
                        'lmm_rtl' => __('Right to left', 'lmm'),
                        'lmm_ltr' => __('Left to right', 'lmm'),
                        'lmm_hinge' => __('Hinge', 'lmm'),
                        'lmm_fadeIn' => __('FadeIn', 'lmm'),
                    )),
                    'title' => __('Dropdown Animation', 'lmm'),
                    'subtitle' => __('Select the animation for the dropdowns.', 'lmm'),
                    'default' => $defaults[$key . '_dropdown_animation'],
                ),
            ),
        );

        $sections[] = array(
            'id' => 'lmm_navbar_' . $key,
            'title' => __('Navbar', 'lmm'),
            'heading' => sprintf(__('Navbar options for %1$s', 'lmm'), $location['name']),
            //'icon' => '',
            'subsection' => true,
            'customizer' => false,
            'permissions' => 'edit_theme_options',
            'fields' => array(
                array(
                    'id' => 'scheme_' . $key . '_navbar_background',
                    'type' => 'button_set',
                    'title' => __('Background', 'lmm'),
                    'subtitle' => __('Select the navbar background.', 'lmm'),
                    'options' => array(
                        'color' => __('Color', 'lmm'),
                        'gradient' => __('Gradient', 'lmm'),
                    //'image' => __('Image', 'lmm'),
                    ),
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_background']
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_background_color',
                    'title' => __('Color', 'lmm'),
                    'subtitle' => __('Pick a background color for the navbar.', 'lmm'),
                    'type' => 'color_rgba',
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => $defaults['scheme_' . $key . '_navbar_background_color']
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_background_to',
                    'title' => __('Gradient Color', 'lmm'),
                    'subtitle' => __('Pick a background color for the navbar.', 'lmm'),
                    'type' => 'color_rgba',
                    'required' => array(
                        'scheme_' . $key . '_navbar_background',
                        '=',
                        'gradient'
                    ),
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => $defaults['scheme_' . $key . '_navbar_background_to']
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_background_deg',
                    'title' => __('Gradient Degrees', 'lmm'),
                    'subtitle' => __('Pick a degrees angle for background gradient.', 'lmm'),
                    'type' => 'spinner',
                    'min' => '0',
                    'step' => '1',
                    'max' => '360',
                    'compiler' => true,
                    'validate' => 'numeric',
                    'required' => array(
                        'scheme_' . $key . '_navbar_background',
                        '=',
                        'gradient'
                    ),
                    'default' => $defaults['scheme_' . $key . '_navbar_background_deg']
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_border',
                    'type' => 'color',
                    'title' => __('Border', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar border.', 'lmm'),
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_border']
                ),
                array(
                    'title' => __('Sharp', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar sharp separator.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_sharp',
                    'type' => 'color_rgba',
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    'required' => array(
                        $key . '_navbar_separator',
                        '=',
                        'lmm-separators-sharp'
                    ),
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => array(
                        'color' => '#ffffff',
                        'alpha' => '0.5'
                    )
                ),
                array(
                    'title' => __('Text', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar text.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_text',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_text']
                ),
                // toggle button -----------------------------------------------
                array(
                    'id' => $key . '_toggle',
                    'type' => 'section',
                    'title' => __('Toggle', 'lmm'),
                    'indent' => true
                ),
                array(
                    'title' => __('Toggle Color', 'lmm'),
                    'subtitle' => __('Pick a color for the toggle icon.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_toggle_icon',
                    'type' => 'color',
                    //'validate' => 'color',
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_toggle_icon']
                ),
                array(
                    'title' => __('Toggle Border', 'lmm'),
                    'subtitle' => __('Pick a color for the toggle button border.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_toggle_border',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_toggle_border']
                ),
                array(
                    'title' => __('Toggle Bg', 'lmm'),
                    'subtitle' => __('Pick a color for the toggle button background.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_toggle_bg',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_toggle_bg']
                ),
                array(
                    'title' => __('Toggle Hover', 'lmm'),
                    'subtitle' => __('Pick a color for the toggle button background on hover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_toggle_hover',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_toggle_hover']
                ),
                // logo background ---------------------------------------------
                array(
                    'id' => $key . '_logo',
                    'type' => 'section',
                    'title' => __('Logo', 'lmm'),
                    'indent' => true
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_logo_bg',
                    'title' => __('Background', 'lmm'),
                    'subtitle' => __('Pick a background color for the navbar logo.', 'lmm'),
                    'type' => 'color_rgba',
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => $defaults['scheme_' . $key . '_navbar_logo_bg']
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_logo_height',
                    'type' => 'slider',
                    'title' => __('Height', 'lmm'),
                    'subtitle' => __('Max logo height in px.', 'lmm'),
                    'min' => '30',
                    'step' => '2',
                    'max' => '160',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_logo_height'],
                ),
                // link --------------------------------------------------------
                array(
                    'id' => $key . '_link',
                    'type' => 'section',
                    'title' => __('Links', 'lmm'),
                    'indent' => true
                ),
                array(
                    'title' => __('Link', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar links.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link']
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_height',
                    'type' => 'slider',
                    'title' => __('Link Height', 'lmm'),
                    'subtitle' => __('Change the items height.', 'lmm'),
                    'min' => '30',
                    'step' => '2',
                    'max' => '160',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_height'],
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_width',
                    'type' => 'slider',
                    'title' => __('Link Width', 'lmm'),
                    'subtitle' => __('Change the items width.', 'lmm'),
                    'min' => '60',
                    'step' => '1',
                    'max' => '500',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_width'],
                ),
                array(
                    'title' => __('Link Hover', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar links on mousehover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_hover',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link_hover']
                ),
                array(
                    'title' => __('Link Hover Bg', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar background on mousehover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_hover_bg',
                    'type' => 'color_rgba',
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => $defaults['scheme_' . $key . '_navbar_link_hover_bg']
                ),
                array(
                    'title' => __('Link Hover Effect', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar link effect on mousehover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_hover_effect',
                    'type' => 'color_rgba',
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => $defaults['scheme_' . $key . '_navbar_link_hover_effect']
                ),
                array(
                    'title' => __('Link Transform', 'lmm'),
                    'subtitle' => __('Pick a text transform for the link.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_transform',
                    'type' => 'select',
                    'options' => array(
                        'none' => __('None', 'lmm'),
                        'capitalize' => __('Capitalize', 'lmm'),
                        'uppercase' => __('Uppercase', 'lmm'),
                        'lowercase' => __('Lowercase', 'lmm'),
                    ),
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link_transform']
                ),
                // link layout -------------------------------------------------                
                array(
                    'title' => __('Link Margin', 'lmm'),
                    'subtitle' => __('Set the margin for the navbar links.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_margin',
                    'type' => 'border',
                    'all' => false,
                    'style' => false,
                    'color' => false,
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link_margin']
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_link_radius',
                    'type' => 'slider',
                    'title' => __('Link Radius', 'lmm'),
                    'subtitle' => __('Set the radius for the navbar links.', 'lmm'),
                    'min' => '0',
                    'step' => '1',
                    'max' => '30',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link_radius'],
                ),
                // link icon ---------------------------------------------------
                array(
                    'title' => __('Icon', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar links icon.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_icon',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link_icon']
                ),
                array(
                    'title' => __('Icon Hover', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar links icon on hover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_icon_hover',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link_icon_hover']
                ),
                // link subtitle -----------------------------------------------
                array(
                    'title' => __('Subtitle', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar links subtitle.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_subtitle',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link_subtitle']
                ),
                array(
                    'title' => __('Subtitle Hover', 'lmm'),
                    'subtitle' => __('Pick a color for the navbar links subtitle on hover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_link_subtitle_hover',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_link_subtitle_hover']
                ),
                // search form -------------------------------------------------
                array(
                    'title' => __('Search Bg', 'lmm'),
                    'subtitle' => __('Pick a color for the search form.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_search_bg',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_search_bg']
                ),
                array(
                    'title' => __('Search Border', 'lmm'),
                    'subtitle' => __('Pick a color for the search form border.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_search_border',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_search_border']
                ),
                array(
                    'title' => __('Search Color', 'lmm'),
                    'subtitle' => __('Pick a color for the search form placeholder.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_search_color',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_search_color']
                ),
                // cart bubble -------------------------------------------------
                array(
                    'title' => __('Cart Bubble', 'lmm'),
                    'subtitle' => __('Pick a background color for the cart bubble.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_cart_bubble',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_cart_bubble']
                ),
                array(
                    'title' => __('Cart Bubble Color', 'lmm'),
                    'subtitle' => __('Pick a color for the cart bubble.', 'lmm'),
                    'id' => 'scheme_' . $key . '_navbar_cart_bubble_color',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_cart_bubble_color']
                ),
                // dropdown options --------------------------------------------
                // -------------------------------------------------------------
                array(
                    'id' => $key . '_sticky',
                    'type' => 'section',
                    'title' => __('Sticky Navbar', 'lmm'),
                    'indent' => true
                ),
                // sticky navbar -----------------------------------------------
                array(
                    'id' => 'scheme_' . $key . '_navbar_sticky_background',
                    'title' => __('Sticky Background', 'lmm'),
                    'subtitle' => __('Change the navbar sticky background.', 'lmm'),
                    'type' => 'color_rgba',
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    /* 'required' => array(
                      'scheme_' . $key . '_navbar_background',
                      '=',
                      'color'
                      ), */
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => $defaults['scheme_' . $key . '_navbar_sticky_background']
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_sticky_height',
                    'type' => 'slider',
                    'title' => __('Link Height', 'lmm'),
                    'subtitle' => __('Change the navbar sticky height.', 'lmm'),
                    'min' => '30',
                    'step' => '2',
                    'max' => '160',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_sticky_height'],
                ),
                array(
                    'id' => 'scheme_' . $key . '_navbar_sticky_logo_height',
                    'type' => 'slider',
                    'title' => __('Logo Height', 'lmm'),
                    'subtitle' => __('Max logo height in px.', 'lmm'),
                    'min' => '30',
                    'step' => '2',
                    'max' => '160',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_navbar_sticky_logo_height'],
                ),
            // mobile options --------------------------------------------
            /* -------------------------------------------------------------
              array(
              'id' => $key . '_mobile',
              'type' => 'section',
              'title' => __('Mobile Navbar', 'lmm'),
              'indent' => true
              ),
              array(
              'id' => 'scheme_' . $key . '_navbar_mobile_background',
              'title' => __('Navbar Background', 'lmm'),
              'subtitle' => __('Change the navbar background on mobile devices.', 'lmm'),
              'type' => 'color_rgba',
              'compiler' => true,
              'validate' => 'colorrgba',
              'options' => array(
              'allow_empty' => false,
              ),
              'default' => $defaults['scheme_' . $key . '_navbar_mobile_background']
              ), */
            )
        );

        $sections[] = array(
            'id' => 'lmm_dropdown_' . $key,
            'title' => __('Dropdown', 'lmm'),
            'heading' => sprintf(__('Dropdown options for %1$s', 'lmm'), $location['name']),
            //'icon' => '',
            'subsection' => true,
            'customizer' => false,
            'permissions' => 'edit_theme_options',
            'fields' => array(
                array(
                    'id' => 'scheme_' . $key . '_dropdown_margin',
                    'type' => 'slider',
                    'title' => __('Dropdown Margin', 'lmm'),
                    'subtitle' => __('Dropdown margin top.', 'lmm'),
                    'min' => '0',
                    'step' => '1',
                    'max' => '45',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_margin'],
                ),
                array(
                    'id' => 'scheme_' . $key . '_dropdown_radius',
                    'type' => 'slider',
                    'title' => __('Dropdown Radius', 'lmm'),
                    'subtitle' => __('Dropdown border radius.', 'lmm'),
                    'min' => '0',
                    'step' => '1',
                    'max' => '30',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_radius'],
                ),
                array(
                    'title' => __('Dropdown Border', 'lmm'),
                    'subtitle' => __('Pick a border color for the dropdown border.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_border',
                    'compiler' => true,
                    'type' => 'border',
                    'style' => false,
                    'default' => $defaults['scheme_' . $key . '_dropdown_border']
                ),
                array(
                    'title' => __('Dropdown Background', 'lmm'),
                    'subtitle' => __('Pick a background color for the dropdown menu.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_background',
                    'type' => 'color_rgba',
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => $defaults['scheme_' . $key . '_dropdown_background']
                ),
                // dropdown title ----------------------------------------------
                array(
                    'title' => __('Title', 'lmm'),
                    'subtitle' => __('Pick a color for the dropdown menu title.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_title',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_title']
                ),
                array(
                    'title' => __('Title Border', 'lmm'),
                    'subtitle' => __('Pick a color for the dropdown menu title border.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_title_border',
                    'type' => 'border',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_title_border']
                ),
                // dropdown link -----------------------------------------------
                array(
                    'title' => __('Link', 'lmm'),
                    'subtitle' => __('Pick a color for the dropdown menu links.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_link']
                ),
                array(
                    'title' => __('Link Hover', 'lmm'),
                    'subtitle' => __('Pick a color for the dropdown menu links on mousehover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link_hover',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_link_hover']
                ),
                array(
                    'title' => __('Link Hover Bg', 'lmm'),
                    'subtitle' => __('Pick a background color for the links onmouseover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link_hover_bg',
                    'type' => 'color_rgba',
                    'compiler' => true,
                    'validate' => 'colorrgba',
                    'options' => array(
                        'allow_empty' => false,
                    ),
                    'default' => $defaults['scheme_' . $key . '_dropdown_link_hover_bg']
                ),
                array(
                    'title' => __('Link Border', 'lmm'),
                    'subtitle' => __('Pick a border color for the dropdown menu links border.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link_border',
                    'compiler' => true,
                    'type' => 'border',
                    'default' => $defaults['scheme_' . $key . '_dropdown_link_border']
                ),
                array(
                    'title' => __('Link Transform', 'lmm'),
                    'subtitle' => __('Pick a text transform for the link.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link_transform',
                    'type' => 'select',
                    'options' => array(
                        'none' => __('None', 'lmm'),
                        'capitalize' => __('Capitalize', 'lmm'),
                        'uppercase' => __('Uppercase', 'lmm'),
                        'lowercase' => __('Lowercase', 'lmm'),
                    ),
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_link_transform']
                ),
                // dropdown link icon --------------------------------------
                array(
                    'title' => __('Icon', 'lmm'),
                    'icon' => __('Pick a color for the dropdown links icon.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link_icon',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_link_icon']
                ),
                array(
                    'title' => __('Icon Hover', 'lmm'),
                    'icon' => __('Pick a color for the dropdown links icon on hover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link_icon_hover',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_link_icon_hover']
                ),
                // dropdown link subtitle --------------------------------------
                array(
                    'title' => __('Subtitle', 'lmm'),
                    'subtitle' => __('Pick a color for the dropdown links subtitle.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link_subtitle',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_link_subtitle']
                ),
                array(
                    'title' => __('Subtitle Hover', 'lmm'),
                    'subtitle' => __('Pick a color for the dropdown links subtitle on hover.', 'lmm'),
                    'id' => 'scheme_' . $key . '_dropdown_link_subtitle_hover',
                    'type' => 'color',
                    //'validate' => 'color',                    
                    'validate' => 'not_empty',
                    'compiler' => true,
                    'default' => $defaults['scheme_' . $key . '_dropdown_link_subtitle_hover']
                ),
            ),
        );

        $sections[] = array(
            'id' => 'lmm_integration_' . $key,
            'title' => __('Integration', 'lmm'),
            'heading' => sprintf(__('Integration options for %1$s', 'lmm'), $location['name']),
            //'icon' => '',
            'subsection' => true,
            'customizer' => false,
            'permissions' => 'edit_theme_options',
            'fields' => array(
                array(
                    'id' => $key . '_integration',
                    'type' => 'button_set',
                    'title' => __('Integration', 'lmm'),
                    'subtitle' => __('Select the method to integrate this menu location in your theme and use the provided integration instructions.', 'lmm'),
                    'options' => array(
                        'manual' => __('Manual', 'lmm'),
                        'auto' => __('Auto', 'lmm'),
                    ),
                    'customizer' => false,
                    'default' => $defaults[$key . '_integration'],
                ),
                array(
                    'id' => $key . '_integration_filters',
                    'type' => 'switch',
                    'title' => __('Remove Theme Filters', 'lmm'),
                    'subtitle' => __('Remove theme filters that may interfere with the menu behavior.', 'lmm'),
                    'required' => array(
                        $key . '_integration',
                        '=',
                        'auto'
                    ),
                    'customizer' => false,
                    'default' => $defaults[$key . '_integration_filters'],
                ),
                array(
                    'id' => $key . '_info_auto',
                    'type' => 'info',
                    'title' => __('Automatic Integration', 'lmm'),
                    'style' => 'success',
                    'desc' => sprintf('
                            <p>%1$s</p>
                            <p>%2$s</p>'
                            , __('Insert menu in this theme location automatically. Works with most modularly coded themes.', 'lmm')
                            , __('If your menu doesnt seem to be working properly after using Automatic Integration, the most common scenario is that you have residual styling from your theme and would need to use Manual Integration instead.', 'lmm')
                    ),
                    'customizer' => false,
                    'required' => array(
                        $key . '_integration',
                        '=',
                        'auto'
                    ),
                ),
                array(
                    'id' => $key . '_info_manual',
                    'type' => 'info',
                    'title' => __('Manual Integration', 'lmm'),
                    'style' => 'critical',
                    'desc' => sprintf(''
                            . '<p>This methods allows you to integrate LMM into your theme. '
                            . '<p><code>[lmmmenu theme_location=&quot;%2$s&quot;]</code></p>'
                            . '<p>Simply copy the generated shortcode and paste it where you would like the menu to appear.</p>'
                            . '<p><code>&lt;?php lmmmenu(array(&quot;theme_location&quot; => &quot;%2$s&quot;)); ?&gt;</code></p>'
                            . '<p>Simply copy the generated PHP function code and paste it into the appropriate template in your theme.</p>', $location['name'], $key == 'all' ? 'replace with your theme location' : $key, 'lmm'),
                    'customizer' => false,
                    'required' => array(
                        $key . '_integration',
                        '=',
                        'manual'
                    ),
                ),
            )
        );
    }

    return $sections;
}

function lmm_options_social($sections, $defaults = array()) {

    $defaults = apply_filters('lmm_hook_options_social_defaults', $defaults);

    $sections[] = array(
        'id' => 'lmm_social',
        'title' => __('Social', 'lmm'),
        'heading' => false,//__('Add your social networks', 'lmm'),
        'icon' => 'lmm-share',
        'permissions' => 'edit_theme_options',
        'fields' => array(
            array(
                'id' => 'lmm_social',
                'type' => 'social',
                'title' => __('Networks', 'lmm'),
                'subtitle' => __('Add your social network icons.', 'lmm'),
                'placeholder' => array(
                    'title' => __('This is a title', 'lmm'),
                    'icon' => __('Icon class', 'lmm'),
                    'url' => __('Give us a link!', 'lmm'),
                ),
                'default' => $defaults['lmm_social'],
            ),
        ),
    );

    return $sections;
}

// config options --------------------------------------------------------------

function lmm_options_css($sections, $css = '') {

    $css = apply_filters('lmm_hook_options_css_default', $css);

    $sections[] = array(
        'id' => 'lmm_css',
        'title' => __('Customize', 'lmm'),
        'heading' => __('Add your custom CSS', 'lmm'),
        'icon' => 'lmm-magic-wand',
        'permissions' => 'edit_theme_options',
        'fields' => array(
            array(
                'id' => 'lmm_css',
                'type' => 'ace_editor',
                'mode' => 'css',
                'title' => __('Custom CSS', 'lmm'),
                'subtitle' => __('Quickly add some CSS to your theme by adding it to this block.', 'lmm'),
                //'theme'    => 'chrome',
                'compiler' => true,
                'default' => $css
            ),
        ),
    );

    return $sections;
}

add_filter('redux/options/' . LMM . '/sections', 'lmm_options_config');
add_filter('redux/options/' . LMM . '/sections', 'lmm_options_general');
add_filter('redux/options/' . LMM . '/sections', 'lmm_options_social');
add_filter('redux/options/' . LMM . '/sections', 'lmm_options_css');
add_filter('redux/options/' . LMM . '/sections', 'lmm_options_locations');
// include options that the user can't change
if (lmm_options_developer())
    add_filter('redux/options/' . LMM . '/options', 'lmm_options_developer');
