<?php

function lmm_login_form() {
    ?>
    <form class="form-horizontal lmm-login-form" name="loginform" action="<?php echo wp_login_url(get_permalink()) ?>" method="post">
        <div class="form-group">      
            <div class="col-xs-12">
                <input type="text" name="log" id="user_login" class="form-control" placeholder="<?php _e('Username', 'lmm'); ?>" value="" size="20" />
            </div>
        </div>
        <div class="form-group">
            <div class="col-xs-12">
                <input type="password" name="pwd" id="user_pass" class="form-control" placeholder="<?php _e('Password', 'lmm'); ?>" value="" size="20" />
            </div>
        </div>
        <div class="form-group">
            <div class="col-xs-12">
                <input type="submit" name="wp-submit" id="wp-submit" class="btn btn-primary pull-right" value="<?php _e('Log in', 'lmm') ?>" />
                <input type="hidden" name="redirect_to" value="<?php echo get_permalink() ?>" />
            </div>
        </div>
    </form>
    <?php
}

function lmm_registration_form() {
    ?>

    <form class="form-horizontal lmm-registration-form" role="form">
        <div class="form-group">
            <div class="col-xs-12">
                <input type="text" name="lmm_username" id="lmm_username" value="" placeholder="Choose Username" class="form-control" />
                <small class="text-right help-block"><?php _e('Use only a-z,A-Z,0-9, dash and underscores.', 'lmm'); ?></small>
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-12"><input type="email" name="lmm_email" id="lmm_email" value="" placeholder="Your Email" class="form-control" /></div>
        </div>

        <div class="form-group">
            <div class="col-xs-12">
                <input type="password" name="lmm_pass" id="lmm_pass" value="" placeholder="Choose Password" class="form-control" />
            </div>
        </div>

        <?php wp_nonce_field('lmm_new_user', 'lmm_new_user_nonce', true, true); ?>

        <div class="form-group register">              
            <div class="col-xs-12">
                <input type="submit" class="btn btn-primary pull-right" id="btn-new-user" value="<?php _e('Register', 'lmm'); ?>" />
            </div>
        </div>
        <div class="indicator" style="display: none;"><span class="spinner"></span></div>
        <div class="alert result-message" style="display: none;"></div>
    </form>
    <?php
}

function lmm_loginform() {

    ob_start();
    ?>

    <div id="login-carousel" class="carousel slide widget widget_login_carousel">
        <div class="carousel-inner">
            <div class="item active">                
                <h4 class="menutitle"><!--<i class="fa fa-lock"></i>--><?php _e('Sign in', 'lmm') ?></h4>
                <br/>                
                <?php lmm_login_form(); ?> 
                <p class="text-right" ><a href="#" data-target="#login-carousel" data-slide-to="1"><small><?php _e('Don’t have a account? Sign up for FREE', 'lmm') ?></small></a></p>
                <p class="text-right" ><a href="<?php echo wp_lostpassword_url(get_permalink()); ?>" title="Lost Password"><small><?php _e('Lost Password', 'lmm') ?></small></a></p>
            </div>
            <div class="item">
                <h4 class="menutitle"><!--<i class="fa fa-user"></i>--><?php _e('Create new account', 'lmm') ?></h4>
                <br/>
                <?php lmm_registration_form(); ?>                
                <p class="text-right" ><a href="#" class="text-right" data-target="#login-carousel" data-slide-to="0"><small><?php _e('Do you have an account? Log in', 'lmm') ?></small></a></p>        
            </div>
        </div>
    </div>

    <?php
    return ob_get_clean();
}

function vb_reg_new_user($output) {

    // Verify nonce
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lmm_new_user')) {

        $output = new WP_Error('registration-error', __('Ooops, something went wrong, please try again later.', 'lmm'));

        echo $output->get_error_message();

        die();
    }
        
    // sanitize post values ----------------------------------------------------
    $username = sanitize_user($_POST['user']);
    $password = $_POST['pass'];
    $email = sanitize_email($_POST['mail']);
    //$name = sanitize_file_name($_POST['name']);
    //$nick = $_POST['nick'];

    // error handling ----------------------------------------------------------

    if (empty($username)) {
        $output = new WP_Error('registration-error', __('Please provide an username.', 'lmm'));

        echo $output->get_error_message();

        die();
    }

    if (empty($email) || !is_email($email)) {
        $output = new WP_Error('registration-error', __('Please provide a valid email address.', 'lmm'));

        echo $output->get_error_message();

        die();
    }

    // after validation --------------------------------------------------------
    $userdata = array(
        'user_login' => $username,
        'user_pass' => $password,
        'user_email' => $email,
            //'first_name' => $name,
            //'nickname' => $nick,
    );

    $user_id = wp_insert_user($userdata);

    // return ------------------------------------------------------------------
    if (!is_wp_error($user_id)) {
        echo '1';
    } else {
        echo $user_id->get_error_message();
    }
    die();
}

add_action('wp_ajax_register_user', 'vb_reg_new_user');

add_action('wp_ajax_nopriv_register_user', 'vb_reg_new_user');
