/*global redux_change, redux*/

(function($) {
    "use strict";

    redux.field_objects = redux.field_objects || {};
    redux.field_objects.custom_locations = redux.field_objects.custom_locations || {};

    $(document).ready(
            function() {
                //redux.field_objects.custom_locations.init();
            }
    );

    redux.field_objects.custom_locations.init = function(selector) {

        if (!selector) {
            selector = $(document).find('.redux-container-custom_locations:visible');
        }

        function encodeID(s) {
            if (s === '')
                return '_';
            return s.replace(/[^a-zA-Z0-9.-]/g, function(match) {
                return '_' + match[0].charCodeAt(0).toString(16) + '_';
            });
        }

        $(selector).each(
                function() {
                    var el = $(this);
                    var parent = el;
                    if (!el.hasClass('redux-field-container')) {
                        parent = el.parents('.redux-field-container:first');
                    }
                    if (parent.is(":hidden")) { // Skip hidden fields
                        return;
                    }
                    if (parent.hasClass('redux-field-init')) {
                        parent.removeClass('redux-field-init');
                    } else {
                        return;
                    }
                    el.find('.redux-custom-locations-remove').live(
                            'click', function() {
                                redux_change($(this));
                                $(this).prev('input[type="text"]').val('');
                                $(this).parent().slideUp(
                                        'medium', function() {
                                            $(this).remove();
                                        }
                                );
                            }
                    );

                    el.find('.redux-custom-locations-add').click(
                            function() {
                                var number = parseInt($(this).attr('data-add_number'));
                                var id = $(this).attr('data-id');
                                var slug = $(this).attr('data-slug');
                                var name = $(this).attr('data-name');
                                var liNum = parseInt(el.find('#' + id).find('> li:visible').length + 1);
                                for (var i = 0; i < number; i++) {

                                    var nameID = slug + '-' + parseInt(liNum + i);

                                    var new_input = $('#' + id + ' li:last-child').clone();

                                    el.find('#' + id).append(new_input);
                                    el.find('#' + id + ' li:last-child').removeAttr('style');
                                    el.find('#' + id + ' li:last-child input[type="text"]').val('');
                                    el.find('#' + id + ' li:last-child input[type="text"]').attr('name', name + '[' + nameID + ']');
                                }
                            }
                    );
                }
        );
    };
})(jQuery);