<?php
if (!class_exists('Liquida_To_Importer')) {

    require_once('class.importer.php');

    class Liquida_To_Importer extends Liquida_Importer {

        protected $parent;
        private static $instance;
        public $theme_options;
        public $theme_options_menu;
        public $theme_content;
        public $theme_content_homepage;
        public $theme_content_postspage;
        public $theme_widgets;
        public $theme_revslider = array();

        public function __construct($parent) {

            $this->parent = $parent;

            $this->active_import = $this->parent->active_import;

            $this->active_import_id = $this->parent->active_import_id;

            $this->fetch_attachments = $this->parent->fetch_attachments;

            $this->initSettings();

            self::$instance = $this;

            parent::__construct();
        }

        public static function get_instance() {
            return self::$instance;
        }

        public function initSettings() {

            if (is_dir($this->parent->demo_data_dir)) {
                $this->demo_files_path = $this->parent->demo_data_dir;
            }

            if (empty($this->active_import_id))
                return;

            $demo = $this->parent->liquida_import_files[$this->active_import_id];

            $this->theme_options = ( isset($demo['theme_options']) ) ? $demo['theme_options'] : false;

            $this->theme_options_menu = ( isset($demo['theme_options_menu']) ) ? $demo['theme_options_menu'] : false;

            $this->theme_widgets = ( isset($demo['theme_widgets']) ) ? $demo['theme_widgets'] : false;

            $this->theme_content = ( isset($demo['theme_content']) ) ? $demo['theme_content'] : false;

            $this->theme_content_homepage = ( isset($demo['theme_content_homepage']) ) ? $demo['theme_content_homepage'] : false;

            $this->theme_content_postspage = ( isset($demo['theme_content_postspage']) ) ? $demo['theme_content_postspage'] : false;

            $this->theme_revslider = ( isset($demo['theme_revslider']) ) ? $demo['theme_revslider'] : false;
        }

    }

}

if (!class_exists('Liquida_Demos')) {

    class Liquida_Demos {

        public static $instance;
        protected $parent;
        public $demo_data_dir;
        public $liquida_import_files = array();
        public $active_import_id;
        public $active_import;

        public function __construct() {

            if (!is_admin())
                return;

            if (!current_user_can('switch_themes'))
                return;

            //delete_option('liquida_imported_demos');

            $this->demos();

            self::$instance = $this;

            add_action('wp_ajax_liquida_theme_demos', array($this, 'ajax_importer'));
        }

        function render() {

            $nonce = wp_create_nonce('liquida_theme_demos');

            $imported = false;

            $this->field['liquida_demo_imports'] = $this->liquida_import_files;

            echo '<div class="liquida_importer"><div class="theme-browser"><div class="themes">';

            if (empty($this->liquida_import_files))
                echo '<h5>' . esc_html__('No Demo Data Provided', 'liquidatheme') . '</h5>';

            foreach ($this->liquida_import_files as $section => $imports) {

                if (empty($imports)) {
                    continue;
                }

                if (!array_key_exists('imported', $imports)) {
                    $imported = false;
                    $extra_class = 'not-imported';
                } else {
                    $imported = true;
                    $extra_class = 'imported';
                }
                ?>

                <div class="wrap-importer liquida-wp-admin-demo theme <?php echo $extra_class; ?>" data-demo-id="<?php echo esc_attr($section); ?>"  data-nonce="<?php echo $nonce; ?>" id="<?php echo esc_attr($section); ?>-custom_imports">
                    <div class="theme-screenshot">
                        <img class="liquida-demo-thumb" src="<?php echo esc_attr(esc_url($imports['url'] . '/' . $imports['image'])); ?>">
                    </div>
                    <span class="more-details imported"><?php echo esc_html__('Demo installed', 'liquidatheme'); ?></span>
                    <span class="more-details not-imported"><?php echo esc_html__('Import demo', 'liquidatheme'); ?></span>
                    <div class="liquida-admin-title">
                        <div class="liquida-progress-bar-wrap"><div class="liquida-progress-bar"></div></div>
                        <h3 class="theme-name"><?php echo esc_html(ucfirst($imports['name'])); ?> demo</h3>
                    </div>
                    <div class="liquida-admin-checkbox liquida-small-checkbox">
                        <div class="liquida-demo-install-content">
                            <?php if (!empty($imports['theme_content']) || !empty($imports['theme_widgets'])): ?>
                                <input id="liquida-fetch-attachments" type="checkbox" class="checkbox">
                                <p><?php _e('Include attachments', 'liquidatheme'); ?></p>
                            <?php else: ?>
                                <p><?php _e('Import theme style', 'liquidatheme'); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="theme-actions">
                        <div class="liquida-importer-buttons">
                            <span class="spinner"><?php esc_html__('Please Wait...', 'liquidatheme'); ?></span>
                            <?php
                            if (!empty($imports['theme_options']) || !empty($imports['theme_options']))
                                echo '<span id="liquida-importer-import-style" class="importer-button button-secondary">' . __('Style', 'liquidatheme') . '</span>';
                            if (!empty($imports['theme_content']) || !empty($imports['theme_widgets']))
                                echo '<span id="liquida-importer-import-content" class="importer-button button-primary">' . __('Content', 'liquidatheme') . '</span>';

                            echo '<span id="liquida-importer-import" class="importer-button button-primary">' . __('Import', 'liquidatheme') . '</span>';
                            echo '<span id="liquida-importer-imported" class="button-secondary">' . esc_html__('Imported', 'liquidatheme') . '</span>';
                            echo '<span id="liquida-importer-importing" class="button-secondary">' . esc_html__('Importing', 'liquidatheme') . '</span>';
                            ?>
                        </div>
                    </div>
                </div>

                <?php
            }


            echo '</div></div></div>';
        }

        public function demos() {

            if (!empty($this->liquida_import_files)) {
                return $this->liquida_import_files;
            }

            global $liquida_admin;

            if (empty($liquida_admin['demos']))
                return;

            $imported = get_option('liquida_imported_demos');

            $x = 1;

            foreach ($liquida_admin['demos'] as $key => $demo) {

                if (!isset($demo['directory']) || !is_dir($demo['directory'])) {
                    continue;
                }

                $id = 'liquida-import-' . $x;

                $this->liquida_import_files[$id] = $demo;

                if (!empty($imported) && is_array($imported)) {
                    if (array_key_exists($id, $imported)) {
                        $this->liquida_import_files[$id]['imported'] = true;
                    }
                }

                $this->liquida_import_files[$id]['theme_options'] = !empty($demo['theme_options']) && is_file($demo['directory'] . '/' . $demo['theme_options']) ? $demo['directory'] . '/' . $demo['theme_options'] : false;

                $this->liquida_import_files[$id]['theme_options_compiler'] = !empty($demo['theme_options_compiler']) ? true : false;

                $this->liquida_import_files[$id]['theme_options_menu'] = !empty($demo['theme_options_menu']) && is_file($demo['directory'] . '/' . $demo['theme_options_menu']) ? $demo['directory'] . '/' . $demo['theme_options_menu'] : false;

                $this->liquida_import_files[$id]['theme_content'] = !empty($demo['theme_content']) && is_file($demo['directory'] . '/' . $demo['theme_content']) ? $demo['directory'] . '/' . $demo['theme_content'] : false;

                $this->liquida_import_files[$id]['theme_homepage'] = !empty($demo['theme_homepage']) ? $demo['theme_homepage'] : false;

                $this->liquida_import_files[$id]['theme_postspage'] = !empty($demo['theme_postspage']) ? $demo['theme_postspage'] : false;

                $this->liquida_import_files[$id]['theme_widgets'] = !empty($demo['theme_widgets']) && is_file($demo['directory'] . '/' . $demo['theme_widgets']) ? $demo['directory'] . '/' . $demo['theme_widgets'] : false;

                $this->liquida_import_files[$id]['url'] = site_url(str_replace(trailingslashit(str_replace('\\', '/', ABSPATH)), '', str_replace('\\', '/', $demo['directory'])));

                if (!empty($demo['theme_revslider']) && is_array($demo['theme_revslider'])) {

                    $this->liquida_import_files[$id]['theme_revslider'] = array();

                    foreach ($demo['theme_revslider'] as $slider) {

                        $slider = $demo['directory'] . '/' . $slider;

                        if (!is_file($slider))
                            continue;

                        $this->liquida_import_files[$id]['theme_revslider'][] = $slider;
                    }
                }


                $x++;
            }

            return $this->liquida_import_files;
        }

        public static function get_instance() {
            return self::$instance;
        }

        public function ajax_importer() {

            if (!isset($_REQUEST['nonce']) || !wp_verify_nonce($_REQUEST['nonce'], 'liquida_theme_demos')) {
                die(0);
            }

            if (isset($_REQUEST['type']) && $_REQUEST['type'] == 'liquida-import-demo' && array_key_exists($_REQUEST['demo_import_id'], $this->liquida_import_files)) {

                $this->active_import_id = $_REQUEST['demo_import_id'];

                $import_parts = $this->liquida_import_files[$this->active_import_id];

                $this->active_import = array($this->active_import_id => $import_parts);

                $this->fetch_attachments = isset($_REQUEST['fetch_attachments']) ? filter_var($_REQUEST['fetch_attachments'], FILTER_VALIDATE_BOOLEAN) : false;

                $installer = new Liquida_To_Importer($this);

                $response = call_user_func(array($installer, $_REQUEST['method']));

                if (empty($response))
                    die();

                die(wpautop($response) . sprintf('<p class="text-center"><code>%d queries in %.3f seconds, using %.2fmb memory</code></p>', get_num_queries(), timer_stop(0, 3), memory_get_peak_usage() / 1024 / 1024));
            }
            die();
        }

    }

}

new Liquida_Demos();
