<?php

/**
 * Class Liquida_Importer
 *
 * This class provides the capability to import demo content as well as import widgets and WordPress menus
 *
 * Modified version of Reduxframework/Wbc_importer extension
 *
 */
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

// Don't duplicate me!
if (!class_exists('Liquida_Importer')) {

    class Liquida_Importer {

        private static $instance;
        public $theme_options_name = LIQUIDA;
        public $theme_options_menu_name = LMM;
        public $theme_options;
        public $theme_options_menu;
        public $theme_content;
        public $theme_content_homepage;
        public $theme_content_postspage;
        public $theme_widgets;
        public $theme_revslider = array();
        public $flag_as_imported = array();
        public $nav_menu_locations = array();
        public $fetch_attachments;

        public function __construct() {

            self::$instance = $this;

            add_filter('add_post_metadata', array($this, 'check_previous_meta'), 10, 5);

            //add_filter('wp_import_post_data_raw', array($this, 'lmm_item_meta'), 10, 1);

            //add_action('import_end', array($this, 'lmm_item_meta_save'));

            add_action('import_end', array($this, 'after_wp_importer'));
        }

        public function theme_options() {

            if (empty($this->theme_options))
                return false;

            if (!is_file($this->theme_options))
                return __('Theme options file could not be found. Please try again.', 'liquidatheme');

            $data = file_get_contents($this->theme_options);
            $data = json_decode($data, true);
            $data = maybe_unserialize($data);

            if (!empty($data) || is_array($data)) {
                update_option($this->theme_options_name, $data);
                update_option('liquida_importer_theme_options_compiler', true);
                return __('Theme options have been imported', 'liquidatheme');
            }

            return __('Theme options cant be imported', 'liquidatheme');
        }

        public function theme_options_compiler() {

            if (!get_option('liquida_importer_theme_options_compiler'))
                return false;

            if (!get_option($this->theme_options_name))
                return __('Theme options cant be found', 'liquidatheme');

            liquida_compiler(get_option($this->theme_options_name));

            delete_option('liquida_importer_theme_options_compiler');

            return __('Theme stylesheet have been compiled', 'liquidatheme');
        }

        public function theme_options_menu() {

            if (empty($this->theme_options_menu))
                return false;

            if (!file_exists($this->theme_options_menu))
                return __('Theme menu options file could not be found. Please try again.', 'liquidatheme');

            $data = file_get_contents($this->theme_options_menu);
            $data = json_decode($data, true);
            $data = maybe_unserialize($data);

            if (!empty($data) || is_array($data)) {
                update_option($this->theme_options_menu_name, $data);
                update_option('liquida_importer_theme_options_menu_compiler', true);
                return __('Theme options menu have been imported', 'liquidatheme');
            }

            return __('Theme menu options cant be imported', 'liquidatheme');
        }

        public function theme_options_menu_compiler() {

            if (!get_option('liquida_importer_theme_options_menu_compiler'))
                return false;

            if (!get_option($this->theme_options_menu_name))
                return __('Theme menu options cant be found', 'liquidatheme');

            lmm_compiler(get_option($this->theme_options_menu_name));

            delete_option('liquida_importer_theme_options_menu_compiler');

            return __('Theme menu stylesheet have been compiled', 'liquidatheme');
        }

        public function theme_content() {

            global $wp_import;

            if (empty($this->theme_content))
                return false;

            if (!is_file($this->theme_content))
                return __('Theme content file could not be found. Please try again.', 'liquidatheme');

            if (!defined('WP_LOAD_IMPORTERS'))
                define('WP_LOAD_IMPORTERS', true);

            require_once ABSPATH . 'wp-admin/includes/import.php';

            $importer_error = false;

            if (!class_exists('WP_Importer')) {

                $class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';

                if (file_exists($class_wp_importer)) {

                    require_once $class_wp_importer;
                } else {

                    $importer_error = true;
                }
            }

            if (!class_exists('WP_Import')) {

                $class_wp_import = dirname(__FILE__) . '/wordpress-importer.php';

                if (file_exists($class_wp_import))
                    require_once $class_wp_import;
                else
                    $importer_error = true;
            }

            if ($importer_error) {
                return __('Error on import.', 'liquidatheme');
            } else {
                $wp_import = new WP_Import();
                $wp_import->fetch_attachments = $this->fetch_attachments;
                $wp_import->import($this->theme_content);
                update_option('liquida_importer_theme_content_menus', true);
                return __('The theme content have been imported', 'liquidatheme');
            }
        }

        public function theme_content_homepage() {

            if (!$this->theme_content_homepage)
                return false;

            $page = get_page_by_path($this->theme_content_homepage);

            if (!isset($page->ID))
                return __('Homepage cant be found', 'liquidatheme');

            update_option('page_on_front', $page->ID);
            update_option('show_on_front', 'page');

            return __('Homepage have been set', 'liquidatheme');
        }

        public function theme_content_postspage() {

            if (!$this->theme_content_postspage)
                return false;

            $page = get_page_by_path($this->theme_content_postspage);

            if (!isset($page->ID))
                return __('Postspage cant be found', 'liquidatheme');

            update_option('page_for_posts', $page->ID);
            update_option('show_on_front', 'page');

            return __('Postspage have been set', 'liquidatheme');
        }

        public function theme_content_menus() {

            if (!get_option('liquida_importer_theme_content_menus'))
                return false;

            global $liquida_admin;

            foreach ($liquida_admin['menus'] as $slug => $menu) {

                $id = get_term_by('slug', 'header', 'nav_menu');

                if (!isset($id->term_id))
                    continue;

                $this->nav_menu_locations[$slug] = $id->term_id;
            }

            //var_dump($this->nav_menu_locations);

            set_theme_mod('nav_menu_locations', $this->nav_menu_locations);

            delete_option('liquida_importer_theme_content_menus');
            return __('Menu theme locations have been set', 'liquidatheme');
        }

        function theme_widgets() {

            if (empty($this->theme_widgets))
                return false;

            if (!is_file($this->theme_widgets))
                return __('Widget Import file could not be found. Please try again.', 'liquidatheme');

            // Get file contents and decode
            $data = file_get_contents($this->theme_widgets);

            if (!$data)
                return __('Theme widgets file cant be read', 'liquidatheme');

            $data = json_decode($data);

            // Delete import file
            //unlink( $file );
            // Import the widget data
            // Make results available for display on import/export page
            $this->widget_import_results = $this->import_widgets($data);

            return __('Theme widgets have been imported', 'liquidatheme');
        }

        public function theme_revslider() {

            if (empty($this->theme_revslider))
                return false;

            if (class_exists('RevSlider')) {

                $output = '';

                foreach ($this->theme_revslider as $revslider) {
                    if (is_file($revslider)) {
                        $slider = new RevSlider();
                        $response = $slider->importSliderFromPost(true, true, $revslider);
                        //handle error
                        if ($response['success'] == false) {
                            $output .= '<br/><b>Error:</b> ' . $response['error'] . $revslider;
                        }
                    }
                }

                $output .= __('Revolution Sliders have been imported', 'liquidatheme');

                return $output;
            } else {
                return __('Revolution is not active. We cant import the sliders.', 'liquidatheme');
            }
        }

        public function import_widgets($data) {

            global $wp_registered_sidebars;

            // Have valid data?
            // If no data or could not decode
            if (empty($data) || !is_object($data)) {
                return __('The widgets XML file is invalid', 'liquidatheme');
            }

            // Hook before import
            //$data = apply_filters('radium_theme_import_widget_data', $data);
            // Get all available widgets site supports
            $available_widgets = $this->available_widgets();

            // Get all existing widget instances
            $widget_instances = array();
            foreach ($available_widgets as $widget_data) {
                $widget_instances[$widget_data['id_base']] = get_option('widget_' . $widget_data['id_base']);
            }

            // Begin results
            $results = array();

            // Loop import data's sidebars
            foreach ($data as $sidebar_id => $widgets) {

                // Skip inactive widgets
                // (should not be in export file)
                if ('wp_inactive_widgets' == $sidebar_id) {
                    continue;
                }

                // Check if sidebar is available on this site
                // Otherwise add widgets to inactive, and say so
                if (isset($wp_registered_sidebars[$sidebar_id])) {
                    $sidebar_available = true;
                    $use_sidebar_id = $sidebar_id;
                    $sidebar_message_type = 'success';
                    $sidebar_message = '';
                } else {
                    $sidebar_available = false;
                    $use_sidebar_id = 'wp_inactive_widgets'; // add to inactive if sidebar does not exist in theme
                    $sidebar_message_type = 'error';
                    $sidebar_message = __('Sidebar does not exist in theme (using Inactive)', 'liquidatheme');
                }

                // Result for sidebar
                $results[$sidebar_id]['name'] = !empty($wp_registered_sidebars[$sidebar_id]['name']) ? $wp_registered_sidebars[$sidebar_id]['name'] : $sidebar_id; // sidebar name if theme supports it; otherwise ID
                $results[$sidebar_id]['message_type'] = $sidebar_message_type;
                $results[$sidebar_id]['message'] = $sidebar_message;
                $results[$sidebar_id]['widgets'] = array();

                // Loop widgets
                foreach ($widgets as $widget_instance_id => $widget) {

                    $fail = false;

                    // Get id_base (remove -# from end) and instance ID number
                    $id_base = preg_replace('/-[0-9]+$/', '', $widget_instance_id);
                    $instance_id_number = str_replace($id_base . '-', '', $widget_instance_id);

                    // Does site support this widget?
                    if (!$fail && !isset($available_widgets[$id_base])) {
                        $fail = true;
                        $widget_message_type = 'error';
                        $widget_message = __('Site does not support widget', 'liquidathe,e'); // explain why widget not imported
                    }

                    // Filter to modify settings before import
                    // Do before identical check because changes may make it identical to end result (such as URL replacements)
                    //$widget = apply_filters('radium_theme_import_widget_settings', $widget);
                    // Does widget with identical settings already exist in same sidebar?
                    if (!$fail && isset($widget_instances[$id_base])) {

                        // Get existing widgets in this sidebar
                        $sidebars_widgets = get_option('sidebars_widgets');
                        $sidebar_widgets = isset($sidebars_widgets[$use_sidebar_id]) ? $sidebars_widgets[$use_sidebar_id] : array(); // check Inactive if that's where will go
                        // Loop widgets with ID base
                        $single_widget_instances = !empty($widget_instances[$id_base]) ? $widget_instances[$id_base] : array();
                        foreach ($single_widget_instances as $check_id => $check_widget) {

                            // Is widget in same sidebar and has identical settings?
                            if (in_array("$id_base-$check_id", $sidebar_widgets) && (array) $widget == $check_widget) {

                                $fail = true;
                                $widget_message_type = 'warning';
                                $widget_message = __('Widget already exists', 'liquidatheme'); // explain why widget not imported

                                break;
                            }
                        }
                    }

                    // No failure
                    if (!$fail) {

                        // Add widget instance
                        $single_widget_instances = get_option('widget_' . $id_base); // all instances for that widget ID base, get fresh every time
                        $single_widget_instances = !empty($single_widget_instances) ? $single_widget_instances : array('_multiwidget' => 1); // start fresh if have to
                        $single_widget_instances[] = (array) $widget; // add it
                        // Get the key it was given
                        end($single_widget_instances);
                        $new_instance_id_number = key($single_widget_instances);

                        // If key is 0, make it 1
                        // When 0, an issue can occur where adding a widget causes data from other widget to load, and the widget doesn't stick (reload wipes it)
                        if ('0' === strval($new_instance_id_number)) {
                            $new_instance_id_number = 1;
                            $single_widget_instances[$new_instance_id_number] = $single_widget_instances[0];
                            unset($single_widget_instances[0]);
                        }

                        // Move _multiwidget to end of array for uniformity
                        if (isset($single_widget_instances['_multiwidget'])) {
                            $multiwidget = $single_widget_instances['_multiwidget'];
                            unset($single_widget_instances['_multiwidget']);
                            $single_widget_instances['_multiwidget'] = $multiwidget;
                        }

                        // Update option with new widget
                        update_option('widget_' . $id_base, $single_widget_instances);

                        // Assign widget instance to sidebar
                        $sidebars_widgets = get_option('sidebars_widgets'); // which sidebars have which widgets, get fresh every time
                        $new_instance_id = $id_base . '-' . $new_instance_id_number; // use ID number from new widget instance
                        $sidebars_widgets[$use_sidebar_id][] = $new_instance_id; // add new instance to sidebar
                        update_option('sidebars_widgets', $sidebars_widgets); // save the amended data
                        // Success message
                        if ($sidebar_available) {
                            $widget_message_type = 'success';
                            $widget_message = __('Imported', 'liquidatheme');
                        } else {
                            $widget_message_type = 'warning';
                            $widget_message = __('Imported to Inactive', 'liquidatheme');
                        }
                    }

                    // Result for widget instance
                    $results[$sidebar_id]['widgets'][$widget_instance_id]['name'] = isset($available_widgets[$id_base]['name']) ? $available_widgets[$id_base]['name'] : $id_base; // widget name or ID if name not available (not supported by site)
                    $results[$sidebar_id]['widgets'][$widget_instance_id]['title'] = isset($widget->title) ? $widget->title : __('No Title', 'liquidatheme'); // show "No Title" if widget instance is untitled
                    $results[$sidebar_id]['widgets'][$widget_instance_id]['message_type'] = $widget_message_type;
                    $results[$sidebar_id]['widgets'][$widget_instance_id]['message'] = $widget_message;
                }
            }

            // Hook after import
            //do_action('radium_theme_import_widget_after_import');
            // Return results
            //return apply_filters('radium_theme_import_widget_results', $results);
            return $results;
        }

        function available_widgets() {

            global $wp_registered_widget_controls;

            $widget_controls = $wp_registered_widget_controls;

            $available_widgets = array();

            foreach ($widget_controls as $widget) {

                if (!empty($widget['id_base']) && !isset($available_widgets[$widget['id_base']])) { // no dupes
                    $available_widgets[$widget['id_base']]['id_base'] = $widget['id_base'];
                    $available_widgets[$widget['id_base']]['name'] = $widget['name'];
                }
            }

            return $available_widgets;
        }

        public function add_widget_to_sidebar($sidebar_slug, $widget_slug, $count_mod, $widget_settings = array()) {

            $sidebars_widgets = get_option('sidebars_widgets');

            if (!isset($sidebars_widgets[$sidebar_slug]))
                $sidebars_widgets[$sidebar_slug] = array('_multiwidget' => 1);

            $newWidget = get_option('widget_' . $widget_slug);

            if (!is_array($newWidget))
                $newWidget = array();

            $count = count($newWidget) + 1 + $count_mod;
            $sidebars_widgets[$sidebar_slug][] = $widget_slug . '-' . $count;

            $newWidget[$count] = $widget_settings;

            update_option('sidebars_widgets', $sidebars_widgets);
            update_option('widget_' . $widget_slug, $newWidget);
        }

        public function lmm_item_meta($item, $i = 0, $lmmmeta = array()) {

            global $wp_import;

            if ('nav_menu_item' != $item['post_type'] || 'draft' == $item['status'])
                return $item;

            foreach ($item['postmeta'] as $key => $meta) {

                if (substr($meta['key'], 0, 4) !== 'lmm_' || empty($meta['value']))
                    continue;

                $lmmmeta[$i++] = array('key' => $meta['key'], 'value' => $meta['value']);
            }

            $wp_import->lmm[(int) $item['post_id']] = $lmmmeta;

            return $item;
        }

        public function check_previous_meta($continue, $post_id, $meta_key, $meta_value, $unique) {

            $old_value = get_metadata('post', $post_id, $meta_key);

            if (count($old_value) == 1) {
                if ($old_value[0] === $meta_value) {
                    return false;
                } elseif ($old_value[0] !== $meta_value) {
                    update_post_meta($post_id, $meta_key, $meta_value);
                    return false;
                }
            }

            return null;
        }

        public function after_wp_importer() {

            $imported_demos = get_option('liquida_imported_demos');

            $this->active_import[$this->active_import_id]['imported'] = 'imported';

            if (empty($imported_demos)) {
                $imported_demos = $this->active_import;
            } else {
                $imported_demos = array_merge($imported_demos, $this->active_import);
            }

            update_option('liquida_imported_demos', $imported_demos);
        }

        function lmm_item_meta_save() {

            global $wpdb, $wp_import;

            if (empty($wp_import->lmm))
                return;

            foreach ($wp_import->lmm as $post_id => $postmeta) {

                if (empty($wp_import->processed_menu_items[$post_id]))
                    continue;

                foreach ($postmeta as $meta) {
                    update_post_meta((int) $wp_import->processed_menu_items[$post_id], $meta['key'], $meta['value']);
                }
            }
        }

    }

    //class
}