;
(function ($, window, document, undefined) {
    'use strict';
    var pluginName = 'lmm',
            defaults = {
                //breakPoint: parseInt(lmm.breakpoint),
                containerGutter: parseInt(lmm.gutter),
                touchEvents: true,
                mouseEvents: true,
                moveThreshold: 10, //distance until tap is cancelled in deference to move/scroll
                intent_delay: 300, //delay before the menu closes
                intent_interval: 150, //polling interval for mouse comparisons
                intent_threshold: 300, //maximum number of pixels mouse can move to be considered intent
            };
    function Plugin(element, options) {

        var plugin = this;
        this.element = element;
        this.$lmm = $(this.element);
        this.$navbar = $('nav.lmm-navbar');
        this.settings = $.extend({}, defaults, options);
        this.touchenabled = ('ontouchstart' in window || navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0);
        this.mobiledevice = (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent));

        this.settings.perfectScrollbar = (typeof $.fn.perfectScrollbar !== 'undefined' && !this.mobiledevice) ? true : false;

        if (this.touchenabled) {
            this.$lmm.addClass('lmm-touch');
        } else {
            this.$lmm.addClass('lmm-notouch');
        }


        if (window.navigator.pointerEnabled) {
            this.touchStart = 'pointerdown';
            this.touchEnd = 'pointerup';
            this.touchMove = 'pointermove';
        } else if (window.navigator.msPointerEnabled) {
            this.touchStart = 'MSPointerDown';
            this.touchEnd = 'MSPointerUp';
            this.touchMove = 'MSPointerMove';
        } else {
            this.touchStart = 'touchstart';
            this.touchEnd = 'touchend';
            this.touchMove = 'touchmove';
        }

        this.init();
    }

    Plugin.prototype = {
        init: function () {
            this.$lmm.removeClass('lmm-nojs');
            this.lmmResolveConflics();
            this.lmmDebounced();
            this.lmmInitClasses();
            this.lmmInitOffCanvasCollapsed();
            this.lmmInitFixOffCanvas();
            this.lmmInitStickyOnScroll();
            this.lmmInitContainerWidth();
            this.lmmInitDropdownFloat();
            this.lmmInitDropdownTouchEvents();
            this.lmmInitDropdownMouseEvents();
            this.lmmInitDropdownRetractors();
            this.lmmInitDropdownCloseAll();
            this.lmmInitDropdownAnimations();
            this.lmmInitBackgrounds();
            this.lmmInitFirstLevelActive();
            this.lmmInitVerticalOpen();
            this.lmmInitSlideBar();
            this.lmmInitTabs();
            this.lmmInitMega();
            this.lmmInitCart();
            this.lmmInitLogIn();
            this.lmmInitSocial();
            this.lmmInitScrollBar();
        },
        lmmResolveConflics: function () {
            this.$lmm.find('.lmm-item, .lmm-dropdown-toggle, .lmm-dropdown-menu, .lmm-dropdown-submenu').add(this.$lmm).removeAttr('style').unbind().off();
        },
        lmmInitDropdownTouchEvents: function (plugin) {

            if (!this.settings.touchEvents)
                return;

            plugin = plugin || this;

            this.$lmm.on(this.touchStart, '.lmm-dropdown > .lmm-dropdown-toggle', function (e) {
                plugin.handleTouchEvents(e, this, plugin);
            });

            this.$lmm.on('click', '.lmm-dropdown > .lmm-dropdown-toggle', function (e) {
                plugin.handleClicks(e, this);
            });

        },
        lmmInitDropdownMouseEvents: function (plugin) {

            if (!this.settings.mouseEvents)
                return;

            plugin = plugin || this;

            if (typeof $.fn.hoverIntent === 'undefined')
                return;

            this.$lmm.on('click', '.lmm-item > .lmm-dropdown-toggle', function (e) {
                plugin.handleLink(e, this);
            });

            if (this.$lmm.hasClass('lmm-trigger-hoverintent') && !this.$lmm.hasClass('lmm-is-responsive')) {

                this.$lmm.on('mouseleave.hoverIntent mouseenter.hoverIntent mousemove.hoverIntent', '.lmm-item > .lmm-dropdown-toggle', function (e) {
                    plugin.handleMouseHover(this, plugin);

                });

                plugin.handleMouseHover(this.$lmm.find('.lmm-item > .lmm-dropdown-toggle'), plugin);


            } else {

                this.$lmm.on('click', '.lmm-item > .lmm-dropdown-toggle', function (e) {
                    plugin.handleMouseClick(e, this, plugin);
                });
            }
        },
        handleMouseHover: function (target, plugin) {

            var $target = $(target),
                    $li = $target.parent('.lmm-item');

            if (!$li.size())
                return;

            $li.hoverIntent({
                over: function () {

                    var $li = $(this),
                            $target = $li.find('> .lmm-dropdown-menu');

                    if ($target.data('lmm-killHover'))
                        return;

                    plugin.triggerSubmenu($li, plugin);
                },
                out: function () {

                    var $li = $(this),
                            $target = $li.find('> .lmm-dropdown-menu');

                    if ($target.data('lmm-killHover'))
                        return;

                    if ($li.hasClass('lmm-item-type-tab'))
                        return;

                    plugin.closeSubmenu($li);
                },
                sensitivity: plugin.settings.intent_interval,
                timeout: plugin.settings.intent_delay,
                interval: plugin.settings.intent_threshold
            });
        },
        lmmInitDropdownRetractors: function () {

            var plugin = this;
            //remove the events
            this.$lmm.off('shown.lmm.dropdown.retractor');
            this.$lmm.off('hidden.lmm.dropdown.retractor');
            this.$lmm.off('click.retractor');
            //vertical & click || touch & vertical || touch and mobile || toch and click
            if (this.$lmm.hasClass('lmm-is-horizontal') || (this.$lmm.hasClass('lmm-is-vertical') && this.$lmm.hasClass('lmm-trigger-hoverintent')))
                return;
            //set up the retractors
            this.$lmm.on('click.retractor', '.lmm-item.lmm-dropdown.open > .lmm-dropdown-toggle > .lmm-item-content > .lmm-caret', function (e) {
                //setTimeout(function () {
                plugin.handleDropdownCloseEnd(e, this, plugin);
                //}, 100);
            });

            // we dont need to off this evet on window resize because touch events hare handled by the browser
            if (!this.settings.touchEvents)
                return;

            this.$lmm.on(this.touchStart + '.retractor', '.lmm-item.lmm-dropdown.open > .lmm-dropdown-toggle > .lmm-item-content > .lmm-caret', function (e) {
                // setTimeout(function () {
                plugin.handleDropdownCloseStart(e, this, plugin);
                //}, 100);

            });
        },
        lmmInitDropdownCloseAll: function () {

            var plugin = this;

            $(document).on(this.touchEnd + '.hidden.lmm.dropdown.all click.hidden.lmm.dropdown.all', function (e) {
                plugin.handleDropdownCloseAll(e, plugin);
            });

        },
        handleClicks: function (e, target) {

            var $target = $(target);
            if ($target.data('lmm-killClick')) {
                e.preventDefault();
            }
        },
        handleTouchEvents: function (e, target, plugin) {
            e.stopPropagation();
            var $target = $(target),
                    $li = $target.parent('.lmm-item');

            //disable hoverintent on touch devices
            $li.off('mouseleave.hoverIntent');
            $target.on(plugin.touchEnd, function (e) {
                plugin.handleTouchTap(e, this, plugin);
            });
            $target.on(plugin.touchMove, function (e) {
                plugin.preventTapOnScroll(e, this, plugin);
            });
            if (e.originalEvent.touches) {
                $target.data('lmm-startX', e.originalEvent.touches[0].clientX);
                $target.data('lmm-startY', e.originalEvent.touches[0].clientY);
            }
            //microsoft
            else if (e.originalEvent.clientY) {
                var pos = $target.offset();
                $target.data('lmm-startX', e.originalEvent.clientX);
                $target.data('lmm-startY', e.originalEvent.clientY);
            }

        },
        preventTapOnScroll: function (e, target, plugin) {

            var $target = $(target);
            //make sure the touch points aren't too close, if so, then remove the event handlers
            if (e.originalEvent.touches) {
                if (Math.abs(e.originalEvent.touches[0].clientX - $target.data('lmm-startX')) > plugin.settings.moveThreshold ||
                        Math.abs(e.originalEvent.touches[0].clientY - $target.data('lmm-startY')) > plugin.settings.moveThreshold) {

                    plugin.resetHandlers($target);
                }
            } else if (e.originalEvent.clientY) {
                var pos = $target.data(pos);
                if (Math.abs(e.originalEvent.clientX - $target.data('lmm-startX')) > plugin.settings.moveThreshold ||
                        Math.abs(e.originalEvent.clientY - $target.data('lmm-startY')) > plugin.settings.moveThreshold) {

                    plugin.resetHandlers($target);
                }
            }

        },
        handleTouchTap: function (e, target, plugin) {

            e.preventDefault();
            e.stopPropagation();
            var $target = $(target),
                    $li = $target.parent();
            //prevent clicks
            $target.data('lmm-killClick', true);
            //prevent hover
            $target.data('lmm-killHover', true);
            setTimeout(function () {
                $target.data('lmm-killClick', false).data('lmm-killHover', false);
            }, 1000);
            //close other submenus
            plugin.closeSubmenu($li.siblings('.open'));
            if ($li.hasClass('lmm-dropdown')) {
                //if submenu is already open then close it
                if ($li.hasClass('open')) {
                    //please don't close tabs
                    if (!$li.hasClass('lmm-item-type-tab')) {
                        plugin.closeSubmenu($li);
                    }
                    //allow link to be followed
                    plugin.handleLink(e, target, true);
                }
                //if submenu is closed then open the submenu and prevent link from being followed
                else {
                    plugin.openSubmenu($li);
                }
            }
            //allow links whitout submenus to be followed
            else {
                plugin.handleLink(e, target, true);
            }

            plugin.resetHandlers($target);
        },
        handleLink: function (e, link, follow) {

            follow = follow || false;
            var $link = $(link),
                    href = $link.attr('href');
            if (!$link.is('a'))
                return;
            if (!href) {
                e.preventDefault();
                return;
            }

            if (!follow || !e.isDefaultPrevented())
                return;
            //handle links after preventDefault
            if ($link.attr('target') === '_blank') {
                window.open(href, '_blank');
            } else {
                window.location = href;
            }

        },
        handleMouseClick: function (e, target, plugin) {

            //e.stopImmediatePropagation();

            var $target = $(target),
                    $li = $target.parent('.lmm-item');

            if ($target.data('lmm-killClick') || !$li.size())
                return;
            //disable hoverintent on click, just in case
            $li.off('mousemove.hoverIntent');
            //$li.off('mouseenter.hoverIntent');
            $li.off('mouseleave.hoverIntent');
            if ($li.hasClass('open')) {

                if ($target.is('a')) {
                    plugin.handleLink(e, target);
                }
                if (!$li.hasClass('lmm-item-type-tab')) {
                    plugin.closeSubmenu($li);
                }
            } else if ($li.hasClass('lmm-dropdown')) {
                e.preventDefault();
                plugin.closeSubmenu($li.siblings('.open'));
                plugin.openSubmenu($li);
            }

        },
        handleDropdownCloseStart: function (e, caret, plugin) {
            e.preventDefault();
            e.stopPropagation();
            $(caret).on(plugin.touchEnd, function (e) {
                plugin.handleDropdownCloseEnd(e, this, plugin);
            });
        },
        handleDropdownCloseEnd: function (e, caret, plugin) {
            e.preventDefault();
            e.stopPropagation();

            //alert($(caret).attr('class'));

            var $li = $(caret).closest('.lmm-dropdown.open');

            plugin.closeSubmenu($li);

            $(caret).off(plugin.touchEnd);

            return false;
        },
        handleDropdownCloseAll: function (e, plugin) {

            if ($(e.target).closest('#lmm').length)
                return;
            //close first level submenus
            plugin.closeAllSubmenus()

        },
        resetHandlers: function ($target) {

            $target.off(this.touchEnd);
            $target.off(this.touchMove);
            var $li = $target.parent();
            $li.off('mousemove.hoverIntent');
            //$li.off('mouseenter.hoverIntent');
            $li.off('mouseleave.hoverIntent');
            $li.removeProp('hoverIntent_t');
            $li.removeProp('hoverIntent_s');
        },
        triggerSubmenu: function ($li, plugin) {
            plugin.closeSubmenu($li.siblings('.open'));
            plugin.openSubmenu($li);
        },
        openSubmenu: function ($li) {

            if ($li.hasClass('open'))
                return;
            $li.trigger('show.lmm.dropdown');
            $li.addClass('open');
            $li.trigger('shown.lmm.dropdown');
        },
        closeSubmenu: function ($li) {

            if (!$li.hasClass('open'))
                return;
            $li.trigger('hide.lmm.dropdown');
            $li.removeClass('open');
            $li.trigger('hidden.lmm.dropdown');
        },
        closeAllSubmenus: function () {

            var $li = this.$lmm.find('.lmm-item.open');

            if ($li.length) {
                this.closeSubmenu($li);
                //this.trigger('hidden.lmm.dropdown.all');
            }


            return;
        },
        lmmInitDropdownAnimations: function () {

            //remove the events
            this.$lmm.off('show.lmm.dropdown.animate hide.lmm.dropdown.animate');
            this.$lmm.find('.lmm-dropdown-menu').removeAttr('style');
            if (this.$lmm.hasClass('lmm-is-horizontal'))
                return;
            this.$lmm.on('show.lmm.dropdown.animate hide.lmm.dropdown.animate', '.lmm-dropdown', function (e) {

                e.stopPropagation();
                $(this).find('.lmm-dropdown-menu').first().stop(true, true).slideToggle();
            });
        },
        lmmInitBackgrounds: function () {

            var $ul = this.$lmm.find('.lmm-dropdown.lmm-has-background > .lmm-dropdown-menu');

            $ul.each(function () {

                var src = $(this).data('lmm-src'),
                        position = $(this).data('lmm-position'),
                        repeat = $(this).data('lmm-repeat'),
                        attachment = $(this).data('lmm-attachment'),
                        size = $(this).data('lmm-size');

                $(this).css({'background-image': 'url(' + src + ')', 'background-position': position, 'background-repeat': repeat, 'background-attachment': attachment, 'background-size': size});
            });


        },
        lmmInitTabs: function () {

            var plugin = this;

            //reset style on resize
            this.$lmm.find('.lmm-item-type-lmm-tabs.lmm-dropdown.lmm-item-level-0 > .lmm-dropdown-menu > li.clearfix').removeAttr('style');

            //destroy scrollbar
            if (this.settings.perfectScrollbar)
                this.$lmm.find('.lmm-item-type-lmm-tabs.lmm-dropdown.lmm-item-level-0 .lmm-item-type-tab > .lmm-dropdown-menu[data-ps-id]').perfectScrollbar('destroy');

            //remove data           
            this.$lmm.find('.lmm-item-type-lmm-tabs.lmm-dropdown.lmm-item-level-0 .lmm-item-type-tab > .lmm-dropdown-menu').data('lmm-tabHeight', false).data('lmm-psScrollbar', false).data('lmm-killHover', false).removeAttr('style');

            //remove tab events
            this.$lmm.off('shown.lmm.dropdown.sizetabs.tabheight', '.lmm-item-type-tab');
            this.$lmm.off('shown.lmm.dropdown.sizetabs', '.lmm-item-type-lmm-tabs.lmm-dropdown.lmm-item-level-0');

            if (!this.$lmm.hasClass('lmm-is-horizontal'))
                return;

            //tab events
            this.$lmm.on('shown.lmm.dropdown.sizetabs', '.lmm-item-type-lmm-tabs.lmm-dropdown.lmm-item-level-0', function (e) {
                e.stopPropagation();
                plugin.sizeTabs($(this));
            });
            //trigger tab events in open tabs
            this.$lmm.find('.lmm-item-type-lmm-tabs.lmm-dropdown.lmm-item-level-0.open').trigger('shown.lmm.dropdown.sizetabs');
        },
        sizeTabs: function (tabs) {

            var plugin = this,
                    $tabs = $(tabs),
                    $tabs_block = $tabs.find('> .lmm-dropdown-menu > li.clearfix'),
                    $opened = $tabs.find('.lmm-item-type-tab.open'),
                    minHeight = $tabs_block.outerHeight();

            if (!$tabs.length)
                return;

            this.$lmm.on('shown.lmm.dropdown.sizetabs.tabheight', '.lmm-item-type-tab', function (e) {

                e.stopPropagation();

                var $current = $(this),
                        $content = $(this).find('> .lmm-dropdown-menu'),
                        offsetTop = plugin.handleElementOffset($content);

                plugin.handleDropdownMaxHeight(e, $current, offsetTop, minHeight);

                $tabs_block.css({'min-height': $current.find('> .lmm-dropdown-menu').data('lmm-tabHeight') + 'px'});

            });

            if ($opened.length) {
                $opened.trigger('shown.lmm.dropdown.sizetabs.tabheight');
                return;
            }

            plugin.openSubmenu($tabs.find('.lmm-item-type-tab').first());
        },
        handleDropdownMaxHeight: function (e, li, offsetTop, minHeight) {

            e.stopPropagation();

            var plugin = this,
                    $li = $(li),
                    $content = $li.find('> .lmm-dropdown-menu');

            if ($content.data('lmm-tabHeight') > 1) {

                $content.css({'height': $content.data('lmm-tabHeight') + 'px', 'overflow-y': 'auto'});

                return;
            }

            var contentHeight = $content.outerHeight(),
                    windowHeight = $(window).height() - offsetTop - 15,
                    tempHeight = Math.min(contentHeight, windowHeight),
                    Height = Math.max(tempHeight, minHeight);

            $content.css({'height': Height + 'px', 'overflow-y': 'auto'}).data('lmm-tabHeight', Height);

            if (contentHeight === Height)
                return;

            $li.trigger('shown.lmm.dropdown.pscrollbar');


        },
        handleElementOffset: function (element) {

            var $element = $(element),
                    scrolled = isNaN(parseInt(this.$sticky.data('sticky-scrolled'))) ? 0 : parseInt(this.$sticky.data('sticky-scrolled'));

            if (!$element.is(':visible'))
                $element.data('element-style', $element.attr('style'));

            if (!$element.is(':visible'))
                $element.css({'visibility': 'hidden', 'display': 'block', 'transform': 'none', 'animation': 'none'});

            var offsetTop = $element.offset().top - scrolled;

            if (!$element.is(':visible'))
                $element.removeAttr('style').attr('style', $element.data('element-style'));

            return offsetTop;

        },
        lmmInitFirstLevelActive: function () {
            this.$lmm.find('.lmm-current-menu-item:not(.lmm-item-type-tab)').addClass('active').first().parents('.lmm-item:not(.lmm-item-type-tab)').addClass('active');
        },
        lmmInitVerticalOpen: function (plugin) {

            plugin = plugin || this;

            if (!this.$lmm.hasClass('lmm-is-vertical'))
                return;

            plugin.$navmenu = this.$lmm.closest('#lmm');

            if (!plugin.$navmenu.length)
                return;

            plugin.$navmenu.find('.lmm-item.lmm-item-level-0.lmm-dropdown.active').addClass('open').trigger('shown.lmm.dropdown');


        },
        lmmInitStickyOnScroll: function () {

            var plugin = this;
            plugin.$sticky = this.$navbar.filter('[data-sticky="1"]').first();
            if (plugin.$sticky.hasClass('lmm-is-vertical') || !plugin.$sticky.length || typeof $.fn.scrollTop === 'undefined')
                return;
            $(window).load(function () {
                plugin.handleStickyOnScroll();
            });
            $(window).scroll(function () {
                plugin.handleStickyOnScroll();
            });
        },
        handleStickyOnScroll: function () {

            var plugin = this;

            var stickyheight = plugin.$sticky.height();

            plugin.$sticky.on('hidden.bs.collapse shown.bs.collapse', function () {
                stickyheight = $(this).height();
            });

            var stickyoffset = Math.abs(plugin.$sticky.data('stickyoffset')),
                    offset = stickyoffset > stickyheight ? stickyoffset : stickyheight + 10,
                    scroll = $(window).scrollTop();

            var stikystop = $(document).height() - $(window).height() - offset < stickyheight;

            plugin.$sticky.data('sticky-scrolled', scroll);

            if (offset == 0 && !plugin.$sticky.hasClass('lmm-navbar-fixed-top')) {

                plugin.$sticky.toggleClass('lmm-navbar-fixed-top').trigger('sticky.lmm.navbar');
                return;
            }

            if (scroll >= offset && !stikystop && !plugin.$sticky.hasClass('lmm-navbar-fixed-top')) {
                plugin.$sticky.find('.lmm-navbar-collapse.collapse.in').collapse('hide');
                plugin.$sticky.toggleClass('lmm-navbar-fixed-top');
                plugin.$sticky.trigger('sticking.lmm.navbar');
                setTimeout(function () {
                    plugin.$sticky.trigger('sticky.lmm.navbar');
                }, 200);
            } else if (scroll < offset && plugin.$sticky.hasClass('lmm-navbar-fixed-top')) {
                plugin.$sticky.toggleClass('lmm-navbar-fixed-top');
                plugin.$sticky.trigger('unsticking.lmm.navbar');
                setTimeout(function () {
                    plugin.$sticky.trigger('unsticky.lmm.navbar');
                }, 200);
            }


        },
        lmmInitDropdownFloat: function (plugin) {

            plugin = plugin || this;

            this.$lmm.off('shown.lmm.dropdown.float');

            if (!this.$lmm.hasClass('lmm-is-horizontal'))
                return;

            this.$lmm.on('shown.lmm.dropdown.float', '.lmm-item.lmm-dropdown:not(.lmm-dropdown-full):not(.lmm-item-type-tab)', function (e) {

                e.stopPropagation();

                var $dropdown = $(this).find('> .lmm-dropdown-menu');

                if (!$dropdown.length)
                    return;

                var elH = $dropdown.outerWidth(),
                        W = $(window).innerWidth(),
                        p = $dropdown.offset(),
                        l = p.left,
                        r = W - (l + elH);

                if ($(this).hasClass('lmm-dropdown-left') && l < 0) {

                    $dropdown.css({'margin-right': l - plugin.settings.containerGutter + 'px'});
                } else if (r < 0) {

                    $dropdown.css({'margin-left': r - plugin.settings.containerGutter + 'px'});
                }

            });

        },
        lmmInitContainerWidth: function (plugin) {

            plugin = plugin || this;

            plugin.handleContainerFixed(this.$navbar);

            plugin.handleContainerAuto(this.$navbar);

            this.$navbar.on('sticking.lmm.navbar unsticking.lmm.navbar', function () {
                plugin.handleContainerAuto($(this));
                plugin.handleContainerFixed($(this));
            });
        },
        handleContainerAuto: function (navbar) {

            var $navbar = $(navbar),
                    $container = $navbar.find('.container-auto'),
                    width = $navbar.parent().innerWidth(),
                    responsive = this.handleResponsive();

            if (!$container.length)
                return;
            if ($navbar.hasClass('lmm-navbar-fixed-top') && !responsive) {
                $container.css({'width': width + 'px'});
            } else {
                $container.removeAttr('style');
            }

        },
        handleContainerFixed: function (navbar) {

            var $navbar = $(navbar),
                    $container = $navbar.find('.container.fixed'),
                    responsive = this.handleResponsive();

            if (!$container.length)
                return;

            $navbar.removeAttr('style');

            if ($navbar.hasClass('lmm-navbar-fixed-top') && !responsive)
                return;

            var width = responsive ? $container.outerWidth() - parseInt($container.css('padding-left')) * 2 : $container.outerWidth();


            $navbar.css({'width': width + 'px', 'margin-left': 'auto', 'margin-right': 'auto'});


        }
        ,
        lmmInitCart: function (plugin) {

            plugin = plugin || this;
            var $cart = plugin.$lmm.find('li.lmm-item-type-lmm-cart'),
                    url = $cart.find('> a').data('cart-url'),
                    qty = $cart.find('> a').data('cart-qty');
            if (!$cart.length)
                return;
            if (qty === 0)
                $cart.removeClass('lmm-dropdown');

            $('body').bind('added_to_cart', function () {
                plugin.handleWooCart(plugin, $cart, url);
            });
            $('body').bind('edd_quantity_updated', function () {
                plugin.handleEddCart(plugin, $cart, url);
            });
        },
        handleWooCart: function (plugin, $cart, url) {

            plugin = plugin || this;
            $cart.each(function () {

                var $woo_cart = $cart.find('.widget_shopping_cart');
                if (!$woo_cart.length)
                    return;
                var total = $woo_cart.find('.total .amount').html(),
                        the_quantities = $woo_cart.find('.quantity'),
                        qty = 0,
                        numberPattern = /\d+/g;
                the_quantities.each(function (idx, el) {
                    var qtytext = $(el).html().match(numberPattern);
                    var qtyint = parseInt(qtytext[0]);
                    qty = qty + qtyint;
                });
                plugin.updateCart($(this), total, qty, url);
            });
        },
        handleEddCart: function (plugin, $cart, url) {

            plugin = plugin || this;
            $cart.each(function () {

                var $edd_cart = $cart.find('.widget_edd_cart_widget');
                if (!$edd_cart.length)
                    return;
                var total = $edd_cart.find('.edd_subtotal .subtotal').html(),
                        qty = $edd_cart.find('.edd-cart-quantity').html();
                plugin.updateCart($(this), total, qty, url);
            });
        },
        updateCart: function (cart, total, qty, url) {

            //alert('test');

            var $cart = $(cart);
            var $cart_total = $cart.find('.cart_total'),
                    $cart_qty = $cart.find('.cart_qty');
            $cart_qty.addClass('animate');
            $cart_total.html(total);
            $cart_qty.html(qty);
            if (qty > 0)
                $cart.addClass('lmm-dropdown').find('> a').addClass('lmm-dropdown-toggle');
            else if (qty === 0)
                $cart.removeClass('lmm-dropdown').find('> a').removeClass('lmm-dropdown-toggle');

            if (url)
                $cart.find('> a').attr('href', url)

            setTimeout(function () {
                $cart_qty.removeClass('animate');
            }, 1500);
        },
        lmmInitFixOffCanvas: function () {

            var $offcanvas = this.$lmm.closest('.navbar-offcanvas'),
                    $collapsed = this.$lmm.closest('.navmenu[class*="offcanvas-"]'),
                    responsive = this.handleResponsive(),
                    maxWidth = $(window).width() * 0.68,
                    style = $('body').data('offcanvas-style');

            /*this.$navmenu = this.$lmm.closest('#lmm');
             
             alert('test 2');
             
             if (!this.$navmenu.length)
             return;
             
             function removeMobileScroll(e) {
             e.preventDefault();
             }
             
             this.$navmenu.on('shown.bs.offcanvas', function () {
             alert('test');
             $('body').bind('touchmove', removeMobileScroll);
             });*/


            if ($offcanvas.length) {

                if (!responsive) {

                    $offcanvas.removeAttr('style').removeClass('in').removeClass('canvas-slid');
                    $('body').removeAttr('style');
                    if (style)
                        $('body').attr('style', $('body').data('offcanvas-style')).removeData('offcanvas-style')

                    return;
                }

                var outerWidth = $offcanvas.outerWidth();
                if (outerWidth > maxWidth)
                    $offcanvas.css({'width': maxWidth + 'px'});
                return;
            }

            if ($collapsed.length) {

                if (!responsive) {
                    $collapsed.removeAttr('style');
                    return;
                }

                var outerWidth = $collapsed.outerWidth();
                if (outerWidth > maxWidth)
                    $collapsed.css({'width': maxWidth + 'px'});
                return;
            }



        },
        lmmInitOffCanvasCollapsed: function () {

            var $collapsed = this.$lmm.closest('.navmenu[class*="offcanvas-"]'),
                    width = $collapsed.outerWidth();

            if (!$collapsed.length || $collapsed.hasClass('inherit'))
                return;

            $collapsed.addClass('in-temp');

            $collapsed.on('hidden.bs.offcanvas', function () {
                $('body').removeClass('lmm-offcanvas-left lmm-offcanvas-right');
            });

            if ($collapsed.length && !$collapsed.hasClass('in') && $collapsed.is(":visible") && $collapsed.hasClass('navmenu-fixed-right')) {
                $('body').addClass('lmm-offcanvas');
                $('body').css({'paddingRight': width + 'px'});
                return;
            } else if ($collapsed.length && !$collapsed.hasClass('in') && $collapsed.is(":visible") && $collapsed.hasClass('navmenu-fixed-left')) {
                $('body').addClass('lmm-offcanvas');
                $('body').css({'paddingLeft': width + 'px'});
                return;
            } else if ($('body').hasClass('lmm-offcanvas')) {
                $('body').removeClass('lmm-offcanvas');
                $('body').css({'paddingLeft': ''});
                $('body').css({'paddingRight': ''});
                return;
            }

        },
        lmmInitMega: function (plugin) {

            plugin = plugin || this;

            if (!this.$lmm.hasClass('lmm-is-horizontal'))
                return;

            this.$lmm.on('shown.lmm.dropdown.login slid.bs.carousel.login', '.lmm-item-type-lmm-mega.lmm-item-level-0', function (e) {

                var $li = $(this),
                        $dropdown = $li.find('> .lmm-dropdown-menu'),
                        offsetTop = plugin.handleElementOffset($dropdown),
                        maxHeight = $(window).height() - offsetTop - 15;

                $dropdown.css({'max-height': maxHeight + 'px', 'overflow-y': 'auto'});

                if (maxHeight >= $dropdown.outerHeight())
                    return;

                $li.trigger('shown.lmm.dropdown.pscrollbar');

            });

        },
        lmmInitLogIn: function (plugin) {

            plugin = plugin || this;

            this.$lmm.on('shown.lmm.dropdown.login', '.lmm-item-type-lmm-login.lmm-item-level-0', function (e) {

                var $li = $(this);

                plugin.handleRegister(e, $li);

            });

            if (!this.$lmm.hasClass('lmm-is-horizontal'))
                return;

            this.$lmm.on('shown.lmm.dropdown.login slid.bs.carousel.login', '.lmm-item-type-lmm-login.lmm-item-level-0', function (e) {

                var $li = $(this),
                        $dropdown = $li.find('> .lmm-dropdown-menu'),
                        offsetTop = plugin.handleElementOffset($dropdown),
                        maxHeight = $(window).height() - offsetTop - 15;

                $dropdown.css({'max-height': maxHeight + 'px', 'overflow-y': 'auto'});

                if (maxHeight >= $dropdown.outerHeight())
                    return;

                $li.trigger('shown.lmm.dropdown.pscrollbar');

            });

        },
        handleRegister: function (e, li) {

            var $li = $(li),
                    $form = $li.find('form.lmm-registration-form'),
                    $button = $form.find('#btn-new-user');

            $button.click(function (event) {

                //Prevent default action, so when user clicks button he doesn't navigate away from page
                if (event.preventDefault) {
                    event.preventDefault();
                } else {
                    event.returnValue = false;
                }

                var $indicator = $form.find('.indicator').show(),
                        $message = $form.find('.result-message').hide();
                $indicator.show();
                $message.hide();
                // Collect data from inputs
                var reg_nonce = $form.find('#lmm_new_user_nonce').val();
                var reg_user = $form.find('#lmm_username').val();
                var reg_pass = $form.find('#lmm_pass').val();
                var reg_mail = $form.find('#lmm_email').val();
                var reg_name = $form.find('#lmm_name').val();
                var reg_nick = $form.find('#lmm_nick').val();
                /**
                 * AJAX URL where to send data
                 * (from localize_script)
                 */
                var ajax_url = lmm.ajax_url;
                // Data to send
                var data = {
                    action: 'register_user',
                    nonce: reg_nonce,
                    user: reg_user,
                    pass: reg_pass,
                    mail: reg_mail,
                    name: reg_name,
                    nick: reg_nick
                };
                // Do AJAX request
                $.post(ajax_url, data, function (response) {

                    // If we have response
                    if (response) {
                        // Hide 'Please wait' indicator
                        $indicator.hide();
                        if (response === '1') {
                            // If user is created
                            $message.html(lmm.registered); // Add success message to results div
                            $message.removeClass('alert-danger').addClass('alert-success'); // Add class success to results div
                            $message.show(); // Show results div
                        } else {
                            $message.html(response); // If there was an error, display it in results div
                            $message.addClass('alert-danger'); // Add class failed to results div
                            $message.show(); // Show results div
                        }
                    }
                });
            });
        },
        lmmInitScrollBar: function (plugin) {

            plugin = plugin || this;

            if (!this.settings.perfectScrollbar)
                return;

            plugin.handleDropdownScrollbar(plugin);

            plugin.handleVerticalScrollbar(plugin);


        },
        handleDropdownScrollbar: function (plugin) {

            plugin = plugin || this;

            this.$lmm.on('shown.lmm.dropdown.pscrollbar', '.lmm-item-type-tab, .lmm-item-type-lmm-mega.lmm-item-level-0, .lmm-item-type-lmm-login.lmm-item-level-0', function (e) {

                e.stopPropagation();

                var $li = $(this),
                        $dropdown = $li.find('> .lmm-dropdown-menu');

                //fix for mousehover -------------------------------------------
                $dropdown.scroll($.debounce(500, true, function () {
                    $(this).data('lmm-killHover', true);
                }));

                $dropdown.scroll($.debounce(500, function () {
                    $(this).removeData('lmm-killHover');
                }));

                $dropdown.data('lmm-psScrollbar', true);

                $dropdown.perfectScrollbar({
                    useKeyboard: true,
                    suppressScrollX: true,
                    includePadding: true,
                    scrollYMarginOffset: 1
                });

                $dropdown.perfectScrollbar('update');


            });

        },
        handleVerticalScrollbar: function (plugin) {

            plugin = plugin || this;

            // we dont need scrollbar in horizontal offcanvas as its showed on mobile devices
            //if (!this.$lmm.hasClass('lmm-is-vertical'))
            if (!this.$lmm.hasClass('navmenu-nav'))
                return;

            plugin.$navmenu = this.$lmm.closest('#lmm');

            if (!plugin.$navmenu.length)
                return;

            plugin.$navmenu.css({'overflow': 'hidden'});

            plugin.$navmenu.perfectScrollbar({
                useKeyboard: true,
                suppressScrollX: true,
                includePadding: true,
                scrollYMarginOffset: 1
            });

            plugin.$navmenu.find('.lmm-item.lmm-item-level-0').on('hidden.lmm.dropdown.pscrollbar', function (e) {

                e.stopPropagation();

                $(this).closest('#lmm').perfectScrollbar('destroy');

            });

            plugin.$navmenu.find('.lmm-item.lmm-item-level-0').on('shown.lmm.dropdown.pscrollbar', function (e) {

                e.stopPropagation();

                plugin.$navmenu.perfectScrollbar({
                    useKeyboard: true,
                    suppressScrollX: true,
                    includePadding: true,
                    scrollYMarginOffset: 1
                });

            });

            plugin.$navmenu.on('shown.bs.offcanvas hidden.bs.offcanvas', function () {

                var $psMenu = $(this);

                $psMenu.on('mouseup mouseenter', '.ps-scrollbar-y-rail', function () {

                    $psMenu.find('.lmm-item > .lmm-dropdown-toggle').data('lmm-killHover', true);
                });

                $psMenu.on('mouseleave', '.ps-scrollbar-y-rail', function () {
                    $psMenu.find('.lmm-item > .lmm-dropdown-toggle').removeData('lmm-killHover');
                });

                $(this).perfectScrollbar('update');
            });

        },
        lmmInitClasses: function () {

            var $body = $('body'),
                    responsive = this.handleResponsive(),
                    collapsed = ($body.hasClass('lmm-offcanvas') || $body.hasClass('canvas-sliding') || $body.hasClass('canvas-slid')),
                    offcanvas = ((responsive && this.$lmm.closest('.navbar-offcanvas').length) || this.$lmm.closest('.navmenu-nav').length);
            if (collapsed || offcanvas) {
                this.$lmm.addClass('lmm-is-vertical').removeClass('lmm-is-horizontal');
                $(document).off(this.touchEnd + '.hidden.lmm.dropdown.all click.hidden.lmm.dropdown.all');
            }
            if (!collapsed && !offcanvas && !responsive)
                this.$lmm.addClass('lmm-is-horizontal').removeClass('lmm-is-vertical');
            if (!responsive)
                this.$lmm.removeClass('lmm-is-responsive');
            if (responsive && !collapsed && !offcanvas)
                this.$lmm.addClass('lmm-is-responsive').removeClass('lmm-is-horizontal').removeClass('lmm-is-vertical');

        },
        handleResponsive: function (plugin) {
            return this.$lmm.parent().parent().find('.lmm-navbar-toggle').is(':visible');
        },
        lmmInitSlideBar: function (plugin) {

            plugin = plugin || this;
            if (!this.$lmm.hasClass('lmm-is-horizontal') || !this.$lmm.hasClass('lmm-hover-slidebar'))
                return;

            $(document).ready(function () {
                setTimeout(function () {
                    plugin.$lmm.append('<span class="lmm-hover-slidebar invisible"><span class="bar"></span></span>');
                    plugin.handleSlideBar(plugin.$lmm);
                }, 1000);

            });
        },
        handleSlideBar: function (ul, plugin) {

            plugin = plugin || this;
            var $ul = $(ul),
                    slide_nav = $ul.find('span.lmm-hover-slidebar'),
                    li = '> li.lmm-item.lmm-item-level-0:not(.lmm-item-type-lmm-icon):not(.lmm-item-type-lmm-search):not(.lmm-item-type-lmm-cart):not(.lmm-item-type-lmm-login):not(.lmm-item-type-lmm-social)',
                    $subtitle = $ul.find('> li > a > .lmm-item-content > .lmm-subtitle'),
                    subtitle = $subtitle.length ? parseInt($subtitle.css('font-size')) : 0,
                    $open = $ul.find('> li.lmm-item.lmm-item-level-0.open'),
                    $active = $open.length ? $open : $ul.find('> li.lmm-item.lmm-item-level-0.active'),
                    $current = $active.length ? $active : $ul.find(li).not('.lmm-float-opposite').first();

            var bottom = function ($ul, $current) {

                if (!$ul.hasClass('sl-middle'))
                    return 'auto';
                return Math.round(parseInt($current.find('> a').outerHeight()) * 0.5 - parseInt($current.find('> a').css('font-size')) - subtitle - 5) + 'px';
            }

            function slide_nav_css($current) {
                var width = parseInt($current.find('> a').outerWidth()),
                        padding = parseInt($current.css('margin-left') + $current.find('> a').find('> .lmm-item-content').css('padding-left')),
                        pos_left = parseInt($current.position().left) + padding;
                slide_nav.css({'width': width + 'px', 'left': pos_left + 'px', 'bottom': bottom($ul, $current)}).removeClass('invisible');
            }

            slide_nav_css($current);

            slide_nav.data('slidebar-style', slide_nav.attr('style'));

            //handle sticky transforms
            this.$navbar.on('sticky.lmm.navbar.slidebar unsticky.lmm.navbar.slidebar', function () {
                slide_nav.addClass('invisible');
                var $ul = $(this).find('.lmm-navbar-nav'),
                        $open = $ul.find('> ' + li + '.open'),
                        $active = $open.length ? $open : $ul.find('> li.lmm-item.lmm-item-level-0.active'),
                        $current = $active.length ? $active : $ul.find(li).not('.lmm-float-opposite').first();
                slide_nav_css($current);
                slide_nav.data('slidebar-style', slide_nav.attr('style'));
            });

            //handle mouse events
            $ul.find(li).on('hover.slidebar', function () {
                slide_nav_css($(this));
            });

            if (this.$lmm.hasClass('lmm-trigger-click')) {
                $ul.find(li).on('hidden.lmm.dropdown.slidebar', function () {
                    slide_nav.attr('style', slide_nav.data('slidebar-style')).show();
                });

                return;
            }

            if (typeof $.fn.hoverIntent === 'undefined') {

                $ul.on('mouseleave.slidebar', function () {
                    slide_nav.attr('style', slide_nav.data('slidebar-style')).show();
                });

                return;
            }

            $ul.hoverIntent({
                over: function () {
                },
                out: function () {
                    slide_nav.attr('style', slide_nav.data('slidebar-style')).show();
                },
                sensitivity: plugin.settings.intent_interval,
                timeout: plugin.settings.intent_delay,
                interval: plugin.settings.intent_threshold
            });

        },
        lmmInitSocial: function (plugin) {

            //don't initialize if not horizontal menu
            this.$lmm.off('shown.lmm.dropdown.social hidden.lmm.dropdown.social');
            if (this.$lmm.hasClass('lmm-is-responsive') || this.$lmm.hasClass('lmm-is-vertical') || !this.$lmm.hasClass('lmm-is-horizontal'))
                return;
            plugin = plugin || this;
            this.$lmm.on('shown.lmm.dropdown.social hidden.lmm.dropdown.social', '.lmm-item-type-lmm-social.lmm-item-level-0', function () {
                plugin.$lmm.find('> li.lmm-item.lmm-item-level-0:not(.lmm-item-type-lmm-social)').toggleClass('invisible');
                plugin.$lmm.find('span.lmm-hover-slidebar').toggleClass('invisible');
            });
        },
        lmmDebounced: function (plugin) {

            plugin = plugin || this;

            $(window).resize($.debounce(300, function () {
                plugin.lmmInitClasses();
                plugin.lmmInitStickyOnScroll();
                plugin.lmmInitOffCanvasCollapsed();
                plugin.lmmInitFixOffCanvas();
                plugin.lmmInitDropdownRetractors();
                plugin.lmmInitDropdownCloseAll();
                plugin.lmmInitDropdownAnimations();
                plugin.lmmInitContainerWidth();
                plugin.lmmInitDropdownFloat();
                plugin.lmmInitTabs();
                plugin.lmmInitMega();
                plugin.lmmInitLogIn();
                plugin.lmmInitSocial();
            }));
        }
    };
    $.fn[ pluginName ] = function (options) {
        var args = arguments;
        if (options === undefined || typeof options === 'object') {
            return this.each(function () {
                if (!$.data(this, "plugin_" + pluginName)) {
                    $.data(this, "plugin_" + pluginName, new Plugin(this, options));
                }
            });
        } else if (typeof options === 'string' && options[0] !== '_' && options !== 'init') {
            // Cache the method call to make it possible to return a value
            var returns;
            this.each(function () {
                var instance = $.data(this, 'plugin_' + pluginName);
                // Tests that there's already a plugin-instance and checks that the requested public method exists
                if (instance instanceof Plugin && typeof instance[options] === 'function') {

                    // Call the method of our plugin instance, and pass it the supplied arguments.
                    returns = instance[options].apply(instance, Array.prototype.slice.call(args, 1));
                }

                // Allow instances to be destroyed via the 'destroy' method
                if (options === 'destroy') {
                    $.data(this, 'plugin_' + pluginName, null);
                }
            });
            // If the earlier cached method gives a value back return the value, otherwise return this to preserve chainability.
            return returns !== undefined ? returns : this;
        }
    };
})(jQuery, window, document);

(function ($) {

    var lmm_initialized = false;
    jQuery(function () {
        lmm_init();
    });
    //Backup
    $(window).load(function () {
        lmm_init();
    });
    function lmm_init() {

        if (lmm_initialized)
            return;
        lmm_initialized = true;
        //scroll to non-ID "hashes"
        if (window.location.hash.substring(1, 2) == '.') {
            var $scrollTarget = $(window.location.hash.substring(1));
            if ($scrollTarget.size())
                window.scrollTo(0, $scrollTarget.offset().top);
        }
        $('.navmenu-nav, .lmm-navbar-nav').lmm();
    }

})(jQuery);

/*
 * jQuery throttle / debounce - v1.1 - 3/7/2010
 * http://benalman.com/projects/jquery-throttle-debounce-plugin/
 * 
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */
(function (b, c) {
    var $ = b.jQuery || b.Cowboy || (b.Cowboy = {}), a;
    $.throttle = a = function (e, f, j, i) {
        var h, d = 0;
        if (typeof f !== "boolean") {
            i = j;
            j = f;
            f = c
        }
        function g() {
            var o = this, m = +new Date() - d, n = arguments;
            function l() {
                d = +new Date();
                j.apply(o, n)
            }
            function k() {
                h = c
            }
            if (i && !h) {
                l()
            }
            h && clearTimeout(h);
            if (i === c && m > e) {
                l()
            } else {
                if (f !== true) {
                    h = setTimeout(i ? k : l, i === c ? e - m : e)
                }
            }
        }
        if ($.guid) {
            g.guid = j.guid = j.guid || $.guid++
        }
        return g
    };
    $.debounce = function (d, e, f) {
        return f === c ? a(d, e, false) : a(d, f, e !== false)
    }
})(this);
