<?php
class GetInTouch_Widget extends WP_Widget {

    function __construct() {
        parent::__construct(
            'getintouch_widget',
            esc_html__('* Get In Touch', 'unfinityplus'),
            array('description' => esc_html__('Get In Touch Widget', 'unfinityplus'),)
        );
    }

    function widget($args, $instance) {

        extract($args);

        $title = isset($instance['title']) ? (!empty($instance['title']) ? $instance['title']: '') : '';
        $phone_text = isset($instance['phone_text']) ? (!empty($instance['phone_text']) ? $instance['phone_text']: '') : '';
        $mail_text = isset($instance['mail_text']) ? (!empty($instance['mail_text']) ? $instance['mail_text']: '') : '';
        $address_text = isset($instance['address_text']) ? (!empty($instance['address_text']) ? $instance['address_text']: '') : '';
        $address_text_url = str_replace(' ', '+', $address_text);
        ?>
        <div class="contact-info widget">
            <?php if(!empty($title)) : ?>
                <h3 class="footer-widget-title"><?php echo esc_attr($title); ?></h3>
            <?php endif; ?>
            <ul class="ct-contact-info-inner">
                <?php if(!empty($phone_text)): ?>
                    <li>
                        <i class="fa fa-phone"></i>
                        <a href="tel:<?php echo esc_attr( $phone_text ); ?>"><?php echo wp_kses_post( $phone_text  ); ?></a>
                    </li>
                <?php endif; ?>
                <?php if(!empty($mail_text)): ?>
                    <li>
                        <i class="fa fa-envelope"></i>
                        <a href="mailto:<?php echo esc_attr( $mail_text ); ?>">
                            <?php echo wp_kses_post( $mail_text  ); ?>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if(!empty($address_text)): ?>
                    <li>
                        <i class="fa fa-home"></i>
                        <a href="http://maps.google.com/?q=<?php echo esc_attr( $address_text_url ); ?>" target="_blank">
                            <?php echo wp_kses_post( $address_text  ); ?>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    <?php }

    function update( $new_instance, $old_instance ) {
         $instance = $old_instance;
         $instance['title'] = strip_tags($new_instance['title']);
         $instance['phone_text'] = strip_tags($new_instance['phone_text']);
         $instance['mail_text'] = strip_tags($new_instance['mail_text']);
         $instance['address_text'] = strip_tags($new_instance['address_text']);

         return $instance;
    }

    function form( $instance ) {
         $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
         $phone_text = isset($instance['phone_text']) ? esc_attr($instance['phone_text']) : '';
         $mail_text = isset($instance['mail_text']) ? esc_attr($instance['mail_text']) : '';
         $address_text = isset($instance['address_text']) ? esc_attr($instance['address_text']) : '';

         ?>
         <p><label for="<?php echo esc_url($this->get_field_id('title')); ?>"><?php esc_html_e( 'Title', 'unfinityplus' ); ?></label>
         <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></p>

         <p><label for="<?php echo esc_url($this->get_field_id('phone_text')); ?>"><?php esc_html_e( 'Phone', 'unfinityplus' ); ?></label>
         <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('phone_text') ); ?>" name="<?php echo esc_attr( $this->get_field_name('phone_text') ); ?>" type="text" value="<?php echo esc_attr( $phone_text ); ?>" /></p>

         <p><label for="<?php echo esc_url($this->get_field_id('mail_text')); ?>"><?php esc_html_e( 'Mail', 'unfinityplus' ); ?></label>
         <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('mail_text') ); ?>" name="<?php echo esc_attr( $this->get_field_name('mail_text') ); ?>" type="text" value="<?php echo esc_attr( $mail_text ); ?>" /></p>
    
        <p><label for="<?php echo esc_url($this->get_field_id('address_text')); ?>"><?php esc_html_e( 'Address', 'unfinityplus' ); ?></label>
         <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('address_text') ); ?>" name="<?php echo esc_attr( $this->get_field_name('address_text') ); ?>" type="text" value="<?php echo esc_attr( $address_text ); ?>" /></p>
    <?php
    }

}
add_action( 'widgets_init', 'unfinityplus_register_getintouch' );
function unfinityplus_register_getintouch(){
    if(function_exists('ct_allow_RegisterWidget')){
        ct_allow_RegisterWidget( 'GetInTouch_Widget' );
    }
}