<?php
$atts_extra = shortcode_atts(array(
    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'gap'                  => '30',
    'post_ids'             => '',
    'col_lg'               => 4,
    'col_md'               => 3,
    'col_sm'               => 2,
    'col_xs'               => 1,
    'el_class'             => '',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
$tax = array();
extract(cms_get_posts_of_grid('event', $atts));
$counter = 0;
$row = 3;
$rtl = unfinityplus_get_opt( 'rtl', false );
$rtl_page = unfinityplus_get_page_opt( 'rtl', false );
if($rtl_page) {
    $rtl = $rtl_page;
}
if ($rtl || is_rtl()) {
    $carousel_rtl = 'true';
} else {
    $carousel_rtl = 'false';
}
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-upcoming-event <?php echo esc_attr($el_class); ?>">

    <div class="ct-upcoming-event-inner row">
        <?php if (is_array($posts)): ?>
            <div class="ct-upcoming-event-left col-lg-6 col-md-12 col-sm-12">
                <?php foreach ($posts as $key => $post) {
                    the_post();
                    $address = get_post_meta($post->ID, 'address', true);
                    $phone = get_post_meta($post->ID, 'phone', true);
                    $venue = get_post_meta($post->ID, 'venue', true);
                    $time = get_post_meta($post->ID, 'time', true);
                    if($key == 0) { ?>
                        <div class="ct-upcoming-event-item">
                            <h3 class="item-title">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                            </h3>
                            <div class="item-date-time">
                               <?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?> - <?php echo esc_attr($time); ?>
                            </div>
                            <div class="item-content">
                                <?php
                                    $cms_the_excerpt = get_the_excerpt($post->ID);
                                    if(!empty($cms_the_excerpt)) {
                                        echo wp_trim_words( $cms_the_excerpt, $num_words = 50, $more = null );
                                    } else {
                                        echo wp_trim_words( strip_shortcodes( $post->post_content ), $num_words = 50, $more = null );
                                    }
                                ?>
                            </div>
                            <ul class="item-meta">
                                <?php if(!empty($address)) :?>
                                    <li><label><i class="fa fa-map-marker"></i><?php echo esc_html__( 'Address:', 'unfinityplus' ) ?></label> <?php echo esc_attr($address); ?></li>
                                <?php endif; ?>
                                <?php if(!empty($phone)) :?>
                                    <li><label><i class="fa fa-phone"></i><?php echo esc_html__( 'Phone:', 'unfinityplus' ) ?></label> <?php echo esc_attr($phone); ?></li>
                                <?php endif; ?>
                            </ul>
                            <div class="item-more">
                                <a class="btn" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html__( 'Join Event', 'unfinityplus' ); ?></a>
                            </div>
                            <div class="item-datetime-box-medium">
                                <div class="date-day"><?php echo get_the_date('d', $post->ID); ?></div>
                                <div class="date-month-year">
                                    <?php echo get_the_date('M', $post->ID); ?><br/><?php echo get_the_date('Y', $post->ID); ?>
                                </div>
                            </div>
                        </div>
                    <?php }
                } ?>
            </div>
        <?php endif; ?>
        <?php if (is_array($posts)): ?>
            <div class="ct-upcoming-event-right col-lg-6 col-md-12 col-sm-12">
                <div class="ct-upcoming-event-carousel owl-carousel owl-dots-medium" data-item-xs="1" data-item-sm="1" data-item-md="1" data-item-lg="1" data-margin="30" data-loop="true" data-autoplay="false" data-autoplaytimeout="5000" data-smartspeed="250" data-center="false" data-arrows="false" data-bullets="true" data-stagepadding="0" data-stagepaddingsm="0" data-rtl="<?php echo esc_attr($carousel_rtl); ?>">
                    <?php foreach ($posts as $key2 => $post2) {
                        $address = get_post_meta($post2->ID, 'address', true);
                        $phone = get_post_meta($post2->ID, 'phone', true);
                        $venue = get_post_meta($post2->ID, 'venue', true);
                        $time = get_post_meta($post2->ID, 'time', true);
                        if($key2 != 0) {
                            $counter++;
                            if($row == 1){
                                echo '<div class="ct-upcoming-event-item-wrap">';
                            }else{
                                if($counter % $row == 1){
                                    echo '<div class="ct-upcoming-event-item-wrap">';
                                }
                            }
                            ?>
                            <div class="ct-upcoming-event-item">
                                <div class="item-body">
                                    <div class="item-datetime-box-small">
                                        <div class="date-day"><?php echo get_the_date('d', $post2->ID); ?></div>
                                        <div class="date-month-year">
                                            <?php echo get_the_date('M', $post2->ID); ?>
                                        </div>
                                    </div>
                                    <div class="item-holder">
                                        <h3 class="item-title">
                                            <a href="<?php echo esc_url(get_permalink( $post2->ID )); ?>"><?php echo esc_attr(get_the_title($post2->ID)); ?></a>
                                        </h3>
                                        <ul class="item-meta">
                                            <li><label><?php echo esc_html__( 'Venue:', 'unfinityplus' ) ?></label><?php echo esc_attr($venue); ?></li>
                                            <li><label><?php echo esc_html__( 'Time:', 'unfinityplus' ) ?></label><?php echo esc_attr($time); ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php if($row == 1){
                                echo '</div>';
                            } else {
                                if($counter % $row == 0){
                                    echo '</div>';
                                }
                            } ?>
                        <?php }
                    } ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>