<?php
extract(shortcode_atts(array(

    'testimonial_item' => '',
    'title_color' => '',
    'position_color' => '',
    'content_color' => '',
    'el_class' => '',
    'box_shadow_style' => 'boxshadow-style1',

), $atts));

wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-testimonial-carousel');
extract(unfinityplus_get_param_carousel($atts));
$testimonials = (array) vc_param_group_parse_atts($testimonial_item);
if(!empty($testimonials)) : ?>
<div class="ct-testimonial-carousel-wrap">
    <div id="<?php echo esc_attr($html_id);?>" class="ct-testimonial-carousel layout3 owl-carousel <?php echo esc_attr( $box_shadow_style.' '.$el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
        <?php foreach ($testimonials as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $content = isset($value['content']) ? $value['content'] : '';
            $position = isset($value['position']) ? $value['position'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $image_url = '';
            if (!empty($image)) {
                $attachment_image = wp_get_attachment_image_src($image, 'thumbnail');
                $image_url = $attachment_image[0];
            }
            ?>
            <div class="ct-testimonial-item">
                <div class="ct-testimonial-quote fa fa-quote-right <?php if($box_shadow_style == 'boxshadow-style2') { echo 'text-gradient'; } ?>"></div>
                <div class="ct-testimonial-holder">
                    <?php if(!empty($image_url)): ?>
                        <div class="ct-testimonial-image"><img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $title ); ?>" /></div>
                    <?php endif; ?>
                    <div class="ct-testimonial-meta">
                        <h3 class="ct-testimonial-title" style="<?php if(!empty($title_color)) { echo 'color:'.esc_attr($title_color).';'; } ?>"><?php echo esc_html($title); ?></h3>
                        <span class="ct-testimonial-position" style="<?php if(!empty($position_color)) { echo 'color:'.esc_attr($position_color).';'; } ?>"><?php echo esc_html($position); ?></span>
                    </div>
                </div>   
                <div class="ct-testimonial-content" style="<?php if(!empty($content_color)) { echo 'color:'.esc_attr($content_color).';'; } ?>"><?php echo apply_filters('the_content', $content); ?></div>
            </div>
        <?php } ?>
    </div>
</div>
<?php endif;?>