<?php
extract(shortcode_atts(array(

    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'el_class'             => '',
    'img_size'             => '600x438',

), $atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-sermon-carousel');
extract(cms_get_posts_of_grid('sermon', $atts));
extract(unfinityplus_get_param_carousel($atts));
wp_enqueue_script( 'waypoints' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-sermon-carousel owl-carousel owl-dots-medium <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
    <?php if (is_array($posts)):
        foreach ($posts as $post) {
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ) );
            $thumbnail    = $img['thumbnail'];
            $audio_url = get_post_meta($post->ID, 'audio_url', true);
            $video_url = get_post_meta($post->ID, 'video_url', true);
            $file_download = get_post_meta($post->ID, 'file_download', true);
            ?>
            <div class="ct-carousel-item">
                <div class="grid-item-inner ct-fade-in">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) : ?>
                        <div class="item-featured">
                             <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post( $thumbnail ); ?>
                             </a>
                        </div>
                    <?php endif; ?>
                    <div class="item-body">
                        <h3 class="item-title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                        </h3>
                        <div class="item-holder">
                            <div class="item-author">
                                <span><?php echo esc_html__('by', 'unfinityplus'); ?></span>
                                <?php the_author_posts_link(); ?>
                            </div>
                            <ul class="item-meta">
                                <?php if(!empty($audio_url)) : ?>
                                    <li><a class="btn-icon-popup" href="<?php echo esc_url($audio_url); ?>"><i class="fa fa-headphones"></i></a></li>
                                <?php endif; ?>
                                <?php if(!empty($video_url)) : ?>
                                    <li><a class="btn-icon-popup" href="<?php echo esc_url($video_url); ?>"><i class="fa fa-youtube-play"></i></a></li>
                                <?php endif; ?>
                                <?php if(!empty($file_download)) : ?>
                                    <li><a class="btn-icon-popup" href="<?php echo esc_url($file_download); ?>"><i class="fa fa-cloud-download"></i></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="item-content">
                            <?php
                                $cms_the_excerpt = get_the_excerpt($post->ID);
                                if(!empty($cms_the_excerpt)) {
                                    echo wp_trim_words( $cms_the_excerpt, $num_words = 22, $more = null );
                                } else {
                                    echo wp_trim_words( strip_shortcodes( $post->post_content ), $num_words = 22, $more = null );
                                }
                            ?>
                        </div>
                        <div class="item-date"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?></div>
                    </div>
                </div>
            </div>
        <?php }
    endif; ?>
</div>