<?php
$atts_extra = shortcode_atts(array(
    'content_list'         => '',
    'post_ids'             => '',
    'col_lg'               => 4,
    'col_md'               => 3,
    'col_sm'               => 2,
    'col_xs'               => 1,
    'filter'               => 'true',
    'filter_default_title' => 'All',
    'el_class'             => '',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
$filter_default_title = !empty($filter_default_title) ? $filter_default_title : 'All';

$col_lg = 12 / $col_lg;
$col_md = 12 / $col_md;
$col_sm = 12 / $col_sm;
$col_xs = 12 / $col_xs;
$grid_sizer = "col-xl-{$col_lg} col-lg-{$col_md} col-md-{$col_sm} col-sm-{$col_xs} col-{$col_xs}";
$grid_class = 'ct-grid-inner ct-grid-masonry row';
wp_enqueue_script('isotope');
wp_enqueue_script('imagesloaded');
wp_enqueue_script('unfinityplus-isotope', get_template_directory_uri() . '/assets/js/isotope.ct.js', array('jquery'), '1.0.0', true);
$cms_content_list = array();
$cms_content_list = (array) vc_param_group_parse_atts( $content_list );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-grid ct-menu-grid <?php echo esc_attr($el_class); ?>">

    <?php if ($filter == "true"): ?>
        <div class="grid-filter-wrap align-center>">
            <span class="filter-item active" data-filter="*"><?php echo esc_html($filter_default_title); ?></span>
            <?php
            $cat_list = array();
            foreach ( $cms_content_list as $item ) {
                $g_category = isset($item['category']) ? $item['category'] : '';
	            $c_a = explode(',', $g_category);
	            foreach ( $c_a as $c){
		            $r_c = str_replace(' ', '-', strtolower(trim($c)));
			        $cat_list[$r_c] = $c;
                }
            }
            ?>
            <?php foreach ($cat_list as $key => $value):
                $key_result = preg_replace('#[&]*#', '', $key);
                ?>
                <span class="filter-item" data-filter="<?php echo esc_attr('.' . $key_result); ?>">
                    <?php echo esc_attr($value); ?>
                </span>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="<?php echo esc_attr($grid_class); ?>" data-gutter="15">
        <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        <?php foreach ($cms_content_list as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $desc = isset($value['desc']) ? $value['desc'] : '';
            $menu_price = isset($value['menu_price']) ? $value['menu_price'] : '';
            $category = isset($value['category']) ? $value['category'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $img_size = isset($value['img_size']) ? $value['img_size'] : '100x100';
            $img = wpb_getImageBySize( array(
                'attach_id'  => $image,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            $item_class = "grid-item col-xl-{$col_lg} col-lg-{$col_md} col-md-{$col_sm} col-sm-{$col_xs} col-{$col_xs}";
            $c_l = explode(',',$category);
	        $filter_class_a = array();
	        foreach ( $c_l as $c_c ) {
		        $filter_class_a[] = str_replace(' ','-',trim(strtolower($c_c)));
            }
            $filter_class = implode(' ',$filter_class_a);
            $filter_class_result = preg_replace('#[&]*#', '', $filter_class);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class_result); ?>">
                <div class="grid-item-inner">
                    <?php if(!empty($image)) : ?>
                        <div class="menu-featured">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                    <?php endif; ?>
                    <div class="menu-holder">
                        <h3 class="menu-title">
                            <span class="menu-title-inner"><?php echo esc_attr($title); ?></span>
                            <span class="menu-dot"></span>
                            <span class="menu-price"><?php echo esc_attr( $menu_price ); ?></span>
                        </h3>
                        <div class="menu-description"><?php echo wp_kses_post( $desc ); ?></div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

</div>