<?php
extract(shortcode_atts(array(
    'sub_title' => '',
    'sub_title_color' => '',
    'title' => '',
    'title_color' => '',
    
    'icon_type' => 'icon',
    'icon_list' => 'fontawesome',
    'icon_fontawesome' => '',
    'icon_material_design' => '',
    'icon_flaticon' => '',
    'icon_etline' => '',
    'icon_image' => '',
    'icon_image_hover' => '',
    'icon_color' => '',
    'icon_font_size' => '',

    'btn_text' => '',
    'btn_link' => '',

    'animation' => '',
    'el_class' => '',
    'icon_style' => 'style1',
), $atts));
$icon_image_url = '';
if (!empty($icon_image)) {
    $attachment_image = wp_get_attachment_image_src($icon_image, 'full');
    $icon_image_url = $attachment_image[0];
}
$icon_name = "icon_" . $icon_list;
$icon_class = isset(${$icon_name}) ? ${$icon_name} : '';
$link = vc_build_link($btn_link);
$a_href = '';
$a_target = '';
if ( strlen( $link['url'] ) > 0 ) {
    $a_href = $link['url'];
    $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
}
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
?>
<div class="ct-cta-layout1 <?php echo esc_attr($el_class.' '.$animation_classes); ?>">
	<div class="ct-cta-inner row">
        <div class="ct-cta-holder col-xl-8 col-lg-8 col-md-8 col-sm-12">
    		<?php if(!empty($icon_image_url) && $icon_type == 'image' ) { ?>
                <div class="ct-cta-icon">
                    <img class="icon-main" src="<?php echo esc_url( $icon_image_url ); ?>" alt="<?php echo esc_attr( $title ); ?>"/>
                </div>
            <?php } else { ?>
                <?php if($icon_class):?>
                    <div class="ct-cta-icon">
                        <i class="<?php echo esc_attr($icon_class); ?>" style="<?php if(!empty($icon_color)) { echo 'color:'.esc_attr($icon_color).';'; } if(!empty($icon_font_size)) { echo 'font-size:'.esc_attr($icon_font_size).'px;'; } ?>"></i>
                    </div>
                <?php endif;?>
            <?php } ?>

            <div class="ct-cta-content">
                <?php if(!empty($sub_title)) : ?>
                    <h6 class="ct-cta-sub-title" style="<?php if(!empty($sub_title_color)) { echo 'color:'.esc_attr($sub_title_color).';'; } ?>">
                        <?php echo wp_kses_post( $sub_title ); ?>
                    </h6>
                <?php endif;?>
                <?php if(!empty($title)) : ?>
                    <h3 class="ct-cta-title" style="<?php if(!empty($title_color)) { echo 'color:'.esc_attr($title_color).';'; } ?>">
                        <?php echo wp_kses_post( $title ); ?>
                    </h3>
                <?php endif;?>
            </div>
        </div>
        
        <?php if(!empty($btn_text)) : ?>
            <div class="ct-cta-btn col-xl-4 col-lg-4 col-md-4 col-sm-12">
                <a class="btn btn-dashed" href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php echo esc_attr( $btn_text ); ?></a>
            </div>
        <?php endif; ?>
	</div>
</div>