<?php
extract(shortcode_atts(array(
    'link_app1'   => '',
    'link_app2'   => '',
    'button_style'   => 'text-icon',
    'animation'   => '',
    'el_class'   => '',
), $atts));
$link1 = vc_build_link($link_app1);
$link2 = vc_build_link($link_app2);
$a_href1 = '';
$a_target1 = '';
$a_href2 = '';
$a_target2 = '';
if ( strlen( $link1['url'] ) > 0 ) {
    $a_href1 = $link1['url'];
    $a_target1 = strlen( $link1['target'] ) > 0 ? $link1['target'] : '_self';
}
if ( strlen( $link2['url'] ) > 0 ) {
    $a_href2 = $link2['url'];
    $a_target2 = strlen( $link2['target'] ) > 0 ? $link2['target'] : '_self';
}
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
?>
<div class="ct-button-app <?php echo esc_attr($button_style.' '.$el_class ); ?>">
    <?php if(!empty($a_href2)) : ?>
        <div class="ct-button-app-item <?php echo esc_attr( $animation_classes ); ?>">
            <a href="<?php echo esc_url($a_href1);?>" target="<?php  echo esc_attr($a_target1); ?>" class="btn">
                <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/google-play.png'); ?>" />
                <span><?php echo esc_html__( 'Google Play', 'unfinityplus' ) ?></span>
            </a>
        </div>
    <?php endif; ?>
    <?php if(!empty($a_href2)) : ?>
        <div class="ct-button-app-item <?php echo esc_attr( $animation_classes ); ?>">
            <a href="<?php echo esc_url($a_href2);?>" target="<?php  echo esc_attr($a_target2); ?>" class="btn">
                <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/app-store.png'); ?>" />
                <span><?php echo esc_html__( 'App Store', 'unfinityplus' ) ?></span>
            </a>
        </div>
    <?php endif; ?>
</div>