<?php
extract(shortcode_atts(array(

    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'el_class'             => '',
    'img_size'             => '680x466',

), $atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-blog-carousel');
extract(cms_get_posts_of_grid('post', $atts));
extract(unfinityplus_get_param_carousel($atts));
wp_enqueue_script( 'waypoints' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-blog-carousel-default owl-carousel <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
    <?php if (is_array($posts)):
        foreach ($posts as $post) {
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ) );
            $thumbnail    = $img['thumbnail'];
            ?>
            <div class="ct-carousel-item">
                <div class="grid-item-inner ct-fade-in">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) : ?>
                        <div class="item-featured">
                             <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post( $thumbnail ); ?>
                             </a>
                        </div>
                    <?php endif; ?>
                    <div class="item-holder">
                        <ul class="entry-meta">
                            <li class="item-category"><?php the_terms( $post->ID, 'category', '', ' ' ); ?></li>
                            <li><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?></li>
                        </ul>
                        <h3 class="item-title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                        </h3>
                        <div class="item-more">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html__('Read More', 'unfinityplus'); ?><i class="fa fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        <?php }
    endif; ?>
</div>