<?php
$args = array(
    'name' => 'Testimonial Carousel',
    'base' => 'cms_testimonial_carousel',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Testimonial Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_testimonial_carousel',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'group' => esc_html__('Template', 'unfinityplus'),
            'std' => 'cms_testimonial_carousel.php'
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Style', 'unfinityplus'),
            'param_name' => 'style_l2',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
            ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_testimonial_carousel--layout2.php',
                )
            ),
            'group' => esc_html__('Template', 'unfinityplus'),
        ),
        
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Testimonial Item', 'unfinityplus' ),
            'value' => '',
            'param_name' => 'testimonial_item',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_testimonial_carousel.php',
                    'cms_testimonial_carousel--layout1.php',
                    'cms_testimonial_carousel--layout2.php',
                    'cms_testimonial_carousel--layout3.php',
                    'cms_testimonial_carousel--layout4.php',
                    'cms_testimonial_carousel--layout10.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'unfinityplus'),
                    'param_name' => 'position',

                ),
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Content', 'unfinityplus'),
                    'param_name' => 'content',
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                ),
            ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Box Shadow Style', 'unfinityplus'),
            'param_name' => 'box_shadow_style',
            'value' => array(
                'Style 1' => 'boxshadow-style1',
                'Style 2' => 'boxshadow-style2',
                'Style 3' => 'boxshadow-style3',
            ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_testimonial_carousel--layout3.php',
                )
            ),
        ),

        /* Layout 5 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Testimonial Item', 'unfinityplus' ),
            'value' => '',
            'param_name' => 'testimonial_item_l5',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_testimonial_carousel--layout5.php',
                    'cms_testimonial_carousel--layout7.php',
                    'cms_testimonial_carousel--layout8.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Content', 'unfinityplus'),
                    'param_name' => 'content',
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Client Title', 'unfinityplus'),
                    'param_name' => 'client_title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Rating', 'unfinityplus'),
                    'param_name' => 'rating',
                    'value' => array(
                        '1 Star' => 'rating-1-star',
                        '2 Star' => 'rating-2-star',
                        '3 Star' => 'rating-3-star',
                        '4 Star' => 'rating-4-star',
                        '5 Star' => 'rating-5-star',
                    ),
                ),
            ),
        ),

        /* Layout 6 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Testimonial Item', 'unfinityplus' ),
            'value' => '',
            'param_name' => 'testimonial_item_l6',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_testimonial_carousel--layout6.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Content', 'unfinityplus'),
                    'param_name' => 'content',
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Text Button Video', 'unfinityplus'),
                    'param_name' => 'video_text',
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Link Button Video', 'unfinityplus'),
                    'param_name' => 'video_link',
                ),
            ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Style', 'unfinityplus'),
            'param_name' => 'style_l6',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
            ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_testimonial_carousel--layout6.php',
                )
            ),
            'group' => esc_html__('Template', 'unfinityplus'),
        ),

        /* Layout 9 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Testimonial Item', 'unfinityplus' ),
            'value' => '',
            'param_name' => 'testimonial_item_l9',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_testimonial_carousel--layout9.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'unfinityplus'),
                    'param_name' => 'position',

                ),
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Content', 'unfinityplus'),
                    'param_name' => 'content',
                ),
            ),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),

    ));

$args = unfinityplus_add_vc_extra_param($args);
vc_map($args);

class WPBakeryShortCode_cms_testimonial_carousel extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>