<?php
vc_map(array(
    'name' => 'Separator',
    'base' => 'cms_separator',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Horizontal separator line', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        array(
            'type' => 'textfield',
            'heading' => esc_html__('Width', 'unfinityplus'),
            'param_name' => 'width',
            'description' => 'Enter number. (Default width 100%)',
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__('Height', 'unfinityplus'),
            'param_name' => 'height',
            'description' => 'Enter number. (Default height 1px)',
        ),
        
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color', 'unfinityplus'),
            'param_name' => 'color',
            'value' => '',
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Position', 'unfinityplus'),
            'param_name' => 'position',
            'value' => array(
                'Left' => 'ps-left',
                'Center' => 'ps-center',
                'Right' => 'ps-right',
            ),
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_separator extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>