<?php
vc_map(array(
    'name' => 'Pricing',
    'base' => 'cms_pricing',
    'class'    => 'ct-icon-element',
    'description' => 'Pricing Displayed',
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(
        
        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_pricing',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'group' => esc_html__('Template', 'unfinityplus'),
        ), 
        array(    
            'type' => 'dropdown',
            'heading' => esc_html__("Item Feature", 'unfinityplus'),
            'param_name' => 'feature',
            'value' => array(
                'No' => 'item-normal',        
                'Yes' => 'is-feature',        
            ),
            "group" => esc_html__("Template", 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_pricing.php',
                )
            ),
        ),  

        /* Layout Classic */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Title', 'unfinityplus' ),
            'param_name' => 'title',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_pricing--layout1.php',
                )
            ),
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Icon Image', 'unfinityplus' ),
            'param_name' => 'icon_image',
            'value' => '',
            'description' => esc_html__( 'Select icon image from media library.', 'unfinityplus' ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_pricing--layout1.php',
                )
            ),
            'group' => esc_html__('Source Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Title', 'unfinityplus' ),
            'param_name' => 'item_title',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_pricing--layout2.php',
                )
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Price', 'unfinityplus' ),
            'param_name' => 'price',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Currency', 'unfinityplus' ),
            'param_name' => 'currency',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_pricing--layout2.php',
                )
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Time', 'unfinityplus' ),
            'param_name' => 'time',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_pricing.php',
                )
            ),
        ),
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Description', 'unfinityplus' ),
            'param_name' => 'description',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'params' => array(
                array(
                    "type" => "textfield",
                    "heading" =>esc_html__("Item", 'unfinityplus'),
                    "param_name" => "description_item",
                    'admin_label' => true,
                ),
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Text Button', 'unfinityplus' ),
            'param_name' => 'text_button',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'vc_link',
            'heading' => esc_html__( 'Link Button', 'unfinityplus' ),
            'param_name' => 'link_button',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
        ),

        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color', 'unfinityplus'),
            'param_name' => 'pricing_color',
            'value' => '',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_pricing--layout1.php',
                )
            ),
            'group' => esc_html__('Source Settings', 'unfinityplus'),
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_pricing extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>