<?php
$args = array(
    'name' => 'Image Gallery Carousel',
    'base' => 'cms_image_gallery_carousel',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Image Gallery Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_image_gallery_carousel',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'std' => 'cms_image_gallery_carousel.php',
            'group' => esc_html__('Template', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Template', 'unfinityplus')
        ),
        
        array(
            'type' => 'attach_images',
            'heading' => esc_html__( 'Images', 'unfinityplus' ),
            'param_name' => 'images',
            'value' => '',
            'description' => esc_html__( 'Select images from media library.', 'unfinityplus' ),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Image size', 'unfinityplus' ),
            'param_name' => 'img_size',
            'value' => '',
            'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).', 'unfinityplus' ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_image_gallery_carousel.php',
                    'cms_image_gallery_carousel--layout1.php',
                )
            ),
        ),

    ));

$args = unfinityplus_add_vc_extra_param($args);
vc_map($args);

class WPBakeryShortCode_cms_image_gallery_carousel extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>