<?php
$term_list = cms_get_grid_term_list('post');
vc_map(
    array(
        'name'     => esc_html__('Blog Grid', 'unfinityplus'),
        'base'     => 'cms_blog_grid',
        'class'    => 'ct-icon-element',
        'description' => esc_html__( 'Posts in masonry grid', 'unfinityplus' ),
        'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
        'params'   => array(
            array(
                'type' => 'cms_template_img',
                'param_name' => 'cms_template',
                'shortcode' => 'cms_blog_grid',
                'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
                'admin_label' => true,
                'std' => 'cms_blog_grid.php',
                'group' => esc_html__('Template', 'unfinityplus'),
            ),
            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Element Title', 'unfinityplus'),
                'param_name' => 'element_title',
                'value'      => '',
                'group'      => esc_html__('Template', 'unfinityplus'),
                'description' => esc_html__('Enter text used as widget title (Note: located above content element).', 'unfinityplus'),
                'dependency' => array(
                    'element' => 'cms_template',
                    'value'   => 'cms_blog_grid--layout4.php'
                ),
            ),
            array(
                'type'       => 'checkbox',
                'heading'    => esc_html__('Custom Source', 'unfinityplus'),
                'param_name' => 'custom_source',
                'value'      => '1',
                'description'        => 'Check here if you want custom source',
                'group'      => esc_html__('Source Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'autocomplete',
                'heading'    => esc_html__('Select Categories', 'unfinityplus'),
                'param_name' => 'source',
                'description' => esc_html__('Leave blank to select all category', 'unfinityplus'),
                'settings'   => array(
                    'multiple' => true,
                    'values'   => $term_list['auto_complete'],
                ),
                'dependency' => array(
                    'element'=>'custom_source',
                    'value'=>array(
                        'true',
                    )
                ),
                'group'      => esc_html__('Source Settings', 'unfinityplus'),
            ),
            array(
                'type'       => 'autocomplete',
                'class'      => '',
                'heading'    => esc_html__('Select Post Name', 'unfinityplus'),
                'param_name' => 'post_ids',
                'description' => esc_html__('Leave blank to show all post', 'unfinityplus'),
                'settings'   => array(
                    'multiple' => true,
                    'values'   => cms_get_type_posts_data('post')
                ),
                'dependency' => array(
                    'element'=>'custom_source',
                    'value'=>array(
                        'true',
                    )
                ),
                'group'      => esc_html__('Source Settings', 'unfinityplus'),
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Order by', 'unfinityplus'),
                'param_name' => 'orderby',
                'value'      => array(
                    'Date'   => 'date',
                    'ID'     => 'ID',
                    'Author' => 'author',
                    'Title'  => 'title',
                    'Random' => 'rand',
                ),
                'std'        => 'date',
                'group'      => esc_html__('Source Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Sort order', 'unfinityplus'),
                'param_name' => 'order',
                'value'      => array(
                    'Ascending'  => 'ASC',
                    'Descending' => 'DESC',
                ),
                'std'        => 'DESC',
                'group'      => esc_html__('Source Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Total items', 'unfinityplus'),
                'param_name' => 'limit',
                'value'      => '6',
                'group'      => esc_html__('Source Settings', 'unfinityplus'),
                'description' => esc_html__('Set max limit for items in grid. Enter number only', 'unfinityplus'),
            ),

            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Item Title Color', 'unfinityplus'),
                'param_name' => 'item_title_color',
                'value' => '',
                'group'      => esc_html__('Grid Settings', 'unfinityplus'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'cms_blog_grid.php',
                    )
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => __( 'Image size', 'unfinityplus' ),
                'param_name' => 'img_size',
                'value' => '',
                'description' => __( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height). Enter multiple sizes (Example: 100x100,200x200,300x300)).', 'unfinityplus' ),
                'group'      => esc_html__('Grid Settings', 'unfinityplus'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'cms_blog_grid.php',
                        'cms_blog_grid--layout1.php',
                        'cms_blog_grid--layout2.php',
                    )
                ),
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Layout Type', 'unfinityplus'),
                'param_name' => 'layout',
                'value'      => array(
                    'Basic'   => 'basic',
                    'Masonry' => 'masonry',
                ),
                'group'      => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Filter on Masonry', 'unfinityplus'),
                'param_name' => 'filter',
                'value'      => array(
                    'Enable'  => 'true',
                    'Disable' => 'false'
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value'   => 'masonry'
                ),
                'group'      => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Pagination Type', 'unfinityplus'),
                'param_name' => 'pagination_type',
                'value'      => array(
                    'Pagination'  => 'pagination',
                    'Loadmore' => 'loadmore',
                    'Disable' => 'false',
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value'   => 'masonry'
                ),
                'group'      => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Button Loadmore Style', 'unfinityplus'),
                'param_name' => 'btn_loadmore_style',
                'value'      => array(
                    'Style 1'  => 'loadmore-style1',
                    'Style 2'  => 'loadmore-style2',
                    'Style 3 (Gradient)'  => 'loadmore-style3',
                ),
                'dependency' => array(
                    'element' => 'pagination_type',
                    'value'   => 'loadmore'
                ),
                'group'      => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Default Title', 'unfinityplus'),
                'param_name' => 'filter_default_title',
                'value'      => 'All',
                'group'      => esc_html__('Filter', 'unfinityplus'),
                'description' => esc_html__('Enter default title for filter option display, empty: All', 'unfinityplus'),
                'dependency' => array(
                    'element' => 'filter',
                    'value'   => 'true'
                ),
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Alignment', 'unfinityplus'),
                'param_name' => 'filter_alignment',
                'value'      => array(
                    'Center'   => 'center',
                    'Left'   => 'left',
                    'Right'   => 'right',
                ),
                'description' => esc_html__('Select filter alignment.', 'unfinityplus'),
                'group'      => esc_html__('Filter', 'unfinityplus'),
                'dependency' => array(
                    'element' => 'filter',
                    'value'   => 'true'
                ),
            ),

            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Item Gap', 'unfinityplus'),
                'param_name' => 'gap',
                'value'      => '30',
                'group'      => esc_html__('Grid Settings', 'unfinityplus'),
                'description' => esc_html__('Select gap between grid elements. Enter number only', 'unfinityplus'),
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns XS Devices', 'unfinityplus'),
                'param_name'       => 'col_xs',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 1,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns SM Devices', 'unfinityplus'),
                'param_name'       => 'col_sm',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 2,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns MD Devices', 'unfinityplus'),
                'param_name'       => 'col_md',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 3,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns LG Devices', 'unfinityplus'),
                'param_name'       => 'col_lg',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 4,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Custom Column Item', 'unfinityplus'),
                'param_name'       => 'custom_column',
                'value'      => array(
                    'False'   => 'false',
                    'True' => 'true',
                ),
                'std'              => false,
                'group'            => esc_html__('Grid Settings', 'unfinityplus'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'cms_blog_grid.php',
                        'cms_blog_grid--layout1.php',
                        'cms_blog_grid--layout2.php',
                    )
                ),
            ),
            array(
            'type' => 'param_group',
                'heading' => esc_html__( 'List Item', 'unfinityplus' ),
                'param_name' => 'cms_list_column',
                'description' => esc_html__( 'Column for each item', 'unfinityplus' ),
                'value' => '',
                'params' => array(
                    array(
                        'type'             => 'dropdown',
                        'heading'          => esc_html__('Columns XS Devices', 'unfinityplus'),
                        'param_name'       => 'custom_col_xs',
                        'edit_field_class' => 'vc_col-sm-3 vc_column',
                        'value'            => array(1, 2, 3, 4, 6, 12),
                        'std'              => 1,
                        'admin_label' => true,
                    ),
                    array(
                        'type'             => 'dropdown',
                        'heading'          => esc_html__('Columns SM Devices', 'unfinityplus'),
                        'param_name'       => 'custom_col_sm',
                        'edit_field_class' => 'vc_col-sm-3 vc_column',
                        'value'            => array(1, 2, 3, 4, 6, 12),
                        'std'              => 2,
                        'admin_label' => true,
                    ),
                    array(
                        'type'             => 'dropdown',
                        'heading'          => esc_html__('Columns MD Devices', 'unfinityplus'),
                        'param_name'       => 'custom_col_md',
                        'edit_field_class' => 'vc_col-sm-3 vc_column',
                        'value'            => array(1, 2, 3, 4, 6, 12),
                        'std'              => 3,
                        'admin_label' => true,
                    ),
                    array(
                        'type'             => 'dropdown',
                        'heading'          => esc_html__('Columns LG Devices', 'unfinityplus'),
                        'param_name'       => 'custom_col_lg',
                        'edit_field_class' => 'vc_col-sm-3 vc_column',
                        'value'            => array(1, 2, 3, 4, 6, 12),
                        'std'              => 4,
                        'admin_label' => true,
                    ),
                ),
                'dependency' => array(
                    'element' => 'custom_column',
                    'value'   => 'true'
                ),
                'group'            => esc_html__('Grid Settings', 'unfinityplus'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
        )
    )
);

class WPBakeryShortCode_cms_blog_grid extends CmsShortCode
{
    protected function content($atts, $content = null)
    {
        $html_id = cmsHtmlID('ct-grid-blog');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}

?>