<?php
/**
 * Template part for displaying posts in loop
 *
 * @package UnfinityPlus
 */
$audio_url = get_post_meta($post->ID, 'audio_url', true);
$video_url = get_post_meta($post->ID, 'video_url', true);
$file_download = get_post_meta($post->ID, 'file_download', true);
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-hentry'); ?>>
    <div class="post-type-inner">
    	<div class="entry-header">
	        <h2 class="entry-title"><?php the_title(); ?></h2>
	        <ul class="entry-meta">
                <li class="item-author">
                    <span><?php echo esc_html__('by:', 'unfinityplus'); ?></span>
                    <?php the_author_posts_link(); ?>
                </li>
            </ul>
	    </div>
        <div class="entry-body">
	        <ul class="entry-meta">
                <li class="item-time"><?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' '.esc_html__('ago', 'unfinityplus'); ?></li>
                <li><a class="btn-icon-popup" href="<?php echo esc_url($audio_url); ?>"><i class="fa fa-headphones"></i></a></li>
                <li><a class="btn-icon-popup" href="<?php echo esc_url($video_url); ?>"><i class="fa fa-youtube-play"></i></a></li>
                <li><a class="btn-icon-popup" href="<?php echo esc_url($file_download); ?>"><i class="fa fa-cloud-download"></i></a></li>
            </ul>
	        <div class="entry-content clearfix">
	            <?php
	                the_content();
	                wp_link_pages( array(
	                    'before'      => '<div class="page-links">',
	                    'after'       => '</div>',
	                    'link_before' => '<span>',
	                    'link_after'  => '</span>',
	                ) );
	            ?>
	        </div><!-- .entry-content -->
	    </div>
    </div>
</article><!-- #post -->