<?php
/**
 * Template part for displaying posts in loop
 *
 * @package UnfinityPlus
 */

$portfolio_type = unfinityplus_get_opt( 'portfolio_type', 'info' );
$portfolio_client = unfinityplus_get_page_opt( 'portfolio_client' );
$portfolio_location = unfinityplus_get_page_opt( 'portfolio_location' );
$portfolio_gallery = unfinityplus_get_page_opt( 'portfolio_gallery' );
$portfolio_gallery_list = explode(',', $portfolio_gallery);

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php if($portfolio_type == 'info') { ?>
        <div class="post-type-inner">
            <div class="row">
                <div class="post-type-content col-md-5 col-lg-4 col-xl-4">
                    <h2 class="entry-title"><?php the_title(); ?></h2>
                    <div class="entry-content">
                        <?php the_content(); ?>
                    </div>
                    <ul class="list-portolio">
                        <?php if(!empty($portfolio_client)): ?>
                            <li><label><?php echo esc_html__( 'Client:', 'unfinityplus' )?></label><?php echo esc_attr( $portfolio_client ); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($portfolio_location)): ?>
                            <li><label><?php echo esc_html__( 'Location:', 'unfinityplus' )?></label><?php echo esc_attr( $portfolio_location ); ?></li>
                        <?php endif; ?>
                        <li><label><?php echo esc_html__( 'Date:', 'unfinityplus' )?></label><?php the_date(); ?></li>
                        <li><label><?php echo esc_html__( 'Category:', 'unfinityplus' )?></label><?php the_terms( $post->ID, 'portfolio-category', '', ', ' ); ?></li>
                    </ul>
                    <?php unfinityplus_socials_share_default(); ?>
                </div>
                <div class="post-type-media col-md-7 col-lg-8 col-xl-8">
                    <?php if(!empty($portfolio_gallery)) { ?>
                        <div class="post-type-gallery images-light-box">
                            <div class="post-type-gallery">
                                <?php foreach ($portfolio_gallery_list as $img_id): ?>
                                    <div class="post-type-gallery-item">
                                        <a class="light-box" href="<?php echo esc_url(wp_get_attachment_image_url($img_id, 'large'));?>">
                                            <img src="<?php echo esc_url(wp_get_attachment_image_url($img_id, 'large'));?>" />
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php } else {
                        the_post_thumbnail('full'); 
                    } ?>
                </div>
            </div>
        </div>
    <?php } else { ?>
        <div class="post-type-inner">
            <div class="row">
                <div class="entry-content col-12">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
    <?php } ?>
</article><!-- #post -->