<?php
/**
 * Custom template tags for this theme.
 *
 * @package UnfinityPlus
 */

/**
 * Header layout
 **/
function unfinityplus_page_loading()
{
    $page_loading = unfinityplus_get_opt( 'show_page_loading', false );
    $loading_type = unfinityplus_get_opt( 'loading_type', 'style1');

    if($page_loading) { ?>
        <div id="ct-loadding" class="ct-loader">
            <?php switch ( $loading_type )
            {
                case 'style2': ?>
                    <div class="ct-spinner2"></div>
                    <?php break;

                case 'style3': ?>
                    <div class="ct-spinner3">
                      <div class="double-bounce1"></div>
                      <div class="double-bounce2"></div>
                    </div>
                    <?php break;

                case 'style4': ?>
                    <div class="ct-spinner4">
                      <div class="rect1"></div>
                      <div class="rect2"></div>
                      <div class="rect3"></div>
                      <div class="rect4"></div>
                      <div class="rect5"></div>
                    </div>
                    <?php break;

                case 'style5': ?>
                    <div class="ct-spinner5">
                      <div class="bounce1"></div>
                      <div class="bounce2"></div>
                      <div class="bounce3"></div>
                    </div>
                    <?php break;

                case 'style6': ?>
                    <div class="ct-cube-grid">
                      <div class="ct-cube ct-cube1"></div>
                      <div class="ct-cube ct-cube2"></div>
                      <div class="ct-cube ct-cube3"></div>
                      <div class="ct-cube ct-cube4"></div>
                      <div class="ct-cube ct-cube5"></div>
                      <div class="ct-cube ct-cube6"></div>
                      <div class="ct-cube ct-cube7"></div>
                      <div class="ct-cube ct-cube8"></div>
                      <div class="ct-cube ct-cube9"></div>
                    </div>
                    <?php break;

                case 'style7': ?>
                    <div class="ct-folding-cube">
                      <div class="ct-cube1 ct-cube"></div>
                      <div class="ct-cube2 ct-cube"></div>
                      <div class="ct-cube4 ct-cube"></div>
                      <div class="ct-cube3 ct-cube"></div>
                    </div>
                    <?php break;

                case 'style8': ?>
                    <div class="ct-loading-stairs">
                        <div class="loader-bar"></div>
                        <div class="loader-bar"></div>
                        <div class="loader-bar"></div>
                        <div class="loader-bar"></div>
                        <div class="loader-bar"></div>
                        <div class="loader-ball"></div>
                    </div>
                    <?php break;

                case 'style9': ?>
                    <div class="ct-spinner9-wrap">
                        <div class="ct-spinner9">
                            <div class="dot1"></div>
                            <div class="dot2"></div>
                        </div>
                    </div>
                    <?php break;

                default: ?>
                    <div class="loading-spin">
                        <div class="spinner">
                            <div class="right-side"><div class="bar"></div></div>
                            <div class="left-side"><div class="bar"></div></div>
                        </div>
                        <div class="spinner color-2" style="">
                            <div class="right-side"><div class="bar"></div></div>
                            <div class="left-side"><div class="bar"></div></div>
                        </div>
                    </div>
                    <?php break;
            } ?>
        </div>
    <?php }
}

/**
 * Header layout
 **/
function unfinityplus_header_layout()
{
    $header_layout = unfinityplus_get_opt( 'header_layout', '1' );
    $custom_header = unfinityplus_get_page_opt( 'custom_header', '0' );

    if ( is_page() && $custom_header == '1' || is_archive() && $custom_header == '1' )
    {
        $page_header_layout = unfinityplus_get_page_opt('header_layout');
        $header_layout = $page_header_layout;
        if($header_layout == '0') {
            return;
        }
    }

    get_template_part( 'template-parts/header-layout', $header_layout );
}

/**
 * Page title layout
 **/
function unfinityplus_footer()
{
    $custom_footer = unfinityplus_get_page_opt( 'custom_footer', '0' );
    $footer_layout = unfinityplus_get_opt( 'footer_layout', '1' );

    if ( is_page() && $custom_footer == '1' || is_archive() && $custom_footer == '1' )
    {
        $page_footer_layout = unfinityplus_get_page_opt('footer_layout');
        $footer_layout = $page_footer_layout;
        if($footer_layout == '0') {
            return;
        }
    }
    
    if($footer_layout != '0') {
        get_template_part( 'template-parts/footer-layout', $footer_layout );
    }
}

/**
 * Set primary content class based on sidebar position
 * 
 * @param  string $sidebar_pos
 * @param  string $extra_class
 */
function unfinityplus_primary_class( $sidebar_pos, $extra_class = '' )
{
    if ( is_page() || is_archive() || (class_exists('WooCommerce') && is_shop()) ) :
        $sidebar_load = 'sidebar-page';
    else :
        $sidebar_load = 'sidebar-blog';
    endif;

    if ( is_active_sidebar( $sidebar_load ) ) {
        $class = array( trim( $extra_class ) );
        switch ( $sidebar_pos )
        {
            case 'left':
                $class[] = 'content-has-sidebar float-right col-xl-9 col-lg-8 col-md-12';
                break;

            case 'right':
                $class[] = 'content-has-sidebar float-left col-xl-9 col-lg-8 col-md-12';
                break;

            default:
                $class[] = 'content-full-width col-12';
                break;
        }

        $class = implode( ' ', array_filter( $class ) );

        if ( $class )
        {
            echo ' class="' . esc_html($class) . '"';
        }
    } else {
        echo ' class="content-area col-12"'; 
    }
}

/**
 * Set secondary content class based on sidebar position
 * 
 * @param  string $sidebar_pos
 * @param  string $extra_class
 */
function unfinityplus_secondary_class( $sidebar_pos, $extra_class = '' )
{
    if ( is_page() || is_archive() || (class_exists('WooCommerce') && is_shop()) ) :
        $sidebar_load = 'sidebar-page';
    else :
        $sidebar_load = 'sidebar-blog';
    endif;

    if ( is_active_sidebar( $sidebar_load ) ) {
        $class = array(trim($extra_class));
        switch ($sidebar_pos) {
            case 'left':
                $class[] = 'widget-has-sidebar sidebar-fixed col-xl-3 col-lg-4 col-md-12';
                break;

            case 'right':
                $class[] = 'widget-has-sidebar sidebar-fixed col-xl-3 col-lg-4 col-md-12';
                break;

            default:
                break;
        }

        $class = implode(' ', array_filter($class));

        if ($class) {
            echo ' class="' . esc_html($class) . '"';
        }
    }
}


/**
 * Prints HTML for breadcrumbs.
 */
function unfinityplus_breadcrumb()
{
    if ( ! class_exists( 'CMS_Breadcrumb' ) )
    {
        return;
    }

    $breadcrumb = new CMS_Breadcrumb();
    $entries = $breadcrumb->get_entries();

    if ( empty( $entries ) )
    {
        return;
    }

    ob_start();

    foreach ( $entries as $entry )
    {
        $entry = wp_parse_args( $entry, array(
            'label' => '',
            'url'   => ''
        ) );

        if ( empty( $entry['label'] ) )
        {
            continue;
        }

        echo '<li>';

        if ( ! empty( $entry['url'] ) )
        {
            printf(
                '<a class="breadcrumb-entry" href="%1$s">%2$s</a>',
                esc_url( $entry['url'] ),
                esc_attr( $entry['label'] )
            );
        }
        else
        {
            printf( '<span class="breadcrumb-entry" >%s</span>', esc_html( $entry['label'] ) );
        }

        echo '</li>';
    }

    $output = ob_get_clean();

    if ( $output )
    {
        printf( '<ul class="ct-breadcrumb">%s</ul>', wp_kses_post($output));
    }
}


function unfinityplus_entry_link_pages()
{
    wp_link_pages( array(
        'before'      => '<div class="page-links">',
        'after'       => '</div>',
        'link_before' => '<span>',
        'link_after'  => '</span>',
    ) );
}


if ( ! function_exists( 'unfinityplus_entry_excerpt' ) ) :
    /**
     * Print post excerpt based on length.
     *
     * @param  integer $length
     */
    function unfinityplus_entry_excerpt( $length = 55 )
    {
        $cms_the_excerpt = get_the_excerpt();
        if(!empty($cms_the_excerpt)) {
            echo esc_html($cms_the_excerpt);
        } else {
            echo wp_kses_post(unfinityplus_get_the_excerpt( $length ));
        }
    }
endif;

/**
 * Prints post edit link when applicable
 */
function unfinityplus_entry_edit_link()
{
    edit_post_link(
        sprintf(
            wp_kses(
                /* translators: %s: Name of current post. Only visible to screen readers */
                esc_html__( 'Edit', 'unfinityplus' ),
                array(
                    'span' => array(
                        'class' => array(),
                    ),
                )
            ),
            get_the_title()
        ),
        '<div class="entry-edit-link"><i class="fa fa-edit"></i>',
        '</div>'
    );
}


/**
 * Prints posts pagination based on query
 *
 * @param  WP_Query $query     Custom query, if left blank, this will use global query ( current query )
 * @return void
 */
function unfinityplus_posts_pagination( $query = null )
{
    $classes = array();

    if ( empty( $query ) )
    {
        $query = $GLOBALS['wp_query'];
    }

    if ( empty( $query->max_num_pages ) || ! is_numeric( $query->max_num_pages ) || $query->max_num_pages < 2 )
    {
        return;
    }

    $paged = get_query_var( 'paged' );

    if ( ! $paged && is_front_page() && ! is_home() )
    {
        $paged = get_query_var( 'page' );
    }

    $paged = $paged ? intval( $paged ) : 1;

    $pagenum_link = html_entity_decode( get_pagenum_link() );
    $query_args   = array();
    $url_parts    = explode( '?', $pagenum_link );

    if ( isset( $url_parts[1] ) )
    {
        wp_parse_str( $url_parts[1], $query_args );
    }

    $pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
    $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

    $html_prev = '<i class="fa fa-angle-left"></i>';
    $html_next = '<i class="fa fa-angle-right"></i>';
    $links = paginate_links( array(
        'base'     => $pagenum_link,
        'total'    => $query->max_num_pages,
        'current'  => $paged,
        'mid_size' => 1,
        'add_args' => array_map( 'urlencode', $query_args ),
        'prev_text' => $html_prev,
        'next_text' => $html_next,
    ) );

    $template = '
    <nav class="navigation posts-pagination">
        <div class="posts-page-links">%2$s</div>
    </nav>';

    if ( $links )
    {
        printf(
            wp_kses_post($template),
            esc_html__( 'Navigation', 'unfinityplus' ),
            wp_kses_post($links)
        );
    }
}

/**
 * Prints archive meta on blog
 */
if ( ! function_exists( 'unfinityplus_archive_meta' ) ) :
    function unfinityplus_archive_meta() {
        $archive_author_on = unfinityplus_get_opt( 'archive_author_on', true );
        $archive_categories_on = unfinityplus_get_opt( 'archive_categories_on', true );
        $archive_comments_on = unfinityplus_get_opt( 'archive_comments_on', true );
        $archive_date_on = unfinityplus_get_opt( 'archive_date_on', false );
        if($archive_author_on || $archive_comments_on || $archive_categories_on || $archive_date_on) : ?>
            <ul class="entry-meta">
                <?php if($archive_author_on) : ?>
                    <li class="item-author">
                        <i class="fa fa-user"></i>
                        <span><?php echo esc_html__('by', 'unfinityplus'); ?></span>
                        <?php the_author_posts_link(); ?>
                    </li>
                <?php endif; ?>
                <?php if($archive_categories_on) : ?>
                    <li class="item-category"><i class="fa fa-tag"></i><?php the_terms( get_the_ID(), 'category', '', ', ' ); ?></li>
                <?php endif; ?>
                <?php if($archive_comments_on) : ?>
                    <li>
                        <i class="fa fa-comments"></i><a href="<?php the_permalink(); ?>"><?php echo comments_number(esc_html__('No Comments', 'unfinityplus'),esc_html__('Comment 1', 'unfinityplus'),esc_html__('% Comments', 'unfinityplus')); ?></a></li>
                <?php endif; ?>
                <?php if($archive_date_on) : ?>
                    <li><i class="fa fa-calendar"></i><?php echo get_the_date(); ?></li>
                <?php endif; ?>
                <?php if(is_sticky()) { ?>
                    <li><i class="fa fa-thumb-tack"></i><?php echo esc_html__('Sticky', 'unfinityplus'); ?></li>
                <?php } ?>
            </ul>
    <?php endif; }
endif;

/**
 * Prints tag list
 */
if ( ! function_exists( 'unfinityplus_entry_tagged_in' ) ) :
    /**
     * Prints HTML with meta information for the current post-date/time.
     */
    function unfinityplus_entry_tagged_in()
    {
        $tags_list = get_the_tag_list( '<label class="label">'.esc_attr__('Post tags:', 'unfinityplus').'</label>', ' ' );
        if ( $tags_list )
        {
            echo '<div class="entry-tags">';
            printf('%2$s', '', $tags_list);
            echo '</div>';
        }
    }
endif;

/**
 * List socials share for post.
 */
function unfinityplus_socials_share_default() { ?>
    <div class="entry-socail">
        <label class="label"><?php echo esc_html__('Share:', 'unfinityplus'); ?></label>
        <a class="fb-social" title="Facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="fa fa-facebook"></i></a>
        <a class="tw-social" title="Twitter" target="_blank" href="http://twitter.com/share?url=<?php the_permalink(); ?>"><i class="fa fa-twitter"></i></a>
        <a class="g-social" title="Linkedin" target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>"><i class="fa fa-linkedin"></i></a>
    </div>
    <?php
}

/**
 * Footer Top
 */
function unfinityplus_footer_top() {
    $footer_top_column = unfinityplus_get_opt( 'footer_top_column' );
    $footer_top_logo = unfinityplus_get_opt( 'footer_top_logo' );
    $_class = "";

    switch ($footer_top_column){
        case '2':
            $_class = 'col-xl-6 col-lg-6 col-md-6 col-sm-12';
            break;
        case '3':
            $_class = 'col-xl-4 col-lg-4 col-md-4 col-sm-12';
            break;
        case '4':
            $_class = 'col-xl-3 col-lg-3 col-md-6 col-sm-12';
            break;
    }

    for($i = 1 ; $i <= $footer_top_column ; $i++){
        if ( is_active_sidebar( 'sidebar-footer-' . $i ) ){
            echo '<div class="ct-footer-item ' . esc_html($_class) . '">'; ?>
                <?php if(!empty($footer_top_logo) && $i == 1) : ?>
                    <?php if(!empty($footer_top_logo['url'])) : ?>
                        <div class="top-footer-logo">
                            <a href="<?php echo esc_url( home_url( '/' )); ?>"><img src="<?php echo esc_url($footer_top_logo['url']); ?>" alt="<?php echo esc_html__('Logo Footer', 'unfinityplus') ?>" /></a>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <?php dynamic_sidebar( 'sidebar-footer-' . $i );
            echo "</div>";
        }
    }
}

/**
* Display navigation to next/previous post when applicable.
*/
function unfinityplus_post_nav_default() {
    global $post;
    // Don't print empty markup if there's nowhere to navigate.
    $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );

    if ( ! $next && ! $previous )
        return;
    ?>
    <?php
    $next_post = get_next_post();
    $previous_post = get_previous_post();
    if( !empty($next_post) || !empty($previous_post) ) { ?>
        <div class="post-previous-next style-default">
            <div class="nav-links row clearfix">
                <?php if ( is_a( $previous_post , 'WP_Post' ) && get_the_title( $previous_post->ID ) != '') { ?>
                    <div class="nav-link-prev col-md-6 col-sm-12">
                        <?php $url_prev = wp_get_attachment_image_src(get_post_thumbnail_id($previous_post->ID), 'unfinityplus-medium', false); ?>
                        <div class="nav-item-inner">
                            <span><?php echo esc_html_e('Previous Story', 'unfinityplus') ?></span>
                            <?php if(!empty($url_prev)) : ?>
                                <div class="nav-item-image bg-image" style="background-image: url(<?php echo esc_url($url_prev[0]); ?>);">
                                    <a href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"></a>
                                </div>
                            <?php endif; ?>
                            <h3><a href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"><?php echo get_the_title( $previous_post->ID ); ?></a></h3>
                            <div class="nav-item-date"><?php echo get_the_date(); ?></div>
                        </div>
                    </div>
                <?php } ?>
                <?php if ( is_a( $next_post , 'WP_Post' ) && get_the_title( $next_post->ID ) != '') { ?>
                    <div class="nav-link-next col-md-6 col-sm-12">
                        <?php $url_next = wp_get_attachment_image_src(get_post_thumbnail_id($next_post->ID), 'unfinityplus-medium', false); ?>
                        <div class="nav-item-inner">
                            <span><?php echo esc_html_e('Next Story', 'unfinityplus') ?></span>
                            <?php if(!empty($url_next)) : ?>
                                <div class="nav-item-image bg-image" style="background-image: url(<?php echo esc_url($url_next[0]); ?>);">
                                    <a href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>"></a>
                                </div>
                            <?php endif; ?>
                            <h3><a href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>"><?php echo get_the_title( $next_post->ID ); ?></a></h3>
                            <div class="nav-item-date"><?php echo get_the_date(); ?></div>
                        </div>
                    </div>
                <?php } ?>
            </div><!-- .nav-links -->
        </div>
    <?php }
}

/**
 * Related Post
 */
function unfinityplus_related_post()
{
    global $post;
    $current_id = $post->ID;
    $posttags = get_the_category($post->ID);
    if (empty($posttags)) return;

    $tags = array();

    foreach ($posttags as $tag) {

        $tags[] = $tag->term_id;
    }
    $post_number = '4';
    $item_class = 'col-xl-3 col-lg-12 col-md-12';
    $post_sidebar_pos = unfinityplus_get_opt( 'post_sidebar_pos', 'none' );
    if($post_sidebar_pos == 'left' || $post_sidebar_pos == 'right') {
        $post_number = '3';
        $item_class = 'col-xl-6 col-lg-12 col-md-12';
    }
    $query_similar = new WP_Query(array('posts_per_page' => $post_number, 'post_type' => 'post', 'post_status' => 'publish', 'category__in' => $tags));
    if (count($query_similar->posts) > 1) {
        ?>
        <div class="ct-related-post clearfix">
            <h3 class="section-title"><?php echo esc_html__('Related Stories', 'unfinityplus'); ?></h3>
            <div class="ct-related-post-inner row">
                <?php foreach ($query_similar->posts as $post):
                    $thumbnail_url = '';
                    if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) :
                        $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full', false);
                    endif;
                    if ($post->ID !== $current_id) : ?>
                        <div class="grid-item <?php echo esc_attr($item_class); ?>">
                            <div class="grid-item-inner row">
                                <?php if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) : ?>
                                    <div class="item-featured col-xl-6 col-lg-6 col-md-6">
                                        <a href="<?php the_permalink(); ?>" class="bg-image" style="background-image: url(<?php echo esc_url($thumbnail_url[0]); ?>);"></a>
                                    </div>
                                <?php endif; ?>
                                <div class="item-holder col-xl-6 col-lg-6 col-md-6">
                                    <h3 class="item-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h3>
                                    <div class="item-content">
                                        <?php echo wp_trim_words( $post->post_excerpt, $num_words = 12, $more = null ); ?>
                                    </div>
                                    <div class="item-date">
                                        <?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif;
                endforeach; ?>
            </div>
        </div>
    <?php }

    wp_reset_postdata();
}

/**
 * Header Social
 */
function unfinityplus_header_social_icon() {
    $header_social = unfinityplus_get_opt( 'header_social' );
    $social_target_top = unfinityplus_get_opt( 'social_target_top', '_self' );
    $social = $header_social['enabled'];
    if ($social) : foreach ($social as $key=>$value) { ?>
        <?php switch($key) {

            case 'facebook': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_facebook_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-facebook"></i></a>';
            break;

            case 'twitter': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_twitter_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-twitter"></i></a>';
            break;

            case 'linkedin': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_inkedin_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-linkedin"></i></a>';
            break;

            case 'instagram': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_instagram_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-instagram"></i></a>';
            break;

            case 'google': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_google_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-google-plus"></i></a>';
            break;

            case 'skype': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_skype_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-skype"></i></a>';
            break;

            case 'pinterest': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_pinterest_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-pinterest"></i></a>';
            break;

            case 'vimeo': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_vimeo_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-vimeo"></i></a>';
            break;

            case 'youtube': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_youtube_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-youtube"></i></a>';
            break;

            case 'yelp': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_yelp_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-yelp"></i></a>';
            break;

            case 'tumblr': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_tumblr_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-tumblr"></i></a>';
            break;

            case 'tripadvisor': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_tripadvisor_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-tripadvisor"></i></a>';
            break;

        }
    }
    endif;
}

function unfinityplus_header_social_icon_text() {
    $header_social = unfinityplus_get_opt( 'header_social' );
    $social_target_top = unfinityplus_get_opt( 'social_target_top', '_self' );
    $social = $header_social['enabled'];
    if ($social) : foreach ($social as $key=>$value) { ?>
        <?php switch($key) {

            case 'facebook': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_facebook_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-facebook"></i>'.esc_html__( 'facebook', 'unfinityplus' ).'</a>';
            break;

            case 'twitter': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_twitter_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-twitter"></i>'.esc_html__( 'twitter', 'unfinityplus' ).'</a>';
            break;

            case 'linkedin': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_inkedin_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-linkedin"></i>'.esc_html__( 'linkedin', 'unfinityplus' ).'</a>';
            break;

            case 'instagram': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_instagram_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-instagram"></i>'.esc_html__( 'instagram', 'unfinityplus' ).'</a>';
            break;

            case 'google': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_google_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-google-plus"></i>'.esc_html__( 'google plus', 'unfinityplus' ).'</a>';
            break;

            case 'skype': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_skype_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-skype"></i>'.esc_html__( 'skype', 'unfinityplus' ).'</a>';
            break;

            case 'pinterest': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_pinterest_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-pinterest"></i>'.esc_html__( 'pinterest', 'unfinityplus' ).'</a>';
            break;

            case 'vimeo': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_vimeo_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-vimeo"></i>'.esc_html__( 'vimeo', 'unfinityplus' ).'</a>';
            break;

            case 'youtube': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_youtube_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-youtube"></i>'.esc_html__( 'youtube', 'unfinityplus' ).'</a>';
            break;

            case 'yelp': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_yelp_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-yelp"></i>'.esc_html__( 'yelp', 'unfinityplus' ).'</a>';
            break;

            case 'tumblr': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_tumblr_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-tumblr"></i>'.esc_html__( 'tumblr', 'unfinityplus' ).'</a>';
            break;

            case 'tripadvisor': echo '<a class="h-social" href="'.esc_url(unfinityplus_get_opt( 'social_tripadvisor_url' )).'" target="'.esc_attr( $social_target_top ).'"><i class="fa fa-tripadvisor"></i>'.esc_html__( 'tripadvisor', 'unfinityplus' ).'</a>';
            break;

        }
    }
    endif;
}

/**
 * Footer Social
 */
function unfinityplus_footer_social_icon() {
    $footer_social = unfinityplus_get_opt( 'footer_bottom_social' );
    $social_target_bottom = unfinityplus_get_opt( 'social_target_bottom', '_self' );
    $social = $footer_social['enabled'];
    if ($social) : foreach ($social as $key=>$value) { ?>
        <?php switch($key) {

            case 'facebook': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_facebook_url' )).'" target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-facebook-square"></i></a>';
            break;

            case 'twitter': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_twitter_url' )).'"  target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-twitter-square"></i></a>';
            break;

            case 'linkedin': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_inkedin_url' )).'"  target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-linkedin-square"></i></a>';
            break;

            case 'instagram': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_instagram_url' )).'"  target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-instagram"></i></a>';
            break;

            case 'google': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_google_url' )).'"  target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-google-plus-square"></i></a>';
            break;

            case 'skype': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_skype_url' )).'"  target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-skype"></i></a>';
            break;

            case 'pinterest': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_pinterest_url' )).'"  target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-pinterest-square"></i></a>';
            break;

            case 'vimeo': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_vimeo_url' )).'"  target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-vimeo-square"></i></a>';
            break;

            case 'youtube': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_youtube_url' )).'" target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-youtube-square"></i></a>';
            break;

            case 'yelp': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_yelp_url' )).'" target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-yelp"></i></a>';
            break;

            case 'tumblr': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_tumblr_url' )).'" target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-tumblr"></i></a>';
            break;

            case 'tripadvisor': echo '<a href="'.esc_url(unfinityplus_get_opt( 'social_tripadvisor_url' )).'" target="'.esc_attr( $social_target_bottom ).'"><i class="fa fa-tripadvisor"></i></a>';
            break;

        }
    }
    endif;
}

/**
 * Header Search Popup
 */
function unfinityplus_search_popup()
{
    $search_on = unfinityplus_get_opt( 'search_on', false );
    if($search_on) : ?>
    <div class="ct-modal ct-search-popup">
        <div class="ct-close"></div>
        <div class="ct-modal-content">
            <form role="search" method="get" class="ct-search-form placeholder-white" action="<?php echo esc_url(home_url( '/' )); ?>">
                <i class="fa fa-search"></i>
                <input type="text" placeholder="<?php esc_attr_e('Search...', 'unfinityplus'); ?>" name="s" class="search-field" />
            </form>
        </div>
    </div>
<?php endif; }

/**
 * Header Search Popup
 */
function unfinityplus_header_mobile_search()
{ ?>
    <div class="header-mobile-search">
        <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
            <input type="text" placeholder="<?php esc_html_e('Search...', 'unfinityplus'); ?>" name="s" class="search-field" />
            <button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
        </form>
    </div>
<?php }

/* Author Social */
function unfinityplus_get_user_social() {

    $user_facebook = get_user_meta(get_the_author_meta( 'ID' ), 'user_facebook', true);
    $user_twitter = get_user_meta(get_the_author_meta( 'ID' ), 'user_twitter', true);
    $user_linkedin = get_user_meta(get_the_author_meta( 'ID' ), 'user_linkedin', true);
    $user_skype = get_user_meta(get_the_author_meta( 'ID' ), 'user_skype', true);
    $user_google = get_user_meta(get_the_author_meta( 'ID' ), 'user_google', true);
    $user_youtube = get_user_meta(get_the_author_meta( 'ID' ), 'user_youtube', true);
    $user_vimeo = get_user_meta(get_the_author_meta( 'ID' ), 'user_vimeo', true);
    $user_tumblr = get_user_meta(get_the_author_meta( 'ID' ), 'user_tumblr', true);
    $user_rss = get_user_meta(get_the_author_meta( 'ID' ), 'user_rss', true);
    $user_pinterest = get_user_meta(get_the_author_meta( 'ID' ), 'user_pinterest', true);
    $user_instagram = get_user_meta(get_the_author_meta( 'ID' ), 'user_instagram', true);
    $user_yelp = get_user_meta(get_the_author_meta( 'ID' ), 'user_yelp', true);

    ?>
    <ul class="user-social">
        <?php if(!empty($user_facebook)) { ?>
            <li><a href="<?php echo esc_url($user_facebook); ?>"><i class="fa fa-facebook"></i></a></li>
       <?php } ?>
        <?php if(!empty($user_twitter)) { ?>
            <li><a href="<?php echo esc_url($user_twitter); ?>"><i class="fa fa-twitter"></i></a></li>
        <?php } ?>
        <?php if(!empty($user_linkedin)) { ?>
            <li><a href="<?php echo esc_url($user_linkedin); ?>"><i class="fa fa-linkedin"></i></a></li>
        <?php } ?>
        <?php if(!empty($user_rss)) { ?>
            <li><a href="<?php echo esc_url($user_rss); ?>"><i class="fa fa-rss"></i></a></li>
        <?php } ?>
        <?php if(!empty($user_instagram)) { ?>
            <li><a href="<?php echo esc_url($user_instagram); ?>"><i class="fa fa-instagram"></i></a></li> 
        <?php } ?>
        <?php if(!empty($user_google)) { ?>
            <li><a href="<?php echo esc_url($user_google); ?>"><i class="fa fa-google-plus"></i></a></li>  
        <?php } ?>
        <?php if(!empty($user_skype)) { ?> 
            <li><a href="<?php echo esc_url($user_skype); ?>"><i class="fa fa-skype"></i></a></li>   
        <?php } ?>
        <?php if(!empty($user_pinterest)) { ?>
            <li><a href="<?php echo esc_url($user_pinterest); ?>"><i class="fa fa-pinterest"></i></a></li>  
        <?php } ?>
        <?php if(!empty($user_vimeo)) { ?> 
            <li><a href="<?php echo esc_url($user_vimeo); ?>"><i class="fa fa-vimeo"></i></a></li>  
        <?php } ?>
        <?php if(!empty($user_youtube)) { ?>
            <li><a href="<?php echo esc_url($user_youtube); ?>"><i class="fa fa-youtube"></i></a></li> 
        <?php } ?> 
        <?php if(!empty($user_yelp)) { ?> 
            <li><a href="<?php echo esc_url($user_yelp); ?>"><i class="fa fa-yelp"></i></a></li>
        <?php } ?>
        <?php if(!empty($user_tumblr)) { ?>
            <li><a href="<?php echo esc_url($user_tumblr); ?>"><i class="fa fa-tumblr"></i></a></li>  
        <?php } ?>

    </ul> <?php  
}

/* User Login/Register */
function unfinityplus_user_form() {
    if(function_exists('up_get_template_part') && !is_user_logged_in()) : ?>
        <div class="ct-modal ct-user-popup">
            <div class="ct-close"></div>
            <div class="ct-modal-content">
                <div class="ct-user ct-user-register u-close">
                    <div class="ct-user-content">
                        <h3 class="ct-user-heading"><?php echo esc_html__('Create your account', 'unfinityplus'); ?></h3>
                        <?php echo do_shortcode('[user-press form_type="register"]'); ?>
                    </div>
                    <div class="ct-user-footer">
                        <a href="javascript:void(0)" class="btn-sign-in"> <?php esc_html_e('Sign In Here', 'unfinityplus');?></a>
                    </div>
                </div>
                <div class="ct-user ct-user-login">
                    <div class="ct-user-content">
                        <h3 class="ct-user-heading"><?php echo esc_html__('Log in to Your Account', 'unfinityplus'); ?></h3>
                        <?php echo do_shortcode('[user-press form_type="login"]'); ?>   
                    </div>
                    <div class="ct-user-footer">
                        <a href="javascript:void(0)" class="btn-sign-up"> <?php esc_html_e('Sign Up Here', 'unfinityplus');?></a>
                    </div>
                </div> 
            </div>
        </div>
    <?php endif;
}

/**
 * Page title layout
 **/
function unfinityplus_page_title_layout()
{
    if(!is_singular('post')) {
        get_template_part( 'template-parts/page-title', '' );
    }
}
/**
 * Demo Bar
 */
function unfinityplus_demo_bar() { ?>
    <div class="ct-demo-bar">
        <div class="ct-demo-option">
            <a class="choose-demo" href="javascript:;">
                <span>Choose Theme Styling</span>
                <i class="fa fa-cog"></i>
            </a>
            <a href="https://casethemes.ticksy.com/" target="_blank">
                <span>Submit a Ticket</span>
                <i class="fa fa-life-ring"></i>
            </a>
            <a href="https://themeforest.net/item/unfinity-plus-one-page-multipurpose-wordpress-theme/22471897" target="_blank">
                <span>Purchase Theme</span>
                <i class="fa fa-shopping-cart"></i>
            </a>
        </div>
        <div class="ct-demo-bar-inner">
            <div class="ct-demo-bar-meta">
                <h4>Pre-Built Demos Collection</h4>
                <p>Unfinity Plus comes with a beautiful collection of modern, easily importable, and highly customizable demo layouts. Any of which can be installed via one click.</p>
            </div>
            <div class="ct-demo-bar-list">
                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo1.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Corporate & Business</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo2.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Finance & Account</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-finance/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo3.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Consulting & Business</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-consulting/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo4.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Construction Business</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-construction/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo5.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Transportation & Logistic</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-transport/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo6.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Lawyers</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-lawyer/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo7.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Event </h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-event/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo8.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Medical </h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-hospital/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo9.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Digital Agency </h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-digital-agency" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo10.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Seo</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-seo" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo11.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Hotel</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-hotel/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo12.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Church</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-church/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo13.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Gym</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-gym/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo14.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Restaurant</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-restaurant" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo15.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Photography</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-photography/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo16.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>App Launching</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-app/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo17.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Minimal Portfolio</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-minimal-portfolio/" target="_blank">View Demo</a>
                    </div>
                </div>

                <div class="ct-demo-bar-item">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/home-demo/demo18.jpg'); ?>" alt="Demo" />
                    <div class="ct-demo-bar-holder">
                        <h6>Industrial</h6>
                        <a class="btn btn-default" href="http://demo.casethemes.net/unfinityplus-industrial/" target="_blank">View Demo</a>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php }