<?php
$atts_extra = shortcode_atts(array(
    'content_list'                  => '',
    'el_class'             => '',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
$tickets_content_list = (array) vc_param_group_parse_atts( $content_list );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-tickets-grid <?php echo esc_attr($el_class); ?>">
    
    <?php foreach ($tickets_content_list as $key => $value) {
        $ct_price = isset($value['ct_price']) ? $value['ct_price'] : '';
        $ct_date = isset($value['ct_date']) ? $value['ct_date'] : '';
        $ct_desc = isset($value['ct_desc']) ? $value['ct_desc'] : '';
        $ct_btn_text = isset($value['ct_btn_text']) ? $value['ct_btn_text'] : '';
        $ct_btn_link = isset($value['ct_btn_link']) ? $value['ct_btn_link'] : '';
        $link = vc_build_link($ct_btn_link);
        $a_href = '';
        $a_target = '';
        if ( strlen( $link['url'] ) > 0 ) {
            $a_href = $link['url'];
            $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
        }
        $ct_image = isset($value['ct_image']) ? $value['ct_image'] : '';
        $image_url = '';
        if (!empty($ct_image)) {
            $attachment_image = wp_get_attachment_image_src($ct_image, 'full');
            $image_url = $attachment_image[0];
        }
        ?>
        <div class="ct-ticket-item">
            <div class="ct-ticket-media">
                <div class="ct-ticket-media-inner">
                    <?php if(!empty($image_url)) : ?>
                        <a href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><img src="<?php echo esc_url( $image_url ); ?>" /></a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="ct-ticket-content">
                <div class="ct-ticket-content-inner">
                    <div class="ct-ticket-price text-gradient">
                        <?php echo esc_attr( $ct_price ); ?>
                    </div>
                    <div class="ct-ticket-date">
                        <?php echo esc_attr( $ct_date ); ?>
                    </div>
                    <div class="ct-ticket-desc">
                        <?php echo wp_kses_post($ct_desc ); ?>
                    </div>
                    <?php if(!empty($ct_btn_text)):?>
                        <a href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>" class="ct-ticket-book"><?php echo esc_attr( $ct_btn_text ); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php } ?>
</div>