<?php
extract(shortcode_atts(array(

    'testimonial_item' => '',
    'title_color' => '',
    'position_color' => '',
    'content_color' => '',
    'el_class' => '',

), $atts));

wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-testimonial-carousel');
extract(unfinityplus_get_param_carousel($atts));
$testimonials = (array) vc_param_group_parse_atts($testimonial_item);
if(!empty($testimonials)) : ?>

    <div id="<?php echo esc_attr($html_id);?>" class="ct-testimonial-carousel layout1 owl-carousel owl-nav-middle <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
        <?php foreach ($testimonials as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $content = isset($value['content']) ? $value['content'] : '';
            $position = isset($value['position']) ? $value['position'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $img_size = '200x175';
            $img = wpb_getImageBySize( array(
                'attach_id'  => $image,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="ct-testimonial-item">
                <?php if(!empty($image)): ?>
                    <div class="ct-testimonial-image">
                        <?php echo wp_kses_post($thumbnail); ?>
                    </div>
                <?php endif; ?>
                <div class="ct-testimonial-holder">
                    <div class="ct-testimonial-meta">
                        <h3 class="ct-testimonial-title" style="<?php if(!empty($title_color)) { echo 'color:'.esc_attr($title_color).';'; } ?>"><?php echo esc_html($title); ?></h3>
                        <span class="ct-testimonial-position" style="<?php if(!empty($position_color)) { echo 'color:'.esc_attr($position_color).';'; } ?>"><?php echo esc_html($position); ?></span>
                    </div>
                    <div class="ct-testimonial-content divider1" style="<?php if(!empty($content_color)) { echo 'color:'.esc_attr($content_color).';'; } ?>"><?php echo apply_filters('the_content', $content); ?></div>
                </div>   
            </div>
        <?php } ?>
    </div>

<?php endif;?>