<?php
extract(shortcode_atts(array(

    'content_list_l5' => '',
    'title_color' => '',
    'el_class' => '',
    'social_hover_style' => 'hover-style1',
    'animation' => '',

), $atts));

wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-team-carousel');
extract(unfinityplus_get_param_carousel($atts));
$el_content_list = array();
$el_content_list = (array) vc_param_group_parse_atts( $content_list_l5 );
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
$primary_color = unfinityplus_get_opt( 'primary_color' );
$primary_color_gradient = unfinityplus_get_opt( 'primary_color_gradient' );
$svg_color_from = $primary_color;
$svg_color_to = $primary_color;
if(!empty($primary_color_gradient['from'])) {
   $svg_color_from = $primary_color_gradient['from'];
}
if(!empty($primary_color_gradient['to'])) {
   $svg_color_to = $primary_color_gradient['to'];
}
if(!empty($el_content_list)) : ?>
    <div id="<?php echo esc_attr($html_id);?>" class="ct-team-carousel layout5 owl-carousel <?php echo esc_attr( $el_class.' '.$animation_classes ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
        <?php foreach ($el_content_list as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $position = isset($value['position']) ? $value['position'] : '';
            $desc = isset($value['desc']) ? $value['desc'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $social = isset($value['social']) ? $value['social'] : '';
            $el_social = (array) vc_param_group_parse_atts( $social );
            $img_size = isset($value['img_size']) ? $value['img_size'] : '470x540';
            $img = wpb_getImageBySize( array(
                'attach_id'  => $image,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="ct-team-item">
                <div class="ct-team-item-inner social-<?php echo esc_attr( $social_hover_style ); ?>">
                    <?php if(!empty($image)) { ?>
                        <div class="team-featured">
                            <?php echo wp_kses_post($thumbnail); ?>
                            <div class="team-social">
                                <div class="team-social-inner">
                                    <?php foreach ($el_social as $key => $value) {
                                        $social_link = isset($value['social_link']) ? $value['social_link'] : '';
                                        $icon_class = isset($value['icon']) ? $value['icon'] : ''; ?>
                                        <a href="<?php echo esc_url($social_link); ?>" target="_blank"><i class="<?php echo esc_attr( $icon_class ); ?>"></i></a>
                                    <?php } ?>
                                </div>
                                <svg class="angle-svg" xmlns="http://www.w3.org/2000/svg" width="100%" viewBox="0 0 100 100" version="1.1" preserveAspectRatio="none" height="80px">
                                    <path stroke="" stroke-width="0" d="M0 0 L100 100 L0 200"/>
                                    <defs>
                                        <linearGradient id="svg-gradient-team">
                                          <stop offset="0%" stop-color="<?php echo esc_attr( $svg_color_from ); ?>" stop-opacity="0.8"  />
                                          <stop offset="100%" stop-color="<?php echo esc_attr( $svg_color_to ); ?>" stop-opacity="0.8" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="team-holder">
                        <h3 class="team-title" style="color:<?php echo esc_attr( $title_color ); ?>">
                            <?php echo esc_attr($title); ?>
                        </h3>
                        <span class="team-position">
                            <?php echo esc_attr($position); ?>
                        </span>
                        <div class="team-desc">
                            <?php echo wp_kses_post( $desc ); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php endif;?>