<?php
extract(shortcode_atts(array(
    'title' => '',
    'icon_image' => '',
    'price' => '',
    'pricing_color' => '',
    'description' => '',
    'text_button' => '',
    'link_button' => '',

    'el_class' => '',
    'animation' => '',
), $atts));
$icon_image_url = '';
if (!empty($icon_image)) {
    $attachment_image = wp_get_attachment_image_src($icon_image, 'full');
    $icon_image_url = $attachment_image[0];
}

$link = vc_build_link($link_button);
$a_href = '';
$a_target = '_self';
if ( strlen( $link['url'] ) > 0 ) {
    $a_href = $link['url'];
    $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
} 

$description = (array) vc_param_group_parse_atts($description);

$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
?>

<div class="ct-pricing-layout1 <?php echo esc_attr($el_class.' '.$animation_classes); ?>">
    <div class="ct-pricing-head f-heading" <?php if(!empty($pricing_color)) { ?> style="background-color:<?php echo esc_attr( $pricing_color ); ?>;" <?php } ?>>
        <h3 class="ct-pricing-title"><?php echo esc_attr($title);?>  </h3>
        <?php if(!empty($icon_image_url)) { ?>
            <div class="ct-pricing-icon">
                <img src="<?php echo esc_url( $icon_image_url ); ?>" />
            </div>
        <?php } ?>
        <?php if(!empty($price)) : ?>
            <div class="ct-pricing-price">
                <?php echo esc_attr($price);?>  
            </div>
        <?php endif;?>
    </div>
    <div class="ct-pricing-body">
        <?php if(!empty($description)) : ?>
            <ul class="ct-pricing-content">
                <?php foreach ($description as $key => $value) { 
                    $description_item = isset($value['description_item']) ? $value['description_item'] : '';
                    ?>
                    <li><i class="fa fa-angle-right"></i><?php echo esc_html($description_item); ?></li>
                <?php } ?>
            </ul>
        <?php endif;?>
        <?php if(!empty($text_button)) : ?>
            <div class="ct-pricing-button">
                <a class="btn" href="<?php echo esc_url($a_href);?>" target="<?php echo esc_attr( $a_target ); ?>" <?php if(!empty($pricing_color)) { ?> style="background-color:<?php echo esc_attr( $pricing_color ); ?>; border-color:<?php echo esc_attr( $pricing_color ); ?>;" <?php } ?>>
                    <?php echo esc_attr($text_button);?>
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>