<?php
extract(shortcode_atts(array(
    'layout' => 'layout1',
    'phone' => '',
    'title' => '',
    'subtitle' => '',
    'btn_text' => '',
    'btn_link' => '',
    'image' => '',
), $atts));
$link = vc_build_link($btn_link);
$a_href = '';
$a_target = '';
if ( strlen( $link['url'] ) > 0 ) {
    $a_href = $link['url'];
    $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
}
$image_url = '';
if (!empty($image)) {
    $attachment_image = wp_get_attachment_image_src($image, 'full');
    $image_url = $attachment_image[0];
} ?>

<?php if($layout == 'layout1') : ?>
	<div class="phone-info-wrap">
		<div class="phone-info">
			<div class="phone-bg">
				<img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/phone.png'); ?>" />
				<div class="phone-bg-inner bg-image" style="background-image: url(<?php echo esc_url($image_url); ?>);"></div>
			</div>
			<div class="phone-holder">
				<h3><?php echo wp_kses_post($title); ?></h3>
				<p><?php echo wp_kses_post($subtitle); ?></p>
				<?php if(!empty($btn_text)) : ?>
					<a href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php echo esc_attr($btn_text); ?><i class="fa fa-angle-right"></i></a>
				<?php endif; ?>
			</div>
		</div>
	</div>
<?php endif; ?>

<?php if($layout == 'layout2') : ?>
	<div class="button-phone-info">
		<a href="tel:<?php echo esc_attr($phone); ?>">
			<i class="fa fa-phone"></i>
			<span><?php echo esc_attr($phone); ?></span>
		</a>
		<h3><?php echo wp_kses_post($title); ?></h3>
	</div>
<?php endif; ?>