<?php
extract(shortcode_atts(array(
    'form' => '',
    'el_title' => '',
    'el_desc' => '',
    'animation'   => '',
    'form_style'   => '',
    'el_class'   => '',
), $atts));
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
$defined_forms = array( 'form_1', 'form_2', 'form_3', 'form_4', 'form_5', 'form_6', 'form_7', 'form_8', 'form_9', 'form_10' );
if(class_exists('Newsletter')) { ?>
    <div class="ct-newsletter-layout2 <?php echo esc_attr( $el_class.' '.$animation_classes.' '.$form_style ); ?>">
        <div class="ct-newsletter-inner row">
            <?php if( ( !empty($el_title) || !empty($el_desc) ) ) : ?>
                <div class="ct-newsletter-holder col-xl-6 col-lg-6 col-md-6">
                    <div class="ct-newsletter-holder-inner">
                        <div class="ct-newsletter-icon"></div>
                        <div class="ct-newsletter-meta">
                            <h3><?php echo esc_attr( $el_title ); ?></h3>
                            <p><?php echo wp_kses_post( $el_desc ); ?></p>
                        </div>
                    </div>
                </div>  
            <?php endif; ?>
            <div class="ct-newsletter-form col-xl-6 col-lg-6 col-md-6">
                <?php
                if ( in_array( $form, $defined_forms ) ) {
                    $form = str_replace( 'form_', '', $form );
                    echo do_shortcode( '[newsletter_form form="' . esc_attr( $form ) . '"]' );
                } else {
                    echo NewsletterSubscription::instance()->get_subscription_form_html5();
                } ?>
            </div>
        </div>
    </div>
<?php } ?>