<?php
extract(shortcode_atts(array(
    'title' => '',
    'title_color' => '',
    'title_font_size' => '',
    'title_line_height' => '',
    'title_link' => '',
    'description' => '',
    'description_color' => '',

    'btn_text' => '',
    'btn_link' => '',

    'l6_image' => '',

    'btn_bg_color' => '',
    'btn_text_color' => '',

    'animation' => '',
    'el_class' => '',
), $atts));
$image_url = '';
if (!empty($l6_image)) {
    $attachment_image = wp_get_attachment_image_src($l6_image, 'full');
    $image_url = $attachment_image[0];
}

$link = vc_build_link($btn_link);
$a_href = '';
$a_target = '';
if ( strlen( $link['url'] ) > 0 ) {
    $a_href = $link['url'];
    $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
}

$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
?>
<div class="ct-fancybox-layout6 <?php echo esc_attr($el_class.' '.$animation_classes); ?>">
	<div class="ct-fancybox-inner">
        <?php if(!empty($image_url)) : ?>
            <div class="ct-fancybox-image">
                <?php if(!empty($a_href)) : ?><a href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php endif; ?>
                    <img src="<?php echo esc_url($image_url); ?>" />
                <?php if(!empty($a_href)) : ?></a><?php endif; ?>
            </div>   
        <?php endif; ?>
        <div class="ct-fancybox-content">
            <?php if(!empty($title)) : ?>
                <h3 class="ct-fancybox-title" style="<?php if(!empty($title_color)) { echo 'color:'.esc_attr($title_color).';'; } if(!empty($title_font_size)) { echo 'font-size:'.esc_attr($title_font_size).'px;'; } if(!empty($title_line_height)) { echo 'line-height:'.esc_attr($title_line_height).'px;'; } ?>">
                    <?php echo wp_kses_post( $title ); ?>
                </h3>
            <?php endif;?>
            <?php if(!empty($description)) : ?>
            <div class="ct-fancybox-desc" style="<?php if(!empty($description_color)) { echo 'color:'.esc_attr($description_color).';'; } ?>">
                <?php echo wp_kses_post( $description ); ?>
            </div>
            <?php endif;?>
            <?php if(!empty($btn_text)) : ?>
                <div class="ct-fancybox-more">
                    <a href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php echo esc_attr( $btn_text ); ?></a>
                </div>
            <?php endif; ?>
            <div class="ct-fancybox-gap"></div>
        </div>
	</div>
</div>