<?php
extract(shortcode_atts(array(

    'content_list' => '',
    'el_class' => '',
    'animation' => '',

), $atts));

wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-deal-carousel');
extract(unfinityplus_get_param_carousel($atts));
$el_content_list = array();
$el_content_list = (array) vc_param_group_parse_atts( $content_list );
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );

if(!empty($el_content_list)) : ?>
    <div id="<?php echo esc_attr($html_id);?>" class="ct-deal-carousel default owl-carousel <?php echo esc_attr( $el_class.' '.$animation_classes ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
        <?php foreach ($el_content_list as $key => $value) {
            $title = isset($value['deal_title']) ? $value['deal_title'] : '';
            $s_prrice = isset($value['s_prrice']) ? $value['s_prrice'] : '';
            $r_prrice = isset($value['r_prrice']) ? $value['r_prrice'] : '';
            $l_prrice = isset($value['l_prrice']) ? $value['l_prrice'] : '';
            $button_text = isset($value['button_text']) ? $value['button_text'] : '';
            $button_link = isset($value['button_link']) ? $value['button_link'] : '';
            $link = vc_build_link($button_link);
            $a_href = '';
            $a_target = '';
            if ( strlen( $link['url'] ) > 0 ) {
                $a_href = $link['url'];
                $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
            }
            $image = isset($value['deal_image']) ? $value['deal_image'] : '';
            $image_url = '';
            if (!empty($image)) {
                $attachment_image = wp_get_attachment_image_src($image, 'full');
                $image_url = $attachment_image[0];
            }
            $content = isset($value['deal_content']) ? $value['deal_content'] : '';
            $content_inner = (array) vc_param_group_parse_atts( $content );
            $holder_class = 'col-xl-5 col-lg-6 col-md-12';
            ?>
            <div class="ct-deal-item">
                <div class="ct-deal-item-inner row">
                    <?php if(!empty($image)) { ?>
                        <div class="deal-featured col-xl-7 col-lg-6 col-md-12">
                            <div class="deal-featured-inner bg-image" style="background-image: url(<?php echo esc_url($image_url); ?>);"></div>
                        </div>
                    <?php } else {
                        $holder_class = 'col-12';
                    } ?>
                    <div class="deal-holder <?php echo esc_attr($holder_class); ?>">
                        <div class="deal-holder-inner">
                            <h3 class="deal-title">
                                <?php echo esc_attr($title); ?>
                            </h3>
                            <div class="deal-price">
                                <del><?php echo esc_attr($s_prrice); ?></del>
                                <span><span><?php echo esc_attr($r_prrice); ?> </span><?php echo esc_attr($l_prrice); ?></span>
                            </div>
                            <ul class="deal-content">
                                <?php foreach ($content_inner as $key => $value) {
                                    $item_content = isset($value['item_content']) ? $value['item_content'] : ''; ?>
                                    <li><i class="fa fa-angle-right"></i><?php echo esc_attr($item_content); ?></li>
                                <?php } ?>
                            </ul>
                            <?php if(!empty($button_text)): ?>
                                <div class="deal-button">
                                    <a class="btn btn-secondary" href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php echo esc_attr( $button_text ); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php endif;?>