<?php
extract(shortcode_atts(array(

    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'el_class'             => '',
    'img_size'             => '600x390',

), $atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-cause-carousel');
extract(cms_get_posts_of_grid('cause', $atts));
extract(unfinityplus_get_param_carousel($atts));
wp_enqueue_script( 'waypoints' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-cause-carousel owl-carousel owl-dots-medium <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
    <?php if (is_array($posts)):
        foreach ($posts as $post) {
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ) );
            $thumbnail    = $img['thumbnail'];
            $progress_bar = get_post_meta($post->ID, 'progress_bar', true);
            $time = get_post_meta($post->ID, 'time', true);
            ?>
            <div class="ct-carousel-item">
                <div class="grid-item-inner ct-fade-in">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) : ?>
                        <div class="item-featured">
                             <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post( $thumbnail ); ?>
                             </a>
                        </div>
                    <?php endif; ?>
                    <div class="item-body">
                        <h3 class="item-title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                        </h3>
                        <ul class="item-meta">
                            <li><label><i class="fa fa-user"></i> <?php echo esc_html__('Raised By:', 'unfinityplus'); ?></label> <?php the_author_posts_link(); ?></li>
                            <?php if(!empty($time)) : ?>
                                <li><label><i class="fa fa-clock-o"></i> <?php echo esc_html__( 'Time:', 'unfinityplus' ) ?></label> <?php echo esc_attr($time); ?></li>
                            <?php endif; ?>
                        </ul>
                        <div class="item-content">
                            <?php
                                $cms_the_excerpt = get_the_excerpt($post->ID);
                                if(!empty($cms_the_excerpt)) {
                                    echo wp_trim_words( $cms_the_excerpt, $num_words = 22, $more = null );
                                } else {
                                    echo wp_trim_words( strip_shortcodes( $post->post_content ), $num_words = 22, $more = null );
                                }
                            ?>
                        </div>
                        <?php if(!empty($progress_bar)) : ?>
                            <div class="item-progress-bar">
                                <?php 
                                    wp_enqueue_style('progressbar', get_template_directory_uri() . '/assets/css/progressbar.min.css', array(), '0.7.1');
                                    wp_enqueue_script('progressbar', get_template_directory_uri() . '/assets/js/progressbar.min.js', array( 'jquery' ), '0.7.1', true);
                                    wp_enqueue_script('ct-progressbar', get_template_directory_uri() . '/assets/js/progressbar.ct.js', array( 'jquery' ), 'all', true);
                                    wp_enqueue_script('waypoints');
                                ?>
                                <div class="ct-progress progress">
                                    <div class="progress-bar" role="progressbar" data-valuetransitiongoal="<?php echo esc_attr($progress_bar); ?>">
                                        <span>
                                            <?php echo esc_attr($progress_bar).'%';?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php }
    endif; ?>
</div>