<?php
extract(shortcode_atts(array(
    'title' => '',
    'description' => '',
    'banner_image' => '',
    'img_pos' => 'img-left',
    'animation' => '',
    'el_class' => '',
), $atts));
$banner_image_url = '';
if (!empty($banner_image)) {
    $attachment_image = wp_get_attachment_image_src($banner_image, 'full');
    $banner_image_url = $attachment_image[0];
}
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
?>
<div class="ct-banner-default <?php echo esc_attr($img_pos.' '.$el_class.' '.$animation_classes); ?>">
	<div class="ct-banner-inner clearfix">
		<?php if(!empty($banner_image_url)) { ?>
            <div class="ct-banner-image">
                <img class="icon-main" src="<?php echo esc_url( $banner_image_url ); ?>" alt="<?php echo esc_attr( $title ); ?>"/>
            </div>
        <?php } ?>

        <div class="ct-banner-content">
            <?php if(!empty($title)) : ?>
                <div class="ct-banner-title">
                    <?php echo wp_kses_post( $title ); ?>
                </div>
            <?php endif;?>
            <?php if(!empty($description)) : ?>
                <div class="ct-banner-desc"">
                    <?php echo wp_kses_post( $description ); ?>
                </div>
            <?php endif;?>
        </div>
	</div>
</div>