<?php
$term_list = cms_get_grid_term_list('post');
vc_map(
    array(
        'name'     => esc_html__('Recent News List', 'unfinityplus'),
        'base'     => 'cms_recent_news',
        'class'    => 'ct-icon-element',
        'description' => esc_html__( 'Posts in masonry grid', 'unfinityplus' ),
        'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
        'params'   => array(
            array(
                'type' => 'cms_template_img',
                'param_name' => 'cms_template',
                'shortcode' => 'cms_recent_news',
                'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
                'admin_label' => true,
                'std' => 'cms_recent_news.php',
                'group' => esc_html__('Template', 'unfinityplus'),
            ),
            array(
                'type'       => 'checkbox',
                'heading'    => esc_html__('Custom Source', 'unfinityplus'),
                'param_name' => 'custom_source',
                'value'      => '1',
                'description'        => 'Check here if you want custom source',
                'group'      => esc_html__('Source Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'autocomplete',
                'heading'    => esc_html__('Select Categories', 'unfinityplus'),
                'param_name' => 'source',
                'description' => esc_html__('Leave blank to select all category', 'unfinityplus'),
                'settings'   => array(
                    'multiple' => true,
                    'values'   => $term_list['auto_complete'],
                ),
                'dependency' => array(
                    'element'=>'custom_source',
                    'value'=>array(
                        'true',
                    )
                ),
                'group'      => esc_html__('Source Settings', 'unfinityplus'),
            ),
            array(
                'type'       => 'autocomplete',
                'class'      => '',
                'heading'    => esc_html__('Select Post Name', 'unfinityplus'),
                'param_name' => 'post_ids',
                'description' => esc_html__('Leave blank to show all post', 'unfinityplus'),
                'settings'   => array(
                    'multiple' => true,
                    'values'   => cms_get_type_posts_data('post')
                ),
                'dependency' => array(
                    'element'=>'custom_source',
                    'value'=>array(
                        'true',
                    )
                ),
                'group'      => esc_html__('Source Settings', 'unfinityplus'),
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Order by', 'unfinityplus'),
                'param_name' => 'orderby',
                'value'      => array(
                    'Date'   => 'date',
                    'ID'     => 'ID',
                    'Author' => 'author',
                    'Title'  => 'title',
                    'Random' => 'rand',
                ),
                'std'        => 'date',
                'group'      => esc_html__('Source Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Sort order', 'unfinityplus'),
                'param_name' => 'order',
                'value'      => array(
                    'Ascending'  => 'ASC',
                    'Descending' => 'DESC',
                ),
                'std'        => 'DESC',
                'group'      => esc_html__('Source Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Total items', 'unfinityplus'),
                'param_name' => 'limit',
                'value'      => '6',
                'group'      => esc_html__('Source Settings', 'unfinityplus'),
                'description' => esc_html__('Set max limit for items in grid. Enter number only', 'unfinityplus'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
                'group'            => esc_html__('Extra', 'unfinityplus')
            ),
        )
    )
);

class WPBakeryShortCode_cms_recent_news extends CmsShortCode
{
    protected function content($atts, $content = null)
    {
        $html_id = cmsHtmlID('ct-recent-news');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}

?>