<?php
vc_map(array(
    'name' => 'Contact Info',
    'base' => 'cms_contact_info',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Contact Info Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        /* Title */
        array(
            'type' => 'textarea',
            'heading' => esc_html__('Content', 'unfinityplus'),
            'param_name' => 'description',
        ),

        /* Icon */
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon Library', 'unfinityplus' ),
            'value' => array(
                esc_html__( 'Font Awesome', 'unfinityplus' ) => 'fontawesome',
                esc_html__( 'Material Design', 'unfinityplus' ) => 'material_design',
                esc_html__( 'ET Line', 'unfinityplus' ) => 'etline',
            ),
            'param_name' => 'icon_list',
            'description' => esc_html__( 'Select icon library.', 'unfinityplus' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon Material', 'unfinityplus' ),
            'param_name' => 'icon_material_design',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'material-design',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'material_design',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon FontAwesome', 'unfinityplus' ),
            'param_name' => 'icon_fontawesome',
            'value' => '',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'fontawesome',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon ET Line', 'unfinityplus' ),
            'param_name' => 'icon_etline',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'etline',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'etline',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_contact_info extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>