<?php
$args = array(
    'name' => 'Client Carousel',
    'base' => 'cms_client_carousel',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Clients Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_client_carousel',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'group' => esc_html__('Template', 'unfinityplus'),
            'std' => 'cms_client_carousel.php'
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Template', 'unfinityplus')
        ),
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Client Item', 'unfinityplus' ),
            'value' => '',
            'param_name' => 'client_item',
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                    'admin_label' => true,
                ),
                array(
                    'type' => 'vc_link',
                    'heading' => esc_html__( 'Link', 'unfinityplus' ),
                    'param_name' => 'link',
                    'value' => '',
                    'admin_label' => true,
                ),
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Image size', 'unfinityplus' ),
            'param_name' => 'img_size',
            'value' => '',
            'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).', 'unfinityplus' ),
        ),

    ));

$args = unfinityplus_add_vc_extra_param($args);
vc_map($args);

class WPBakeryShortCode_cms_client_carousel extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>