<?php
$footer_top_column = unfinityplus_get_opt( 'footer_top_column', '4' );
$column_width_change = unfinityplus_get_opt( 'column_width_change', 'yes' );
$bottom_style = unfinityplus_get_opt( 'bottom_style', 'dark' );
$footer_copyright = unfinityplus_get_opt( 'footer_copyright' );
$social_label = unfinityplus_get_opt( 'social_label' );
$back_totop_on = unfinityplus_get_opt('back_totop_on', true);
?>
<footer id="colophon" class="site-footer footer-layout1 bg-overlay footer-<?php echo esc_attr($footer_top_column); ?>-column <?php if($column_width_change == 'yes') { echo 'col-width-change'; } ?>">

    <?php if ( is_active_sidebar( 'sidebar-footer-1' ) || is_active_sidebar( 'sidebar-footer-2' ) || is_active_sidebar( 'sidebar-footer-3' ) || is_active_sidebar( 'sidebar-footer-4' ) ) : ?>
        <?php if (class_exists('ReduxFramework')) { ?>
            <div class="top-footer">
                <div class="container">
                    <div class="row">
                        <?php unfinityplus_footer_top(); ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    <?php endif; ?>

    <div class="bottom-footer style-<?php echo esc_attr($bottom_style); ?>">
        <div class="container">
            <div class="bf-gap"></div>
            <div class="row">
                <div class="bottom-col bottom-copyright col-xl-6 col-lg-6 col-md-12 text-left-lg text-center">
                    <?php
                    if ($footer_copyright) {
                        echo apply_filters('the_content', $footer_copyright);
                    } else {
                        echo wp_kses_post(esc_attr(date("Y")).' &copy; All Rights Reserved by <a target="_blank" href="https://themeforest.net/user/case-themes/portfolio">CaseThemes</a>');
                    } ?>
                </div>
                <?php if ( class_exists( 'ReduxFrameworkInstances' ) ) : ?>
                    <div class="bottom-col col-xl-6 col-lg-6 col-md-12 text-right-lg text-center">
                        <div class="footer-social">
                            <?php if(!empty($social_label)) : ?>
                                <label><?php echo esc_attr($social_label); ?></label>
                            <?php endif; ?>
                            <?php unfinityplus_footer_social_icon(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php if (isset($back_totop_on) && $back_totop_on) : ?>
	    <a href="#" class="ct-scroll-top fixed-bottom"><i class="zmdi zmdi-chevron-up"></i></a>
	<?php endif; ?>
</footer>