<?php
/**
 * Register metabox for posts based on Redux Framework. Supported methods:
 *     isset_args( $post_type )
 *     set_args( $post_type, $redux_args, $metabox_args )
 *     add_section( $post_type, $sections )
 * Each post type can contains only one metabox. Pease note that each field id
 * leads by an underscore sign ( _ ) in order to not show that into Custom Field
 * Metabox from WordPress core feature.
 *
 * @param  unfinityplus_Post_Metabox $metabox
 */

/**
 * Get list menu.
 * @return array
 */
function unfinityplus_get_nav_menu(){

    $menus = array(
        '' => esc_html__('Default', 'unfinityplus')
    );

    $obj_menus = wp_get_nav_menus();

    foreach ($obj_menus as $obj_menu){
        $menus[$obj_menu->term_id] = $obj_menu->name;
    }

    return $menus;
}

function unfinityplus_page_options_register( $metabox ) {
	if ( ! $metabox->isset_args( 'post' ) ) {
		$metabox->set_args( 'post', array(
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Settings', 'unfinityplus' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'page' ) ) {
		$metabox->set_args( 'page', array(
			'opt_name'            => unfinityplus_get_page_opt_name(),
			'display_name'        => esc_html__( 'Page Settings', 'unfinityplus' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_audio' ) ) {
		$metabox->set_args( 'cms_pf_audio', array(
			'opt_name'     => 'post_format_audio',
			'display_name' => esc_html__( 'Audio', 'unfinityplus' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_link' ) ) {
		$metabox->set_args( 'cms_pf_link', array(
			'opt_name'     => 'post_format_link',
			'display_name' => esc_html__( 'Link', 'unfinityplus' )
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_quote' ) ) {
		$metabox->set_args( 'cms_pf_quote', array(
			'opt_name'     => 'post_format_quote',
			'display_name' => esc_html__( 'Quote', 'unfinityplus' )
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_video' ) ) {
		$metabox->set_args( 'cms_pf_video', array(
			'opt_name'     => 'post_format_video',
			'display_name' => esc_html__( 'Video', 'unfinityplus' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_gallery' ) ) {
		$metabox->set_args( 'cms_pf_gallery', array(
			'opt_name'     => 'post_format_gallery',
			'display_name' => esc_html__( 'Gallery', 'unfinityplus' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if (!$metabox->isset_args('product')) {
        $metabox->set_args('product', array(
            'opt_name'            => unfinityplus_get_page_opt_name(),
            'display_name'        => esc_html__('Product Settings', 'unfinityplus'),
            'show_options_object' => false,
        ), array(
            'context'  => 'advanced',
            'priority' => 'default'
        ));
    }

	/* Extra Post Type */
	if ( ! $metabox->isset_args( 'service' ) ) {
		$metabox->set_args( 'service', array(
			'opt_name'            => 'service_option',
			'display_name'        => esc_html__( 'Services Settings', 'unfinityplus' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'portfolio' ) ) {
		$metabox->set_args( 'portfolio', array(
			'opt_name'            => 'portfolio_option',
			'display_name'        => esc_html__( 'Portfolio Settings', 'unfinityplus' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'sermon' ) ) {
		$metabox->set_args( 'sermon', array(
			'opt_name'            => 'sermon_option',
			'display_name'        => esc_html__( 'Sermons Settings', 'unfinityplus' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'event' ) ) {
		$metabox->set_args( 'event', array(
			'opt_name'            => 'event_option',
			'display_name'        => esc_html__( 'Event Settings', 'unfinityplus' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cause' ) ) {
		$metabox->set_args( 'cause', array(
			'opt_name'            => 'cause_option',
			'display_name'        => esc_html__( 'Causes Settings', 'unfinityplus' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	/**
	 * Config service meta options
	 *
	 */
	$metabox->add_section( 'service', array(
		'title'  => esc_html__( 'General', 'unfinityplus' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'       => 'service_excerpt',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Excerpt', 'unfinityplus' ),
				'validate' => 'html'
			),
			array(
				'id'       => 'service_url',
				'type'     => 'text',
				'title'    => esc_html__( 'Custom Link Item', 'unfinityplus' ),
				'validate' => 'no_html'
			),
			array(
				'id'             => 'content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-service #content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'unfinityplus' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'unfinityplus' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				),
				'force_output' => true
			),
		)
	) );

	/**
	 * Config portfolio meta options
	 *
	 */

	$metabox->add_section( 'portfolio', array(
		'title'  => esc_html__( 'General', 'unfinityplus' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'    => 'portfolio_client',
				'type'  => 'text',
				'title' => esc_html__( 'Client', 'unfinityplus' ),
			),
			array(
				'id'    => 'portfolio_location',
				'type'  => 'text',
				'title' => esc_html__( 'Location', 'unfinityplus' ),
			),
			array(
				'id'    => 'portfolio_gallery',
				'type'  => 'gallery',
				'title' => esc_html__( 'Add/Edit Gallery', 'unfinityplus' ),
			),
			array(
				'id'             => 'content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-portfolio #content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'unfinityplus' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'unfinityplus' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				),
				'force_output' => true
			),
		)
	) );

	/**
	 * Config sermon meta options
	 *
	 */
	$metabox->add_section( 'sermon', array(
		'title'  => esc_html__( 'General', 'unfinityplus' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'    => 'audio_url',
				'type'  => 'text',
				'title' => esc_html__( 'Audio Link', 'unfinityplus' ),
			),
			array(
				'id'    => 'video_url',
				'type'  => 'text',
				'title' => esc_html__( 'Video Link', 'unfinityplus' ),
			),
			array(
				'id'    => 'file_download',
				'type'  => 'text',
				'title' => esc_html__( 'File Download', 'unfinityplus' ),
			),
		)
	) );

	/**
	 * Config event meta options
	 *
	 */
	$metabox->add_section( 'event', array(
		'title'  => esc_html__( 'General', 'unfinityplus' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'    => 'address',
				'type'  => 'text',
				'title' => esc_html__( 'Address', 'unfinityplus' ),
			),
			array(
				'id'    => 'phone',
				'type'  => 'text',
				'title' => esc_html__( 'Phone', 'unfinityplus' ),
			),
			array(
				'id'    => 'venue',
				'type'  => 'text',
				'title' => esc_html__( 'Venue', 'unfinityplus' ),
			),
			array(
				'id'    => 'time',
				'type'  => 'text',
				'title' => esc_html__( 'Time', 'unfinityplus' ),
			),
		)
	) );

	/**
	 * Config event meta options
	 *
	 */
	$metabox->add_section( 'cause', array(
		'title'  => esc_html__( 'General', 'unfinityplus' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'    => 'progress_bar',
				'type'  => 'text',
				'title' => esc_html__( 'Progress Bar', 'unfinityplus' ),
				'desc'           => esc_html__( 'Enter number.', 'unfinityplus' ),
			),
			array(
				'id'    => 'time',
				'type'  => 'text',
				'title' => esc_html__( 'Time', 'unfinityplus' ),
			),
		)
	) );

	/**
	 * Config post meta options
	 *
	 */
	$single_post_fields[] = array(
		'id'             => 'post_content_padding',
		'type'           => 'spacing',
		'output'         => array( '.single-post #content' ),
		'right'          => false,
		'left'           => false,
		'mode'           => 'padding',
		'units'          => array( 'px' ),
		'units_extended' => 'false',
		'title'          => esc_html__( 'Content Padding', 'unfinityplus' ),
		'subtitle'     => esc_html__( 'Content site paddings.', 'unfinityplus' ),
		'desc'           => esc_html__( 'Default: Theme Option.', 'unfinityplus' ),
		'default'        => array(
			'padding-top'    => '',
			'padding-bottom' => '',
			'units'          => 'px',
		)
	);
	$metabox->add_section( 'post', array(
		'title'  => esc_html__( 'Post Settings', 'unfinityplus' ),
		'icon'   => 'el el-refresh',
		'fields' => $single_post_fields
	) );

	/**
	 * Config page meta options
	 *
	 */

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Header', 'unfinityplus' ),
		'desc'   => esc_html__( 'Header settings for the page.', 'unfinityplus' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'      => 'custom_header',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Header', 'unfinityplus' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'header_layout',
				'type'         => 'image_select',
				'title'        => esc_html__( 'Layout', 'unfinityplus' ),
				'subtitle'     => esc_html__( 'Select a layout for header.', 'unfinityplus' ),
				'options'      => array(
					'0' => get_template_directory_uri() . '/assets/images/header-layout/h0.jpg',
					'1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
					'2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
					'3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
					'4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
					'5' => get_template_directory_uri() . '/assets/images/header-layout/h5.jpg',
					'6' => get_template_directory_uri() . '/assets/images/header-layout/h6.jpg',
					'7' => get_template_directory_uri() . '/assets/images/header-layout/h7.jpg',
					'8' => get_template_directory_uri() . '/assets/images/header-layout/h8.jpg',
					'9' => get_template_directory_uri() . '/assets/images/header-layout/h9.jpg',
					'10' => get_template_directory_uri() . '/assets/images/header-layout/h10.jpg',
					'11' => get_template_directory_uri() . '/assets/images/header-layout/h11.jpg',
					'12' => get_template_directory_uri() . '/assets/images/header-layout/h12.jpg',
					'13' => get_template_directory_uri() . '/assets/images/header-layout/h13.jpg',
					'14' => get_template_directory_uri() . '/assets/images/header-layout/h14.jpg',
					'15' => get_template_directory_uri() . '/assets/images/header-layout/h15.jpg',
					'16' => get_template_directory_uri() . '/assets/images/header-layout/h16.jpg',
					'17' => get_template_directory_uri() . '/assets/images/header-layout/h17.jpg',
				),
				'default'      => unfinityplus_get_option_of_theme_options( 'header_layout' ),
				'required'     => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '5' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent_layout6',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '6' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent_layout7',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '7' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent_layout10',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '10' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent_layout11',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '11' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent_layout13',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '13' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent_layout14',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '14' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent_layout15',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '15' ),
				'force_output' => true
			),
			array(
				'id'      => 'header_transparent_layout16',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header Transparent', 'unfinityplus' ),
				'default' => false,
				'required'     => array( 0 => 'header_layout', 1 => 'equals', 2 => '16' ),
				'force_output' => true
			),
			array(
	            'id'       => 'logo_light',
	            'type'     => 'media',
	            'title'    => esc_html__('Logo Light', 'unfinityplus'),
	            'default' => '',
	            'required' => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
	            'force_output' => true
	        ),
	        array(
	            'id'       => 'logo_dark',
	            'type'     => 'media',
	            'title'    => esc_html__('Logo Dark', 'unfinityplus'),
	            'default' => '',
	            'required' => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
	            'force_output' => true
	        ),
			array(
                'id'       => 'h_custom_menu',
                'type'     => 'select',
                'title'    => esc_html__( 'Select Menu', 'unfinityplus' ),
                'subtitle' => esc_html__( 'Custom menu for current page.', 'unfinityplus' ),
                'options'  => unfinityplus_get_nav_menu(),
                'default' => '',
                'required' => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
                'force_output' => true
            ),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Content', 'unfinityplus' ),
		'desc'   => esc_html__( 'Settings for content area.', 'unfinityplus' ),
		'icon'   => 'el-icon-pencil',
		'fields' => array(
			array(
				'id'       => 'content_bg_color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background Color', 'unfinityplus' ),
				'subtitle' => esc_html__( 'Content background color.', 'unfinityplus' ),
				'output'   => array( 'background-color' => '#content, .site-layout-default .site-footer:before' )
			),
			array(
				'id'             => 'content_padding',
				'type'           => 'spacing',
				'output'         => array( '#content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'unfinityplus' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'unfinityplus' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				),
				'force_output' => true
			),
			array(
				'id'      => 'show_sidebar_page',
				'type'    => 'switch',
				'title'   => esc_html__( 'Show Sidebar', 'unfinityplus' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'sidebar_page_pos',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Sidebar Position', 'unfinityplus' ),
				'options'      => array(
					'left'  => esc_html__( 'Left', 'unfinityplus' ),
					'right' => esc_html__( 'Right', 'unfinityplus' ),
				),
				'default'      => 'right',
				'required'     => array( 0 => 'show_sidebar_page', 1 => '=', 2 => '1' ),
				'force_output' => true
			),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Footer', 'unfinityplus' ),
		'desc'   => esc_html__( 'Settings for footer.', 'unfinityplus' ),
		'icon'   => 'el el-website',
		'fields' => array(
			array(
				'id'      => 'custom_footer',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Footer', 'unfinityplus' ),
				'default' => false,
				'indent'  => true
			),
			array(
	            'id'       => 'footer_layout',
	            'type'     => 'image_select',
	            'title'    => esc_html__('Layout', 'unfinityplus'),
	            'subtitle' => esc_html__('Select a layout for upper footer area.', 'unfinityplus'),
	            'options'  => array(
	                '0' => get_template_directory_uri() . '/assets/images/footer-layout/f0.jpg',
	                '1' => get_template_directory_uri() . '/assets/images/footer-layout/f1.jpg',
	            ),
	            'default'  => '1',
	            'required'     => array( 0 => 'custom_footer', 1 => 'equals', 2 => '1' ),
				'force_output' => true
	        ),
		)
	) );

	/**
	 * Config post format meta options
	 *
	 */

	$metabox->add_section( 'cms_pf_video', array(
		'title'  => esc_html__( 'Video', 'unfinityplus' ),
		'fields' => array(
			array(
				'id'    => 'post-video-url',
				'type'  => 'text',
				'title' => esc_html__( 'Video URL', 'unfinityplus' ),
				'desc'  => esc_html__( 'YouTube or Vimeo video URL', 'unfinityplus' )
			),

			array(
				'id'    => 'post-video-file',
				'type'  => 'editor',
				'title' => esc_html__( 'Video Upload', 'unfinityplus' ),
				'desc'  => esc_html__( 'Upload video file', 'unfinityplus' )
			),

			array(
				'id'    => 'post-video-html',
				'type'  => 'textarea',
				'title' => esc_html__( 'Embadded video', 'unfinityplus' ),
				'desc'  => esc_html__( 'Use this option when the video does not come from YouTube or Vimeo', 'unfinityplus' )
			)
		)
	) );

	$metabox->add_section( 'cms_pf_gallery', array(
		'title'  => esc_html__( 'Gallery', 'unfinityplus' ),
		'fields' => array(
			array(
				'id'       => 'post-gallery-lightbox',
				'type'     => 'switch',
				'title'    => esc_html__( 'Lightbox?', 'unfinityplus' ),
				'subtitle' => esc_html__( 'Enable lightbox for gallery images.', 'unfinityplus' ),
				'default'  => true
			),
			array(
				'id'       => 'post-gallery-images',
				'type'     => 'gallery',
				'title'    => esc_html__( 'Gallery Images ', 'unfinityplus' ),
				'subtitle' => esc_html__( 'Upload images or add from media library.', 'unfinityplus' )
			)
		)
	) );

	$metabox->add_section( 'cms_pf_audio', array(
		'title'  => esc_html__( 'Audio', 'unfinityplus' ),
		'fields' => array(
			array(
				'id'          => 'post-audio-url',
				'type'        => 'text',
				'title'       => esc_html__( 'Audio URL', 'unfinityplus' ),
				'description' => esc_html__( 'Audio file URL in format: mp3, ogg, wav.', 'unfinityplus' ),
				'validate'    => 'url',
				'msg'         => 'Url error!'
			)
		)
	) );

	$metabox->add_section( 'cms_pf_link', array(
		'title'  => esc_html__( 'Link', 'unfinityplus' ),
		'fields' => array(
			array(
				'id'       => 'post-link-url',
				'type'     => 'text',
				'title'    => esc_html__( 'URL', 'unfinityplus' ),
				'validate' => 'url',
				'msg'      => 'Url error!'
			)
		)
	) );

	$metabox->add_section( 'cms_pf_quote', array(
		'title'  => esc_html__( 'Quote', 'unfinityplus' ),
		'fields' => array(
			array(
				'id'    => 'post-quote-cite',
				'type'  => 'text',
				'title' => esc_html__( 'Cite', 'unfinityplus' )
			)
		)
	) );

}


add_action( 'cms_post_metabox_register', 'unfinityplus_page_options_register' );

function unfinityplus_get_option_of_theme_options( $key, $default = '' ) {
	if ( empty( $key ) ) {
		return '';
	}
	$options = get_option( unfinityplus_get_opt_name(), array() );
	$value   = isset( $options[ $key ] ) ? $options[ $key ] : $default;

	return $value;
}