<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package UnfinityPlus
 */

/**
 * Setup default image sizes after the theme has been activated
 */
function unfinityplus_after_setup_theme()
{

}
add_action( 'after_setup_theme', 'unfinityplus_after_setup_theme' );

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function unfinityplus_body_classes( $classes )
{   

    // Adds a class of group-blog to blogs with more than 1 published author.
    if (is_multi_author()) {
        $classes[] = 'group-blog';
    }

    // Adds a class of hfeed to non-singular pages.
    if (!is_singular()) {
        $classes[] = 'hfeed';
    }
    $rtl = unfinityplus_get_opt( 'rtl', false );
    $rtl_page = unfinityplus_get_page_opt( 'rtl', false );
    if($rtl_page) {
        $rtl = $rtl_page;
    }
    if ($rtl || is_rtl()) {
        $classes[] = 'rtl';
    }

    if ( class_exists('WPBakeryVisualComposerAbstract') ) {
        $classes[] = 'visual-composer';
    }

    return $classes;
}
add_filter( 'body_class', 'unfinityplus_body_classes' );


/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function unfinityplus_pingback_header()
{
    if ( is_singular() && pings_open() )
    {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}
add_action( 'wp_head', 'unfinityplus_pingback_header' );
