;(function ($) {

    "use strict";

    /* ===================
     Page reload
     ===================== */
    var scroll_top;
    var window_height;
    var window_width;
    var scroll_status = '';
    var lastScrollTop = 0;
    $(window).on('load', function () {
        $(".ct-loader").fadeOut("slow");
        window_width = $(window).width();
        unfinityplus_col_offset();
        unfinityplus_item_sameheight();
        unfinityplus_header_sticky();
        unfinityplus_scroll_to_top();
    });
    $(window).on('resize', function () {
        window_width = $(window).width();
        unfinityplus_col_offset();
        unfinityplus_item_sameheight();
        unfinityplus_header_sticky();
    });

    $(window).on('scroll', function () {
        scroll_top = $(window).scrollTop();
        window_height = $(window).height();
        window_width = $(window).width();
        if (scroll_top < lastScrollTop) {
            scroll_status = 'up';
        } else {
            scroll_status = 'down';
        }
        lastScrollTop = scroll_top;
        unfinityplus_header_sticky();
        unfinityplus_scroll_to_top();
    });

    $(document).ready(function () {

        /* =================
         Menu Dropdown
         =================== */
        var $menu = $('.main-navigation');
        $menu.find('ul.sub-menu > li').each(function () {
            var $submenu = $(this).find('>ul');
            if ($submenu.length == 1) {
                $(this).hover(function () {
                    if ($submenu.offset().left + $submenu.width() > $(window).width()) {
                        $submenu.addClass('back');
                    } else if ($submenu.offset().left < 0) {
                        $submenu.addClass('back');
                    }
                }, function () {
                    $submenu.removeClass('back');
                });
            }
        });
        /* =================
         Menu Mobile
         =================== */
        $('.main-navigation li.menu-item-has-children').append('<span class="main-menu-toggle"></span>');
        $('.main-menu-toggle').on('click', function () {
            $(this).parent().find('> .sub-menu').toggleClass('submenu-open');
            $(this).parent().find('> .sub-menu').slideToggle();
        });

        $("#main-menu-mobile .open-menu").on('click', function () {
            $(this).toggleClass('opened');
            $('.site-navigation').toggleClass('navigation-open');
            $('.menu-mobile-overlay').toggleClass('active');
        })

        $(".menu-mobile-close").on('click', function () {
            $(this).parents('.site-navigation').removeClass('navigation-open');
            $('.menu-mobile-overlay').removeClass('active');
            $('#main-menu-mobile .open-menu').removeClass('opened');
        })

        $(".menu-mobile-overlay").on('click', function () {
            $(this).parents('#site-header').find('.site-navigation').removeClass('navigation-open');
            $(this).removeClass('active');
            $('#main-menu-mobile .open-menu').removeClass('opened');
            $('.site-navigation').removeClass('navigation-open');
        })

        $(".primary-menu li a").on('click', function () {
            $(this).parents('.site-navigation').removeClass('navigation-open');
            $('.menu-mobile-overlay').removeClass('active');
            $('#main-menu-mobile .open-menu').removeClass('opened');
            $('.site-navigation').removeClass('navigation-open');
        })

        /* ===================
         Search Toggle
         ===================== */
        $('.h-btn-search').on('click', function (e) {
            e.preventDefault();
            $('.ct-search-popup').removeClass('remove').toggleClass('open').find('.search-field').focus();
        });
        
        $('.h-btn-form').on('click', function (e) {
            e.preventDefault();
            $('.ct-modal-contact-form').removeClass('remove').toggleClass('open');
        });
        $(document).on('click','.ct-close',function(e){
            $(this).parent().addClass('remove').removeClass('open');
            $(this).parents('.ct-modal').addClass('remove').removeClass('open');
            $(this).parent('.ct-modal').addClass('remove').removeClass('open');
            $(this).parents('body').removeClass('ovhidden');
            e.preventDefault();
        });
        $(document).on('click', function (e) {
            if (e.target.className == 'ct-modal ct-search-popup open')
                $('.ct-search-popup').removeClass('open').addClass('remove');
            if (e.target.className == 'ct-modal ct-user-popup open')
                $('.ct-user-popup').removeClass('open').addClass('remove');
        });

        $('.map-popup').on('click', function (e) {
            e.preventDefault();
            $(this).parents('#page').find('.ct-contact-map-popup').removeClass('remove').toggleClass('open');
            $(this).parents('body').addClass('ovhidden');
        });

        /* Video 16:9 */
        $('.entry-video iframe').each(function () {
            var v_width = $(this).width();

            v_width = v_width / (16 / 9);
            $(this).attr('height', v_width + 35);
        });
        $('.entry-video .wp-video').each(function () {
            var v_width = $(this).width();

            v_width = (v_width / (16 / 9)) + 32;
            $(this).css('height', v_width + 'px');
        });
        $('.entry-video-intro .button-video').each(function () {
            $(this).on('click', function () {
                $(this).parents('.entry-video-intro').addClass('offintro');
                $(this).parents('.entry-video').find('.wp-video').addClass('onvideo');
                $(this).parents('.entry-video').find('.mejs-overlay-button').trigger('click');
            });
        });
        /* Images Light Box - Gallery:True */
        $('.images-light-box').each(function () {
            $(this).magnificPopup({
                delegate: 'a.light-box',
                type: 'image',
                gallery: {
                    enabled: true
                },
                mainClass: 'mfp-fade',
            });
        });

        $('.image-light-box').each(function () {
            $(this).magnificPopup({
                delegate: 'a.light-box',
                type: 'image',
                gallery: {
                    enabled: false
                },
                mainClass: 'mfp-fade',
            });
        });

        /* Video Light Box */
        $('.ct-video-button, .btn-video, .btn-icon-popup').magnificPopup({
            type: 'iframe',
            mainClass: 'mfp-fade',
            removalDelay: 160,
            preloader: false,

            fixedContentPos: false
        });

        /* ===================
        Theia Sticky Sidebar
        ===================== */
        var sidebarOffset = $('#site-header').outerHeight();
        $(".sidebar-fixed").theiaStickySidebar({
            "containerSelector": "",
            "additionalMarginTop": sidebarOffset,
            "additionalMarginBottom": "0",
            "updateSidebarHeight": false,
            "minWidth": "768",
            "sidebarBehavior": "modern"
        });
        /* =================
        WooCommerce
        =================== */
        $('#review_form').find("#comment").each(function (ev) {
            if (!$(this).val()) {
                $(this).attr("placeholder", "Your review *");
            }
        });

        $('.widget_product_search .search-field').find("input[type='text']").each(function (ev) {
            if (!$(this).val()) {
                $(this).attr("placeholder", "Search and Press Enter");
            }
        });
        var email_text = $('.tnp-field-email label').text();
        $('.tnp-field-email label').remove();
        $('.tnp-field-email').find(".tnp-email").each(function (ev) {
            if (!$(this).val()) {
                $(this).attr("placeholder", email_text);
            }
        });
        var firstname_text = $('.tnp-field-firstname label').text();
        $('.tnp-field-firstname label').remove();
        $('.tnp-field-firstname').find(".tnp-firstname").each(function (ev) {
            if (!$(this).val()) {
                $(this).attr("placeholder", firstname_text);
            }
        });
        var lastname_text = $('.tnp-field-lastname label').text();
        $('.tnp-field-lastname label').remove();
        $('.tnp-field-lastname').find(".tnp-lastname").each(function (ev) {
            if (!$(this).val()) {
                $(this).attr("placeholder", lastname_text);
            }
        });

        /* ====================
         Scroll To Top
         ====================== */
        $('.ct-scroll-top').on('click', function () {
            $('html, body').animate({scrollTop: 0}, 800);
            return false;
        });

        $('.ct-scroll-top i').on('click', function () {
            $('html, body').animate({scrollTop: 0}, 800);
            return false;
        });

        /* =================
        Add Class
        =================== */
        $('.wpcf7-select').parent().addClass('wpcf7-menu');
        /* =================
         Row & VC Column Animation
         =================== */
        $('.vc_row.wpb_row.vc_row-fluid').each(function () {
            var vctime = 100;
            var vc_inner = $(this).children().length;
            var _vci = vc_inner - 1;
            $(this).find('> .wpb_animate_when_almost_visible').each(function (index, obj) {
                $(this).css('animation-delay', vctime + 'ms');
                if (_vci === index) {
                    vctime = 100;
                    _vci = _vci + vc_inner;
                } else {
                    vctime = vctime + 100;
                }
            })
        });
        $('.animation-time').each(function () {
            var vctime = 20;
            var vc_inner = $(this).children().length;
            var _vci = vc_inner - 1;
            $(this).find('> .grid-item > .wpb_animate_when_almost_visible').each(function (index, obj) {
                $(this).css('animation-delay', vctime + 'ms');
                if (_vci === index) {
                    vctime = 20;
                    _vci = _vci + vc_inner;
                } else {
                    vctime = vctime + 30;
                }
            });
        });

        /* =================
         The clicked item should be in center in owl carousel
         =================== */
        var $owl_item = $('.owl-active-click');
        $owl_item.children().each(function (index) {
            $(this).attr('data-position', index);
        });
        $(document).on('click', '.owl-active-click .owl-item > div', function () {
            $owl_item.trigger('to.owl.carousel', $(this).data('position'));
        });

        /* =================
         Multi Select
         =================== */
        $('select').each(function () {
            $(this).niceSelect();
        });

        /* =================
         Woocomerce
         =================== */
        $('.woocommerce-cart-meta').on('click', function () {
            $(this).parent().find('.widget_shopping_cart').toggleClass('cart-open');
        });

        /* =================
         One Page
         =================== */
        if( $('.primary-menu > li > a').hasClass('item-one-page') ) {
            $('.primary-menu').singlePageNav({
                currentClass: 'current',
                changeHash: false,
                scrollSpeed: 1200,
                scrollThreshold: 0.5,
                filter: '.item-one-page',
                easing: 'swing',
            });
        }

        $('.primary-menu > li > .item-one-page').parent().removeClass('current-menu-item').removeClass('current_page_item');
        $('.primary-menu > li > .item-one-page').on('click', function (e) {
            var _link = $(this).attr('href');
            var _id_data = e.currentTarget.hash;
            if ($(_id_data).length !== 1) {
                window.location.href = _link;
            }
            return false;
        });

        $('body:not(".home") .primary-menu > li > .item-one-page').removeClass('current');

        if($('#site-header-wrap').hasClass('is-sticky')) {
            var offsetHeaderData = parseInt($('#site-header-wrap').attr('site-data-offset'));
            var offsetHeaderWrap = $('#site-header-wrap').outerHeight();
            var offsetHeader = $('#site-header').outerHeight();
            if(typeof $('#site-header-wrap').attr('site-data-offset') !== 'undefined') {
                $('.item-one-page').parents('.site').find('.entry-content > .vc_row').attr('data-offset', offsetHeaderData);
            } else {
                $('.item-one-page').parents('.site').find('.entry-content > .vc_row').attr('data-offset', offsetHeader);
            }
            $('.item-one-page').parents('.site').find('.entry-content > #section-home.vc_row').attr('data-offset', offsetHeaderWrap);
        }
        $('.el-btn-link').on('click', function(e) {
            var id_scroll = $(this).attr('href');
            var offsetScroll = $('#site-header').outerHeight();
            e.preventDefault();
            $("html, body").animate({ scrollTop: $(id_scroll).offset().top - offsetScroll }, 600);
        });

        /* =================
         Element
         =================== */
        $('.ctf-author-box-link').removeAttr('target');
        setTimeout(function () {
            $('.ct-service-carousel-default .ct-carousel-item').each(function () {
                var h_meta = $(this).find('.item-meta').outerHeight();
                var h_meta_total = h_meta + 30;
                $(this).find('.item-holder').css('margin-top', -h_meta_total + 'px');
            });
            $('.ct-carousel').find('.owl-dot').parents('.owl-carousel').addClass('dot-added');
        }, 100);

        $('.entry-content > .vc_row').each(function () {
            var _ele_col = $(this).find(".ct-row-overlay.in-column"),
                _ele_row = $(this).find(".ct-row-overlay.in-row"),
                _col = _ele_col.parents(".vc_column-inner"),
                _row = _ele_row.parents(".wpb_column");

            _col.before(_ele_col.clone());
            _ele_col.remove();

            _row.before(_ele_row.clone());
            _ele_row.remove();
        });

        $('.ct-contact-form-wrap').each(function () {
            var _map_popup = $(this).find(".ct-contact-map-popup"),
                _footer = $(this).parents("#content");

            _footer.before(_map_popup.clone());
            _map_popup.remove();
        });

        

        /* =================
         Login
         =================== */
        $('.btn-sign-up').on('click', function () {
            $(this).parents('.ct-modal-content').find('.ct-user-register').addClass('u-open').removeClass('u-close');
            $(this).parents('.ct-modal-content').find('.ct-user-login').addClass('u-close').removeClass('u-open');
        });
        $('.btn-sign-in').on('click', function () {
            $(this).parents('.ct-modal-content').find('.ct-user-login').addClass('u-open').removeClass('u-close');
            $(this).parents('.ct-modal-content').find('.ct-user-register').addClass('u-close').removeClass('u-open');
        });
        $('.btn-user').on('click', function () {
            $('.ct-user-popup').addClass('open').removeClass('remove');
        });

        $('.ct-text-look').parents('.wpb_column').addClass('ps-st');

        $('.scroll-to-content a').on('click', function(e) {
            var id_scroll = $(this).attr('href');
            e.preventDefault();
            $("html, body").animate({ scrollTop: $(id_scroll).offset().top - 0 }, 600);
        });

        $('.scroll-to-id').on('click', function(e) {
            var get_id_scroll = $(this).attr('data-link');
            e.preventDefault();
            $("html, body").animate({ scrollTop: $(get_id_scroll).offset().top - 0 }, 600);
        });

        $(".choose-demo").on('click', function () {
            $(this).parents('.ct-demo-bar').toggleClass('active');
        })

    });

    /* =================
     Column Absolute
     =================== */
    function unfinityplus_col_offset() {
        var w_vc_row_lg = ($('#content').width() - 1140) / 2;
        if (window_width > 1200) {
            $('.col-offset-right > .vc_column-inner').css('padding-right', w_vc_row_lg + 'px');
            $('.col-offset-left > .vc_column-inner').css('padding-left', w_vc_row_lg + 'px');

            $('.rtl .col-offset-right > .vc_column-inner').css('padding-right', 0 + 'px');
            $('.rtl .col-offset-right > .vc_column-inner').css('padding-left', w_vc_row_lg + 'px');
            $('.rtl .col-offset-left > .vc_column-inner').css('padding-left', 0 + 'px');
            $('.rtl .col-offset-left > .vc_column-inner').css('padding-right', w_vc_row_lg + 'px');
            
            $('.col-offset-right > .col-offset-inner').css('padding-right', w_vc_row_lg + 'px');
            $('.col-offset-left > .col-offset-inner').css('padding-left', w_vc_row_lg + 'px');
        }
    }

    function unfinityplus_header_sticky() {
        var offsetTop = $('#site-header-wrap').outerHeight();
        var h_header = $('.fixed-height').outerHeight();
        var offsetTopAnimation = offsetTop + 200;
        if($('#site-header-wrap').hasClass('is-sticky')) {
            if (scroll_top > offsetTopAnimation) {
                $('#site-header').addClass('h-fixed');
            } else {
                $('#site-header').removeClass('h-fixed');   
            }
        }
        if (window_width > 992) {
            $('.fixed-height').css({
                'height': h_header
            });
        }
    }

    function unfinityplus_item_sameheight() {
        $('.vc_row-o-equal-height .wpb_column').matchHeight();
        $('.vc_row .ct-fancybox-layout1').matchHeight();
        $('.ct-fancybox-layout3').parents('.vc_row-o-equal-height').addClass('fancybox-layout3-sameheight');
    }

    /* ====================
     Scroll To Top
     ====================== */
    function unfinityplus_scroll_to_top() {
        if (scroll_top < window_height) {
            $('.ct-scroll-top').addClass('off').removeClass('on');
        }
        if (scroll_top > window_height) {
            $('.ct-scroll-top').addClass('on').removeClass('off');
        }
    }

})(jQuery);